/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.referrals;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.referrals.ReferralClient;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class ReferralLogger {
    static final String EVENT_NAME_REFERRAL_START = "fb_mobile_referral_start";
    static final String EVENT_NAME_REFERRAL_SUCCESS = "fb_mobile_referral_success";
    static final String EVENT_NAME_REFERRAL_CANCEL = "fb_mobile_referral_cancel";
    static final String EVENT_NAME_REFERRAL_ERROR = "fb_mobile_referral_error";
    static final String EVENT_PARAM_AUTH_LOGGER_ID = "0_auth_logger_id";
    static final String EVENT_PARAM_TIMESTAMP = "1_timestamp_ms";
    static final String EVENT_PARAM_ERROR_MESSAGE = "2_error_message";
    static final String EVENT_PARAM_EXTRAS = "3_extras";
    static final String EVENT_EXTRAS_FACEBOOK_VERSION = "facebookVersion";
    static final String EVENT_EXTRAS_REQUEST_CODE = "request_code";
    static final String EVENT_PARAM_VALUE_EMPTY = "";
    static final String FACEBOOK_PACKAGE_NAME = "com.facebook.katana";
    private final InternalAppEventsLogger logger;
    private String loggerID;
    private String facebookVersion;

    ReferralLogger(Context context, String applicationId) {
        this.logger = new InternalAppEventsLogger(context, applicationId);
        this.loggerID = UUID.randomUUID().toString();
        try {
            PackageInfo facebookInfo;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (facebookInfo = packageManager.getPackageInfo(FACEBOOK_PACKAGE_NAME, 0)) != null) {
                this.facebookVersion = facebookInfo.versionName;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    private Bundle getReferralLoggingBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(EVENT_PARAM_AUTH_LOGGER_ID, this.loggerID);
        bundle.putLong(EVENT_PARAM_TIMESTAMP, System.currentTimeMillis());
        bundle.putString(EVENT_PARAM_ERROR_MESSAGE, EVENT_PARAM_VALUE_EMPTY);
        bundle.putString(EVENT_PARAM_EXTRAS, EVENT_PARAM_VALUE_EMPTY);
        return bundle;
    }

    public void logStartReferral() {
        Bundle bundle = this.getReferralLoggingBundle();
        try {
            JSONObject extras = new JSONObject();
            extras.put(EVENT_EXTRAS_REQUEST_CODE, ReferralClient.getReferralRequestCode());
            if (this.facebookVersion != null) {
                extras.put(EVENT_EXTRAS_FACEBOOK_VERSION, (Object)this.facebookVersion);
            }
            bundle.putString(EVENT_PARAM_EXTRAS, extras.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.logger.logEventImplicitly(EVENT_NAME_REFERRAL_START, bundle);
    }

    public void logSuccess() {
        Bundle bundle = this.getReferralLoggingBundle();
        this.logger.logEventImplicitly(EVENT_NAME_REFERRAL_SUCCESS, bundle);
    }

    public void logCancel() {
        Bundle bundle = this.getReferralLoggingBundle();
        this.logger.logEventImplicitly(EVENT_NAME_REFERRAL_CANCEL, bundle);
    }

    public void logError(Exception exception) {
        Bundle bundle = this.getReferralLoggingBundle();
        if (exception != null && exception.getMessage() != null) {
            bundle.putString(EVENT_PARAM_ERROR_MESSAGE, exception.getMessage());
        }
        this.logger.logEventImplicitly(EVENT_NAME_REFERRAL_ERROR, bundle);
    }
}

