/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.login.LoginClient;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class LoginLogger {
    static final String EVENT_NAME_LOGIN_METHOD_START = "fb_mobile_login_method_start";
    static final String EVENT_NAME_LOGIN_METHOD_COMPLETE = "fb_mobile_login_method_complete";
    static final String EVENT_NAME_LOGIN_METHOD_NOT_TRIED = "fb_mobile_login_method_not_tried";
    static final String EVENT_PARAM_METHOD_RESULT_SKIPPED = "skipped";
    static final String EVENT_NAME_LOGIN_START = "fb_mobile_login_start";
    static final String EVENT_NAME_LOGIN_COMPLETE = "fb_mobile_login_complete";
    static final String EVENT_NAME_LOGIN_STATUS_START = "fb_mobile_login_status_start";
    static final String EVENT_NAME_LOGIN_STATUS_COMPLETE = "fb_mobile_login_status_complete";
    static final String EVENT_NAME_LOGIN_HEARTBEAT = "fb_mobile_login_heartbeat";
    static final String EVENT_NAME_FOA_LOGIN_METHOD_START = "foa_mobile_login_method_start";
    static final String EVENT_NAME_FOA_LOGIN_METHOD_COMPLETE = "foa_mobile_login_method_complete";
    static final String EVENT_NAME_FOA_LOGIN_METHOD_NOT_TRIED = "foa_mobile_login_method_not_tried";
    static final String EVENT_PARAM_FOA_METHOD_RESULT_SKIPPED = "foa_skipped";
    static final String EVENT_NAME_FOA_LOGIN_START = "foa_mobile_login_start";
    static final String EVENT_NAME_FOA_LOGIN_COMPLETE = "foa_mobile_login_complete";
    static final String EVENT_PARAM_AUTH_LOGGER_ID = "0_auth_logger_id";
    static final String EVENT_PARAM_TIMESTAMP = "1_timestamp_ms";
    static final String EVENT_PARAM_LOGIN_RESULT = "2_result";
    static final String EVENT_PARAM_METHOD = "3_method";
    static final String EVENT_PARAM_ERROR_CODE = "4_error_code";
    static final String EVENT_PARAM_ERROR_MESSAGE = "5_error_message";
    static final String EVENT_PARAM_EXTRAS = "6_extras";
    static final String EVENT_PARAM_CHALLENGE = "7_challenge";
    static final String EVENT_EXTRAS_TRY_LOGIN_ACTIVITY = "try_login_activity";
    static final String EVENT_EXTRAS_MISSING_INTERNET_PERMISSION = "no_internet_permission";
    static final String EVENT_EXTRAS_NOT_TRIED = "not_tried";
    static final String EVENT_EXTRAS_NEW_PERMISSIONS = "new_permissions";
    static final String EVENT_EXTRAS_LOGIN_BEHAVIOR = "login_behavior";
    static final String EVENT_EXTRAS_REQUEST_CODE = "request_code";
    static final String EVENT_EXTRAS_PERMISSIONS = "permissions";
    static final String EVENT_EXTRAS_DEFAULT_AUDIENCE = "default_audience";
    static final String EVENT_EXTRAS_IS_REAUTHORIZE = "isReauthorize";
    static final String EVENT_EXTRAS_FACEBOOK_VERSION = "facebookVersion";
    static final String EVENT_EXTRAS_FAILURE = "failure";
    static final String EVENT_EXTRAS_TARGET_APP = "target_app";
    static final String FACEBOOK_PACKAGE_NAME = "com.facebook.katana";
    private final InternalAppEventsLogger logger;
    private String applicationId;
    private String facebookVersion;
    private static final ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();

    LoginLogger(Context context, String applicationId) {
        this.applicationId = applicationId;
        this.logger = new InternalAppEventsLogger(context, applicationId);
        try {
            PackageInfo facebookInfo;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (facebookInfo = packageManager.getPackageInfo(FACEBOOK_PACKAGE_NAME, 0)) != null) {
                this.facebookVersion = facebookInfo.versionName;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    public String getApplicationId() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            return this.applicationId;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    static Bundle newAuthorizationLoggingBundle(String string2) {
        if (CrashShieldHandler.isObjectCrashing(LoginLogger.class)) {
            return null;
        }
        try {
            String authLoggerId;
            Bundle bundle = new Bundle();
            bundle.putLong(EVENT_PARAM_TIMESTAMP, System.currentTimeMillis());
            bundle.putString(EVENT_PARAM_AUTH_LOGGER_ID, authLoggerId);
            bundle.putString(EVENT_PARAM_METHOD, "");
            bundle.putString(EVENT_PARAM_LOGIN_RESULT, "");
            bundle.putString(EVENT_PARAM_ERROR_MESSAGE, "");
            bundle.putString(EVENT_PARAM_ERROR_CODE, "");
            bundle.putString(EVENT_PARAM_EXTRAS, "");
            return bundle;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, LoginLogger.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logStartLogin(LoginClient.Request request) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void pendingLoginRequest;
            this.logStartLogin((LoginClient.Request)pendingLoginRequest, EVENT_NAME_LOGIN_START);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logStartLogin(LoginClient.Request request, String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void eventName;
            void pendingLoginRequest;
            Bundle bundle = LoginLogger.newAuthorizationLoggingBundle(pendingLoginRequest.getAuthId());
            try {
                JSONObject extras = new JSONObject();
                extras.put(EVENT_EXTRAS_LOGIN_BEHAVIOR, (Object)pendingLoginRequest.getLoginBehavior().toString());
                extras.put(EVENT_EXTRAS_REQUEST_CODE, LoginClient.getLoginRequestCode());
                extras.put(EVENT_EXTRAS_PERMISSIONS, (Object)TextUtils.join((CharSequence)",", pendingLoginRequest.getPermissions()));
                extras.put(EVENT_EXTRAS_DEFAULT_AUDIENCE, (Object)pendingLoginRequest.getDefaultAudience().toString());
                extras.put(EVENT_EXTRAS_IS_REAUTHORIZE, pendingLoginRequest.isRerequest());
                if (this.facebookVersion != null) {
                    extras.put(EVENT_EXTRAS_FACEBOOK_VERSION, (Object)this.facebookVersion);
                }
                if (pendingLoginRequest.getLoginTargetApp() != null) {
                    extras.put(EVENT_EXTRAS_TARGET_APP, (Object)pendingLoginRequest.getLoginTargetApp().toString());
                }
                bundle.putString(EVENT_PARAM_EXTRAS, extras.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.logger.logEventImplicitly((String)eventName, null, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logCompleteLogin(String string2, Map<String, String> map, LoginClient.Result.Code code, Map<String, String> map2, Exception exception) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void exception2;
            void resultExtras;
            void result;
            void loggingExtras;
            void loginRequestId;
            this.logCompleteLogin((String)loginRequestId, (Map<String, String>)loggingExtras, (LoginClient.Result.Code)result, (Map<String, String>)resultExtras, (Exception)exception2, EVENT_NAME_LOGIN_COMPLETE);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logCompleteLogin(String string2, Map<String, String> map, LoginClient.Result.Code code, Map<String, String> map2, Exception exception, String string3) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void eventName;
            void resultExtras;
            void loggingExtras;
            void exception2;
            void result;
            void loginRequestId;
            Bundle bundle = LoginLogger.newAuthorizationLoggingBundle((String)loginRequestId);
            if (result != null) {
                bundle.putString(EVENT_PARAM_LOGIN_RESULT, result.getLoggingValue());
            }
            if (exception2 != null && exception2.getMessage() != null) {
                bundle.putString(EVENT_PARAM_ERROR_MESSAGE, exception2.getMessage());
            }
            JSONObject jsonObject = null;
            if (!loggingExtras.isEmpty()) {
                jsonObject = new JSONObject((Map)loggingExtras);
            }
            if (resultExtras != null) {
                if (jsonObject == null) {
                    jsonObject = new JSONObject();
                }
                try {
                    for (Map.Entry entry : resultExtras.entrySet()) {
                        jsonObject.put((String)entry.getKey(), entry.getValue());
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            if (jsonObject != null) {
                bundle.putString(EVENT_PARAM_EXTRAS, jsonObject.toString());
            }
            this.logger.logEventImplicitly((String)eventName, bundle);
            if (result == LoginClient.Result.Code.SUCCESS) {
                this.logHeartbeatEvent((String)loginRequestId);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logHeartbeatEvent(String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void loginRequestId;
            final Bundle bundle = LoginLogger.newAuthorizationLoggingBundle((String)loginRequestId);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                        return;
                    }
                    try {
                        LoginLogger.access$000(LoginLogger.this).logEventImplicitly(LoginLogger.EVENT_NAME_LOGIN_HEARTBEAT, bundle);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                        return;
                    }
                }
            };
            worker.schedule(runnable, 5L, TimeUnit.SECONDS);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logAuthorizationMethodStart(String string2, String string3) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void method;
            void authId;
            this.logAuthorizationMethodStart((String)authId, (String)method, EVENT_NAME_LOGIN_METHOD_START);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logAuthorizationMethodStart(String string2, String string3, String string4) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void eventName;
            void method;
            void authId;
            Bundle bundle = LoginLogger.newAuthorizationLoggingBundle((String)authId);
            bundle.putString(EVENT_PARAM_METHOD, (String)method);
            this.logger.logEventImplicitly((String)eventName, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logAuthorizationMethodComplete(String string2, String string3, String string4, String string5, String string6, Map<String, String> map) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void loggingExtras;
            void errorCode;
            void errorMessage;
            void result;
            void method;
            void authId;
            this.logAuthorizationMethodComplete((String)authId, (String)method, (String)result, (String)errorMessage, (String)errorCode, (Map<String, String>)loggingExtras, EVENT_NAME_LOGIN_METHOD_COMPLETE);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logAuthorizationMethodComplete(String string2, String string3, String string4, String string5, String string6, Map<String, String> map, String string7) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void eventName;
            void method;
            void loggingExtras;
            void errorCode;
            void errorMessage;
            void result;
            void authId;
            Bundle bundle = LoginLogger.newAuthorizationLoggingBundle((String)authId);
            if (result != null) {
                bundle.putString(EVENT_PARAM_LOGIN_RESULT, (String)result);
            }
            if (errorMessage != null) {
                bundle.putString(EVENT_PARAM_ERROR_MESSAGE, (String)errorMessage);
            }
            if (errorCode != null) {
                bundle.putString(EVENT_PARAM_ERROR_CODE, (String)errorCode);
            }
            if (loggingExtras != null && !loggingExtras.isEmpty()) {
                JSONObject jsonObject = new JSONObject((Map)loggingExtras);
                bundle.putString(EVENT_PARAM_EXTRAS, jsonObject.toString());
            }
            bundle.putString(EVENT_PARAM_METHOD, (String)method);
            this.logger.logEventImplicitly((String)eventName, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logAuthorizationMethodNotTried(String string2, String string3) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void method;
            void authId;
            this.logAuthorizationMethodNotTried((String)authId, (String)method, EVENT_NAME_LOGIN_METHOD_NOT_TRIED);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logAuthorizationMethodNotTried(String string2, String string3, String string4) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void eventName;
            void method;
            void authId;
            Bundle bundle = LoginLogger.newAuthorizationLoggingBundle((String)authId);
            bundle.putString(EVENT_PARAM_METHOD, (String)method);
            this.logger.logEventImplicitly((String)eventName, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logLoginStatusStart(String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void loggerRef;
            Bundle bundle = LoginLogger.newAuthorizationLoggingBundle((String)loggerRef);
            this.logger.logEventImplicitly(EVENT_NAME_LOGIN_STATUS_START, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logLoginStatusSuccess(String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void loggerRef;
            Bundle bundle = LoginLogger.newAuthorizationLoggingBundle((String)loggerRef);
            bundle.putString(EVENT_PARAM_LOGIN_RESULT, LoginClient.Result.Code.SUCCESS.getLoggingValue());
            this.logger.logEventImplicitly(EVENT_NAME_LOGIN_STATUS_COMPLETE, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logLoginStatusFailure(String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void loggerRef;
            Bundle bundle = LoginLogger.newAuthorizationLoggingBundle((String)loggerRef);
            bundle.putString(EVENT_PARAM_LOGIN_RESULT, EVENT_EXTRAS_FAILURE);
            this.logger.logEventImplicitly(EVENT_NAME_LOGIN_STATUS_COMPLETE, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logLoginStatusError(String string2, Exception exception) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void exception2;
            void loggerRef;
            Bundle bundle = LoginLogger.newAuthorizationLoggingBundle((String)loggerRef);
            bundle.putString(EVENT_PARAM_LOGIN_RESULT, LoginClient.Result.Code.ERROR.getLoggingValue());
            bundle.putString(EVENT_PARAM_ERROR_MESSAGE, exception2.toString());
            this.logger.logEventImplicitly(EVENT_NAME_LOGIN_STATUS_COMPLETE, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logUnexpectedError(String string2, String string3) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void errorMessage;
            void eventName;
            this.logUnexpectedError((String)eventName, (String)errorMessage, "");
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logUnexpectedError(String string2, String string3, String string4) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void eventName;
            void method;
            void errorMessage;
            Bundle bundle = LoginLogger.newAuthorizationLoggingBundle("");
            bundle.putString(EVENT_PARAM_LOGIN_RESULT, LoginClient.Result.Code.ERROR.getLoggingValue());
            bundle.putString(EVENT_PARAM_ERROR_MESSAGE, (String)errorMessage);
            bundle.putString(EVENT_PARAM_METHOD, (String)method);
            this.logger.logEventImplicitly((String)eventName, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    static /* synthetic */ InternalAppEventsLogger access$000(LoginLogger loginLogger) {
        if (CrashShieldHandler.isObjectCrashing(LoginLogger.class)) {
            return null;
        }
        try {
            LoginLogger x0;
            return x0.logger;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, LoginLogger.class);
            return null;
        }
    }
}

