/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import com.facebook.share.model.CameraEffectArguments;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CameraEffectJSONUtility {
    private static final Map<Class<?>, Setter> SETTERS = new HashMap();

    public static JSONObject convertToJSON(CameraEffectArguments arguments) throws JSONException {
        if (arguments == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        for (String key : arguments.keySet()) {
            Object value = arguments.get(key);
            if (value == null) continue;
            Setter setter = SETTERS.get(value.getClass());
            if (setter == null) {
                throw new IllegalArgumentException("Unsupported type: " + value.getClass());
            }
            setter.setOnJSON(json, key, value);
        }
        return json;
    }

    public static CameraEffectArguments convertToCameraEffectArguments(JSONObject jsonObject) throws JSONException {
        if (jsonObject == null) {
            return null;
        }
        CameraEffectArguments.Builder builder = new CameraEffectArguments.Builder();
        Iterator jsonIterator = jsonObject.keys();
        while (jsonIterator.hasNext()) {
            String key = (String)jsonIterator.next();
            Object value = jsonObject.get(key);
            if (value == null || value == JSONObject.NULL) continue;
            Setter setter = SETTERS.get(value.getClass());
            if (setter == null) {
                throw new IllegalArgumentException("Unsupported type: " + value.getClass());
            }
            setter.setOnArgumentsBuilder(builder, key, value);
        }
        return builder.build();
    }

    static {
        SETTERS.put(String.class, new Setter(){

            @Override
            public void setOnArgumentsBuilder(CameraEffectArguments.Builder builder, String key, Object value) throws JSONException {
                builder.putArgument(key, (String)value);
            }

            @Override
            public void setOnJSON(JSONObject json, String key, Object value) throws JSONException {
                json.put(key, value);
            }
        });
        SETTERS.put(String[].class, new Setter(){

            @Override
            public void setOnArgumentsBuilder(CameraEffectArguments.Builder builder, String key, Object value) throws JSONException {
                throw new IllegalArgumentException("Unexpected type from JSON");
            }

            @Override
            public void setOnJSON(JSONObject json, String key, Object value) throws JSONException {
                JSONArray jsonArray = new JSONArray();
                for (String stringValue : (String[])value) {
                    jsonArray.put((Object)stringValue);
                }
                json.put(key, (Object)jsonArray);
            }
        });
        SETTERS.put(JSONArray.class, new Setter(){

            @Override
            public void setOnArgumentsBuilder(CameraEffectArguments.Builder builder, String key, Object value) throws JSONException {
                JSONArray jsonArray = (JSONArray)value;
                String[] argsArray = new String[jsonArray.length()];
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Object current = jsonArray.get(i);
                    if (!(current instanceof String)) {
                        throw new IllegalArgumentException("Unexpected type in an array: " + current.getClass());
                    }
                    argsArray[i] = (String)current;
                }
                builder.putArgument(key, argsArray);
            }

            @Override
            public void setOnJSON(JSONObject json, String key, Object value) throws JSONException {
                throw new IllegalArgumentException("JSONArray's are not supported in bundles.");
            }
        });
    }

    public static interface Setter {
        public void setOnArgumentsBuilder(CameraEffectArguments.Builder var1, String var2, Object var3) throws JSONException;

        public void setOnJSON(JSONObject var1, String var2, Object var3) throws JSONException;
    }
}

