/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.devicerequests.internal;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Build;
import androidx.annotation.Nullable;
import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.SmartLoginOption;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class DeviceRequestsHelper {
    private static final String TAG = DeviceRequestsHelper.class.getCanonicalName();
    public static final String DEVICE_INFO_PARAM = "device_info";
    public static final String DEVICE_TARGET_USER_ID = "target_user_id";
    static final String DEVICE_INFO_DEVICE = "device";
    static final String DEVICE_INFO_MODEL = "model";
    static final String SDK_HEADER = "fbsdk";
    static final String SDK_FLAVOR = "android";
    static final String SERVICE_TYPE = "_fb._tcp.";
    private static HashMap<String, NsdManager.RegistrationListener> deviceRequestsListeners = new HashMap();

    public static String getDeviceInfo(@Nullable Map<String, String> map) {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return null;
        }
        try {
            Map<String, String> deviceInfo;
            if (deviceInfo == null) {
                deviceInfo = new HashMap<String, String>();
            }
            deviceInfo.put(DEVICE_INFO_DEVICE, Build.DEVICE);
            deviceInfo.put(DEVICE_INFO_MODEL, Build.MODEL);
            return new JSONObject(deviceInfo).toString();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return null;
        }
    }

    public static String getDeviceInfo() {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return null;
        }
        try {
            return DeviceRequestsHelper.getDeviceInfo(null);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return null;
        }
    }

    public static boolean startAdvertisementService(String string) {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return false;
        }
        try {
            if (DeviceRequestsHelper.isAvailable()) {
                String userCode;
                return DeviceRequestsHelper.startAdvertisementServiceImpl(userCode);
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return false;
        }
    }

    public static boolean isAvailable() {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return false;
        }
        try {
            FetchedAppSettings settings = FetchedAppSettingsManager.getAppSettingsWithoutQuery((String)FacebookSdk.getApplicationId());
            return Build.VERSION.SDK_INT >= 16 && settings != null && settings.getSmartLoginOptions().contains(SmartLoginOption.Enabled);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return false;
        }
    }

    public static Bitmap generateQRCode(String string) {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return null;
        }
        try {
            Bitmap qrCode = null;
            EnumMap<EncodeHintType, Integer> hints = new EnumMap<EncodeHintType, Integer>(EncodeHintType.class);
            hints.put(EncodeHintType.MARGIN, 2);
            try {
                String url;
                BitMatrix matrix = new MultiFormatWriter().encode(url, BarcodeFormat.QR_CODE, 200, 200, hints);
                int h = matrix.getHeight();
                int w = matrix.getWidth();
                int[] pixels = new int[h * w];
                for (int i = 0; i < h; ++i) {
                    int offset = i * w;
                    for (int j = 0; j < w; ++j) {
                        pixels[offset + j] = matrix.get(j, i) ? -16777216 : -1;
                    }
                }
                qrCode = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                qrCode.setPixels(pixels, 0, w, 0, 0, w, h);
            }
            catch (WriterException writerException) {
                // empty catch block
            }
            return qrCode;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return null;
        }
    }

    public static void cleanUpAdvertisementService(String string) {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return;
        }
        try {
            String userCode;
            DeviceRequestsHelper.cleanUpAdvertisementServiceImpl(userCode);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return;
        }
    }

    @TargetApi(value=16)
    private static boolean startAdvertisementServiceImpl(String string) {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return false;
        }
        try {
            String userCode;
            if (deviceRequestsListeners.containsKey(userCode)) {
                return true;
            }
            String sdkVersion = FacebookSdk.getSdkVersion().replace('.', '|');
            final String nsdServiceName = String.format("%s_%s_%s", SDK_HEADER, String.format("%s-%s", SDK_FLAVOR, sdkVersion), userCode);
            NsdServiceInfo nsdLoginAdvertisementService = new NsdServiceInfo();
            nsdLoginAdvertisementService.setServiceType(SERVICE_TYPE);
            nsdLoginAdvertisementService.setServiceName(nsdServiceName);
            nsdLoginAdvertisementService.setPort(80);
            NsdManager nsdManager = (NsdManager)FacebookSdk.getApplicationContext().getSystemService("servicediscovery");
            NsdManager.RegistrationListener nsdRegistrationListener = new NsdManager.RegistrationListener(){

                public void onServiceRegistered(NsdServiceInfo NsdServiceInfo2) {
                    if (!nsdServiceName.equals(NsdServiceInfo2.getServiceName())) {
                        DeviceRequestsHelper.cleanUpAdvertisementService(userCode);
                    }
                }

                public void onServiceUnregistered(NsdServiceInfo serviceInfo) {
                }

                public void onRegistrationFailed(NsdServiceInfo serviceInfo, int errorCode) {
                    DeviceRequestsHelper.cleanUpAdvertisementService(userCode);
                }

                public void onUnregistrationFailed(NsdServiceInfo serviceInfo, int errorCode) {
                }
            };
            deviceRequestsListeners.put(userCode, nsdRegistrationListener);
            nsdManager.registerService(nsdLoginAdvertisementService, 1, nsdRegistrationListener);
            return true;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return false;
        }
    }

    @TargetApi(value=16)
    private static void cleanUpAdvertisementServiceImpl(String string) {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return;
        }
        try {
            String userCode;
            NsdManager.RegistrationListener nsdRegistrationListener = deviceRequestsListeners.get(userCode);
            if (nsdRegistrationListener != null) {
                NsdManager nsdManager = (NsdManager)FacebookSdk.getApplicationContext().getSystemService("servicediscovery");
                try {
                    nsdManager.unregisterService(nsdRegistrationListener);
                }
                catch (IllegalArgumentException e) {
                    Utility.logd((String)TAG, (Exception)e);
                }
                deviceRequestsListeners.remove(userCode);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return;
        }
    }
}

