/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import com.facebook.FacebookSdk;
import com.facebook.internal.Validate;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/facebook/internal/CustomTabUtils;", "", "()V", "CHROME_PACKAGES", "", "", "[Ljava/lang/String;", "getChromePackage", "getDefaultRedirectURI", "getValidRedirectURI", "developerDefinedRedirectURI", "facebook-common_release"})
public final class CustomTabUtils {
    private static final String[] CHROME_PACKAGES;
    @NotNull
    public static final CustomTabUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final String getDefaultRedirectURI() {
        if (CrashShieldHandler.isObjectCrashing(CustomTabUtils.class)) {
            return null;
        }
        try {
            return "fbconnect://cct." + FacebookSdk.getApplicationContext().getPackageName();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, CustomTabUtils.class);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final String getValidRedirectURI(@NotNull String string2) {
        if (CrashShieldHandler.isObjectCrashing(CustomTabUtils.class)) {
            return null;
        }
        try {
            String developerDefinedRedirectURI;
            Intrinsics.checkNotNullParameter((Object)developerDefinedRedirectURI, (String)"developerDefinedRedirectURI");
            boolean hasDeveloperDefinedRedirect = Validate.hasCustomTabRedirectActivity((Context)FacebookSdk.getApplicationContext(), (String)developerDefinedRedirectURI);
            if (hasDeveloperDefinedRedirect) {
                return developerDefinedRedirectURI;
            }
            boolean hasDefaultRedirect = Validate.hasCustomTabRedirectActivity((Context)FacebookSdk.getApplicationContext(), (String)CustomTabUtils.getDefaultRedirectURI());
            if (hasDefaultRedirect) {
                return CustomTabUtils.getDefaultRedirectURI();
            }
            return "";
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, CustomTabUtils.class);
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final String getChromePackage() {
        if (CrashShieldHandler.isObjectCrashing(CustomTabUtils.class)) {
            return null;
        }
        try {
            Context context = FacebookSdk.getApplicationContext();
            Intent serviceIntent = new Intent("android.support.customtabs.action.CustomTabsService");
            List resolveInfos = context.getPackageManager().queryIntentServices(serviceIntent, 0);
            if (resolveInfos != null) {
                Set chromePackages = ArraysKt.toHashSet((Object[])CHROME_PACKAGES);
                for (ResolveInfo resolveInfo : resolveInfos) {
                    ServiceInfo serviceInfo = resolveInfo.serviceInfo;
                    if (serviceInfo == null || !chromePackages.contains(serviceInfo.packageName)) continue;
                    return serviceInfo.packageName;
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, CustomTabUtils.class);
            return null;
        }
    }

    private CustomTabUtils() {
    }

    static {
        CustomTabUtils customTabUtils;
        INSTANCE = customTabUtils = new CustomTabUtils();
        CHROME_PACKAGES = new String[]{"com.android.chrome", "com.chrome.beta", "com.chrome.dev"};
    }
}

