/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.internal.FacebookWebFallbackDialog;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.WebDialog;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u000bJ\u001c\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0017\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/facebook/internal/FacebookDialogFragment;", "Landroidx/fragment/app/DialogFragment;", "()V", "innerDialog", "Landroid/app/Dialog;", "getInnerDialog", "()Landroid/app/Dialog;", "setInnerDialog", "(Landroid/app/Dialog;)V", "initDialog", "", "initDialog$facebook_common_release", "onCompleteWebDialog", "values", "Landroid/os/Bundle;", "error", "Lcom/facebook/FacebookException;", "onCompleteWebFallbackDialog", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onCreate", "savedInstanceState", "onCreateDialog", "onDestroyView", "onResume", "Companion", "facebook-common_release"})
public final class FacebookDialogFragment
extends DialogFragment {
    @Nullable
    private Dialog innerDialog;
    @NotNull
    public static final String TAG = "FacebookDialogFragment";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Dialog getInnerDialog() {
        return this.innerDialog;
    }

    public final void setInnerDialog(@Nullable Dialog dialog) {
        this.innerDialog = dialog;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initDialog$facebook_common_release();
    }

    @VisibleForTesting
    public final void initDialog$facebook_common_release() {
        Bundle params;
        Intent intent;
        if (this.innerDialog != null) {
            return;
        }
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"activity ?: return");
        FragmentActivity activity = fragmentActivity;
        Intent intent2 = intent = activity.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"intent");
        Bundle bundle = params = NativeProtocol.getMethodArgumentsFromIntent((Intent)intent2);
        boolean isWebFallback = bundle != null ? bundle.getBoolean("is_fallback", false) : false;
        WebDialog webDialog = null;
        if (!isWebFallback) {
            Bundle webParams;
            Bundle bundle2 = params;
            String actionName = bundle2 != null ? bundle2.getString("action") : null;
            Bundle bundle3 = params;
            Object object = webParams = bundle3 != null ? bundle3.getBundle("params") : null;
            if (Utility.isNullOrEmpty((String)actionName)) {
                Utility.logd((String)TAG, (String)"Cannot start a WebDialog with an empty/missing 'actionName'");
                activity.finish();
                return;
            }
            String string2 = actionName;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            webDialog = new WebDialog.Builder((Context)activity, string2, webParams).setOnCompleteListener(new WebDialog.OnCompleteListener(this){
                final /* synthetic */ FacebookDialogFragment this$0;

                public final void onComplete(@Nullable Bundle values, @Nullable FacebookException error) {
                    FacebookDialogFragment.access$onCompleteWebDialog(this.this$0, values, error);
                }
                {
                    this.this$0 = facebookDialogFragment;
                }
            }).build();
        } else {
            String url;
            Bundle bundle4 = params;
            String string3 = url = bundle4 != null ? bundle4.getString("url") : null;
            if (Utility.isNullOrEmpty((String)url)) {
                Utility.logd((String)TAG, (String)"Cannot start a fallback WebDialog with an empty/missing 'url'");
                activity.finish();
                return;
            }
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string4 = "fb%s://bridge/";
            Object[] objectArray = new Object[]{FacebookSdk.getApplicationId()};
            boolean bl = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
            String redirectUrl = string5;
            String string6 = url;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            webDialog = FacebookWebFallbackDialog.Companion.newInstance((Context)activity, string6, redirectUrl);
            webDialog.setOnCompleteListener(new WebDialog.OnCompleteListener(this){
                final /* synthetic */ FacebookDialogFragment this$0;

                public final void onComplete(@Nullable Bundle values, @Nullable FacebookException $noName_1) {
                    FacebookDialogFragment.access$onCompleteWebFallbackDialog(this.this$0, values);
                }
                {
                    this.this$0 = facebookDialogFragment;
                }
            });
        }
        this.innerDialog = webDialog;
    }

    @NotNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        if (this.innerDialog == null) {
            this.onCompleteWebDialog(null, null);
            this.setShowsDialog(false);
            Dialog dialog = super.onCreateDialog(savedInstanceState);
            Intrinsics.checkNotNullExpressionValue((Object)dialog, (String)"super.onCreateDialog(savedInstanceState)");
            return dialog;
        }
        Dialog dialog = this.innerDialog;
        if (dialog == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.Dialog");
        }
        return dialog;
    }

    public void onResume() {
        super.onResume();
        if (this.innerDialog instanceof WebDialog) {
            Dialog dialog = this.innerDialog;
            if (dialog == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.facebook.internal.WebDialog");
            }
            ((WebDialog)dialog).resize();
        }
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        if (this.innerDialog instanceof WebDialog && this.isResumed()) {
            Dialog dialog = this.innerDialog;
            if (dialog == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.facebook.internal.WebDialog");
            }
            ((WebDialog)dialog).resize();
        }
    }

    public void onDestroyView() {
        Dialog dialog = this.getDialog();
        if (dialog != null && this.getRetainInstance()) {
            dialog.setDismissMessage(null);
        }
        super.onDestroyView();
    }

    private final void onCompleteWebDialog(Bundle values, FacebookException error) {
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"activity ?: return");
        FragmentActivity fragmentActivity2 = fragmentActivity;
        Intent intent = fragmentActivity2.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"fragmentActivity.intent");
        Intent resultIntent = NativeProtocol.createProtocolResultIntent((Intent)intent, (Bundle)values, (FacebookException)error);
        int resultCode = error == null ? -1 : 0;
        fragmentActivity2.setResult(resultCode, resultIntent);
        fragmentActivity2.finish();
    }

    private final void onCompleteWebFallbackDialog(Bundle values) {
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"activity ?: return");
        FragmentActivity fragmentActivity2 = fragmentActivity;
        Intent resultIntent = new Intent();
        Bundle bundle = values;
        if (bundle == null) {
            bundle = new Bundle();
        }
        resultIntent.putExtras(bundle);
        fragmentActivity2.setResult(-1, resultIntent);
        fragmentActivity2.finish();
    }

    public static final /* synthetic */ void access$onCompleteWebDialog(FacebookDialogFragment $this, Bundle values, FacebookException error) {
        $this.onCompleteWebDialog(values, error);
    }

    public static final /* synthetic */ void access$onCompleteWebFallbackDialog(FacebookDialogFragment $this, Bundle values) {
        $this.onCompleteWebFallbackDialog(values);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/internal/FacebookDialogFragment$Companion;", "", "()V", "TAG", "", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

