/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.internal.CustomTabUtils;
import com.facebook.internal.NativeProtocol;
import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginClient;
import com.facebook.login.NativeAppLoginMethodHandler;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0011\b\u0016\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/facebook/login/KatanaProxyLoginMethodHandler;", "Lcom/facebook/login/NativeAppLoginMethodHandler;", "loginClient", "Lcom/facebook/login/LoginClient;", "(Lcom/facebook/login/LoginClient;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "nameForLogging", "", "getNameForLogging", "()Ljava/lang/String;", "describeContents", "", "shouldKeepTrackOfMultipleIntents", "", "tryAuthorize", "request", "Lcom/facebook/login/LoginClient$Request;", "Companion", "facebook-common_release"})
@VisibleForTesting(otherwise=3)
public final class KatanaProxyLoginMethodHandler
extends NativeAppLoginMethodHandler {
    @NotNull
    private final String nameForLogging;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<KatanaProxyLoginMethodHandler> CREATOR;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public String getNameForLogging() {
        return this.nameForLogging;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int tryAuthorize(@NotNull LoginClient.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        LoginBehavior behavior = request.getLoginBehavior();
        boolean ignoreAppSwitchToLoggedOut = FacebookSdk.ignoreAppSwitchToLoggedOut && CustomTabUtils.getChromePackage() != null && behavior.allowsCustomTabAuth();
        String e2e = LoginClient.getE2E();
        Context context = (Context)this.getLoginClient().getActivity();
        String string2 = request.getApplicationId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.applicationId");
        Set<String> set = request.getPermissions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"request.permissions");
        Collection collection = set;
        String string3 = e2e;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"e2e");
        boolean bl = request.isRerequest();
        boolean bl2 = request.hasPublishPermission();
        DefaultAudience defaultAudience = request.getDefaultAudience();
        Intrinsics.checkNotNullExpressionValue((Object)defaultAudience, (String)"request.defaultAudience");
        String string4 = request.getAuthId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"request.authId");
        String string5 = this.getClientState(string4);
        String string6 = request.getAuthType();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"request.authType");
        List intents = NativeProtocol.createProxyAuthIntents((Context)context, (String)string2, (Collection)collection, (String)string3, (boolean)bl, (boolean)bl2, (DefaultAudience)defaultAudience, (String)string5, (String)string6, (boolean)ignoreAppSwitchToLoggedOut, (String)request.getMessengerPageId(), (boolean)request.getResetMessengerState(), (boolean)request.isFamilyLogin(), (boolean)request.shouldSkipAccountDeduplication(), (String)request.getNonce());
        this.addLoggingExtra("e2e", e2e);
        boolean bl3 = false;
        for (Intent intent : (Iterable)intents) {
            void i;
            boolean launchedIntent = this.tryIntent(intent, LoginClient.getLoginRequestCode());
            if (launchedIntent) {
                return (int)(i + true);
            }
            ++i;
        }
        return 0;
    }

    @Override
    public boolean shouldKeepTrackOfMultipleIntents() {
        return true;
    }

    public int describeContents() {
        return 0;
    }

    public KatanaProxyLoginMethodHandler(@Nullable LoginClient loginClient) {
        super(loginClient);
        this.nameForLogging = "katana_proxy_auth";
    }

    public KatanaProxyLoginMethodHandler(@Nullable Parcel source) {
        super(source);
        this.nameForLogging = "katana_proxy_auth";
    }

    static {
        Companion = new Companion(null);
        CREATOR = (Parcelable.Creator)new Parcelable.Creator<KatanaProxyLoginMethodHandler>(){

            @NotNull
            public KatanaProxyLoginMethodHandler createFromParcel(@NotNull Parcel source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                return new KatanaProxyLoginMethodHandler(source);
            }

            @NotNull
            public KatanaProxyLoginMethodHandler[] newArray(int size) {
                return new KatanaProxyLoginMethodHandler[size];
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/login/KatanaProxyLoginMethodHandler$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/login/KatanaProxyLoginMethodHandler;", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

