/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.facebook.AccessToken;
import com.facebook.AuthenticationToken;
import com.facebook.CustomTabMainActivity;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.common.R;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.login.CustomTabLoginMethodHandler;
import com.facebook.login.DefaultAudience;
import com.facebook.login.DeviceAuthMethodHandler;
import com.facebook.login.FacebookLiteLoginMethodHandler;
import com.facebook.login.GetTokenLoginMethodHandler;
import com.facebook.login.InstagramAppLoginMethodHandler;
import com.facebook.login.KatanaProxyLoginMethodHandler;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginLogger;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginMethodHandler;
import com.facebook.login.LoginTargetApp;
import com.facebook.login.WebViewLoginMethodHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

@VisibleForTesting(otherwise=3)
public class LoginClient
implements Parcelable {
    LoginMethodHandler[] handlersToTry;
    int currentHandler = -1;
    Fragment fragment;
    OnCompletedListener onCompletedListener;
    BackgroundProcessingListener backgroundProcessingListener;
    boolean checkedInternetPermission;
    Request pendingRequest;
    Map<String, String> loggingExtras;
    Map<String, String> extraData;
    private LoginLogger loginLogger;
    private int numActivitiesReturned = 0;
    private int numTotalIntentsFired = 0;
    public static final Parcelable.Creator<LoginClient> CREATOR = new Parcelable.Creator<LoginClient>(){

        public LoginClient createFromParcel(Parcel source) {
            return new LoginClient(source);
        }

        public LoginClient[] newArray(int size) {
            return new LoginClient[size];
        }
    };

    public LoginClient(Fragment fragment) {
        this.fragment = fragment;
    }

    public Fragment getFragment() {
        return this.fragment;
    }

    void setFragment(Fragment fragment) {
        if (this.fragment != null) {
            throw new FacebookException("Can't set fragment once it is already set.");
        }
        this.fragment = fragment;
    }

    FragmentActivity getActivity() {
        return this.fragment.getActivity();
    }

    public Request getPendingRequest() {
        return this.pendingRequest;
    }

    public static int getLoginRequestCode() {
        return CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode();
    }

    void startOrContinueAuth(Request request) {
        if (!this.getInProgress()) {
            this.authorize(request);
        }
    }

    void authorize(Request request) {
        if (request == null) {
            return;
        }
        if (this.pendingRequest != null) {
            throw new FacebookException("Attempted to authorize while a request is pending.");
        }
        if (AccessToken.isCurrentAccessTokenActive() && !this.checkInternetPermission()) {
            return;
        }
        this.pendingRequest = request;
        this.handlersToTry = this.getHandlersToTry(request);
        this.tryNextHandler();
    }

    boolean getInProgress() {
        return this.pendingRequest != null && this.currentHandler >= 0;
    }

    void cancelCurrentHandler() {
        if (this.currentHandler >= 0) {
            this.getCurrentHandler().cancel();
        }
    }

    LoginMethodHandler getCurrentHandler() {
        if (this.currentHandler >= 0) {
            return this.handlersToTry[this.currentHandler];
        }
        return null;
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        ++this.numActivitiesReturned;
        if (this.pendingRequest != null) {
            boolean hasNoBrowserException;
            if (data != null && (hasNoBrowserException = data.getBooleanExtra(CustomTabMainActivity.NO_ACTIVITY_EXCEPTION, false))) {
                this.tryNextHandler();
                return false;
            }
            if (!this.getCurrentHandler().shouldKeepTrackOfMultipleIntents() || data != null || this.numActivitiesReturned >= this.numTotalIntentsFired) {
                return this.getCurrentHandler().onActivityResult(requestCode, resultCode, data);
            }
        }
        return false;
    }

    protected LoginMethodHandler[] getHandlersToTry(Request request) {
        ArrayList<LoginMethodHandler> handlers = new ArrayList<LoginMethodHandler>();
        LoginBehavior behavior = request.getLoginBehavior();
        if (request.isInstagramLogin()) {
            if (!FacebookSdk.bypassAppSwitch && behavior.allowsInstagramAppAuth()) {
                handlers.add(new InstagramAppLoginMethodHandler(this));
            }
        } else {
            if (behavior.allowsGetTokenAuth()) {
                handlers.add(new GetTokenLoginMethodHandler(this));
            }
            if (!FacebookSdk.bypassAppSwitch && behavior.allowsKatanaAuth()) {
                handlers.add(new KatanaProxyLoginMethodHandler(this));
            }
            if (!FacebookSdk.bypassAppSwitch && behavior.allowsFacebookLiteAuth()) {
                handlers.add(new FacebookLiteLoginMethodHandler(this));
            }
        }
        if (behavior.allowsCustomTabAuth()) {
            handlers.add(new CustomTabLoginMethodHandler(this));
        }
        if (behavior.allowsWebViewAuth()) {
            handlers.add(new WebViewLoginMethodHandler(this));
        }
        if (!request.isInstagramLogin() && behavior.allowsDeviceAuth()) {
            handlers.add(new DeviceAuthMethodHandler(this));
        }
        LoginMethodHandler[] result = new LoginMethodHandler[handlers.size()];
        handlers.toArray(result);
        return result;
    }

    boolean checkInternetPermission() {
        if (this.checkedInternetPermission) {
            return true;
        }
        int permissionCheck = this.checkPermission("android.permission.INTERNET");
        if (permissionCheck != 0) {
            FragmentActivity activity = this.getActivity();
            String errorType = activity.getString(R.string.com_facebook_internet_permission_error_title);
            String errorDescription = activity.getString(R.string.com_facebook_internet_permission_error_message);
            this.complete(Result.createErrorResult(this.pendingRequest, errorType, errorDescription));
            return false;
        }
        this.checkedInternetPermission = true;
        return true;
    }

    void tryNextHandler() {
        if (this.currentHandler >= 0) {
            this.logAuthorizationMethodComplete(this.getCurrentHandler().getNameForLogging(), "skipped", null, null, this.getCurrentHandler().getMethodLoggingExtras());
        }
        while (this.handlersToTry != null && this.currentHandler < this.handlersToTry.length - 1) {
            ++this.currentHandler;
            boolean started = this.tryCurrentHandler();
            if (!started) continue;
            return;
        }
        if (this.pendingRequest != null) {
            this.completeWithFailure();
        }
    }

    private void completeWithFailure() {
        this.complete(Result.createErrorResult(this.pendingRequest, "Login attempt failed.", null));
    }

    private void addLoggingExtra(String key, String value, boolean accumulate) {
        if (this.loggingExtras == null) {
            this.loggingExtras = new HashMap<String, String>();
        }
        if (this.loggingExtras.containsKey(key) && accumulate) {
            value = this.loggingExtras.get(key) + "," + value;
        }
        this.loggingExtras.put(key, value);
    }

    void addExtraData(String key, String value, boolean accumulate) {
        if (this.extraData == null) {
            this.extraData = new HashMap<String, String>();
        }
        if (this.extraData.containsKey(key) && accumulate) {
            value = this.extraData.get(key) + "," + value;
        }
        this.extraData.put(key, value);
    }

    boolean tryCurrentHandler() {
        LoginMethodHandler handler = this.getCurrentHandler();
        if (handler.needsInternetPermission() && !this.checkInternetPermission()) {
            this.addLoggingExtra("no_internet_permission", "1", false);
            return false;
        }
        int numTried = handler.tryAuthorize(this.pendingRequest);
        this.numActivitiesReturned = 0;
        if (numTried > 0) {
            this.getLogger().logAuthorizationMethodStart(this.pendingRequest.getAuthId(), handler.getNameForLogging(), this.pendingRequest.isFamilyLogin() ? "foa_mobile_login_method_start" : "fb_mobile_login_method_start");
            this.numTotalIntentsFired = numTried;
        } else {
            this.getLogger().logAuthorizationMethodNotTried(this.pendingRequest.getAuthId(), handler.getNameForLogging(), this.pendingRequest.isFamilyLogin() ? "foa_mobile_login_method_not_tried" : "fb_mobile_login_method_not_tried");
            this.addLoggingExtra("not_tried", handler.getNameForLogging(), true);
        }
        return numTried > 0;
    }

    void completeAndValidate(Result outcome) {
        if (outcome.token != null && AccessToken.isCurrentAccessTokenActive()) {
            this.validateSameFbidAndFinish(outcome);
        } else {
            this.complete(outcome);
        }
    }

    void complete(Result outcome) {
        LoginMethodHandler handler = this.getCurrentHandler();
        if (handler != null) {
            this.logAuthorizationMethodComplete(handler.getNameForLogging(), outcome, handler.getMethodLoggingExtras());
        }
        if (this.loggingExtras != null) {
            outcome.loggingExtras = this.loggingExtras;
        }
        if (this.extraData != null) {
            outcome.extraData = this.extraData;
        }
        this.handlersToTry = null;
        this.currentHandler = -1;
        this.pendingRequest = null;
        this.loggingExtras = null;
        this.numActivitiesReturned = 0;
        this.numTotalIntentsFired = 0;
        this.notifyOnCompleteListener(outcome);
    }

    OnCompletedListener getOnCompletedListener() {
        return this.onCompletedListener;
    }

    void setOnCompletedListener(OnCompletedListener onCompletedListener) {
        this.onCompletedListener = onCompletedListener;
    }

    BackgroundProcessingListener getBackgroundProcessingListener() {
        return this.backgroundProcessingListener;
    }

    void setBackgroundProcessingListener(BackgroundProcessingListener backgroundProcessingListener) {
        this.backgroundProcessingListener = backgroundProcessingListener;
    }

    int checkPermission(String permission2) {
        return this.getActivity().checkCallingOrSelfPermission(permission2);
    }

    void validateSameFbidAndFinish(Result pendingResult) {
        if (pendingResult.token == null) {
            throw new FacebookException("Can't validate without a token");
        }
        AccessToken previousToken = AccessToken.getCurrentAccessToken();
        AccessToken newToken = pendingResult.token;
        try {
            Result result = previousToken != null && newToken != null && previousToken.getUserId().equals(newToken.getUserId()) ? Result.createCompositeTokenResult(this.pendingRequest, pendingResult.token, pendingResult.authenticationToken) : Result.createErrorResult(this.pendingRequest, "User logged in as different Facebook user.", null);
            this.complete(result);
        }
        catch (Exception ex) {
            this.complete(Result.createErrorResult(this.pendingRequest, "Caught exception", ex.getMessage()));
        }
    }

    private LoginLogger getLogger() {
        if (this.loginLogger == null || !this.loginLogger.getApplicationId().equals(this.pendingRequest.getApplicationId())) {
            this.loginLogger = new LoginLogger((Context)this.getActivity(), this.pendingRequest.getApplicationId());
        }
        return this.loginLogger;
    }

    private void notifyOnCompleteListener(Result outcome) {
        if (this.onCompletedListener != null) {
            this.onCompletedListener.onCompleted(outcome);
        }
    }

    void notifyBackgroundProcessingStart() {
        if (this.backgroundProcessingListener != null) {
            this.backgroundProcessingListener.onBackgroundProcessingStarted();
        }
    }

    void notifyBackgroundProcessingStop() {
        if (this.backgroundProcessingListener != null) {
            this.backgroundProcessingListener.onBackgroundProcessingStopped();
        }
    }

    private void logAuthorizationMethodComplete(String method, Result result, Map<String, String> loggingExtras) {
        this.logAuthorizationMethodComplete(method, result.code.getLoggingValue(), result.errorMessage, result.errorCode, loggingExtras);
    }

    private void logAuthorizationMethodComplete(String method, String result, String errorMessage, String errorCode, Map<String, String> loggingExtras) {
        if (this.pendingRequest == null) {
            this.getLogger().logUnexpectedError("fb_mobile_login_method_complete", "Unexpected call to logCompleteLogin with null pendingAuthorizationRequest.", method);
        } else {
            this.getLogger().logAuthorizationMethodComplete(this.pendingRequest.getAuthId(), method, result, errorMessage, errorCode, loggingExtras, this.pendingRequest.isFamilyLogin() ? "foa_mobile_login_method_complete" : "fb_mobile_login_method_complete");
        }
    }

    static String getE2E() {
        JSONObject e2e = new JSONObject();
        try {
            e2e.put("init", System.currentTimeMillis());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return e2e.toString();
    }

    public LoginClient(Parcel source) {
        Parcelable[] o = source.readParcelableArray(LoginMethodHandler.class.getClassLoader());
        this.handlersToTry = new LoginMethodHandler[o.length];
        for (int i = 0; i < o.length; ++i) {
            this.handlersToTry[i] = (LoginMethodHandler)o[i];
            this.handlersToTry[i].setLoginClient(this);
        }
        this.currentHandler = source.readInt();
        this.pendingRequest = (Request)source.readParcelable(Request.class.getClassLoader());
        this.loggingExtras = Utility.readStringMapFromParcel((Parcel)source);
        this.extraData = Utility.readStringMapFromParcel((Parcel)source);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelableArray((Parcelable[])this.handlersToTry, flags);
        dest.writeInt(this.currentHandler);
        dest.writeParcelable((Parcelable)this.pendingRequest, flags);
        Utility.writeStringMapToParcel((Parcel)dest, this.loggingExtras);
        Utility.writeStringMapToParcel((Parcel)dest, this.extraData);
    }

    public static class Result
    implements Parcelable {
        final Code code;
        @Nullable
        final AccessToken token;
        @Nullable
        final AuthenticationToken authenticationToken;
        @Nullable
        final String errorMessage;
        @Nullable
        final String errorCode;
        final Request request;
        public Map<String, String> loggingExtras;
        public Map<String, String> extraData;
        public static final Parcelable.Creator<Result> CREATOR = new Parcelable.Creator<Result>(){

            public Result createFromParcel(Parcel source) {
                return new Result(source);
            }

            public Result[] newArray(int size) {
                return new Result[size];
            }
        };

        Result(Request request, Code code, @Nullable AccessToken token, @Nullable String errorMessage, @Nullable String errorCode) {
            this(request, code, token, null, errorMessage, errorCode);
        }

        Result(Request request, Code code, @Nullable AccessToken accessToken, @Nullable AuthenticationToken authenticationToken, @Nullable String errorMessage, @Nullable String errorCode) {
            Validate.notNull((Object)((Object)code), (String)"code");
            this.request = request;
            this.token = accessToken;
            this.authenticationToken = authenticationToken;
            this.errorMessage = errorMessage;
            this.code = code;
            this.errorCode = errorCode;
        }

        static Result createTokenResult(Request request, AccessToken token) {
            return new Result(request, Code.SUCCESS, token, null, null);
        }

        static Result createCompositeTokenResult(Request request, AccessToken accessToken, AuthenticationToken authenticationToken) {
            return new Result(request, Code.SUCCESS, accessToken, authenticationToken, null, null);
        }

        static Result createCancelResult(Request request, @Nullable String message) {
            return new Result(request, Code.CANCEL, null, message, null);
        }

        static Result createErrorResult(Request request, @Nullable String errorType, @Nullable String errorDescription) {
            return Result.createErrorResult(request, errorType, errorDescription, null);
        }

        static Result createErrorResult(Request request, @Nullable String errorType, @Nullable String errorDescription, @Nullable String errorCode) {
            String message = TextUtils.join((CharSequence)": ", (Iterable)Utility.asListNoNulls((Object[])new String[]{errorType, errorDescription}));
            return new Result(request, Code.ERROR, null, message, errorCode);
        }

        private Result(Parcel parcel) {
            this.code = Code.valueOf(parcel.readString());
            this.token = (AccessToken)parcel.readParcelable(AccessToken.class.getClassLoader());
            this.authenticationToken = (AuthenticationToken)parcel.readParcelable(AuthenticationToken.class.getClassLoader());
            this.errorMessage = parcel.readString();
            this.errorCode = parcel.readString();
            this.request = (Request)parcel.readParcelable(Request.class.getClassLoader());
            this.loggingExtras = Utility.readStringMapFromParcel((Parcel)parcel);
            this.extraData = Utility.readStringMapFromParcel((Parcel)parcel);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.code.name());
            dest.writeParcelable((Parcelable)this.token, flags);
            dest.writeParcelable((Parcelable)this.authenticationToken, flags);
            dest.writeString(this.errorMessage);
            dest.writeString(this.errorCode);
            dest.writeParcelable((Parcelable)this.request, flags);
            Utility.writeStringMapToParcel((Parcel)dest, this.loggingExtras);
            Utility.writeStringMapToParcel((Parcel)dest, this.extraData);
        }

        static enum Code {
            SUCCESS("success"),
            CANCEL("cancel"),
            ERROR("error");

            private final String loggingValue;

            private Code(String loggingValue) {
                this.loggingValue = loggingValue;
            }

            String getLoggingValue() {
                return this.loggingValue;
            }
        }
    }

    public static class Request
    implements Parcelable {
        private final LoginBehavior loginBehavior;
        private Set<String> permissions;
        private final DefaultAudience defaultAudience;
        private final String applicationId;
        private String authId;
        private boolean isRerequest = false;
        private String deviceRedirectUriString;
        private String authType;
        private String deviceAuthTargetUserId;
        @Nullable
        private String messengerPageId;
        private boolean resetMessengerState;
        private final LoginTargetApp targetApp;
        private boolean isFamilyLogin = false;
        private boolean shouldSkipAccountDeduplication = false;
        private String nonce;
        public static final Parcelable.Creator<Request> CREATOR = new Parcelable.Creator<Request>(){

            public Request createFromParcel(Parcel source) {
                return new Request(source);
            }

            public Request[] newArray(int size) {
                return new Request[size];
            }
        };

        Request(LoginBehavior loginBehavior, Set<String> permissions, DefaultAudience defaultAudience, String authType, String applicationId, String authId) {
            this(loginBehavior, permissions, defaultAudience, authType, applicationId, authId, LoginTargetApp.FACEBOOK);
        }

        Request(LoginBehavior loginBehavior, Set<String> permissions, DefaultAudience defaultAudience, String authType, String applicationId, String authId, LoginTargetApp targetApp) {
            this(loginBehavior, permissions, defaultAudience, authType, applicationId, authId, targetApp, null);
        }

        Request(LoginBehavior loginBehavior, Set<String> permissions, DefaultAudience defaultAudience, String authType, String applicationId, String authId, LoginTargetApp targetApp, String nonce) {
            this.loginBehavior = loginBehavior;
            this.permissions = permissions != null ? permissions : new HashSet();
            this.defaultAudience = defaultAudience;
            this.authType = authType;
            this.applicationId = applicationId;
            this.authId = authId;
            this.targetApp = targetApp;
            this.nonce = Utility.isNullOrEmpty((String)nonce) ? UUID.randomUUID().toString() : nonce;
        }

        Set<String> getPermissions() {
            return this.permissions;
        }

        void setPermissions(Set<String> permissions) {
            Validate.notNull(permissions, (String)"permissions");
            this.permissions = permissions;
        }

        LoginBehavior getLoginBehavior() {
            return this.loginBehavior;
        }

        LoginTargetApp getLoginTargetApp() {
            return this.targetApp;
        }

        DefaultAudience getDefaultAudience() {
            return this.defaultAudience;
        }

        String getApplicationId() {
            return this.applicationId;
        }

        String getAuthId() {
            return this.authId;
        }

        void setAuthId(String authId) {
            this.authId = authId;
        }

        boolean isRerequest() {
            return this.isRerequest;
        }

        void setRerequest(boolean isRerequest) {
            this.isRerequest = isRerequest;
        }

        boolean isFamilyLogin() {
            return this.isFamilyLogin;
        }

        void setFamilyLogin(boolean isFamilyLogin) {
            this.isFamilyLogin = isFamilyLogin;
        }

        boolean shouldSkipAccountDeduplication() {
            return this.shouldSkipAccountDeduplication;
        }

        void setShouldSkipAccountDeduplication(boolean shouldSkipAccountDeduplication) {
            this.shouldSkipAccountDeduplication = shouldSkipAccountDeduplication;
        }

        String getDeviceRedirectUriString() {
            return this.deviceRedirectUriString;
        }

        void setDeviceRedirectUriString(String deviceRedirectUriString) {
            this.deviceRedirectUriString = deviceRedirectUriString;
        }

        String getDeviceAuthTargetUserId() {
            return this.deviceAuthTargetUserId;
        }

        void setDeviceAuthTargetUserId(String deviceAuthTargetUserId) {
            this.deviceAuthTargetUserId = deviceAuthTargetUserId;
        }

        String getAuthType() {
            return this.authType;
        }

        void setAuthType(String authType) {
            this.authType = authType;
        }

        @Nullable
        public String getMessengerPageId() {
            return this.messengerPageId;
        }

        public void setMessengerPageId(@Nullable String pageId) {
            this.messengerPageId = pageId;
        }

        public boolean getResetMessengerState() {
            return this.resetMessengerState;
        }

        public void setResetMessengerState(boolean resetMessengerState) {
            this.resetMessengerState = resetMessengerState;
        }

        boolean hasPublishPermission() {
            for (String permission2 : this.permissions) {
                if (!LoginManager.isPublishPermission(permission2)) continue;
                return true;
            }
            return false;
        }

        boolean isInstagramLogin() {
            return this.targetApp == LoginTargetApp.INSTAGRAM;
        }

        public String getNonce() {
            return this.nonce;
        }

        private Request(Parcel parcel) {
            String enumValue = parcel.readString();
            this.loginBehavior = enumValue != null ? LoginBehavior.valueOf(enumValue) : null;
            ArrayList permissionsList = new ArrayList();
            parcel.readStringList(permissionsList);
            this.permissions = new HashSet<String>(permissionsList);
            enumValue = parcel.readString();
            this.defaultAudience = enumValue != null ? DefaultAudience.valueOf((String)enumValue) : null;
            this.applicationId = parcel.readString();
            this.authId = parcel.readString();
            this.isRerequest = parcel.readByte() != 0;
            this.deviceRedirectUriString = parcel.readString();
            this.authType = parcel.readString();
            this.deviceAuthTargetUserId = parcel.readString();
            this.messengerPageId = parcel.readString();
            this.resetMessengerState = parcel.readByte() != 0;
            enumValue = parcel.readString();
            this.targetApp = enumValue != null ? LoginTargetApp.valueOf((String)enumValue) : null;
            this.isFamilyLogin = parcel.readByte() != 0;
            this.shouldSkipAccountDeduplication = parcel.readByte() != 0;
            this.nonce = parcel.readString();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.loginBehavior != null ? this.loginBehavior.name() : null);
            dest.writeStringList(new ArrayList<String>(this.permissions));
            dest.writeString(this.defaultAudience != null ? this.defaultAudience.name() : null);
            dest.writeString(this.applicationId);
            dest.writeString(this.authId);
            dest.writeByte((byte)(this.isRerequest ? 1 : 0));
            dest.writeString(this.deviceRedirectUriString);
            dest.writeString(this.authType);
            dest.writeString(this.deviceAuthTargetUserId);
            dest.writeString(this.messengerPageId);
            dest.writeByte((byte)(this.resetMessengerState ? 1 : 0));
            dest.writeString(this.targetApp != null ? this.targetApp.name() : null);
            dest.writeByte((byte)(this.isFamilyLogin ? 1 : 0));
            dest.writeByte((byte)(this.shouldSkipAccountDeduplication ? 1 : 0));
            dest.writeString(this.nonce);
        }
    }

    static interface BackgroundProcessingListener {
        public void onBackgroundProcessingStarted();

        public void onBackgroundProcessingStopped();
    }

    public static interface OnCompletedListener {
        public void onCompleted(Result var1);
    }
}

