/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookGraphResponseException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.NativeAppCallAttachmentStore;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.share.Sharer;
import com.facebook.share.internal.OpenGraphJSONUtility;
import com.facebook.share.internal.ResultProcessor;
import com.facebook.share.model.CameraEffectTextures;
import com.facebook.share.model.ShareCameraEffectContent;
import com.facebook.share.model.ShareMedia;
import com.facebook.share.model.ShareMediaContent;
import com.facebook.share.model.ShareOpenGraphAction;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareStoryContent;
import com.facebook.share.model.ShareVideo;
import com.facebook.share.model.ShareVideoContent;
import com.facebook.share.widget.LikeView;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ShareInternalUtility {
    public static final String MY_PHOTOS = "me/photos";
    static final String MY_STAGING_RESOURCES = "me/staging_resources";
    static final String STAGING_PARAM = "file";

    /*
     * WARNING - void declaration
     */
    public static void invokeCallbackWithException(FacebookCallback<Sharer.Result> facebookCallback, Exception exception) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return;
        }
        try {
            FacebookCallback<Sharer.Result> callback2;
            void exception2;
            if (exception2 instanceof FacebookException) {
                ShareInternalUtility.invokeOnErrorCallback(callback2, (FacebookException)exception2);
                return;
            }
            ShareInternalUtility.invokeCallbackWithError(callback2, "Error preparing share content: " + exception2.getLocalizedMessage());
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void invokeCallbackWithError(FacebookCallback<Sharer.Result> facebookCallback, String string2) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return;
        }
        try {
            void error;
            FacebookCallback<Sharer.Result> callback2;
            ShareInternalUtility.invokeOnErrorCallback(callback2, (String)error);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void invokeCallbackWithResults(FacebookCallback<Sharer.Result> facebookCallback, String string2, GraphResponse graphResponse) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return;
        }
        try {
            FacebookCallback<Sharer.Result> callback2;
            void graphResponse2;
            FacebookRequestError requestError = graphResponse2.getError();
            if (requestError != null) {
                String errorMessage = requestError.getErrorMessage();
                if (Utility.isNullOrEmpty((String)errorMessage)) {
                    errorMessage = "Unexpected error sharing.";
                }
                ShareInternalUtility.invokeOnErrorCallback(callback2, (GraphResponse)graphResponse2, errorMessage);
            } else {
                void postId;
                ShareInternalUtility.invokeOnSuccessCallback(callback2, (String)postId);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return;
        }
    }

    public static String getNativeDialogCompletionGesture(Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            Bundle result;
            if (result.containsKey("completionGesture")) {
                return result.getString("completionGesture");
            }
            return result.getString("com.facebook.platform.extra.COMPLETION_GESTURE");
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    public static String getShareDialogPostId(Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            Bundle result;
            if (result.containsKey("postId")) {
                return result.getString("postId");
            }
            if (result.containsKey("com.facebook.platform.extra.POST_ID")) {
                return result.getString("com.facebook.platform.extra.POST_ID");
            }
            return result.getString("post_id");
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean handleActivityResult(int n, int n2, Intent intent, ResultProcessor resultProcessor) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return false;
        }
        try {
            void resultProcessor2;
            void data;
            void resultCode;
            int requestCode;
            AppCall appCall = ShareInternalUtility.getAppCallFromActivityResult(requestCode, (int)resultCode, (Intent)data);
            if (appCall == null) {
                return false;
            }
            NativeAppCallAttachmentStore.cleanupAttachmentsForCall((UUID)appCall.getCallId());
            if (resultProcessor2 == null) {
                return true;
            }
            FacebookException exception = NativeProtocol.getExceptionFromErrorData((Bundle)NativeProtocol.getErrorDataFromResultIntent((Intent)data));
            if (exception != null) {
                if (exception instanceof FacebookOperationCanceledException) {
                    resultProcessor2.onCancel(appCall);
                } else {
                    resultProcessor2.onError(appCall, exception);
                }
            } else {
                Bundle results = NativeProtocol.getSuccessResultsFromIntent((Intent)data);
                resultProcessor2.onSuccess(appCall, results);
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return false;
        }
    }

    public static ResultProcessor getShareResultProcessor(FacebookCallback<Sharer.Result> facebookCallback) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            FacebookCallback<Sharer.Result> callback2;
            return new ResultProcessor(callback2){

                @Override
                public void onSuccess(AppCall appCall, Bundle results) {
                    if (results != null) {
                        String gesture = ShareInternalUtility.getNativeDialogCompletionGesture(results);
                        if (gesture == null || "post".equalsIgnoreCase(gesture)) {
                            String postId = ShareInternalUtility.getShareDialogPostId(results);
                            if (postId != null) {
                                ShareInternalUtility.invokeOnSuccessCallback(callback2, postId);
                            } else {
                                ShareInternalUtility.invokeOnErrorCallback((FacebookCallback<Sharer.Result>)callback2, new FacebookException("UnknownError"));
                            }
                        } else if ("cancel".equalsIgnoreCase(gesture)) {
                            ShareInternalUtility.invokeOnCancelCallback(callback2);
                        } else {
                            ShareInternalUtility.invokeOnErrorCallback((FacebookCallback<Sharer.Result>)callback2, new FacebookException("UnknownError"));
                        }
                    }
                }

                @Override
                public void onCancel(AppCall appCall) {
                    ShareInternalUtility.invokeOnCancelCallback(callback2);
                }

                @Override
                public void onError(AppCall appCall, FacebookException error) {
                    ShareInternalUtility.invokeOnErrorCallback((FacebookCallback<Sharer.Result>)callback2, error);
                }
            };
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static AppCall getAppCallFromActivityResult(int n, int n2, Intent intent) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            int requestCode;
            void data;
            UUID callId = NativeProtocol.getCallIdFromIntent((Intent)data);
            if (callId == null) {
                return null;
            }
            return AppCall.finishPendingCall(callId, requestCode);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    public static void registerStaticShareCallback(int n) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return;
        }
        try {
            int requestCode;
            CallbackManagerImpl.registerStaticCallback((int)requestCode, (CallbackManagerImpl.Callback)new CallbackManagerImpl.Callback(){

                public boolean onActivityResult(int resultCode, Intent data) {
                    return ShareInternalUtility.handleActivityResult(requestCode, resultCode, data, ShareInternalUtility.getShareResultProcessor(null));
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registerSharerCallback(int n, CallbackManager callbackManager, FacebookCallback<Sharer.Result> facebookCallback) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return;
        }
        try {
            void callback2;
            int requestCode;
            void callbackManager2;
            if (!(callbackManager2 instanceof CallbackManagerImpl)) {
                throw new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
            }
            ((CallbackManagerImpl)callbackManager2).registerCallback(requestCode, new CallbackManagerImpl.Callback((FacebookCallback)callback2){
                final /* synthetic */ FacebookCallback val$callback;
                {
                    this.val$callback = facebookCallback;
                }

                public boolean onActivityResult(int resultCode, Intent data) {
                    return ShareInternalUtility.handleActivityResult(requestCode, resultCode, data, ShareInternalUtility.getShareResultProcessor(this.val$callback));
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getPhotoUrls(SharePhotoContent sharePhotoContent, UUID uUID) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            void appCallId;
            List<SharePhoto> photos;
            SharePhotoContent photoContent;
            if (photoContent == null || (photos = photoContent.getPhotos()) == null) {
                return null;
            }
            List attachments = Utility.map(photos, (Utility.Mapper)new Utility.Mapper<SharePhoto, NativeAppCallAttachmentStore.Attachment>((UUID)appCallId){
                final /* synthetic */ UUID val$appCallId;
                {
                    this.val$appCallId = uUID;
                }

                public NativeAppCallAttachmentStore.Attachment apply(SharePhoto item) {
                    return ShareInternalUtility.access$000(this.val$appCallId, item);
                }
            });
            List attachmentUrls = Utility.map((List)attachments, (Utility.Mapper)new Utility.Mapper<NativeAppCallAttachmentStore.Attachment, String>(){

                public String apply(NativeAppCallAttachmentStore.Attachment item) {
                    return item.getAttachmentUrl();
                }
            });
            NativeAppCallAttachmentStore.addAttachments((Collection)attachments);
            return attachmentUrls;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getVideoUrl(ShareVideoContent shareVideoContent, UUID uUID) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            void appCallId;
            ShareVideoContent videoContent;
            if (videoContent == null || videoContent.getVideo() == null) {
                return null;
            }
            NativeAppCallAttachmentStore.Attachment attachment = NativeAppCallAttachmentStore.createAttachment((UUID)appCallId, (Uri)videoContent.getVideo().getLocalUrl());
            ArrayList<NativeAppCallAttachmentStore.Attachment> attachments = new ArrayList<NativeAppCallAttachmentStore.Attachment>(1);
            attachments.add(attachment);
            NativeAppCallAttachmentStore.addAttachments(attachments);
            return attachment.getAttachmentUrl();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<Bundle> getMediaInfos(ShareMediaContent shareMediaContent, UUID uUID) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            void appCallId;
            List<ShareMedia> media;
            ShareMediaContent mediaContent;
            if (mediaContent == null || (media = mediaContent.getMedia()) == null) {
                return null;
            }
            ArrayList attachments = new ArrayList();
            List mediaInfos = Utility.map(media, (Utility.Mapper)new Utility.Mapper<ShareMedia, Bundle>((UUID)appCallId, attachments){
                final /* synthetic */ UUID val$appCallId;
                final /* synthetic */ List val$attachments;
                {
                    this.val$appCallId = uUID;
                    this.val$attachments = list;
                }

                public Bundle apply(ShareMedia item) {
                    NativeAppCallAttachmentStore.Attachment attachment = ShareInternalUtility.access$000(this.val$appCallId, item);
                    this.val$attachments.add(attachment);
                    Bundle mediaInfo = new Bundle();
                    mediaInfo.putString("type", item.getMediaType().name());
                    mediaInfo.putString("uri", attachment.getAttachmentUrl());
                    return mediaInfo;
                }
            });
            NativeAppCallAttachmentStore.addAttachments(attachments);
            return mediaInfos;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Bundle getTextureUrlBundle(ShareCameraEffectContent shareCameraEffectContent, UUID uUID) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            CameraEffectTextures textures;
            ShareCameraEffectContent cameraEffectContent;
            if (cameraEffectContent == null || (textures = cameraEffectContent.getTextures()) == null) {
                return null;
            }
            Bundle attachmentUrlsBundle = new Bundle();
            ArrayList<NativeAppCallAttachmentStore.Attachment> attachments = new ArrayList<NativeAppCallAttachmentStore.Attachment>();
            for (String key : textures.keySet()) {
                void appCallId;
                NativeAppCallAttachmentStore.Attachment attachment = ShareInternalUtility.getAttachment((UUID)appCallId, textures.getTextureUri(key), textures.getTextureBitmap(key));
                attachments.add(attachment);
                attachmentUrlsBundle.putString(key, attachment.getAttachmentUrl());
            }
            NativeAppCallAttachmentStore.addAttachments(attachments);
            return attachmentUrlsBundle;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static JSONObject toJSONObjectForCall(UUID uUID, ShareOpenGraphContent shareOpenGraphContent) throws JSONException {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            String placeTag;
            UUID callId;
            void content;
            ShareOpenGraphAction action = content.getAction();
            final ArrayList attachments = new ArrayList();
            JSONObject actionJSON = OpenGraphJSONUtility.toJSONObject(action, new OpenGraphJSONUtility.PhotoJSONProcessor(){

                @Override
                public JSONObject toJSONObject(SharePhoto photo) {
                    NativeAppCallAttachmentStore.Attachment attachment = ShareInternalUtility.access$000(callId, photo);
                    if (attachment == null) {
                        return null;
                    }
                    attachments.add(attachment);
                    JSONObject photoJSONObject = new JSONObject();
                    try {
                        photoJSONObject.put("url", (Object)attachment.getAttachmentUrl());
                        if (photo.getUserGenerated()) {
                            photoJSONObject.put("user_generated", true);
                        }
                    }
                    catch (JSONException e) {
                        throw new FacebookException("Unable to attach images", (Throwable)e);
                    }
                    return photoJSONObject;
                }
            });
            NativeAppCallAttachmentStore.addAttachments(attachments);
            if (content.getPlaceId() != null && Utility.isNullOrEmpty((String)(placeTag = actionJSON.optString("place")))) {
                actionJSON.put("place", (Object)content.getPlaceId());
            }
            if (content.getPeopleIds() != null) {
                JSONArray peopleTags = actionJSON.optJSONArray("tags");
                Set<String> peopleIdSet = peopleTags == null ? new HashSet() : Utility.jsonArrayToSet((JSONArray)peopleTags);
                for (String peopleId : content.getPeopleIds()) {
                    peopleIdSet.add(peopleId);
                }
                actionJSON.put("tags", (Object)new JSONArray(peopleIdSet));
            }
            return actionJSON;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    public static JSONObject toJSONObjectForWeb(ShareOpenGraphContent shareOpenGraphContent) throws JSONException {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            ShareOpenGraphContent shareOpenGraphContent2;
            ShareOpenGraphAction action = shareOpenGraphContent2.getAction();
            return OpenGraphJSONUtility.toJSONObject(action, new OpenGraphJSONUtility.PhotoJSONProcessor(){

                @Override
                public JSONObject toJSONObject(SharePhoto photo) {
                    Uri photoUri = photo.getImageUrl();
                    if (!Utility.isWebUri((Uri)photoUri)) {
                        throw new FacebookException("Only web images may be used in OG objects shared via the web dialog");
                    }
                    JSONObject photoJSONObject = new JSONObject();
                    try {
                        photoJSONObject.put("url", (Object)photoUri.toString());
                    }
                    catch (JSONException e) {
                        throw new FacebookException("Unable to attach images", (Throwable)e);
                    }
                    return photoJSONObject;
                }
            });
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static JSONArray removeNamespacesFromOGJsonArray(JSONArray jSONArray, boolean bl) throws JSONException {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            JSONArray jsonArray;
            JSONArray newArray = new JSONArray();
            for (int i = 0; i < jsonArray.length(); ++i) {
                void requireNamespace;
                Object value = jsonArray.get(i);
                if (value instanceof JSONArray) {
                    value = ShareInternalUtility.removeNamespacesFromOGJsonArray((JSONArray)value, (boolean)requireNamespace);
                } else if (value instanceof JSONObject) {
                    value = ShareInternalUtility.removeNamespacesFromOGJsonObject((JSONObject)value, (boolean)requireNamespace);
                }
                newArray.put(value);
            }
            return newArray;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static JSONObject removeNamespacesFromOGJsonObject(JSONObject jSONObject, boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            JSONObject jsonObject;
            if (jsonObject == null) {
                return null;
            }
            try {
                JSONObject newJsonObject = new JSONObject();
                JSONObject data = new JSONObject();
                JSONArray names = jsonObject.names();
                for (int i = 0; i < names.length(); ++i) {
                    void requireNamespace;
                    String key = names.getString(i);
                    Object value = jsonObject.get(key);
                    if (value instanceof JSONObject) {
                        value = ShareInternalUtility.removeNamespacesFromOGJsonObject((JSONObject)value, true);
                    } else if (value instanceof JSONArray) {
                        value = ShareInternalUtility.removeNamespacesFromOGJsonArray((JSONArray)value, true);
                    }
                    Pair<String, String> fieldNameAndNamespace = ShareInternalUtility.getFieldNameAndNamespaceFromFullName(key);
                    String namespace = (String)fieldNameAndNamespace.first;
                    String fieldName = (String)fieldNameAndNamespace.second;
                    if (requireNamespace != false) {
                        if (namespace != null && namespace.equals("fbsdk")) {
                            newJsonObject.put(key, value);
                            continue;
                        }
                        if (namespace == null || namespace.equals("og")) {
                            newJsonObject.put(fieldName, value);
                            continue;
                        }
                        data.put(fieldName, value);
                        continue;
                    }
                    if (namespace != null && namespace.equals("fb")) {
                        newJsonObject.put(key, value);
                        continue;
                    }
                    newJsonObject.put(fieldName, value);
                }
                if (data.length() > 0) {
                    newJsonObject.put("data", (Object)data);
                }
                return newJsonObject;
            }
            catch (JSONException e) {
                throw new FacebookException("Failed to create json object from share content");
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    public static Pair<String, String> getFieldNameAndNamespaceFromFullName(String string2) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            String fieldName;
            String fullName;
            String namespace = null;
            int index = fullName.indexOf(58);
            if (index != -1 && fullName.length() > index + 1) {
                namespace = fullName.substring(0, index);
                fieldName = fullName.substring(index + 1);
            } else {
                fieldName = fullName;
            }
            return new Pair(namespace, (Object)fieldName);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static NativeAppCallAttachmentStore.Attachment getAttachment(UUID uUID, ShareMedia shareMedia) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            UUID callId;
            void medium;
            Bitmap bitmap = null;
            Uri uri = null;
            if (medium instanceof SharePhoto) {
                SharePhoto photo = (SharePhoto)medium;
                bitmap = photo.getBitmap();
                uri = photo.getImageUrl();
            } else if (medium instanceof ShareVideo) {
                ShareVideo video = (ShareVideo)medium;
                uri = video.getLocalUrl();
            }
            return ShareInternalUtility.getAttachment(callId, uri, bitmap);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static NativeAppCallAttachmentStore.Attachment getAttachment(UUID uUID, Uri uri, Bitmap bitmap) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            void uri2;
            UUID callId;
            void bitmap2;
            NativeAppCallAttachmentStore.Attachment attachment = null;
            if (bitmap2 != null) {
                attachment = NativeAppCallAttachmentStore.createAttachment((UUID)callId, (Bitmap)bitmap2);
            } else if (uri2 != null) {
                attachment = NativeAppCallAttachmentStore.createAttachment((UUID)callId, (Uri)uri2);
            }
            return attachment;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    static void invokeOnCancelCallback(FacebookCallback<Sharer.Result> facebookCallback) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return;
        }
        try {
            FacebookCallback<Sharer.Result> callback2;
            ShareInternalUtility.logShareResult("cancelled", null);
            if (callback2 != null) {
                callback2.onCancel();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void invokeOnSuccessCallback(FacebookCallback<Sharer.Result> facebookCallback, String string2) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return;
        }
        try {
            FacebookCallback<Sharer.Result> callback2;
            ShareInternalUtility.logShareResult("succeeded", null);
            if (callback2 != null) {
                void postId;
                callback2.onSuccess(new Sharer.Result((String)postId));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void invokeOnErrorCallback(FacebookCallback<Sharer.Result> facebookCallback, GraphResponse graphResponse, String string2) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return;
        }
        try {
            FacebookCallback<Sharer.Result> callback2;
            void message;
            ShareInternalUtility.logShareResult("error", (String)message);
            if (callback2 != null) {
                void response;
                callback2.onError((FacebookException)new FacebookGraphResponseException((GraphResponse)response, (String)message));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void invokeOnErrorCallback(FacebookCallback<Sharer.Result> facebookCallback, String string2) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return;
        }
        try {
            FacebookCallback<Sharer.Result> callback2;
            void message;
            ShareInternalUtility.logShareResult("error", (String)message);
            if (callback2 != null) {
                callback2.onError(new FacebookException((String)message));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void invokeOnErrorCallback(FacebookCallback<Sharer.Result> facebookCallback, FacebookException facebookException) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return;
        }
        try {
            FacebookCallback<Sharer.Result> callback2;
            void ex;
            ShareInternalUtility.logShareResult("error", ex.getMessage());
            if (callback2 != null) {
                callback2.onError((FacebookException)ex);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void logShareResult(String string2, String string3) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return;
        }
        try {
            void errorMessage;
            String shareOutcome;
            Context context = FacebookSdk.getApplicationContext();
            InternalAppEventsLogger logger = new InternalAppEventsLogger(context);
            Bundle parameters = new Bundle();
            parameters.putString("fb_share_dialog_outcome", shareOutcome);
            if (errorMessage != null) {
                parameters.putString("error_message", (String)errorMessage);
            }
            logger.logEventImplicitly("fb_share_dialog_result", parameters);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static GraphRequest newUploadStagingResourceWithImageRequest(AccessToken accessToken, Bitmap bitmap, GraphRequest.Callback callback2) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            void callback3;
            AccessToken accessToken2;
            void image;
            Bundle parameters = new Bundle(1);
            parameters.putParcelable(STAGING_PARAM, (Parcelable)image);
            return new GraphRequest(accessToken2, MY_STAGING_RESOURCES, parameters, HttpMethod.POST, (GraphRequest.Callback)callback3);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static GraphRequest newUploadStagingResourceWithImageRequest(AccessToken accessToken, File file, GraphRequest.Callback callback2) throws FileNotFoundException {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            void callback3;
            AccessToken accessToken2;
            void file2;
            ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)file2, (int)0x10000000);
            GraphRequest.ParcelableResourceWithMimeType resourceWithMimeType = new GraphRequest.ParcelableResourceWithMimeType((Parcelable)descriptor, "image/png");
            Bundle parameters = new Bundle(1);
            parameters.putParcelable(STAGING_PARAM, (Parcelable)resourceWithMimeType);
            return new GraphRequest(accessToken2, MY_STAGING_RESOURCES, parameters, HttpMethod.POST, (GraphRequest.Callback)callback3);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static GraphRequest newUploadStagingResourceWithImageRequest(AccessToken accessToken, Uri uri, GraphRequest.Callback callback2) throws FileNotFoundException {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            void callback3;
            AccessToken accessToken2;
            void imageUri;
            if (Utility.isFileUri((Uri)imageUri)) {
                return ShareInternalUtility.newUploadStagingResourceWithImageRequest(accessToken2, new File(imageUri.getPath()), (GraphRequest.Callback)callback3);
            }
            if (!Utility.isContentUri((Uri)imageUri)) {
                throw new FacebookException("The image Uri must be either a file:// or content:// Uri");
            }
            GraphRequest.ParcelableResourceWithMimeType resourceWithMimeType = new GraphRequest.ParcelableResourceWithMimeType((Parcelable)imageUri, "image/png");
            Bundle parameters = new Bundle(1);
            parameters.putParcelable(STAGING_PARAM, (Parcelable)resourceWithMimeType);
            return new GraphRequest(accessToken2, MY_STAGING_RESOURCES, parameters, HttpMethod.POST, (GraphRequest.Callback)callback3);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static LikeView.ObjectType getMostSpecificObjectType(LikeView.ObjectType objectType, LikeView.ObjectType objectType2) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            void objectType22;
            LikeView.ObjectType objectType1;
            if (objectType1 == objectType22) {
                return objectType1;
            }
            if (objectType1 == LikeView.ObjectType.UNKNOWN) {
                return objectType22;
            }
            if (objectType22 == LikeView.ObjectType.UNKNOWN) {
                return objectType1;
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Bundle getStickerUrl(ShareStoryContent shareStoryContent, UUID uUID) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            void appCallId;
            ShareStoryContent storyContent;
            if (storyContent == null || storyContent.getStickerAsset() == null) {
                return null;
            }
            ArrayList<SharePhoto> photos = new ArrayList<SharePhoto>();
            photos.add(storyContent.getStickerAsset());
            List attachments = Utility.map(photos, (Utility.Mapper)new Utility.Mapper<SharePhoto, NativeAppCallAttachmentStore.Attachment>((UUID)appCallId){
                final /* synthetic */ UUID val$appCallId;
                {
                    this.val$appCallId = uUID;
                }

                public NativeAppCallAttachmentStore.Attachment apply(SharePhoto item) {
                    return ShareInternalUtility.access$000(this.val$appCallId, item);
                }
            });
            List stickerInfo = Utility.map((List)attachments, (Utility.Mapper)new Utility.Mapper<NativeAppCallAttachmentStore.Attachment, Bundle>(){

                public Bundle apply(NativeAppCallAttachmentStore.Attachment item) {
                    Bundle mediaInfo = new Bundle();
                    mediaInfo.putString("uri", item.getAttachmentUrl());
                    String extension = ShareInternalUtility.getUriExtension(item.getOriginalUri());
                    if (extension != null) {
                        Utility.putNonEmptyString((Bundle)mediaInfo, (String)"extension", (String)extension);
                    }
                    return mediaInfo;
                }
            });
            NativeAppCallAttachmentStore.addAttachments((Collection)attachments);
            return (Bundle)stickerInfo.get(0);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Bundle getBackgroundAssetMediaInfo(ShareStoryContent shareStoryContent, UUID uUID) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            void appCallId;
            ShareStoryContent storyContent;
            if (storyContent == null || storyContent.getBackgroundAsset() == null) {
                return null;
            }
            ArrayList<ShareMedia> media = new ArrayList<ShareMedia>();
            media.add(storyContent.getBackgroundAsset());
            ArrayList attachments = new ArrayList();
            List mediaInfos = Utility.map(media, (Utility.Mapper)new Utility.Mapper<ShareMedia, Bundle>((UUID)appCallId, attachments){
                final /* synthetic */ UUID val$appCallId;
                final /* synthetic */ List val$attachments;
                {
                    this.val$appCallId = uUID;
                    this.val$attachments = list;
                }

                public Bundle apply(ShareMedia item) {
                    NativeAppCallAttachmentStore.Attachment attachment = ShareInternalUtility.access$000(this.val$appCallId, item);
                    this.val$attachments.add(attachment);
                    Bundle mediaInfo = new Bundle();
                    mediaInfo.putString("type", item.getMediaType().name());
                    mediaInfo.putString("uri", attachment.getAttachmentUrl());
                    String extension = ShareInternalUtility.getUriExtension(attachment.getOriginalUri());
                    if (extension != null) {
                        Utility.putNonEmptyString((Bundle)mediaInfo, (String)"extension", (String)extension);
                    }
                    return mediaInfo;
                }
            });
            NativeAppCallAttachmentStore.addAttachments(attachments);
            return (Bundle)mediaInfos.get(0);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    @Nullable
    public static String getUriExtension(Uri uri) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            Uri uri2;
            if (uri2 == null) {
                return null;
            }
            String path = uri2.toString();
            int idx = path.lastIndexOf(46);
            if (idx == -1) {
                return null;
            }
            return path.substring(idx);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ NativeAppCallAttachmentStore.Attachment access$000(UUID uUID, ShareMedia shareMedia) {
        if (CrashShieldHandler.isObjectCrashing(ShareInternalUtility.class)) {
            return null;
        }
        try {
            void x1;
            UUID x0;
            return ShareInternalUtility.getAttachment(x0, (ShareMedia)x1);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareInternalUtility.class);
            return null;
        }
    }
}

