/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Pair;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.contract.ActivityResultContract;
import com.facebook.CallbackManager;
import com.facebook.CustomTabMainActivity;
import com.facebook.FacebookActivity;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.CustomTabUtils;
import com.facebook.internal.DialogFeature;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\"\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J$\u0010#\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010$\u001a\u0004\u0018\u00010\u000f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J\u001a\u0010'\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010(\u001a\u0004\u0018\u00010)H\u0007J \u0010*\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010-\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010.\u001a\u0004\u0018\u00010)H\u0007J$\u0010/\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J\"\u00100\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J*\u00101\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0007\u00a8\u00067"}, d2={"Lcom/facebook/internal/DialogPresenter;", "", "()V", "canPresentNativeDialogWithFeature", "", "feature", "Lcom/facebook/internal/DialogFeature;", "canPresentWebFallbackDialogWithFeature", "getDialogWebFallbackUri", "Landroid/net/Uri;", "getProtocolVersionForNativeDialog", "Lcom/facebook/internal/NativeProtocol$ProtocolVersionQueryResult;", "getVersionSpecForFeature", "", "applicationId", "", "actionName", "logDialogActivity", "", "context", "Landroid/content/Context;", "eventName", "outcome", "present", "appCall", "Lcom/facebook/internal/AppCall;", "activity", "Landroid/app/Activity;", "registry", "Landroidx/activity/result/ActivityResultRegistry;", "callbackManager", "Lcom/facebook/CallbackManager;", "fragmentWrapper", "Lcom/facebook/internal/FragmentWrapper;", "setupAppCallForCannotShowError", "setupAppCallForCustomTabDialog", "action", "parameters", "Landroid/os/Bundle;", "setupAppCallForErrorResult", "exception", "Lcom/facebook/FacebookException;", "setupAppCallForNativeDialog", "parameterProvider", "Lcom/facebook/internal/DialogPresenter$ParameterProvider;", "setupAppCallForValidationError", "validationError", "setupAppCallForWebDialog", "setupAppCallForWebFallbackDialog", "startActivityForResultWithAndroidX", "intent", "Landroid/content/Intent;", "requestCode", "", "ParameterProvider", "facebook-common_release"})
public final class DialogPresenter {
    @NotNull
    public static final DialogPresenter INSTANCE = new DialogPresenter();

    private DialogPresenter() {
    }

    @JvmStatic
    public static final void setupAppCallForCannotShowError(@NotNull AppCall appCall) {
        Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
        FacebookException e = new FacebookException("Unable to show the provided content via the web or the installed version of the Facebook app. Some dialogs are only supported starting API 14.");
        DialogPresenter.setupAppCallForValidationError(appCall, e);
    }

    @JvmStatic
    public static final void setupAppCallForValidationError(@NotNull AppCall appCall, @Nullable FacebookException validationError) {
        Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
        DialogPresenter.setupAppCallForErrorResult(appCall, validationError);
    }

    @JvmStatic
    public static final void present(@NotNull AppCall appCall, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.startActivityForResult(appCall.getRequestIntent(), appCall.getRequestCode());
        appCall.setPending();
    }

    @JvmStatic
    public static final void present(@NotNull AppCall appCall, @NotNull FragmentWrapper fragmentWrapper) {
        Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
        Intrinsics.checkNotNullParameter((Object)fragmentWrapper, (String)"fragmentWrapper");
        fragmentWrapper.startActivityForResult(appCall.getRequestIntent(), appCall.getRequestCode());
        appCall.setPending();
    }

    @JvmStatic
    public static final void present(@NotNull AppCall appCall, @NotNull ActivityResultRegistry registry, @Nullable CallbackManager callbackManager) {
        Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intent intent = appCall.getRequestIntent();
        if (intent == null) {
            return;
        }
        Intent requestIntent = intent;
        DialogPresenter.startActivityForResultWithAndroidX(registry, callbackManager, requestIntent, appCall.getRequestCode());
        appCall.setPending();
    }

    @JvmStatic
    public static final void startActivityForResultWithAndroidX(@NotNull ActivityResultRegistry registry, @Nullable CallbackManager callbackManager, @NotNull Intent intent, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Ref.ObjectRef launcher = new Ref.ObjectRef();
        launcher.element = registry.register(Intrinsics.stringPlus((String)"facebook-dialog-request-", (Object)requestCode), (ActivityResultContract)new ActivityResultContract<Intent, Pair<Integer, Intent>>(){

            @NotNull
            public Intent createIntent(@NotNull Context context, @NotNull Intent input) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return input;
            }

            @NotNull
            public Pair<Integer, Intent> parseResult(int resultCode, @Nullable Intent intent) {
                Pair pair = Pair.create((Object)resultCode, (Object)intent);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(resultCode, intent)");
                return pair;
            }
        }, arg_0 -> DialogPresenter.startActivityForResultWithAndroidX$lambda-2(callbackManager, requestCode, launcher, arg_0));
        ActivityResultLauncher activityResultLauncher = (ActivityResultLauncher)launcher.element;
        if (activityResultLauncher != null) {
            activityResultLauncher.launch((Object)intent);
        }
    }

    @JvmStatic
    public static final boolean canPresentNativeDialogWithFeature(@NotNull DialogFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return DialogPresenter.getProtocolVersionForNativeDialog(feature).getProtocolVersion() != -1;
    }

    @JvmStatic
    public static final boolean canPresentWebFallbackDialogWithFeature(@NotNull DialogFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return INSTANCE.getDialogWebFallbackUri(feature) != null;
    }

    @JvmStatic
    public static final void setupAppCallForErrorResult(@NotNull AppCall appCall, @Nullable FacebookException exception) {
        Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
        if (exception == null) {
            return;
        }
        Validate.hasFacebookActivity((Context)FacebookSdk.INSTANCE.getApplicationContext());
        Intent errorResultIntent = new Intent();
        errorResultIntent.setClass(FacebookSdk.INSTANCE.getApplicationContext(), FacebookActivity.class);
        errorResultIntent.setAction("PassThrough");
        NativeProtocol.setupProtocolRequestIntent((Intent)errorResultIntent, (String)appCall.getCallId().toString(), null, (int)NativeProtocol.INSTANCE.getLatestKnownVersion(), (Bundle)NativeProtocol.createBundleForException((FacebookException)exception));
        appCall.setRequestIntent(errorResultIntent);
    }

    @JvmStatic
    public static final void setupAppCallForWebDialog(@NotNull AppCall appCall, @Nullable String actionName, @Nullable Bundle parameters) {
        Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
        Validate.hasFacebookActivity((Context)FacebookSdk.INSTANCE.getApplicationContext());
        Validate.hasInternetPermissions((Context)FacebookSdk.INSTANCE.getApplicationContext());
        Bundle intentParameters = new Bundle();
        intentParameters.putString("action", actionName);
        intentParameters.putBundle("params", parameters);
        Intent webDialogIntent = new Intent();
        NativeProtocol.setupProtocolRequestIntent((Intent)webDialogIntent, (String)appCall.getCallId().toString(), (String)actionName, (int)NativeProtocol.INSTANCE.getLatestKnownVersion(), (Bundle)intentParameters);
        webDialogIntent.setClass(FacebookSdk.INSTANCE.getApplicationContext(), FacebookActivity.class);
        webDialogIntent.setAction("FacebookDialogFragment");
        appCall.setRequestIntent(webDialogIntent);
    }

    @JvmStatic
    public static final void setupAppCallForWebFallbackDialog(@NotNull AppCall appCall, @Nullable Bundle parameters, @NotNull DialogFeature feature) {
        Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Validate.hasFacebookActivity((Context)FacebookSdk.INSTANCE.getApplicationContext());
        Validate.hasInternetPermissions((Context)FacebookSdk.INSTANCE.getApplicationContext());
        String featureName = feature.name();
        Uri fallbackUrl = INSTANCE.getDialogWebFallbackUri(feature);
        if (fallbackUrl == null) {
            throw new FacebookException("Unable to fetch the Url for the DialogFeature : '" + featureName + '\'');
        }
        int protocolVersion = NativeProtocol.INSTANCE.getLatestKnownVersion();
        String string2 = appCall.getCallId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"appCall.callId.toString()");
        Bundle bundle = ServerProtocol.getQueryParamsForPlatformActivityIntentWebFallback((String)string2, (int)protocolVersion, (Bundle)parameters);
        if (bundle == null) {
            throw new FacebookException("Unable to fetch the app's key-hash");
        }
        Bundle webParams = bundle;
        fallbackUrl = fallbackUrl.isRelative() ? Utility.buildUri((String)ServerProtocol.INSTANCE.getDialogAuthority(), (String)fallbackUrl.toString(), (Bundle)webParams) : Utility.buildUri((String)fallbackUrl.getAuthority(), (String)fallbackUrl.getPath(), (Bundle)webParams);
        Bundle intentParameters = new Bundle();
        intentParameters.putString("url", fallbackUrl.toString());
        intentParameters.putBoolean("is_fallback", true);
        Intent webDialogIntent = new Intent();
        NativeProtocol.setupProtocolRequestIntent((Intent)webDialogIntent, (String)appCall.getCallId().toString(), (String)feature.getAction(), (int)NativeProtocol.INSTANCE.getLatestKnownVersion(), (Bundle)intentParameters);
        webDialogIntent.setClass(FacebookSdk.INSTANCE.getApplicationContext(), FacebookActivity.class);
        webDialogIntent.setAction("FacebookDialogFragment");
        appCall.setRequestIntent(webDialogIntent);
    }

    @JvmStatic
    public static final void setupAppCallForNativeDialog(@NotNull AppCall appCall, @NotNull ParameterProvider parameterProvider, @NotNull DialogFeature feature) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
        Intrinsics.checkNotNullParameter((Object)parameterProvider, (String)"parameterProvider");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Context context = FacebookSdk.INSTANCE.getApplicationContext();
        String action = feature.getAction();
        NativeProtocol.ProtocolVersionQueryResult protocolVersionResult = DialogPresenter.getProtocolVersionForNativeDialog(feature);
        int protocolVersion = protocolVersionResult.getProtocolVersion();
        if (protocolVersion == -1) {
            throw new FacebookException("Cannot present this dialog. This likely means that the Facebook app is not installed.");
        }
        Bundle params = null;
        Bundle bundle = params = NativeProtocol.isVersionCompatibleWithBucketedIntent((int)protocolVersion) ? parameterProvider.getParameters() : parameterProvider.getLegacyParameters();
        if (params == null) {
            params = new Bundle();
        }
        if ((intent = NativeProtocol.createPlatformActivityIntent((Context)context, (String)appCall.getCallId().toString(), (String)action, (NativeProtocol.ProtocolVersionQueryResult)protocolVersionResult, (Bundle)params)) == null) {
            throw new FacebookException("Unable to create Intent; this likely means theFacebook app is not installed.");
        }
        Intent intent2 = intent;
        appCall.setRequestIntent(intent2);
    }

    @JvmStatic
    public static final void setupAppCallForCustomTabDialog(@NotNull AppCall appCall, @Nullable String action, @Nullable Bundle parameters) {
        Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
        Validate.hasCustomTabRedirectActivity((Context)FacebookSdk.INSTANCE.getApplicationContext(), (String)CustomTabUtils.INSTANCE.getDefaultRedirectURI());
        Validate.hasInternetPermissions((Context)FacebookSdk.INSTANCE.getApplicationContext());
        Intent intent = new Intent(FacebookSdk.INSTANCE.getApplicationContext(), CustomTabMainActivity.class);
        intent.putExtra(CustomTabMainActivity.EXTRA_ACTION, action);
        intent.putExtra(CustomTabMainActivity.EXTRA_PARAMS, parameters);
        intent.putExtra(CustomTabMainActivity.EXTRA_CHROME_PACKAGE, CustomTabUtils.INSTANCE.getChromePackage());
        NativeProtocol.setupProtocolRequestIntent((Intent)intent, (String)appCall.getCallId().toString(), (String)action, (int)NativeProtocol.INSTANCE.getLatestKnownVersion(), null);
        appCall.setRequestIntent(intent);
    }

    private final Uri getDialogWebFallbackUri(DialogFeature feature) {
        String featureName = feature.name();
        String action = feature.getAction();
        String applicationId = FacebookSdk.INSTANCE.getApplicationId();
        FetchedAppSettings.DialogFeatureConfig config = FetchedAppSettings.Companion.getDialogFeatureConfig(applicationId, action, featureName);
        Uri fallbackUrl = null;
        if (config != null) {
            fallbackUrl = config.getFallbackUrl();
        }
        return fallbackUrl;
    }

    @JvmStatic
    @NotNull
    public static final NativeProtocol.ProtocolVersionQueryResult getProtocolVersionForNativeDialog(@NotNull DialogFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        String applicationId = FacebookSdk.INSTANCE.getApplicationId();
        String action = feature.getAction();
        int[] featureVersionSpec = INSTANCE.getVersionSpecForFeature(applicationId, action, feature);
        return NativeProtocol.getLatestAvailableProtocolVersionForAction((String)action, (int[])featureVersionSpec);
    }

    private final int[] getVersionSpecForFeature(String applicationId, String actionName, DialogFeature feature) {
        Object object;
        int[] nArray;
        FetchedAppSettings.DialogFeatureConfig config = FetchedAppSettings.Companion.getDialogFeatureConfig(applicationId, actionName, feature.name());
        Object object2 = config;
        int[] nArray2 = nArray = object2 == null ? null : object2.getVersionSpec();
        if (nArray == null) {
            object2 = new int[1];
            object2[0] = (FetchedAppSettings.DialogFeatureConfig)feature.getMinVersion();
            object = object2;
        } else {
            object = nArray;
        }
        return object;
    }

    @JvmStatic
    public static final void logDialogActivity(@NotNull Context context, @NotNull String eventName, @NotNull String outcome) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        InternalAppEventsLogger logger = new InternalAppEventsLogger(context);
        Bundle parameters = new Bundle();
        parameters.putString("fb_dialog_outcome", outcome);
        logger.logEventImplicitly(eventName, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startActivityForResultWithAndroidX$lambda-2(CallbackManager $callbackManager, int $requestCode, Ref.ObjectRef $launcher, Pair result) {
        Intrinsics.checkNotNullParameter((Object)$launcher, (String)"$launcher");
        CallbackManager innerCallbackManager = $callbackManager;
        if (innerCallbackManager == null) {
            innerCallbackManager = (CallbackManager)new CallbackManagerImpl();
        }
        Object object = result.first;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.first");
        innerCallbackManager.onActivityResult($requestCode, ((Number)object).intValue(), (Intent)result.second);
        object = (ActivityResultLauncher)$launcher.element;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            synchronized (it) {
                boolean bl6 = false;
                it.unregister();
                $launcher.element = null;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\b"}, d2={"Lcom/facebook/internal/DialogPresenter$ParameterProvider;", "", "legacyParameters", "Landroid/os/Bundle;", "getLegacyParameters", "()Landroid/os/Bundle;", "parameters", "getParameters", "facebook-common_release"})
    public static interface ParameterProvider {
        @Nullable
        public Bundle getParameters();

        @Nullable
        public Bundle getLegacyParameters();
    }
}

