/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslError;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.VisibleForTesting;
import com.facebook.AccessToken;
import com.facebook.FacebookDialogException;
import com.facebook.FacebookException;
import com.facebook.FacebookGraphResponseException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.FacebookServiceException;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestAsyncTask;
import com.facebook.GraphResponse;
import com.facebook.common.R;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.login.LoginTargetApp;
import com.facebook.share.internal.ShareInternalUtility;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0003\n\u0002\b\f\b\u0016\u0018\u0000 N2\u00020\u0001:\u0006MNOPQRB\u0017\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB=\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020-H\u0002J\b\u0010/\u001a\u00020-H\u0016J(\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\bH\u0002J\b\u00106\u001a\u00020-H\u0016J\u0012\u00107\u001a\u00020-2\b\u00108\u001a\u0004\u0018\u00010\fH\u0014J\b\u00109\u001a\u00020-H\u0016J\u0018\u0010:\u001a\u00020\u00182\u0006\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020-H\u0014J\b\u0010?\u001a\u00020-H\u0014J\u0010\u0010@\u001a\u00020-2\u0006\u0010A\u001a\u00020+H\u0016J\u0012\u0010B\u001a\u00020\f2\b\u0010C\u001a\u0004\u0018\u00010\u0005H\u0017J\u0006\u0010D\u001a\u00020-J\u0012\u0010E\u001a\u00020-2\b\u0010F\u001a\u0004\u0018\u00010GH\u0004J\u0012\u0010H\u001a\u00020-2\b\u0010I\u001a\u0004\u0018\u00010\fH\u0004J\u0010\u0010J\u001a\u00020-2\u0006\u0010\u0016\u001a\u00020\u0005H\u0004J\u0010\u0010K\u001a\u00020-2\u0006\u0010L\u001a\u00020\bH\u0003R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0018\u00010%R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010'\u001a\u0004\u0018\u00010&2\b\u0010\u0019\u001a\u0004\u0018\u00010&@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/facebook/internal/WebDialog;", "Landroid/app/Dialog;", "context", "Landroid/content/Context;", "url", "", "(Landroid/content/Context;Ljava/lang/String;)V", "theme", "", "(Landroid/content/Context;Ljava/lang/String;I)V", "action", "parameters", "Landroid/os/Bundle;", "targetApp", "Lcom/facebook/login/LoginTargetApp;", "listener", "Lcom/facebook/internal/WebDialog$OnCompleteListener;", "(Landroid/content/Context;Ljava/lang/String;Landroid/os/Bundle;ILcom/facebook/login/LoginTargetApp;Lcom/facebook/internal/WebDialog$OnCompleteListener;)V", "contentFrameLayout", "Landroid/widget/FrameLayout;", "crossImageView", "Landroid/widget/ImageView;", "expectedRedirectUrl", "isDetached", "", "<set-?>", "isListenerCalled", "()Z", "isPageFinished", "onCompleteListener", "getOnCompleteListener", "()Lcom/facebook/internal/WebDialog$OnCompleteListener;", "setOnCompleteListener", "(Lcom/facebook/internal/WebDialog$OnCompleteListener;)V", "spinner", "Landroid/app/ProgressDialog;", "uploadTask", "Lcom/facebook/internal/WebDialog$UploadStagingResourcesTask;", "Landroid/webkit/WebView;", "webView", "getWebView", "()Landroid/webkit/WebView;", "windowParams", "Landroid/view/WindowManager$LayoutParams;", "cancel", "", "createCrossImage", "dismiss", "getScaledSize", "screenSize", "density", "", "noPaddingSize", "maxPaddingSize", "onAttachedToWindow", "onCreate", "savedInstanceState", "onDetachedFromWindow", "onKeyDown", "keyCode", "event", "Landroid/view/KeyEvent;", "onStart", "onStop", "onWindowAttributesChanged", "params", "parseResponseUri", "urlString", "resize", "sendErrorToListener", "error", "", "sendSuccessToListener", "values", "setExpectedRedirectUrl", "setUpWebView", "margin", "Builder", "Companion", "DialogWebViewClient", "InitCallback", "OnCompleteListener", "UploadStagingResourcesTask", "facebook-common_release"})
public class WebDialog
extends Dialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String url;
    @NotNull
    private String expectedRedirectUrl;
    @Nullable
    private OnCompleteListener onCompleteListener;
    @Nullable
    private WebView webView;
    @Nullable
    private ProgressDialog spinner;
    @Nullable
    private ImageView crossImageView;
    @Nullable
    private FrameLayout contentFrameLayout;
    @Nullable
    private UploadStagingResourcesTask uploadTask;
    private boolean isListenerCalled;
    private boolean isDetached;
    private boolean isPageFinished;
    @Nullable
    private WindowManager.LayoutParams windowParams;
    @NotNull
    private static final String LOG_TAG = "FacebookSDK.WebDialog";
    @NotNull
    private static final String DISPLAY_TOUCH = "touch";
    @NotNull
    private static final String PLATFORM_DIALOG_PATH_REGEX = "^/(v\\d+\\.\\d+/)??dialog/.*";
    private static final int API_EC_DIALOG_CANCEL = 4201;
    public static final boolean DISABLE_SSL_CHECK_FOR_TESTING = false;
    private static final int NO_PADDING_SCREEN_WIDTH = 480;
    private static final int MAX_PADDING_SCREEN_WIDTH = 800;
    private static final int NO_PADDING_SCREEN_HEIGHT = 800;
    private static final int MAX_PADDING_SCREEN_HEIGHT = 1280;
    private static final double MIN_SCALE_FACTOR = 0.5;
    private static final int BACKGROUND_GRAY = -872415232;
    private static final int DEFAULT_THEME = R.style.com_facebook_activity_theme;
    private static volatile int webDialogTheme;
    @Nullable
    private static InitCallback initCallback;

    @Nullable
    public final OnCompleteListener getOnCompleteListener() {
        return this.onCompleteListener;
    }

    public final void setOnCompleteListener(@Nullable OnCompleteListener onCompleteListener) {
        this.onCompleteListener = onCompleteListener;
    }

    @Nullable
    protected final WebView getWebView() {
        return this.webView;
    }

    protected final boolean isListenerCalled() {
        return this.isListenerCalled;
    }

    protected final boolean isPageFinished() {
        return this.isPageFinished;
    }

    protected WebDialog(@NotNull Context context, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this(context, url, Companion.getWebDialogTheme());
    }

    private WebDialog(Context context, String url, int theme) {
        super(context, theme == 0 ? Companion.getWebDialogTheme() : theme);
        this.expectedRedirectUrl = "fbconnect://success";
        this.url = url;
    }

    private WebDialog(Context context, String action, Bundle parameters, int theme, LoginTargetApp targetApp, OnCompleteListener listener2) {
        super(context, theme == 0 ? Companion.getWebDialogTheme() : theme);
        boolean isChromeOS;
        this.expectedRedirectUrl = "fbconnect://success";
        Bundle parameters2 = parameters;
        if (parameters2 == null) {
            parameters2 = new Bundle();
        }
        this.expectedRedirectUrl = (isChromeOS = Utility.isChromeOS((Context)context)) ? "fbconnect://chrome_os_success" : "fbconnect://success";
        parameters2.putString("redirect_uri", this.expectedRedirectUrl);
        parameters2.putString("display", DISPLAY_TOUCH);
        parameters2.putString("client_id", FacebookSdk.INSTANCE.getApplicationId());
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = Locale.ROOT;
        String string2 = "android-%s";
        Object[] objectArray = new Object[1];
        objectArray[0] = FacebookSdk.INSTANCE.getSdkVersion();
        boolean bl = false;
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        parameters2.putString("sdk", string3);
        this.onCompleteListener = listener2;
        if (Intrinsics.areEqual((Object)action, (Object)"share") && parameters2.containsKey("media")) {
            this.uploadTask = new UploadStagingResourcesTask(action, parameters2);
        } else {
            locale = targetApp;
            int n = WhenMappings.$EnumSwitchMapping$0[locale.ordinal()];
            Uri uri = n == 1 ? Utility.buildUri((String)ServerProtocol.INSTANCE.getInstagramDialogAuthority(), (String)"oauth/authorize", (Bundle)parameters2) : Utility.buildUri((String)ServerProtocol.INSTANCE.getDialogAuthority(), (String)(FacebookSdk.INSTANCE.getGraphApiVersion() + "/dialog/" + action), (Bundle)parameters2);
            this.url = uri.toString();
        }
    }

    public boolean onKeyDown(int keyCode, @NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (keyCode == 4) {
            WebView webView;
            if (this.webView != null && Intrinsics.areEqual((Object)((webView = this.webView) == null ? null : Boolean.valueOf(webView.canGoBack())), (Object)true)) {
                webView = this.webView;
                if (webView != null) {
                    webView.goBack();
                }
                return true;
            }
            this.cancel();
        }
        return super.onKeyDown(keyCode, event);
    }

    public void dismiss() {
        WebView it;
        boolean bl;
        boolean bl2;
        WebView webView;
        WebView webView2 = this.webView;
        if (webView2 != null) {
            webView = webView2;
            bl2 = false;
            bl = false;
            it = webView;
            boolean bl3 = false;
            it.stopLoading();
        }
        if (!this.isDetached && (webView2 = this.spinner) != null) {
            webView = webView2;
            bl2 = false;
            bl = false;
            it = webView;
            boolean bl4 = false;
            if (it.isShowing()) {
                it.dismiss();
            }
        }
        super.dismiss();
    }

    protected void onStart() {
        UploadStagingResourcesTask uploadStagingResourcesTask;
        super.onStart();
        if (this.uploadTask != null && ((uploadStagingResourcesTask = this.uploadTask) == null ? null : uploadStagingResourcesTask.getStatus()) == AsyncTask.Status.PENDING) {
            uploadStagingResourcesTask = this.uploadTask;
            if (uploadStagingResourcesTask != null) {
                uploadStagingResourcesTask.execute(new Void[0]);
            }
            uploadStagingResourcesTask = this.spinner;
            if (uploadStagingResourcesTask != null) {
                uploadStagingResourcesTask.show();
            }
        } else {
            this.resize();
        }
    }

    protected void onStop() {
        UploadStagingResourcesTask uploadStagingResourcesTask = this.uploadTask;
        if (uploadStagingResourcesTask != null) {
            UploadStagingResourcesTask uploadStagingResourcesTask2 = uploadStagingResourcesTask;
            boolean bl = false;
            boolean bl2 = false;
            UploadStagingResourcesTask task = uploadStagingResourcesTask2;
            boolean bl3 = false;
            task.cancel(true);
            ProgressDialog progressDialog = this.spinner;
            if (progressDialog != null) {
                ProgressDialog progressDialog2 = progressDialog;
                boolean bl4 = false;
                boolean bl5 = false;
                ProgressDialog it = progressDialog2;
                boolean bl6 = false;
                it.dismiss();
            }
        }
        super.onStop();
    }

    public void onDetachedFromWindow() {
        this.isDetached = true;
        super.onDetachedFromWindow();
    }

    public void onAttachedToWindow() {
        this.isDetached = false;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        if (Utility.mustFixWindowParamsForAutofill((Context)context) && this.windowParams != null && ((context = this.windowParams) == null ? null : context.token) == null) {
            context = this.windowParams;
            if (context != null) {
                Window window;
                Activity activity = this.getOwnerActivity();
                Window window2 = window = activity == null ? null : activity.getWindow();
                context.token = window == null ? null : ((activity = window.getAttributes()) == null ? null : activity.token);
            }
            Utility.logd((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Set token on onAttachedToWindow(): ", (Object)((context = this.windowParams) == null ? null : context.token)));
        }
        super.onAttachedToWindow();
    }

    public void onWindowAttributesChanged(@NotNull WindowManager.LayoutParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (params.token == null) {
            this.windowParams = params;
        }
        super.onWindowAttributesChanged(params);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        FrameLayout frameLayout;
        boolean bl;
        boolean bl2;
        boolean bl3;
        super.onCreate(savedInstanceState);
        ProgressDialog progressDialog = this.spinner = new ProgressDialog(this.getContext());
        if (progressDialog != null) {
            progressDialog.requestWindowFeature(1);
        }
        progressDialog = this.spinner;
        if (progressDialog != null) {
            progressDialog.setMessage((CharSequence)this.getContext().getString(R.string.com_facebook_loading));
        }
        progressDialog = this.spinner;
        if (progressDialog != null) {
            progressDialog.setCanceledOnTouchOutside(false);
        }
        progressDialog = this.spinner;
        if (progressDialog != null) {
            progressDialog.setOnCancelListener(arg_0 -> WebDialog.onCreate$lambda-4(this, arg_0));
        }
        this.requestWindowFeature(1);
        this.contentFrameLayout = new FrameLayout(this.getContext());
        this.resize();
        progressDialog = this.getWindow();
        if (progressDialog != null) {
            progressDialog.setGravity(17);
        }
        progressDialog = this.getWindow();
        if (progressDialog != null) {
            progressDialog.setSoftInputMode(16);
        }
        this.createCrossImage();
        if (this.url != null) {
            ImageView imageView = this.crossImageView;
            bl3 = false;
            bl2 = false;
            bl2 = false;
            bl = false;
            if (imageView == null) {
                boolean bl4 = false;
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            int crossWidth = imageView.getDrawable().getIntrinsicWidth();
            this.setUpWebView(crossWidth / 2 + 1);
        }
        if ((frameLayout = this.contentFrameLayout) != null) {
            frameLayout.addView((View)this.crossImageView, new ViewGroup.LayoutParams(-2, -2));
        }
        frameLayout = this.contentFrameLayout;
        boolean bl5 = false;
        bl3 = false;
        bl3 = false;
        bl2 = false;
        if (frameLayout == null) {
            bl = false;
            String string3 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        this.setContentView((View)frameLayout);
    }

    protected final void setExpectedRedirectUrl(@NotNull String expectedRedirectUrl) {
        Intrinsics.checkNotNullParameter((Object)expectedRedirectUrl, (String)"expectedRedirectUrl");
        this.expectedRedirectUrl = expectedRedirectUrl;
    }

    @VisibleForTesting(otherwise=4)
    @NotNull
    public Bundle parseResponseUri(@Nullable String urlString) {
        Uri u = Uri.parse((String)urlString);
        Bundle b = Utility.parseUrlQueryString((String)u.getQuery());
        b.putAll(Utility.parseUrlQueryString((String)u.getFragment()));
        return b;
    }

    public final void resize() {
        Object object = this.getContext().getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Display display = wm.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        int width = metrics.widthPixels < metrics.heightPixels ? metrics.widthPixels : metrics.heightPixels;
        int height = metrics.widthPixels < metrics.heightPixels ? metrics.heightPixels : metrics.widthPixels;
        int dialogWidth = Math.min(this.getScaledSize(width, metrics.density, 480, 800), metrics.widthPixels);
        int dialogHeight = Math.min(this.getScaledSize(height, metrics.density, 800, 1280), metrics.heightPixels);
        Window window = this.getWindow();
        if (window != null) {
            window.setLayout(dialogWidth, dialogHeight);
        }
    }

    private final int getScaledSize(int screenSize, float density, int noPaddingSize, int maxPaddingSize) {
        int scaledSize = (int)((float)screenSize / density);
        double scaleFactor = 0.0;
        scaleFactor = scaledSize <= noPaddingSize ? 1.0 : (scaledSize >= maxPaddingSize ? 0.5 : 0.5 + (double)(maxPaddingSize - scaledSize) / (double)(maxPaddingSize - noPaddingSize) * 0.5);
        return (int)((double)screenSize * scaleFactor);
    }

    protected final void sendSuccessToListener(@Nullable Bundle values) {
        if (this.onCompleteListener != null && !this.isListenerCalled) {
            this.isListenerCalled = true;
            OnCompleteListener onCompleteListener = this.onCompleteListener;
            if (onCompleteListener != null) {
                onCompleteListener.onComplete(values, null);
            }
            this.dismiss();
        }
    }

    protected final void sendErrorToListener(@Nullable Throwable error) {
        if (this.onCompleteListener != null && !this.isListenerCalled) {
            this.isListenerCalled = true;
            FacebookException facebookException = error instanceof FacebookException ? (FacebookException)error : new FacebookException(error);
            OnCompleteListener onCompleteListener = this.onCompleteListener;
            if (onCompleteListener != null) {
                onCompleteListener.onComplete(null, facebookException);
            }
            this.dismiss();
        }
    }

    public void cancel() {
        if (this.onCompleteListener != null && !this.isListenerCalled) {
            this.sendErrorToListener((Throwable)new FacebookOperationCanceledException());
        }
    }

    private final void createCrossImage() {
        this.crossImageView = new ImageView(this.getContext());
        ImageView imageView = this.crossImageView;
        if (imageView != null) {
            imageView.setOnClickListener(arg_0 -> WebDialog.createCrossImage$lambda-5(this, arg_0));
        }
        Drawable crossDrawable = this.getContext().getResources().getDrawable(R.drawable.com_facebook_close);
        ImageView imageView2 = this.crossImageView;
        if (imageView2 != null) {
            imageView2.setImageDrawable(crossDrawable);
        }
        imageView2 = this.crossImageView;
        if (imageView2 != null) {
            imageView2.setVisibility(4);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void setUpWebView(int margin) {
        boolean bl;
        boolean bl2;
        Object object;
        LinearLayout webViewContainer = new LinearLayout(this.getContext());
        Object object2 = this.getContext();
        this.webView = new WebView((Context)object2){

            public void onWindowFocusChanged(boolean hasWindowFocus) {
                try {
                    super.onWindowFocusChanged(hasWindowFocus);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        };
        object2 = initCallback;
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            Object it = object;
            boolean bl3 = false;
            it.onInit(this.getWebView());
        }
        object2 = this.webView;
        if (object2 != null) {
            object2.setVerticalScrollBarEnabled(false);
        }
        object2 = this.webView;
        if (object2 != null) {
            object2.setHorizontalScrollBarEnabled(false);
        }
        object2 = this.webView;
        if (object2 != null) {
            object2.setWebViewClient((WebViewClient)new DialogWebViewClient());
        }
        object = this.webView;
        Object object3 = object2 = object == null ? null : object.getSettings();
        if (object2 != null) {
            object2.setJavaScriptEnabled(true);
        }
        object2 = this.webView;
        if (object2 != null) {
            object = this.url;
            bl2 = false;
            bl = false;
            bl = false;
            boolean bl4 = false;
            if (object == null) {
                boolean bl5 = false;
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            object2.loadUrl((String)object);
        }
        object2 = this.webView;
        if (object2 != null) {
            object2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        }
        object2 = this.webView;
        if (object2 != null) {
            object2.setVisibility(4);
        }
        object = this.webView;
        Object object4 = object2 = object == null ? null : object.getSettings();
        if (object2 != null) {
            object2.setSavePassword(false);
        }
        object = this.webView;
        Object object5 = object2 = object == null ? null : object.getSettings();
        if (object2 != null) {
            object2.setSaveFormData(false);
        }
        object2 = this.webView;
        if (object2 != null) {
            object2.setFocusable(true);
        }
        object2 = this.webView;
        if (object2 != null) {
            object2.setFocusableInTouchMode(true);
        }
        object2 = this.webView;
        if (object2 != null) {
            object2.setOnTouchListener(WebDialog::setUpWebView$lambda-7);
        }
        webViewContainer.setPadding(margin, margin, margin, margin);
        webViewContainer.addView((View)this.webView);
        webViewContainer.setBackgroundColor(-872415232);
        object2 = this.contentFrameLayout;
        if (object2 != null) {
            object2.addView((View)webViewContainer);
        }
    }

    private static final void onCreate$lambda-4(WebDialog this$0, DialogInterface it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.cancel();
    }

    private static final void createCrossImage$lambda-5(WebDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.cancel();
    }

    private static final boolean setUpWebView$lambda-7(View v, MotionEvent event) {
        if (!v.hasFocus()) {
            v.requestFocus();
        }
        return false;
    }

    @JvmStatic
    protected static final void initDefaultTheme(@Nullable Context context) {
        Companion.initDefaultTheme(context);
    }

    @JvmStatic
    @NotNull
    public static final WebDialog newInstance(@NotNull Context context, @Nullable String action, @Nullable Bundle parameters, int theme, @Nullable OnCompleteListener listener2) {
        return Companion.newInstance(context, action, parameters, theme, listener2);
    }

    @JvmStatic
    @NotNull
    public static final WebDialog newInstance(@NotNull Context context, @Nullable String action, @Nullable Bundle parameters, int theme, @NotNull LoginTargetApp targetApp, @Nullable OnCompleteListener listener2) {
        return Companion.newInstance(context, action, parameters, theme, targetApp, listener2);
    }

    @JvmStatic
    public static final int getWebDialogTheme() {
        return Companion.getWebDialogTheme();
    }

    @JvmStatic
    public static final void setWebDialogTheme(int theme) {
        Companion.setWebDialogTheme(theme);
    }

    @JvmStatic
    public static final void setInitCallback(@Nullable InitCallback callback) {
        Companion.setInitCallback(callback);
    }

    public /* synthetic */ WebDialog(Context context, String action, Bundle parameters, int theme, LoginTargetApp targetApp, OnCompleteListener listener2, DefaultConstructorMarker $constructor_marker) {
        this(context, action, parameters, theme, targetApp, listener2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/facebook/internal/WebDialog$InitCallback;", "", "onInit", "", "webView", "Landroid/webkit/WebView;", "facebook-common_release"})
    public static interface InitCallback {
        public void onInit(@Nullable WebView var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00a8\u0006\b"}, d2={"Lcom/facebook/internal/WebDialog$OnCompleteListener;", "", "onComplete", "", "values", "Landroid/os/Bundle;", "error", "Lcom/facebook/FacebookException;", "facebook-common_release"})
    public static interface OnCompleteListener {
        public void onComplete(@Nullable Bundle var1, @Nullable FacebookException var2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J(\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/facebook/internal/WebDialog$DialogWebViewClient;", "Landroid/webkit/WebViewClient;", "(Lcom/facebook/internal/WebDialog;)V", "onPageFinished", "", "view", "Landroid/webkit/WebView;", "url", "", "onPageStarted", "favicon", "Landroid/graphics/Bitmap;", "onReceivedError", "errorCode", "", "description", "failingUrl", "onReceivedSslError", "handler", "Landroid/webkit/SslErrorHandler;", "error", "Landroid/net/http/SslError;", "shouldOverrideUrlLoading", "", "facebook-common_release"})
    private final class DialogWebViewClient
    extends WebViewClient {
        public DialogWebViewClient() {
            Intrinsics.checkNotNullParameter((Object)((Object)WebDialog.this), (String)"this$0");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean shouldOverrideUrlLoading(@NotNull WebView view, @NotNull String url) {
            boolean isPlatformDialogURL;
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Utility.logd((String)WebDialog.LOG_TAG, (String)Intrinsics.stringPlus((String)"Redirect URL: ", (Object)url));
            Uri parsedURL = Uri.parse((String)url);
            boolean bl = isPlatformDialogURL = parsedURL.getPath() != null && Pattern.matches(WebDialog.PLATFORM_DIALOG_PATH_REGEX, parsedURL.getPath());
            if (StringsKt.startsWith$default((String)url, (String)WebDialog.this.expectedRedirectUrl, (boolean)false, (int)2, null)) {
                String errorMessage;
                Bundle values = WebDialog.this.parseResponseUri(url);
                String error = values.getString("error");
                if (error == null) {
                    error = values.getString("error_type");
                }
                if ((errorMessage = values.getString("error_msg")) == null) {
                    errorMessage = values.getString("error_message");
                }
                if (errorMessage == null) {
                    errorMessage = values.getString("error_description");
                }
                String errorCodeString = values.getString("error_code");
                int errorCode = -1;
                if (errorCodeString != null) {
                    if (!Utility.isNullOrEmpty((String)errorCodeString)) {
                        int n;
                        try {
                            String string2 = errorCodeString;
                            boolean bl2 = false;
                            n = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException ex) {
                            n = -1;
                        }
                        errorCode = n;
                    }
                }
                if (Utility.isNullOrEmpty((String)error)) {
                    if (Utility.isNullOrEmpty((String)errorMessage) && errorCode == -1) {
                        WebDialog.this.sendSuccessToListener(values);
                        return true;
                    }
                }
                if (error != null && (Intrinsics.areEqual((Object)error, (Object)"access_denied") || Intrinsics.areEqual((Object)error, (Object)"OAuthAccessDeniedException"))) {
                    WebDialog.this.cancel();
                    return true;
                }
                if (errorCode == 4201) {
                    WebDialog.this.cancel();
                    return true;
                }
                FacebookRequestError requestError = new FacebookRequestError(errorCode, error, errorMessage);
                WebDialog.this.sendErrorToListener((Throwable)new FacebookServiceException(requestError, errorMessage));
                return true;
            }
            if (StringsKt.startsWith$default((String)url, (String)"fbconnect://cancel", (boolean)false, (int)2, null)) {
                WebDialog.this.cancel();
                return true;
            }
            if (isPlatformDialogURL) return false;
            if (StringsKt.contains$default((CharSequence)url, (CharSequence)WebDialog.DISPLAY_TOUCH, (boolean)false, (int)2, null)) {
                return false;
            }
            try {
                WebDialog.this.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
                return true;
            }
            catch (ActivityNotFoundException e) {
                return false;
            }
        }

        public void onReceivedError(@NotNull WebView view, int errorCode, @NotNull String description, @NotNull String failingUrl) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)failingUrl, (String)"failingUrl");
            super.onReceivedError(view, errorCode, description, failingUrl);
            WebDialog.this.sendErrorToListener((Throwable)((Object)new FacebookDialogException(description, errorCode, failingUrl)));
        }

        public void onReceivedSslError(@NotNull WebView view, @NotNull SslErrorHandler handler, @NotNull SslError error) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super.onReceivedSslError(view, handler, error);
            handler.cancel();
            WebDialog.this.sendErrorToListener((Throwable)((Object)new FacebookDialogException(null, -11, null)));
        }

        public void onPageStarted(@NotNull WebView view, @NotNull String url, @Nullable Bitmap favicon) {
            ProgressDialog progressDialog;
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Utility.logd((String)WebDialog.LOG_TAG, (String)Intrinsics.stringPlus((String)"Webview loading URL: ", (Object)url));
            super.onPageStarted(view, url, favicon);
            if (!WebDialog.this.isDetached && (progressDialog = WebDialog.this.spinner) != null) {
                progressDialog.show();
            }
        }

        public void onPageFinished(@NotNull WebView view, @NotNull String url) {
            ProgressDialog progressDialog;
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super.onPageFinished(view, url);
            if (!WebDialog.this.isDetached && (progressDialog = WebDialog.this.spinner) != null) {
                progressDialog.dismiss();
            }
            if ((progressDialog = WebDialog.this.contentFrameLayout) != null) {
                progressDialog.setBackgroundColor(0);
            }
            progressDialog = WebDialog.this.getWebView();
            if (progressDialog != null) {
                progressDialog.setVisibility(0);
            }
            progressDialog = WebDialog.this.crossImageView;
            if (progressDialog != null) {
                progressDialog.setVisibility(0);
            }
            WebDialog.this.isPageFinished = true;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J$\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010 \u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0018R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lcom/facebook/internal/WebDialog$Builder;", "", "context", "Landroid/content/Context;", "action", "", "parameters", "Landroid/os/Bundle;", "(Landroid/content/Context;Ljava/lang/String;Landroid/os/Bundle;)V", "applicationId", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Landroid/os/Bundle;)V", "accessToken", "Lcom/facebook/AccessToken;", "<set-?>", "getApplicationId", "()Ljava/lang/String;", "getContext", "()Landroid/content/Context;", "Lcom/facebook/internal/WebDialog$OnCompleteListener;", "listener", "getListener", "()Lcom/facebook/internal/WebDialog$OnCompleteListener;", "getParameters", "()Landroid/os/Bundle;", "", "theme", "getTheme", "()I", "build", "Lcom/facebook/internal/WebDialog;", "finishInit", "", "setOnCompleteListener", "setTheme", "facebook-common_release"})
    public static class Builder {
        @Nullable
        private Context context;
        @Nullable
        private String applicationId;
        @Nullable
        private String action;
        private int theme;
        @Nullable
        private OnCompleteListener listener;
        @Nullable
        private Bundle parameters;
        @Nullable
        private AccessToken accessToken;

        @Nullable
        public final Context getContext() {
            return this.context;
        }

        @Nullable
        public final String getApplicationId() {
            return this.applicationId;
        }

        public final int getTheme() {
            return this.theme;
        }

        @Nullable
        public final OnCompleteListener getListener() {
            return this.listener;
        }

        @Nullable
        public final Bundle getParameters() {
            return this.parameters;
        }

        public Builder(@NotNull Context context, @NotNull String action, @Nullable Bundle parameters) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            this.accessToken = AccessToken.Companion.getCurrentAccessToken();
            if (!AccessToken.Companion.isCurrentAccessTokenActive()) {
                String applicationId = Utility.getMetadataApplicationId((Context)context);
                if (applicationId != null) {
                    this.applicationId = applicationId;
                } else {
                    throw new FacebookException("Attempted to create a builder without a valid access token or a valid default Application ID.");
                }
            }
            this.finishInit(context, action, parameters);
        }

        public Builder(@NotNull Context context, @Nullable String applicationId, @NotNull String action, @Nullable Bundle parameters) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            String applicationId2 = applicationId;
            if (applicationId2 == null) {
                applicationId2 = Utility.getMetadataApplicationId((Context)context);
            }
            this.applicationId = Validate.notNullOrEmpty((String)applicationId2, (String)"applicationId");
            this.finishInit(context, action, parameters);
        }

        @NotNull
        public final Builder setTheme(int theme) {
            this.theme = theme;
            return this;
        }

        @NotNull
        public final Builder setOnCompleteListener(@Nullable OnCompleteListener listener2) {
            this.listener = listener2;
            return this;
        }

        @Nullable
        public WebDialog build() {
            Bundle bundle;
            if (this.accessToken != null) {
                AccessToken accessToken;
                bundle = this.parameters;
                if (bundle != null) {
                    accessToken = this.accessToken;
                    bundle.putString("app_id", accessToken == null ? null : accessToken.getApplicationId());
                }
                if ((bundle = this.parameters) != null) {
                    accessToken = this.accessToken;
                    bundle.putString("access_token", accessToken == null ? null : accessToken.getToken());
                }
            } else {
                bundle = this.parameters;
                if (bundle != null) {
                    bundle.putString("app_id", this.applicationId);
                }
            }
            bundle = this.context;
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (bundle == null) {
                boolean bl4 = false;
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return Companion.newInstance((Context)bundle, this.action, this.parameters, this.theme, this.listener);
        }

        private final void finishInit(Context context, String action, Bundle parameters) {
            this.context = context;
            this.action = action;
            this.parameters = parameters != null ? parameters : new Bundle();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00030\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ+\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00032\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0003\"\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003H\u0014\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0010\u0012\f\u0012\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b0\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/internal/WebDialog$UploadStagingResourcesTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "", "", "action", "parameters", "Landroid/os/Bundle;", "(Lcom/facebook/internal/WebDialog;Ljava/lang/String;Landroid/os/Bundle;)V", "exceptions", "Ljava/lang/Exception;", "Lkotlin/Exception;", "[Ljava/lang/Exception;", "doInBackground", "p0", "([Ljava/lang/Void;)[Ljava/lang/String;", "onPostExecute", "", "results", "([Ljava/lang/String;)V", "facebook-common_release"})
    private final class UploadStagingResourcesTask
    extends AsyncTask<Void, Void, String[]> {
        @NotNull
        private final String action;
        @NotNull
        private final Bundle parameters;
        @NotNull
        private Exception[] exceptions;

        public UploadStagingResourcesTask(@NotNull String action, Bundle parameters) {
            Intrinsics.checkNotNullParameter((Object)((Object)WebDialog.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.action = action;
            this.parameters = parameters;
            this.exceptions = new Exception[0];
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        protected String[] doInBackground(Void ... voidArray) {
            if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
                return null;
            }
            try {
                String[] stringArray;
                void p0;
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                String[] stringArray2 = this.parameters.getStringArray("media");
                if (stringArray2 == null) {
                    return null;
                }
                String[] params = stringArray = stringArray2;
                String[] results = new String[params.length];
                this.exceptions = new Exception[params.length];
                CountDownLatch latch = new CountDownLatch(params.length);
                ConcurrentLinkedQueue<GraphRequestAsyncTask> tasks = new ConcurrentLinkedQueue<GraphRequestAsyncTask>();
                AccessToken accessToken = AccessToken.Companion.getCurrentAccessToken();
                try {
                    int n = 0;
                    int n2 = params.length + -1;
                    if (n <= n2) {
                        do {
                            int i = n++;
                            if (this.isCancelled()) {
                                for (GraphRequestAsyncTask task : tasks) {
                                    task.cancel(true);
                                }
                                return null;
                            }
                            Uri uri = Uri.parse((String)params[i]);
                            if (Utility.isWebUri((Uri)uri)) {
                                results[i] = uri.toString();
                                latch.countDown();
                                continue;
                            }
                            GraphRequest.Callback callback = arg_0 -> UploadStagingResourcesTask.doInBackground$lambda-0(results, i, this, latch, arg_0);
                            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                            GraphRequestAsyncTask task = ShareInternalUtility.newUploadStagingResourceWithImageRequest(accessToken, uri, callback).executeAsync();
                            tasks.add(task);
                        } while (n <= n2);
                    }
                    latch.await();
                }
                catch (Exception e) {
                    for (GraphRequestAsyncTask task : tasks) {
                        task.cancel(true);
                    }
                    return null;
                }
                return results;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void onPostExecute(@Nullable String[] stringArray) {
            if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
                return;
            }
            try {
                void results;
                Exception[] exceptionArray = WebDialog.this.spinner;
                if (exceptionArray != null) {
                    exceptionArray.dismiss();
                }
                for (Exception e : this.exceptions) {
                    if (e == null) continue;
                    WebDialog.this.sendErrorToListener(e);
                    return;
                }
                if (results == null) {
                    WebDialog.this.sendErrorToListener(new FacebookException("Failed to stage photos for web dialog"));
                    return;
                }
                List resultList = ArraysKt.asList((Object[])results);
                if (resultList.contains(null)) {
                    WebDialog.this.sendErrorToListener(new FacebookException("Failed to stage photos for web dialog"));
                    return;
                }
                Utility.putJSONValueInBundle((Bundle)this.parameters, (String)"media", (Object)new JSONArray((Collection)resultList));
                Uri uri = Utility.buildUri((String)ServerProtocol.INSTANCE.getDialogAuthority(), (String)(FacebookSdk.INSTANCE.getGraphApiVersion() + "/dialog/" + this.action), (Bundle)this.parameters);
                WebDialog.this.url = uri.toString();
                ImageView imageView = WebDialog.this.crossImageView;
                boolean bl = false;
                boolean bl2 = false;
                bl2 = false;
                boolean bl3 = false;
                if (imageView == null) {
                    boolean bl4 = false;
                    String string2 = "Required value was null.";
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                int crossWidth = imageView.getDrawable().getIntrinsicWidth();
                WebDialog.this.setUpWebView(crossWidth / 2 + 1);
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
                return;
            }
        }

        private static final void doInBackground$lambda-0(String[] $results, int $i, UploadStagingResourcesTask this$0, CountDownLatch $latch, GraphResponse response) {
            Intrinsics.checkNotNullParameter((Object)$results, (String)"$results");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            try {
                String stagedImageUri;
                FacebookRequestError error = response.getError();
                if (error != null) {
                    String message = error.getErrorMessage();
                    if (message == null) {
                        message = "Error staging photo.";
                    }
                    throw new FacebookGraphResponseException(response, message);
                }
                JSONObject jSONObject = response.getJSONObject();
                if (jSONObject == null) {
                    throw new FacebookException("Error staging photo.");
                }
                JSONObject data = jSONObject;
                String string2 = data.optString("uri");
                if (string2 == null) {
                    throw new FacebookException("Error staging photo.");
                }
                $results[$i] = stagedImageUri = string2;
            }
            catch (Exception e) {
                this$0.exceptions[$i] = e;
            }
            $latch.countDown();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0004H\u0007J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0005J6\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\"H\u0007J>\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u0012\u0010%\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010\u0014H\u0007J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/facebook/internal/WebDialog$Companion;", "", "()V", "API_EC_DIALOG_CANCEL", "", "BACKGROUND_GRAY", "DEFAULT_THEME", "DISABLE_SSL_CHECK_FOR_TESTING", "", "DISPLAY_TOUCH", "", "LOG_TAG", "MAX_PADDING_SCREEN_HEIGHT", "MAX_PADDING_SCREEN_WIDTH", "MIN_SCALE_FACTOR", "", "NO_PADDING_SCREEN_HEIGHT", "NO_PADDING_SCREEN_WIDTH", "PLATFORM_DIALOG_PATH_REGEX", "initCallback", "Lcom/facebook/internal/WebDialog$InitCallback;", "webDialogTheme", "getWebDialogTheme", "initDefaultTheme", "", "context", "Landroid/content/Context;", "newInstance", "Lcom/facebook/internal/WebDialog;", "action", "parameters", "Landroid/os/Bundle;", "theme", "listener", "Lcom/facebook/internal/WebDialog$OnCompleteListener;", "targetApp", "Lcom/facebook/login/LoginTargetApp;", "setInitCallback", "callback", "setWebDialogTheme", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        protected final void initDefaultTheme(@Nullable Context context) {
            ApplicationInfo ai;
            ApplicationInfo applicationInfo;
            if (context == null) {
                return;
            }
            try {
                applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            }
            catch (PackageManager.NameNotFoundException e) {
                return;
            }
            applicationInfo = ai = applicationInfo;
            if ((applicationInfo == null ? null : applicationInfo.metaData) == null) {
                return;
            }
            if (webDialogTheme == 0) {
                this.setWebDialogTheme(ai.metaData.getInt("com.facebook.sdk.WebDialogTheme"));
            }
        }

        @JvmStatic
        @NotNull
        public final WebDialog newInstance(@NotNull Context context, @Nullable String action, @Nullable Bundle parameters, int theme, @Nullable OnCompleteListener listener2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            WebDialog.initDefaultTheme(context);
            return new WebDialog(context, action, parameters, theme, LoginTargetApp.FACEBOOK, listener2, null);
        }

        @JvmStatic
        @NotNull
        public final WebDialog newInstance(@NotNull Context context, @Nullable String action, @Nullable Bundle parameters, int theme, @NotNull LoginTargetApp targetApp, @Nullable OnCompleteListener listener2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)targetApp, (String)"targetApp");
            WebDialog.initDefaultTheme(context);
            return new WebDialog(context, action, parameters, theme, targetApp, listener2, null);
        }

        @JvmStatic
        public final int getWebDialogTheme() {
            Validate.INSTANCE.sdkInitialized();
            return webDialogTheme;
        }

        @JvmStatic
        public final void setWebDialogTheme(int theme) {
            webDialogTheme = theme != 0 ? theme : DEFAULT_THEME;
        }

        @JvmStatic
        public final void setInitCallback(@Nullable InitCallback callback) {
            WebDialog.initCallback = callback;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoginTargetApp.values().length];
            nArray[LoginTargetApp.INSTAGRAM.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

