/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.text.TextUtils;
import android.webkit.CookieSyncManager;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.FragmentActivity;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.AuthenticationToken;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.FacebookServiceException;
import com.facebook.internal.Utility;
import com.facebook.login.CodeChallengeMethod;
import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginMethodHandler;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0014J\n\u0010\u0015\u001a\u0004\u0018\u00010\tH\u0002J$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0017J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\tH\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/facebook/login/WebLoginMethodHandler;", "Lcom/facebook/login/LoginMethodHandler;", "loginClient", "Lcom/facebook/login/LoginClient;", "(Lcom/facebook/login/LoginClient;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "e2e", "", "tokenSource", "Lcom/facebook/AccessTokenSource;", "getTokenSource", "()Lcom/facebook/AccessTokenSource;", "addExtraParameters", "Landroid/os/Bundle;", "parameters", "request", "Lcom/facebook/login/LoginClient$Request;", "getParameters", "getSSODevice", "loadCookieToken", "onComplete", "", "values", "error", "Lcom/facebook/FacebookException;", "saveCookieToken", "token", "Companion", "facebook-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class WebLoginMethodHandler
extends LoginMethodHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String e2e;
    @NotNull
    private static final String WEB_VIEW_AUTH_HANDLER_STORE = "com.facebook.login.AuthorizationClient.WebViewAuthHandler.TOKEN_STORE_KEY";
    @NotNull
    private static final String WEB_VIEW_AUTH_HANDLER_TOKEN_KEY = "TOKEN";

    @NotNull
    public abstract AccessTokenSource getTokenSource();

    public WebLoginMethodHandler(@NotNull LoginClient loginClient) {
        Intrinsics.checkNotNullParameter((Object)loginClient, (String)"loginClient");
        super(loginClient);
    }

    public WebLoginMethodHandler(@NotNull Parcel source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super(source);
    }

    @Nullable
    protected String getSSODevice() {
        return null;
    }

    @NotNull
    protected Bundle getParameters(@NotNull LoginClient.Request request) {
        String previousTokenString;
        AccessToken previousToken;
        DefaultAudience defaultAudience;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Bundle parameters = new Bundle();
        if (!Utility.isNullOrEmpty((Collection)request.getPermissions())) {
            String scope = TextUtils.join((CharSequence)",", (Iterable)request.getPermissions());
            parameters.putString("scope", scope);
            this.addLoggingExtra("scope", scope);
        }
        DefaultAudience audience = (defaultAudience = request.getDefaultAudience()) == null ? DefaultAudience.NONE : defaultAudience;
        parameters.putString("default_audience", audience.getNativeProtocolAudience());
        parameters.putString("state", this.getClientState(request.getAuthId()));
        AccessToken accessToken = previousToken = AccessToken.Companion.getCurrentAccessToken();
        String string2 = previousTokenString = accessToken == null ? null : accessToken.getToken();
        if (previousTokenString != null && Intrinsics.areEqual((Object)previousTokenString, (Object)this.loadCookieToken())) {
            parameters.putString("access_token", previousTokenString);
            this.addLoggingExtra("access_token", "1");
        } else {
            accessToken = this.getLoginClient().getActivity();
            if (accessToken != null) {
                AccessToken accessToken2 = accessToken;
                boolean bl = false;
                boolean bl2 = false;
                AccessToken it = accessToken2;
                boolean bl3 = false;
                Utility.clearFacebookCookies((Context)((Context)it));
            }
            this.addLoggingExtra("access_token", "0");
        }
        parameters.putString("cbt", String.valueOf(System.currentTimeMillis()));
        parameters.putString("ies", FacebookSdk.INSTANCE.getAutoLogAppEventsEnabled() ? "1" : "0");
        return parameters;
    }

    @NotNull
    protected Bundle addExtraParameters(@NotNull Bundle parameters, @NotNull LoginClient.Request request) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        parameters.putString("redirect_uri", this.getRedirectUrl());
        if (request.isInstagramLogin()) {
            parameters.putString("app_id", request.getApplicationId());
        } else {
            parameters.putString("client_id", request.getApplicationId());
        }
        parameters.putString("e2e", LoginClient.Companion.getE2E());
        if (request.isInstagramLogin()) {
            parameters.putString("response_type", "token,signed_request,graph_domain,granted_scopes");
        } else {
            if (request.getPermissions().contains("openid")) {
                parameters.putString("nonce", request.getNonce());
            }
            parameters.putString("response_type", "id_token,token,signed_request,graph_domain");
        }
        parameters.putString("code_challenge", request.getCodeChallenge());
        CodeChallengeMethod codeChallengeMethod = request.getCodeChallengeMethod();
        parameters.putString("code_challenge_method", codeChallengeMethod == null ? null : codeChallengeMethod.name());
        parameters.putString("return_scopes", "true");
        parameters.putString("auth_type", request.getAuthType());
        parameters.putString("login_behavior", request.getLoginBehavior().name());
        parameters.putString("sdk", Intrinsics.stringPlus((String)"android-", (Object)FacebookSdk.INSTANCE.getSdkVersion()));
        if (this.getSSODevice() != null) {
            parameters.putString("sso", this.getSSODevice());
        }
        parameters.putString("cct_prefetching", FacebookSdk.hasCustomTabsPrefetching ? "1" : "0");
        if (request.isFamilyLogin()) {
            parameters.putString("fx_app", request.getLoginTargetApp().toString());
        }
        if (request.shouldSkipAccountDeduplication()) {
            parameters.putString("skip_dedupe", "true");
        }
        if (request.getMessengerPageId() != null) {
            parameters.putString("messenger_page_id", request.getMessengerPageId());
            parameters.putString("reset_messenger_state", request.getResetMessengerState() ? "1" : "0");
        }
        return parameters;
    }

    @VisibleForTesting(otherwise=4)
    public void onComplete(@NotNull LoginClient.Request request, @Nullable Bundle values, @Nullable FacebookException error) {
        LoginClient loginClient;
        LoginClient.Result outcome;
        block10: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            outcome = null;
            loginClient = this.getLoginClient();
            this.e2e = null;
            if (values != null) {
                if (values.containsKey("e2e")) {
                    this.e2e = values.getString("e2e");
                }
                try {
                    AccessToken token = LoginMethodHandler.Companion.createAccessTokenFromWebBundle((Collection<String>)request.getPermissions(), values, this.getTokenSource(), request.getApplicationId());
                    AuthenticationToken authenticationToken = LoginMethodHandler.Companion.createAuthenticationTokenFromWebBundle(values, request.getNonce());
                    outcome = LoginClient.Result.Companion.createCompositeTokenResult(loginClient.getPendingRequest(), token, authenticationToken);
                    if (loginClient.getActivity() == null) break block10;
                    CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)((Context)loginClient.getActivity()));
                    syncManager.sync();
                    if (token != null) {
                        this.saveCookieToken(token.getToken());
                    }
                }
                catch (FacebookException ex) {
                    outcome = LoginClient.Result.Companion.createErrorResult$default(LoginClient.Result.Companion, loginClient.getPendingRequest(), null, ex.getMessage(), null, 8, null);
                }
            } else if (error instanceof FacebookOperationCanceledException) {
                outcome = LoginClient.Result.Companion.createCancelResult(loginClient.getPendingRequest(), "User canceled log in.");
            } else {
                String errorMessage;
                this.e2e = null;
                String errorCode = null;
                FacebookException syncManager = error;
                String string2 = errorMessage = syncManager == null ? null : syncManager.getMessage();
                if (error instanceof FacebookServiceException) {
                    FacebookRequestError requestError = ((FacebookServiceException)((Object)error)).getRequestError();
                    errorCode = String.valueOf(requestError.getErrorCode());
                    errorMessage = requestError.toString();
                }
                outcome = LoginClient.Result.Companion.createErrorResult(loginClient.getPendingRequest(), null, errorMessage, errorCode);
            }
        }
        if (!Utility.isNullOrEmpty((String)this.e2e)) {
            this.logWebLoginCompleted(this.e2e);
        }
        loginClient.completeAndValidate(outcome);
    }

    private final String loadCookieToken() {
        FragmentActivity fragmentActivity = this.getLoginClient().getActivity();
        Context context = fragmentActivity == null ? FacebookSdk.INSTANCE.getApplicationContext() : (Context)fragmentActivity;
        SharedPreferences sharedPreferences = context.getSharedPreferences(WEB_VIEW_AUTH_HANDLER_STORE, 0);
        return sharedPreferences.getString(WEB_VIEW_AUTH_HANDLER_TOKEN_KEY, "");
    }

    private final void saveCookieToken(String token) {
        FragmentActivity fragmentActivity = this.getLoginClient().getActivity();
        Context context = fragmentActivity == null ? FacebookSdk.INSTANCE.getApplicationContext() : (Context)fragmentActivity;
        context.getSharedPreferences(WEB_VIEW_AUTH_HANDLER_STORE, 0).edit().putString(WEB_VIEW_AUTH_HANDLER_TOKEN_KEY, token).apply();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/login/WebLoginMethodHandler$Companion;", "", "()V", "WEB_VIEW_AUTH_HANDLER_STORE", "", "WEB_VIEW_AUTH_HANDLER_TOKEN_KEY", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

