/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.AuthenticationToken;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.internal.PlatformServiceClient;
import com.facebook.internal.Utility;
import com.facebook.login.GetTokenClient;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginMethodHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0016\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/facebook/login/GetTokenLoginMethodHandler;", "Lcom/facebook/login/LoginMethodHandler;", "loginClient", "Lcom/facebook/login/LoginClient;", "(Lcom/facebook/login/LoginClient;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "getTokenClient", "Lcom/facebook/login/GetTokenClient;", "nameForLogging", "", "getNameForLogging", "()Ljava/lang/String;", "cancel", "", "complete", "request", "Lcom/facebook/login/LoginClient$Request;", "result", "Landroid/os/Bundle;", "describeContents", "", "getTokenCompleted", "onComplete", "tryAuthorize", "Companion", "facebook-common_release"})
public final class GetTokenLoginMethodHandler
extends LoginMethodHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private GetTokenClient getTokenClient;
    @NotNull
    private final String nameForLogging;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<GetTokenLoginMethodHandler> CREATOR = (Parcelable.Creator)new Parcelable.Creator<GetTokenLoginMethodHandler>(){

        @NotNull
        public GetTokenLoginMethodHandler createFromParcel(@NotNull Parcel source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new GetTokenLoginMethodHandler(source);
        }

        @NotNull
        public GetTokenLoginMethodHandler[] newArray(int size) {
            return new GetTokenLoginMethodHandler[size];
        }
    };

    public GetTokenLoginMethodHandler(@NotNull LoginClient loginClient) {
        Intrinsics.checkNotNullParameter((Object)loginClient, (String)"loginClient");
        super(loginClient);
        this.nameForLogging = "get_token";
    }

    @Override
    @NotNull
    public String getNameForLogging() {
        return this.nameForLogging;
    }

    @Override
    public void cancel() {
        GetTokenClient getTokenClient = this.getTokenClient;
        if (getTokenClient != null) {
            GetTokenClient getTokenClient2 = getTokenClient;
            boolean bl = false;
            boolean bl2 = false;
            GetTokenClient it = getTokenClient2;
            boolean bl3 = false;
            it.cancel();
            it.setCompletedListener(null);
            this.getTokenClient = null;
        }
    }

    @Override
    public int tryAuthorize(@NotNull LoginClient.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = this.getLoginClient().getActivity();
        this.getTokenClient = new GetTokenClient(object == null ? FacebookSdk.INSTANCE.getApplicationContext() : (Context)object, request);
        object = this.getTokenClient;
        if (Intrinsics.areEqual((Object)(object == null ? null : Boolean.valueOf(((PlatformServiceClient)object).start())), (Object)false)) {
            return 0;
        }
        this.getLoginClient().notifyBackgroundProcessingStart();
        PlatformServiceClient.CompletedListener callback = arg_0 -> GetTokenLoginMethodHandler.tryAuthorize$lambda-1(this, request, arg_0);
        GetTokenClient getTokenClient = this.getTokenClient;
        if (getTokenClient != null) {
            getTokenClient.setCompletedListener(callback);
        }
        return 1;
    }

    public final void getTokenCompleted(@NotNull LoginClient.Request request, @Nullable Bundle result) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        GetTokenClient getTokenClient = this.getTokenClient;
        if (getTokenClient != null) {
            getTokenClient.setCompletedListener(null);
        }
        this.getTokenClient = null;
        this.getLoginClient().notifyBackgroundProcessingStop();
        if (result != null) {
            boolean bl;
            ArrayList arrayList = result.getStringArrayList("com.facebook.platform.extra.PERMISSIONS");
            List currentPermissions = arrayList == null ? CollectionsKt.emptyList() : (List)arrayList;
            Set<String> set = request.getPermissions();
            Set<String> permissions = set == null ? SetsKt.emptySet() : set;
            String idTokenString = result.getString("com.facebook.platform.extra.ID_TOKEN");
            if (permissions.contains("openid")) {
                CharSequence charSequence = idTokenString;
                boolean bl2 = false;
                bl = false;
                if (charSequence == null || charSequence.length() == 0) {
                    this.getLoginClient().tryNextHandler();
                    return;
                }
            }
            if (currentPermissions.containsAll((Collection)permissions)) {
                this.complete(request, result);
                return;
            }
            HashSet<String> newPermissions = new HashSet<String>();
            for (String permission : permissions) {
                if (currentPermissions.contains(permission)) continue;
                newPermissions.add(permission);
            }
            Collection collection = newPermissions;
            bl = false;
            if (!collection.isEmpty()) {
                this.addLoggingExtra("new_permissions", TextUtils.join((CharSequence)",", (Iterable)newPermissions));
            }
            request.setPermissions((Set<String>)newPermissions);
        }
        this.getLoginClient().tryNextHandler();
    }

    public final void onComplete(@NotNull LoginClient.Request request, @NotNull Bundle result) {
        LoginClient.Result result2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        try {
            AccessToken token = LoginMethodHandler.Companion.createAccessTokenFromNativeLogin(result, AccessTokenSource.FACEBOOK_APPLICATION_SERVICE, request.getApplicationId());
            AuthenticationToken authenticationToken = LoginMethodHandler.Companion.createAuthenticationTokenFromNativeLogin(result, request.getNonce());
            result2 = LoginClient.Result.Companion.createCompositeTokenResult(request, token, authenticationToken);
        }
        catch (FacebookException ex) {
            result2 = LoginClient.Result.Companion.createErrorResult$default(LoginClient.Result.Companion, this.getLoginClient().getPendingRequest(), null, ex.getMessage(), null, 8, null);
        }
        LoginClient.Result outcome = result2;
        this.getLoginClient().completeAndValidate(outcome);
    }

    public final void complete(@NotNull LoginClient.Request request, @NotNull Bundle result) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        String userId = result.getString("com.facebook.platform.extra.USER_ID");
        CharSequence charSequence = userId;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            String string2;
            this.getLoginClient().notifyBackgroundProcessingStart();
            String string3 = result.getString("com.facebook.platform.extra.ACCESS_TOKEN");
            boolean bl3 = false;
            boolean bl4 = false;
            bl4 = false;
            boolean bl5 = false;
            if (string3 == null) {
                boolean bl6 = false;
                String string4 = "Required value was null.";
                throw (Throwable)new IllegalStateException(string4.toString());
            }
            String accessToken = string2 = string3;
            Utility.getGraphMeRequestWithCacheAsync((String)accessToken, (Utility.GraphMeRequestWithCacheCallback)new Utility.GraphMeRequestWithCacheCallback(result, this, request){
                final /* synthetic */ Bundle $result;
                final /* synthetic */ GetTokenLoginMethodHandler this$0;
                final /* synthetic */ LoginClient.Request $request;
                {
                    this.$result = $result;
                    this.this$0 = $receiver;
                    this.$request = $request;
                }

                public void onSuccess(@Nullable JSONObject userInfo) {
                    try {
                        JSONObject jSONObject = userInfo;
                        this.$result.putString("com.facebook.platform.extra.USER_ID", jSONObject == null ? null : jSONObject.getString("id"));
                        this.this$0.onComplete(this.$request, this.$result);
                    }
                    catch (JSONException ex) {
                        this.this$0.getLoginClient().complete(LoginClient.Result.Companion.createErrorResult$default(LoginClient.Result.Companion, this.this$0.getLoginClient().getPendingRequest(), "Caught exception", ex.getMessage(), null, 8, null));
                    }
                }

                public void onFailure(@Nullable FacebookException error) {
                    FacebookException facebookException;
                    this.this$0.getLoginClient().complete(LoginClient.Result.Companion.createErrorResult$default(LoginClient.Result.Companion, this.this$0.getLoginClient().getPendingRequest(), "Caught exception", (facebookException = error) == null ? null : facebookException.getMessage(), null, 8, null));
                }
            });
        } else {
            this.onComplete(request, result);
        }
    }

    public GetTokenLoginMethodHandler(@NotNull Parcel source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super(source);
        this.nameForLogging = "get_token";
    }

    public int describeContents() {
        return 0;
    }

    private static final void tryAuthorize$lambda-1(GetTokenLoginMethodHandler this$0, LoginClient.Request $request, Bundle result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        this$0.getTokenCompleted($request, result);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/login/GetTokenLoginMethodHandler$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/login/GetTokenLoginMethodHandler;", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

