/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.FragmentActivity;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.internal.FacebookDialogFragment;
import com.facebook.internal.Utility;
import com.facebook.internal.WebDialog;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginTargetApp;
import com.facebook.login.WebLoginMethodHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 ,2\u00020\u0001:\u0002+,B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\"\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u001dH\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lcom/facebook/login/WebViewLoginMethodHandler;", "Lcom/facebook/login/WebLoginMethodHandler;", "loginClient", "Lcom/facebook/login/LoginClient;", "(Lcom/facebook/login/LoginClient;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "e2e", "", "getE2e", "()Ljava/lang/String;", "setE2e", "(Ljava/lang/String;)V", "loginDialog", "Lcom/facebook/internal/WebDialog;", "getLoginDialog", "()Lcom/facebook/internal/WebDialog;", "setLoginDialog", "(Lcom/facebook/internal/WebDialog;)V", "nameForLogging", "getNameForLogging", "tokenSource", "Lcom/facebook/AccessTokenSource;", "getTokenSource", "()Lcom/facebook/AccessTokenSource;", "cancel", "", "describeContents", "", "needsInternetPermission", "", "onWebDialogComplete", "request", "Lcom/facebook/login/LoginClient$Request;", "values", "Landroid/os/Bundle;", "error", "Lcom/facebook/FacebookException;", "tryAuthorize", "writeToParcel", "dest", "flags", "AuthDialogBuilder", "Companion", "facebook-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WebViewLoginMethodHandler
extends WebLoginMethodHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private WebDialog loginDialog;
    @Nullable
    private String e2e;
    @NotNull
    private final String nameForLogging;
    @NotNull
    private final AccessTokenSource tokenSource;
    @NotNull
    private static final String OAUTH_DIALOG = "oauth";
    @JvmField
    @NotNull
    public static final Parcelable.Creator<WebViewLoginMethodHandler> CREATOR = (Parcelable.Creator)new Parcelable.Creator<WebViewLoginMethodHandler>(){

        @NotNull
        public WebViewLoginMethodHandler createFromParcel(@NotNull Parcel source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new WebViewLoginMethodHandler(source);
        }

        @NotNull
        public WebViewLoginMethodHandler[] newArray(int size) {
            return new WebViewLoginMethodHandler[size];
        }
    };

    @Nullable
    public final WebDialog getLoginDialog() {
        return this.loginDialog;
    }

    public final void setLoginDialog(@Nullable WebDialog webDialog) {
        this.loginDialog = webDialog;
    }

    @Nullable
    public final String getE2e() {
        return this.e2e;
    }

    public final void setE2e(@Nullable String string2) {
        this.e2e = string2;
    }

    public WebViewLoginMethodHandler(@NotNull LoginClient loginClient) {
        Intrinsics.checkNotNullParameter((Object)loginClient, (String)"loginClient");
        super(loginClient);
        this.nameForLogging = "web_view";
        this.tokenSource = AccessTokenSource.WEB_VIEW;
    }

    @Override
    @NotNull
    public String getNameForLogging() {
        return this.nameForLogging;
    }

    @Override
    @NotNull
    public AccessTokenSource getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public boolean needsInternetPermission() {
        return true;
    }

    @Override
    public void cancel() {
        if (this.loginDialog != null) {
            WebDialog webDialog = this.loginDialog;
            if (webDialog != null) {
                webDialog.cancel();
            }
            this.loginDialog = null;
        }
    }

    @Override
    public int tryAuthorize(@NotNull LoginClient.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Bundle parameters = this.getParameters(request);
        WebDialog.OnCompleteListener listener2 = new WebDialog.OnCompleteListener(this, request){
            final /* synthetic */ WebViewLoginMethodHandler this$0;
            final /* synthetic */ LoginClient.Request $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
            }

            public void onComplete(@Nullable Bundle values, @Nullable FacebookException error) {
                this.this$0.onWebDialogComplete(this.$request, values, error);
            }
        };
        this.e2e = LoginClient.Companion.getE2E();
        this.addLoggingExtra("e2e", this.e2e);
        FragmentActivity fragmentActivity = this.getLoginClient().getActivity();
        if (fragmentActivity == null) {
            return 0;
        }
        FragmentActivity fragmentActivity2 = fragmentActivity;
        boolean isChromeOS = Utility.isChromeOS((Context)((Context)fragmentActivity2));
        String string2 = this.e2e;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        WebDialog.Builder builder = new AuthDialogBuilder((Context)fragmentActivity2, request.getApplicationId(), parameters).setE2E(string2).setIsChromeOS(isChromeOS).setAuthType(request.getAuthType()).setLoginBehavior(request.getLoginBehavior()).setLoginTargetApp(request.getLoginTargetApp()).setFamilyLogin(request.isFamilyLogin()).setShouldSkipDedupe(request.shouldSkipAccountDeduplication()).setOnCompleteListener(listener2);
        this.loginDialog = builder.build();
        FacebookDialogFragment dialogFragment = new FacebookDialogFragment();
        dialogFragment.setRetainInstance(true);
        dialogFragment.setInnerDialog(this.loginDialog);
        dialogFragment.show(fragmentActivity2.getSupportFragmentManager(), "FacebookDialogFragment");
        return 1;
    }

    public final void onWebDialogComplete(@NotNull LoginClient.Request request, @Nullable Bundle values, @Nullable FacebookException error) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super.onComplete(request, values, error);
    }

    public WebViewLoginMethodHandler(@NotNull Parcel source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super(source);
        this.nameForLogging = "web_view";
        this.tokenSource = AccessTokenSource.WEB_VIEW;
        this.e2e = source.readString();
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        super.writeToParcel(dest, flags);
        dest.writeString(this.e2e);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\f\u001a\u00060\u0000R\u00020\u001b2\u0006\u0010\t\u001a\u00020\u0005J\u0012\u0010\u001c\u001a\u00060\u0000R\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u0005J\u0012\u0010\u001d\u001a\u00060\u0000R\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u001e\u001a\u00060\u0000R\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0012J\u0012\u0010 \u001a\u00060\u0000R\u00020\u001b2\u0006\u0010!\u001a\u00020\u0012J\u0012\u0010\"\u001a\u00060\u0000R\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010#\u001a\u00060\u0000R\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010$\u001a\u00060\u0000R\u00020\u001b2\u0006\u0010%\u001a\u00020\u0012R\u001a\u0010\t\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/facebook/login/WebViewLoginMethodHandler$AuthDialogBuilder;", "Lcom/facebook/internal/WebDialog$Builder;", "context", "Landroid/content/Context;", "applicationId", "", "parameters", "Landroid/os/Bundle;", "(Lcom/facebook/login/WebViewLoginMethodHandler;Landroid/content/Context;Ljava/lang/String;Landroid/os/Bundle;)V", "authType", "getAuthType", "()Ljava/lang/String;", "setAuthType", "(Ljava/lang/String;)V", "e2e", "getE2e", "setE2e", "isFamilyLogin", "", "loginBehavior", "Lcom/facebook/login/LoginBehavior;", "redirect_uri", "shouldSkipDedupe", "targetApp", "Lcom/facebook/login/LoginTargetApp;", "build", "Lcom/facebook/internal/WebDialog;", "Lcom/facebook/login/WebViewLoginMethodHandler;", "setE2E", "setFamilyLogin", "setIsChromeOS", "isChromeOS", "setIsRerequest", "isRerequest", "setLoginBehavior", "setLoginTargetApp", "setShouldSkipDedupe", "shouldSkip", "facebook-common_release"})
    public final class AuthDialogBuilder
    extends WebDialog.Builder {
        @NotNull
        private String redirect_uri;
        @NotNull
        private LoginBehavior loginBehavior;
        @NotNull
        private LoginTargetApp targetApp;
        private boolean isFamilyLogin;
        private boolean shouldSkipDedupe;
        public String e2e;
        public String authType;

        @NotNull
        public final String getE2e() {
            String string2 = this.e2e;
            if (string2 != null) {
                return string2;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"e2e");
            throw null;
        }

        public final void setE2e(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.e2e = string2;
        }

        @NotNull
        public final String getAuthType() {
            String string2 = this.authType;
            if (string2 != null) {
                return string2;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"authType");
            throw null;
        }

        public final void setAuthType(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.authType = string2;
        }

        public AuthDialogBuilder(@NotNull Context context, @NotNull String applicationId, Bundle parameters) {
            Intrinsics.checkNotNullParameter((Object)WebViewLoginMethodHandler.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            super(context, applicationId, WebViewLoginMethodHandler.OAUTH_DIALOG, parameters);
            this.redirect_uri = "fbconnect://success";
            this.loginBehavior = LoginBehavior.NATIVE_WITH_FALLBACK;
            this.targetApp = LoginTargetApp.FACEBOOK;
        }

        @NotNull
        public final AuthDialogBuilder setE2E(@NotNull String e2e) {
            Intrinsics.checkNotNullParameter((Object)e2e, (String)"e2e");
            this.setE2e(e2e);
            return this;
        }

        @NotNull
        public final AuthDialogBuilder setIsRerequest(boolean isRerequest) {
            return this;
        }

        @NotNull
        public final AuthDialogBuilder setIsChromeOS(boolean isChromeOS) {
            this.redirect_uri = isChromeOS ? "fbconnect://chrome_os_success" : "fbconnect://success";
            return this;
        }

        @NotNull
        public final AuthDialogBuilder setAuthType(@NotNull String authType) {
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            this.setAuthType(authType);
            return this;
        }

        @NotNull
        public final AuthDialogBuilder setLoginBehavior(@NotNull LoginBehavior loginBehavior) {
            Intrinsics.checkNotNullParameter((Object)((Object)loginBehavior), (String)"loginBehavior");
            this.loginBehavior = loginBehavior;
            return this;
        }

        @NotNull
        public final AuthDialogBuilder setLoginTargetApp(@NotNull LoginTargetApp targetApp) {
            Intrinsics.checkNotNullParameter((Object)targetApp, (String)"targetApp");
            this.targetApp = targetApp;
            return this;
        }

        @NotNull
        public final AuthDialogBuilder setFamilyLogin(boolean isFamilyLogin) {
            this.isFamilyLogin = isFamilyLogin;
            return this;
        }

        @NotNull
        public final AuthDialogBuilder setShouldSkipDedupe(boolean shouldSkip) {
            this.shouldSkipDedupe = shouldSkip;
            return this;
        }

        @Override
        @NotNull
        public WebDialog build() {
            Bundle bundle = this.getParameters();
            if (bundle == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.os.Bundle");
            }
            Bundle parameters = bundle;
            parameters.putString("redirect_uri", this.redirect_uri);
            parameters.putString("client_id", this.getApplicationId());
            parameters.putString("e2e", this.getE2e());
            parameters.putString("response_type", this.targetApp == LoginTargetApp.INSTAGRAM ? "token,signed_request,graph_domain,granted_scopes" : "token,signed_request,graph_domain");
            parameters.putString("return_scopes", "true");
            parameters.putString("auth_type", this.getAuthType());
            parameters.putString("login_behavior", this.loginBehavior.name());
            if (this.isFamilyLogin) {
                parameters.putString("fx_app", this.targetApp.toString());
            }
            if (this.shouldSkipDedupe) {
                parameters.putString("skip_dedupe", "true");
            }
            if ((bundle = this.getContext()) == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.content.Context");
            }
            return WebDialog.Companion.newInstance((Context)bundle, WebViewLoginMethodHandler.OAUTH_DIALOG, parameters, this.getTheme(), this.targetApp, this.getListener());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/login/WebViewLoginMethodHandler$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/login/WebViewLoginMethodHandler;", "OAUTH_DIALOG", "", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

