/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.os.Bundle;
import android.util.Base64;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.HttpMethod;
import com.facebook.login.CodeChallengeMethod;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0007J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\u0006H\u0007J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u000f"}, d2={"Lcom/facebook/login/PKCEUtil;", "", "()V", "createCodeExchangeRequest", "Lcom/facebook/GraphRequest;", "authorizationCode", "", "redirectUri", "codeVerifier", "generateCodeChallenge", "codeChallengeMethod", "Lcom/facebook/login/CodeChallengeMethod;", "generateCodeVerifier", "isValidCodeVerifier", "", "facebook-common_release"})
public final class PKCEUtil {
    @NotNull
    public static final PKCEUtil INSTANCE = new PKCEUtil();

    private PKCEUtil() {
    }

    @JvmStatic
    public static final boolean isValidCodeVerifier(@Nullable String codeVerifier) {
        CharSequence charSequence = codeVerifier;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0 || codeVerifier.length() < 43 || codeVerifier.length() > 128) {
            return false;
        }
        Regex regex = new Regex("^[-._~A-Za-z0-9]+$");
        return regex.matches((CharSequence)codeVerifier);
    }

    @JvmStatic
    @NotNull
    public static final String generateCodeVerifier() {
        IntRange intRange = new IntRange(43, 128);
        boolean bl = false;
        int random43to128 = RangesKt.random((IntRange)intRange, (Random)((Random)Random.Default));
        List allowedCharSet = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9'))), (Object)Character.valueOf('-')), (Object)Character.valueOf('.')), (Object)Character.valueOf('_')), (Object)Character.valueOf('~'));
        bl = false;
        boolean bl2 = false;
        ArrayList<Character> arrayList = new ArrayList<Character>(random43to128);
        boolean bl3 = false;
        int n = 0;
        n = 0;
        int n2 = random43to128;
        while (n < n2) {
            int n3 = n++;
            boolean bl4 = false;
            int n4 = n3;
            ArrayList<Character> arrayList2 = arrayList;
            boolean bl5 = false;
            Collection collection = allowedCharSet;
            boolean bl6 = false;
            Character c = Character.valueOf(((Character)CollectionsKt.random((Collection)collection, (Random)((Random)Random.Default))).charValue());
            arrayList2.add(c);
        }
        return CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @JvmStatic
    @NotNull
    public static final String generateCodeChallenge(@NotNull String codeVerifier, @NotNull CodeChallengeMethod codeChallengeMethod) throws FacebookException {
        String string2;
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        Intrinsics.checkNotNullParameter((Object)((Object)codeChallengeMethod), (String)"codeChallengeMethod");
        if (!PKCEUtil.isValidCodeVerifier(codeVerifier)) {
            throw new FacebookException("Invalid Code Verifier.");
        }
        if (codeChallengeMethod == CodeChallengeMethod.PLAIN) {
            return codeVerifier;
        }
        try {
            String string3 = codeVerifier;
            Charset charset = Charsets.US_ASCII;
            boolean bl = false;
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] bytes = byArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(bytes, 0, bytes.length);
            byte[] digest = messageDigest.digest();
            string2 = Base64.encodeToString((byte[])digest, (int)11);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n      // try to generate challenge with S256\n      val bytes: ByteArray = codeVerifier.toByteArray(Charsets.US_ASCII)\n      val messageDigest = MessageDigest.getInstance(\"SHA-256\")\n      messageDigest.update(bytes, 0, bytes.size)\n      val digest = messageDigest.digest()\n\n      Base64.encodeToString(digest, Base64.URL_SAFE or Base64.NO_PADDING or Base64.NO_WRAP)\n    }");
        }
        catch (Exception ex) {
            throw new FacebookException((Throwable)ex);
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest createCodeExchangeRequest(@NotNull String authorizationCode, @NotNull String redirectUri, @NotNull String codeVerifier) {
        Intrinsics.checkNotNullParameter((Object)authorizationCode, (String)"authorizationCode");
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        Bundle parameters = new Bundle();
        parameters.putString("code", authorizationCode);
        parameters.putString("client_id", FacebookSdk.INSTANCE.getApplicationId());
        parameters.putString("redirect_uri", redirectUri);
        parameters.putString("code_verifier", codeVerifier);
        GraphRequest graphRequest = GraphRequest.Companion.newGraphPathRequest(null, "oauth/access_token", null);
        graphRequest.setHttpMethod(HttpMethod.GET);
        graphRequest.setParameters(parameters);
        return graphRequest;
    }
}

