/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Pair;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookGraphResponseException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.NativeAppCallAttachmentStore;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.share.Sharer;
import com.facebook.share.internal.ResultProcessor;
import com.facebook.share.model.CameraEffectTextures;
import com.facebook.share.model.ShareCameraEffectContent;
import com.facebook.share.model.ShareMedia;
import com.facebook.share.model.ShareMediaContent;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareStoryContent;
import com.facebook.share.model.ShareVideo;
import com.facebook.share.model.ShareVideoContent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J&\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0015\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0016H\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0007J\u001e\u0010\u001c\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0007J\"\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001b\u001a\u00020\u0010H\u0007J\u0012\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020\u0018H\u0007J\"\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010 2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001b\u001a\u00020\u0010H\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020\u0018H\u0007J\u0018\u0010)\u001a\u00020*2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,H\u0007J\u001c\u0010.\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0007J\u001c\u0010/\u001a\u0004\u0018\u00010\u00182\b\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u001b\u001a\u00020\u0010H\u0007J\u0014\u00102\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\u001c\u00103\u001a\u0004\u0018\u00010\u00042\b\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\u001b\u001a\u00020\u0010H\u0007J,\u00106\u001a\u0002072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u00108\u001a\u0004\u0018\u00010*H\u0007J\"\u00109\u001a\u00020:2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\b\u0010;\u001a\u0004\u0018\u00010\u0004H\u0007J \u0010<\u001a\u00020:2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\u0006\u0010=\u001a\u00020>H\u0007J*\u0010?\u001a\u00020:2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\b\u0010@\u001a\u0004\u0018\u00010\u00042\u0006\u0010A\u001a\u00020BH\u0007J\u0018\u0010C\u001a\u00020:2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,H\u0007J \u0010D\u001a\u00020:2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\u0006\u0010E\u001a\u00020FH\u0007J,\u0010D\u001a\u00020:2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\b\u0010G\u001a\u0004\u0018\u00010B2\b\u0010H\u001a\u0004\u0018\u00010\u0004H\u0007J\"\u0010D\u001a\u00020:2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\b\u0010H\u001a\u0004\u0018\u00010\u0004H\u0007J\"\u0010I\u001a\u00020:2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,2\b\u0010@\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010J\u001a\u00020:2\u0006\u0010K\u001a\u00020\u00042\b\u0010L\u001a\u0004\u0018\u00010\u0004H\u0002J&\u0010M\u001a\u00020N2\b\u0010O\u001a\u0004\u0018\u00010P2\b\u0010Q\u001a\u0004\u0018\u00010\u00142\b\u0010+\u001a\u0004\u0018\u00010RH\u0007J$\u0010M\u001a\u00020N2\b\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010S\u001a\u00020\u00122\b\u0010+\u001a\u0004\u0018\u00010RH\u0007J&\u0010M\u001a\u00020N2\b\u0010O\u001a\u0004\u0018\u00010P2\b\u0010T\u001a\u0004\u0018\u00010U2\b\u0010+\u001a\u0004\u0018\u00010RH\u0007J*\u0010V\u001a\u00020:2\u0006\u0010\b\u001a\u00020\t2\b\u0010W\u001a\u0004\u0018\u00010X2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,H\u0007J\u0010\u0010Y\u001a\u00020:2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020[2\u0006\u0010]\u001a\u000207H\u0007J\u001c\u0010^\u001a\u0004\u0018\u00010_2\b\u0010`\u001a\u0004\u0018\u00010_2\u0006\u0010]\u001a\u000207H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/facebook/share/internal/ShareInternalUtility;", "", "()V", "MY_STAGING_RESOURCES", "", "STAGING_PARAM", "getAppCallFromActivityResult", "Lcom/facebook/internal/AppCall;", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "getAttachment", "Lcom/facebook/internal/NativeAppCallAttachmentStore$Attachment;", "callId", "Ljava/util/UUID;", "uri", "Landroid/net/Uri;", "bitmap", "Landroid/graphics/Bitmap;", "medium", "Lcom/facebook/share/model/ShareMedia;", "getBackgroundAssetMediaInfo", "Landroid/os/Bundle;", "storyContent", "Lcom/facebook/share/model/ShareStoryContent;", "appCallId", "getFieldNameAndNamespaceFromFullName", "Landroid/util/Pair;", "fullName", "getMediaInfos", "", "mediaContent", "Lcom/facebook/share/model/ShareMediaContent;", "getNativeDialogCompletionGesture", "result", "getPhotoUrls", "photoContent", "Lcom/facebook/share/model/SharePhotoContent;", "getShareDialogPostId", "getShareResultProcessor", "Lcom/facebook/share/internal/ResultProcessor;", "callback", "Lcom/facebook/FacebookCallback;", "Lcom/facebook/share/Sharer$Result;", "getStickerUrl", "getTextureUrlBundle", "cameraEffectContent", "Lcom/facebook/share/model/ShareCameraEffectContent;", "getUriExtension", "getVideoUrl", "videoContent", "Lcom/facebook/share/model/ShareVideoContent;", "handleActivityResult", "", "resultProcessor", "invokeCallbackWithError", "", "error", "invokeCallbackWithException", "exception", "Ljava/lang/Exception;", "invokeCallbackWithResults", "postId", "graphResponse", "Lcom/facebook/GraphResponse;", "invokeOnCancelCallback", "invokeOnErrorCallback", "ex", "Lcom/facebook/FacebookException;", "response", "message", "invokeOnSuccessCallback", "logShareResult", "shareOutcome", "errorMessage", "newUploadStagingResourceWithImageRequest", "Lcom/facebook/GraphRequest;", "accessToken", "Lcom/facebook/AccessToken;", "image", "Lcom/facebook/GraphRequest$Callback;", "imageUri", "file", "Ljava/io/File;", "registerSharerCallback", "callbackManager", "Lcom/facebook/CallbackManager;", "registerStaticShareCallback", "removeNamespacesFromOGJsonArray", "Lorg/json/JSONArray;", "jsonArray", "requireNamespace", "removeNamespacesFromOGJsonObject", "Lorg/json/JSONObject;", "jsonObject", "facebook-common_release"})
public final class ShareInternalUtility {
    @NotNull
    public static final ShareInternalUtility INSTANCE = new ShareInternalUtility();
    @NotNull
    public static final String MY_STAGING_RESOURCES = "me/staging_resources";
    @NotNull
    public static final String STAGING_PARAM = "file";

    private ShareInternalUtility() {
    }

    @JvmStatic
    public static final void invokeCallbackWithException(@Nullable FacebookCallback<Sharer.Result> callback, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception instanceof FacebookException) {
            ShareInternalUtility.invokeOnErrorCallback(callback, (FacebookException)((Object)exception));
            return;
        }
        ShareInternalUtility.invokeCallbackWithError(callback, Intrinsics.stringPlus((String)"Error preparing share content: ", (Object)exception.getLocalizedMessage()));
    }

    @JvmStatic
    public static final void invokeCallbackWithError(@Nullable FacebookCallback<Sharer.Result> callback, @Nullable String error) {
        ShareInternalUtility.invokeOnErrorCallback(callback, error);
    }

    @JvmStatic
    public static final void invokeCallbackWithResults(@Nullable FacebookCallback<Sharer.Result> callback, @Nullable String postId, @NotNull GraphResponse graphResponse) {
        Intrinsics.checkNotNullParameter((Object)graphResponse, (String)"graphResponse");
        FacebookRequestError requestError = graphResponse.getError();
        if (requestError != null) {
            String errorMessage = requestError.getErrorMessage();
            if (Utility.isNullOrEmpty((String)errorMessage)) {
                errorMessage = "Unexpected error sharing.";
            }
            ShareInternalUtility.invokeOnErrorCallback(callback, graphResponse, errorMessage);
        } else {
            ShareInternalUtility.invokeOnSuccessCallback(callback, postId);
        }
    }

    @JvmStatic
    @Nullable
    public static final String getNativeDialogCompletionGesture(@NotNull Bundle result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return result.containsKey("completionGesture") ? result.getString("completionGesture") : result.getString("com.facebook.platform.extra.COMPLETION_GESTURE");
    }

    @JvmStatic
    @Nullable
    public static final String getShareDialogPostId(@NotNull Bundle result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (result.containsKey("postId")) {
            return result.getString("postId");
        }
        return result.containsKey("com.facebook.platform.extra.POST_ID") ? result.getString("com.facebook.platform.extra.POST_ID") : result.getString("post_id");
    }

    @JvmStatic
    public static final boolean handleActivityResult(int requestCode, int resultCode, @Nullable Intent data, @Nullable ResultProcessor resultProcessor) {
        FacebookException exception;
        AppCall appCall = INSTANCE.getAppCallFromActivityResult(requestCode, resultCode, data);
        if (appCall == null) {
            return false;
        }
        AppCall appCall2 = appCall;
        NativeAppCallAttachmentStore.cleanupAttachmentsForCall((UUID)appCall2.getCallId());
        if (resultProcessor == null) {
            return true;
        }
        FacebookException facebookException = data != null ? NativeProtocol.getExceptionFromErrorData((Bundle)NativeProtocol.getErrorDataFromResultIntent((Intent)data)) : (exception = null);
        if (exception != null) {
            if (exception instanceof FacebookOperationCanceledException) {
                resultProcessor.onCancel(appCall2);
            } else {
                resultProcessor.onError(appCall2, exception);
            }
        } else {
            Bundle results = data != null ? NativeProtocol.getSuccessResultsFromIntent((Intent)data) : null;
            resultProcessor.onSuccess(appCall2, results);
        }
        return true;
    }

    @JvmStatic
    @NotNull
    public static final ResultProcessor getShareResultProcessor(@Nullable FacebookCallback<Sharer.Result> callback) {
        return new ResultProcessor(callback){
            final /* synthetic */ FacebookCallback<Sharer.Result> $callback;
            {
                this.$callback = $callback;
                super($callback);
            }

            public void onSuccess(@NotNull AppCall appCall, @Nullable Bundle results) {
                Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
                if (results != null) {
                    String gesture = ShareInternalUtility.getNativeDialogCompletionGesture(results);
                    if (gesture == null || StringsKt.equals((String)"post", (String)gesture, (boolean)true)) {
                        ShareInternalUtility.invokeOnSuccessCallback(this.$callback, ShareInternalUtility.getShareDialogPostId(results));
                    } else if (StringsKt.equals((String)"cancel", (String)gesture, (boolean)true)) {
                        ShareInternalUtility.invokeOnCancelCallback(this.$callback);
                    } else {
                        ShareInternalUtility.invokeOnErrorCallback(this.$callback, new FacebookException("UnknownError"));
                    }
                }
            }

            public void onCancel(@NotNull AppCall appCall) {
                Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
                ShareInternalUtility.invokeOnCancelCallback(this.$callback);
            }

            public void onError(@NotNull AppCall appCall, @NotNull FacebookException error) {
                Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                ShareInternalUtility.invokeOnErrorCallback(this.$callback, error);
            }
        };
    }

    private final AppCall getAppCallFromActivityResult(int requestCode, int resultCode, Intent data) {
        UUID uUID = NativeProtocol.getCallIdFromIntent((Intent)data);
        if (uUID == null) {
            return null;
        }
        UUID callId = uUID;
        return AppCall.Companion.finishPendingCall(callId, requestCode);
    }

    @JvmStatic
    public static final void registerStaticShareCallback(int requestCode) {
        CallbackManagerImpl.Companion.registerStaticCallback(requestCode, (arg_0, arg_1) -> ShareInternalUtility.registerStaticShareCallback$lambda-0(requestCode, arg_0, arg_1));
    }

    @JvmStatic
    public static final void registerSharerCallback(int requestCode, @Nullable CallbackManager callbackManager, @Nullable FacebookCallback<Sharer.Result> callback) {
        if (!(callbackManager instanceof CallbackManagerImpl)) {
            throw new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
        }
        ((CallbackManagerImpl)callbackManager).registerCallback(requestCode, (arg_0, arg_1) -> ShareInternalUtility.registerSharerCallback$lambda-1(requestCode, callback, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final List<String> getPhotoUrls(@Nullable SharePhotoContent photoContent, @NotNull UUID appCallId) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        List<SharePhoto> list;
        Intrinsics.checkNotNullParameter((Object)appCallId, (String)"appCallId");
        SharePhotoContent sharePhotoContent = photoContent;
        List<SharePhoto> list2 = list = sharePhotoContent == null ? null : sharePhotoContent.getPhotos();
        if (list == null) {
            return null;
        }
        List<SharePhoto> photos = list;
        Iterable $this$mapNotNull$iv = photos;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<NativeAppCallAttachmentStore.Attachment> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NativeAppCallAttachmentStore.Attachment attachment;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SharePhoto it = (SharePhoto)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.getAttachment(appCallId, it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            NativeAppCallAttachmentStore.Attachment it$iv$iv = attachment;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List attachments = (List)destination$iv$iv;
        Iterable $this$map$iv = attachments;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (NativeAppCallAttachmentStore.Attachment)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            String string2 = it.getAttachmentUrl();
            collection.add(string2);
        }
        List attachmentUrls = (List)destination$iv$iv2;
        NativeAppCallAttachmentStore.addAttachments((Collection)attachments);
        return attachmentUrls;
    }

    @JvmStatic
    @Nullable
    public static final String getVideoUrl(@Nullable ShareVideoContent videoContent, @NotNull UUID appCallId) {
        ShareVideo shareVideo;
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)appCallId, (String)"appCallId");
        ShareVideoContent shareVideoContent = videoContent;
        Uri uri2 = shareVideoContent == null ? null : (uri = (shareVideo = shareVideoContent.getVideo()) == null ? null : shareVideo.getLocalUrl());
        if (uri == null) {
            return null;
        }
        Uri videoLocalUrl = uri;
        NativeAppCallAttachmentStore.Attachment attachment = NativeAppCallAttachmentStore.createAttachment((UUID)appCallId, (Uri)videoLocalUrl);
        NativeAppCallAttachmentStore.addAttachments((Collection)CollectionsKt.listOf((Object)attachment));
        return attachment.getAttachmentUrl();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final List<Bundle> getMediaInfos(@Nullable ShareMediaContent mediaContent, @NotNull UUID appCallId) {
        void $this$mapNotNullTo$iv$iv;
        List<ShareMedia<?, ?>> list;
        Intrinsics.checkNotNullParameter((Object)appCallId, (String)"appCallId");
        ShareMediaContent shareMediaContent = mediaContent;
        List<ShareMedia<?, ?>> list2 = list = shareMediaContent == null ? null : shareMediaContent.getMedia();
        if (list == null) {
            return null;
        }
        List<ShareMedia<?, ?>> media = list;
        List attachments = new ArrayList();
        Iterable $this$mapNotNull$iv = media;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Bundle bundle;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ShareMedia it = (ShareMedia)element$iv$iv;
            boolean bl2 = false;
            NativeAppCallAttachmentStore.Attachment attachment = INSTANCE.getAttachment(appCallId, it);
            if (attachment == null) {
                bundle = null;
            } else {
                NativeAppCallAttachmentStore.Attachment attachment2 = attachment;
                attachments.add(attachment2);
                Bundle mediaInfo = new Bundle();
                mediaInfo.putString("type", it.getMediaType().name());
                mediaInfo.putString("uri", attachment2.getAttachmentUrl());
                bundle = mediaInfo;
            }
            if (bundle == null) continue;
            Bundle bundle2 = bundle;
            boolean bl3 = false;
            boolean bl4 = false;
            Bundle it$iv$iv = bundle2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List mediaInfos = (List)destination$iv$iv;
        NativeAppCallAttachmentStore.addAttachments((Collection)attachments);
        return mediaInfos;
    }

    @JvmStatic
    @Nullable
    public static final Bundle getTextureUrlBundle(@Nullable ShareCameraEffectContent cameraEffectContent, @NotNull UUID appCallId) {
        CameraEffectTextures cameraEffectTextures;
        Intrinsics.checkNotNullParameter((Object)appCallId, (String)"appCallId");
        ShareCameraEffectContent shareCameraEffectContent = cameraEffectContent;
        CameraEffectTextures cameraEffectTextures2 = cameraEffectTextures = shareCameraEffectContent == null ? null : shareCameraEffectContent.getTextures();
        if (cameraEffectTextures == null) {
            return null;
        }
        CameraEffectTextures textures = cameraEffectTextures;
        Bundle attachmentUrlsBundle = new Bundle();
        List attachments = new ArrayList();
        for (String key : textures.keySet()) {
            NativeAppCallAttachmentStore.Attachment attachment = INSTANCE.getAttachment(appCallId, textures.getTextureUri(key), textures.getTextureBitmap(key));
            if (attachment == null) continue;
            attachments.add(attachment);
            attachmentUrlsBundle.putString(key, attachment.getAttachmentUrl());
        }
        NativeAppCallAttachmentStore.addAttachments((Collection)attachments);
        return attachmentUrlsBundle;
    }

    @JvmStatic
    @NotNull
    public static final JSONArray removeNamespacesFromOGJsonArray(@NotNull JSONArray jsonArray, boolean requireNamespace) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        JSONArray newArray = new JSONArray();
        int n = 0;
        int n2 = jsonArray.length();
        if (n < n2) {
            do {
                int i;
                Object value;
                if ((value = jsonArray.get(i = n++)) instanceof JSONArray) {
                    Object object = value;
                    value = ShareInternalUtility.removeNamespacesFromOGJsonArray((JSONArray)object, requireNamespace);
                } else if (value instanceof JSONObject) {
                    value = ShareInternalUtility.removeNamespacesFromOGJsonObject((JSONObject)value, requireNamespace);
                }
                newArray.put(value);
            } while (n < n2);
        }
        return newArray;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final JSONObject removeNamespacesFromOGJsonObject(@Nullable JSONObject jsonObject, boolean requireNamespace) {
        JSONObject jSONObject;
        if (jsonObject == null) {
            jSONObject = null;
        } else {
            void var2_2;
            try {
                JSONObject newJsonObject = new JSONObject();
                JSONObject data = new JSONObject();
                JSONArray jSONArray = jsonObject.names();
                if (jSONArray == null) {
                    return null;
                }
                int n = 0;
                JSONArray names = jSONArray;
                int n2 = names.length();
                if (n < n2) {
                    do {
                        int i = n++;
                        String key = names.getString(i);
                        Object value = null;
                        value = jsonObject.get(key);
                        if (value instanceof JSONObject) {
                            value = ShareInternalUtility.removeNamespacesFromOGJsonObject((JSONObject)value, true);
                        } else if (value instanceof JSONArray) {
                            value = ShareInternalUtility.removeNamespacesFromOGJsonArray((JSONArray)value, true);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                        Pair<String, String> fieldNameAndNamespace = ShareInternalUtility.getFieldNameAndNamespaceFromFullName(key);
                        String namespace = (String)fieldNameAndNamespace.first;
                        String fieldName = (String)fieldNameAndNamespace.second;
                        if (requireNamespace) {
                            if (namespace != null && Intrinsics.areEqual((Object)namespace, (Object)"fbsdk")) {
                                newJsonObject.put(key, value);
                                continue;
                            }
                            if (namespace == null || Intrinsics.areEqual((Object)namespace, (Object)"og")) {
                                newJsonObject.put(fieldName, value);
                                continue;
                            }
                            data.put(fieldName, value);
                            continue;
                        }
                        if (namespace != null && Intrinsics.areEqual((Object)namespace, (Object)"fb")) {
                            newJsonObject.put(key, value);
                            continue;
                        }
                        newJsonObject.put(fieldName, value);
                    } while (n < n2);
                }
                if (data.length() > 0) {
                    newJsonObject.put("data", (Object)data);
                }
            }
            catch (JSONException e) {
                throw new FacebookException("Failed to create json object from share content");
            }
            jSONObject = var2_2;
        }
        return jSONObject;
    }

    @JvmStatic
    @NotNull
    public static final Pair<String, String> getFieldNameAndNamespaceFromFullName(@NotNull String fullName) {
        Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
        String namespace = null;
        String fieldName = null;
        int index = StringsKt.indexOf$default((CharSequence)fullName, (char)':', (int)0, (boolean)false, (int)6, null);
        if (index != -1 && fullName.length() > index + 1) {
            String string2 = fullName;
            int n = 0;
            boolean bl = false;
            String string3 = string2.substring(n, index);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            namespace = string3;
            string2 = fullName;
            n = index + 1;
            bl = false;
            String string4 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            fieldName = string4;
        } else {
            fieldName = fullName;
        }
        return new Pair(namespace, (Object)fieldName);
    }

    private final NativeAppCallAttachmentStore.Attachment getAttachment(UUID callId, ShareMedia<?, ?> medium) {
        Bitmap bitmap = null;
        Uri uri = null;
        if (medium instanceof SharePhoto) {
            bitmap = ((SharePhoto)medium).getBitmap();
            uri = ((SharePhoto)medium).getImageUrl();
        } else if (medium instanceof ShareVideo) {
            uri = ((ShareVideo)medium).getLocalUrl();
        }
        return this.getAttachment(callId, uri, bitmap);
    }

    private final NativeAppCallAttachmentStore.Attachment getAttachment(UUID callId, Uri uri, Bitmap bitmap) {
        NativeAppCallAttachmentStore.Attachment attachment = null;
        if (bitmap != null) {
            attachment = NativeAppCallAttachmentStore.createAttachment((UUID)callId, (Bitmap)bitmap);
        } else if (uri != null) {
            attachment = NativeAppCallAttachmentStore.createAttachment((UUID)callId, (Uri)uri);
        }
        return attachment;
    }

    @JvmStatic
    public static final void invokeOnCancelCallback(@Nullable FacebookCallback<Sharer.Result> callback) {
        INSTANCE.logShareResult("cancelled", null);
        FacebookCallback<Sharer.Result> facebookCallback = callback;
        if (facebookCallback != null) {
            facebookCallback.onCancel();
        }
    }

    @JvmStatic
    public static final void invokeOnSuccessCallback(@Nullable FacebookCallback<Sharer.Result> callback, @Nullable String postId) {
        INSTANCE.logShareResult("succeeded", null);
        FacebookCallback<Sharer.Result> facebookCallback = callback;
        if (facebookCallback != null) {
            facebookCallback.onSuccess(new Sharer.Result(postId));
        }
    }

    @JvmStatic
    public static final void invokeOnErrorCallback(@Nullable FacebookCallback<Sharer.Result> callback, @Nullable GraphResponse response, @Nullable String message) {
        INSTANCE.logShareResult("error", message);
        FacebookCallback<Sharer.Result> facebookCallback = callback;
        if (facebookCallback != null) {
            facebookCallback.onError((FacebookException)new FacebookGraphResponseException(response, message));
        }
    }

    @JvmStatic
    public static final void invokeOnErrorCallback(@Nullable FacebookCallback<Sharer.Result> callback, @Nullable String message) {
        INSTANCE.logShareResult("error", message);
        FacebookCallback<Sharer.Result> facebookCallback = callback;
        if (facebookCallback != null) {
            facebookCallback.onError(new FacebookException(message));
        }
    }

    @JvmStatic
    public static final void invokeOnErrorCallback(@Nullable FacebookCallback<Sharer.Result> callback, @NotNull FacebookException ex) {
        Intrinsics.checkNotNullParameter((Object)((Object)ex), (String)"ex");
        INSTANCE.logShareResult("error", ex.getMessage());
        FacebookCallback<Sharer.Result> facebookCallback = callback;
        if (facebookCallback != null) {
            facebookCallback.onError(ex);
        }
    }

    private final void logShareResult(String shareOutcome, String errorMessage) {
        Context context = FacebookSdk.INSTANCE.getApplicationContext();
        InternalAppEventsLogger logger = new InternalAppEventsLogger(context);
        Bundle parameters = new Bundle();
        parameters.putString("fb_share_dialog_outcome", shareOutcome);
        if (errorMessage != null) {
            parameters.putString("error_message", errorMessage);
        }
        logger.logEventImplicitly("fb_share_dialog_result", parameters);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newUploadStagingResourceWithImageRequest(@Nullable AccessToken accessToken, @Nullable Bitmap image, @Nullable GraphRequest.Callback callback) {
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(STAGING_PARAM, (Parcelable)image);
        return new GraphRequest(accessToken, MY_STAGING_RESOURCES, parameters, HttpMethod.POST, callback, null, 32, null);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newUploadStagingResourceWithImageRequest(@Nullable AccessToken accessToken, @Nullable File file, @Nullable GraphRequest.Callback callback) throws FileNotFoundException {
        ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        GraphRequest.ParcelableResourceWithMimeType resourceWithMimeType = new GraphRequest.ParcelableResourceWithMimeType((Parcelable)descriptor, "image/png");
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(STAGING_PARAM, (Parcelable)resourceWithMimeType);
        return new GraphRequest(accessToken, MY_STAGING_RESOURCES, parameters, HttpMethod.POST, callback, null, 32, null);
    }

    @JvmStatic
    @NotNull
    public static final GraphRequest newUploadStagingResourceWithImageRequest(@Nullable AccessToken accessToken, @NotNull Uri imageUri, @Nullable GraphRequest.Callback callback) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        String imagePath = imageUri.getPath();
        if (Utility.isFileUri((Uri)imageUri) && imagePath != null) {
            return ShareInternalUtility.newUploadStagingResourceWithImageRequest(accessToken, new File(imagePath), callback);
        }
        if (!Utility.isContentUri((Uri)imageUri)) {
            throw new FacebookException("The image Uri must be either a file:// or content:// Uri");
        }
        GraphRequest.ParcelableResourceWithMimeType resourceWithMimeType = new GraphRequest.ParcelableResourceWithMimeType((Parcelable)imageUri, "image/png");
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(STAGING_PARAM, (Parcelable)resourceWithMimeType);
        return new GraphRequest(accessToken, MY_STAGING_RESOURCES, parameters, HttpMethod.POST, callback, null, 32, null);
    }

    @JvmStatic
    @Nullable
    public static final Bundle getStickerUrl(@Nullable ShareStoryContent storyContent, @NotNull UUID appCallId) {
        Intrinsics.checkNotNullParameter((Object)appCallId, (String)"appCallId");
        if (storyContent == null || storyContent.getStickerAsset() == null) {
            return null;
        }
        List photos = new ArrayList();
        photos.add(storyContent.getStickerAsset());
        NativeAppCallAttachmentStore.Attachment attachment = INSTANCE.getAttachment(appCallId, storyContent.getStickerAsset());
        if (attachment == null) {
            return null;
        }
        NativeAppCallAttachmentStore.Attachment attachment2 = attachment;
        Bundle stickerInfo = new Bundle();
        stickerInfo.putString("uri", attachment2.getAttachmentUrl());
        String extension = ShareInternalUtility.getUriExtension(attachment2.getOriginalUri());
        if (extension != null) {
            Utility.putNonEmptyString((Bundle)stickerInfo, (String)"extension", (String)extension);
        }
        NativeAppCallAttachmentStore.addAttachments((Collection)CollectionsKt.listOf((Object)attachment2));
        return stickerInfo;
    }

    @JvmStatic
    @Nullable
    public static final Bundle getBackgroundAssetMediaInfo(@Nullable ShareStoryContent storyContent, @NotNull UUID appCallId) {
        Intrinsics.checkNotNullParameter((Object)appCallId, (String)"appCallId");
        if (storyContent == null || storyContent.getBackgroundAsset() == null) {
            return null;
        }
        ShareMedia<?, ?> media = storyContent.getBackgroundAsset();
        NativeAppCallAttachmentStore.Attachment attachment = INSTANCE.getAttachment(appCallId, media);
        if (attachment == null) {
            return null;
        }
        NativeAppCallAttachmentStore.Attachment attachment2 = attachment;
        Bundle mediaInfo = new Bundle();
        mediaInfo.putString("type", media.getMediaType().name());
        mediaInfo.putString("uri", attachment2.getAttachmentUrl());
        String extension = ShareInternalUtility.getUriExtension(attachment2.getOriginalUri());
        if (extension != null) {
            Utility.putNonEmptyString((Bundle)mediaInfo, (String)"extension", (String)extension);
        }
        NativeAppCallAttachmentStore.addAttachments((Collection)CollectionsKt.listOf((Object)attachment2));
        return mediaInfo;
    }

    @JvmStatic
    @Nullable
    public static final String getUriExtension(@Nullable Uri uri) {
        String string2;
        if (uri == null) {
            return null;
        }
        String string3 = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"uri.toString()");
        String path = string3;
        int idx = StringsKt.lastIndexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (idx == -1) {
            string2 = null;
        } else {
            String string4 = path;
            boolean bl = false;
            String string5 = string4.substring(idx);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        }
        return string2;
    }

    private static final boolean registerStaticShareCallback$lambda-0(int $requestCode, int resultCode, Intent data) {
        return ShareInternalUtility.handleActivityResult($requestCode, resultCode, data, ShareInternalUtility.getShareResultProcessor(null));
    }

    private static final boolean registerSharerCallback$lambda-1(int $requestCode, FacebookCallback $callback, int resultCode, Intent data) {
        return ShareInternalUtility.handleActivityResult($requestCode, resultCode, data, ShareInternalUtility.getShareResultProcessor($callback));
    }
}

