/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.app.Activity;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.util.Pair;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import com.facebook.AccessToken;
import com.facebook.AuthenticationToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookActivity;
import com.facebook.FacebookAuthorizationException;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.LoginStatusCallback;
import com.facebook.Profile;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.CustomTabUtils;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.PlatformServiceClient;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.login.CodeChallengeMethod;
import com.facebook.login.CustomTabPrefetchHelper;
import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginConfiguration;
import com.facebook.login.LoginLogger;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginMethodHandler;
import com.facebook.login.LoginResult;
import com.facebook.login.LoginStatusClient;
import com.facebook.login.LoginTargetApp;
import com.facebook.login.PKCEUtil;
import com.facebook.login.StartActivityDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 y2\u00020\u0001:\u0006wxyz{|B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u001e\u001a\u00060\u001fR\u00020\u00002\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u0004H\u0007J\u0018\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&H\u0014J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020$H\u0014JH\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u00010$2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\r2\u000e\u00108\u001a\n\u0012\u0004\u0012\u00020:\u0018\u000109H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020$H\u0014JL\u0010>\u001a\u00020/2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020B2\u0014\u0010C\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010D2\b\u00105\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020\r2\b\u0010=\u001a\u0004\u0018\u00010$H\u0002J\u0016\u0010G\u001a\u00020/2\u0006\u0010H\u001a\u00020I2\u0006\u0010+\u001a\u00020,J\u001e\u0010G\u001a\u00020/2\u0006\u0010H\u001a\u00020I2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&J(\u0010G\u001a\u00020/2\u0006\u0010H\u001a\u00020I2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\b\u0010\"\u001a\u0004\u0018\u00010\u0004J\u001e\u0010G\u001a\u00020/2\u0006\u0010J\u001a\u00020K2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&J(\u0010G\u001a\u00020/2\u0006\u0010J\u001a\u00020K2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\b\u0010\"\u001a\u0004\u0018\u00010\u0004J \u0010G\u001a\u00020/2\u0006\u0010L\u001a\u00020M2\u0006\u0010 \u001a\u00020!2\u0006\u0010+\u001a\u00020,H\u0002J$\u0010G\u001a\u00020/2\u0006\u0010L\u001a\u00020M2\u0006\u0010 \u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&J.\u0010G\u001a\u00020/2\u0006\u0010L\u001a\u00020M2\u0006\u0010 \u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&2\b\u0010\"\u001a\u0004\u0018\u00010\u0004J\u001e\u0010G\u001a\u00020/2\u0006\u0010J\u001a\u00020N2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&J(\u0010G\u001a\u00020/2\u0006\u0010J\u001a\u00020N2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\b\u0010\"\u001a\u0004\u0018\u00010\u0004J\u0016\u0010G\u001a\u00020/2\u0006\u0010J\u001a\u00020O2\u0006\u0010+\u001a\u00020,J\u001e\u0010G\u001a\u00020/2\u0006\u0010J\u001a\u00020O2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&J(\u0010G\u001a\u00020/2\u0006\u0010J\u001a\u00020O2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\b\u0010\"\u001a\u0004\u0018\u00010\u0004J\u0016\u0010P\u001a\u00020/2\u0006\u0010J\u001a\u00020N2\u0006\u0010+\u001a\u00020,J\u001e\u0010Q\u001a\u00020/2\u0006\u0010H\u001a\u00020I2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&J\u001c\u0010Q\u001a\u00020/2\u0006\u0010J\u001a\u00020K2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&J$\u0010Q\u001a\u00020/2\u0006\u0010L\u001a\u00020M2\u0006\u0010 \u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&J$\u0010Q\u001a\u00020/2\u0006\u0010J\u001a\u00020N2\u0006\u0010 \u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&J\u001e\u0010Q\u001a\u00020/2\u0006\u0010J\u001a\u00020N2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&H\u0007J\u001e\u0010Q\u001a\u00020/2\u0006\u0010J\u001a\u00020O2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&H\u0002J\u001e\u0010R\u001a\u00020/2\u0006\u0010H\u001a\u00020I2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&J\u001c\u0010R\u001a\u00020/2\u0006\u0010J\u001a\u00020K2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&J$\u0010R\u001a\u00020/2\u0006\u0010L\u001a\u00020M2\u0006\u0010 \u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&J$\u0010R\u001a\u00020/2\u0006\u0010J\u001a\u00020N2\u0006\u0010 \u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&J\u001e\u0010R\u001a\u00020/2\u0006\u0010J\u001a\u00020N2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&H\u0007J\u001e\u0010R\u001a\u00020/2\u0006\u0010J\u001a\u00020O2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&H\u0002J\b\u0010S\u001a\u00020/H\u0016J\u001c\u0010T\u001a\u00020/2\b\u0010?\u001a\u0004\u0018\u00010@2\b\u0010U\u001a\u0004\u0018\u00010$H\u0002J\u0016\u0010V\u001a\u00020/2\u0006\u0010H\u001a\u00020I2\u0006\u0010+\u001a\u00020,J\u0018\u0010V\u001a\u00020/2\u0006\u0010J\u001a\u00020O2\u0006\u0010+\u001a\u00020,H\u0002J,\u0010W\u001a\u00020\r2\u0006\u0010X\u001a\u00020Y2\b\u0010Z\u001a\u0004\u0018\u00010<2\u0010\b\u0002\u00108\u001a\n\u0012\u0004\u0012\u00020:\u0018\u000109H\u0017J\u000e\u0010[\u001a\u00020/2\u0006\u0010H\u001a\u00020IJ\u000e\u0010[\u001a\u00020/2\u0006\u0010J\u001a\u00020NJ\u0010\u0010[\u001a\u00020/2\u0006\u0010J\u001a\u00020OH\u0002J \u0010\\\u001a\u00020/2\b\u0010 \u001a\u0004\u0018\u00010!2\u000e\u00108\u001a\n\u0012\u0004\u0012\u00020:\u0018\u000109J\u0016\u0010]\u001a\u00020/2\u0006\u0010H\u001a\u00020I2\u0006\u0010(\u001a\u00020)J\u0016\u0010]\u001a\u00020/2\u0006\u0010J\u001a\u00020K2\u0006\u0010(\u001a\u00020)J\u001e\u0010]\u001a\u00020/2\u0006\u0010L\u001a\u00020M2\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020)J\u001e\u0010]\u001a\u00020/2\u0006\u0010J\u001a\u00020N2\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020)J\u0018\u0010]\u001a\u00020/2\u0006\u0010J\u001a\u00020N2\u0006\u0010(\u001a\u00020)H\u0007J\u0018\u0010]\u001a\u00020/2\u0006\u0010J\u001a\u00020O2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010^\u001a\u00020\r2\u0006\u0010_\u001a\u00020<H\u0002J\u0016\u0010`\u001a\u00020/2\u0006\u0010?\u001a\u00020@2\u0006\u0010a\u001a\u00020bJ\u001e\u0010`\u001a\u00020/2\u0006\u0010?\u001a\u00020@2\u0006\u0010c\u001a\u00020d2\u0006\u0010a\u001a\u00020bJ \u0010e\u001a\u00020/2\u0006\u0010?\u001a\u00020@2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020dH\u0002J\u000e\u0010f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010g\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010h\u001a\u00020/2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010i\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010j\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010k\u001a\u00020\u00002\u0006\u0010l\u001a\u00020\u0014J\u0010\u0010m\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004J\u000e\u0010n\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010o\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\rJ\u0018\u0010p\u001a\u00020/2\u0006\u0010q\u001a\u00020r2\u0006\u0010=\u001a\u00020$H\u0002J\u0018\u0010s\u001a\u00020\r2\u0006\u0010q\u001a\u00020r2\u0006\u0010=\u001a\u00020$H\u0002J\u0010\u0010t\u001a\u00020/2\b\u0010 \u001a\u0004\u0018\u00010!J\u0018\u0010u\u001a\u00020/2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&H\u0002J\u0018\u0010v\u001a\u00020/2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&H\u0002R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000e\u00a8\u0006}"}, d2={"Lcom/facebook/login/LoginManager;", "", "()V", "<set-?>", "", "authType", "getAuthType", "()Ljava/lang/String;", "Lcom/facebook/login/DefaultAudience;", "defaultAudience", "getDefaultAudience", "()Lcom/facebook/login/DefaultAudience;", "isExpressLoginAllowed", "", "()Z", "isFamilyLogin", "Lcom/facebook/login/LoginBehavior;", "loginBehavior", "getLoginBehavior", "()Lcom/facebook/login/LoginBehavior;", "Lcom/facebook/login/LoginTargetApp;", "loginTargetApp", "getLoginTargetApp", "()Lcom/facebook/login/LoginTargetApp;", "messengerPageId", "resetMessengerState", "sharedPreferences", "Landroid/content/SharedPreferences;", "shouldSkipAccountDeduplication", "getShouldSkipAccountDeduplication", "createLogInActivityResultContract", "Lcom/facebook/login/LoginManager$FacebookLoginActivityResultContract;", "callbackManager", "Lcom/facebook/CallbackManager;", "loggerID", "createLoginRequest", "Lcom/facebook/login/LoginClient$Request;", "permissions", "", "createLoginRequestFromResponse", "response", "Lcom/facebook/GraphResponse;", "createLoginRequestWithConfig", "loginConfig", "Lcom/facebook/login/LoginConfiguration;", "createReauthorizeRequest", "finishLogin", "", "newToken", "Lcom/facebook/AccessToken;", "newIdToken", "Lcom/facebook/AuthenticationToken;", "origRequest", "exception", "Lcom/facebook/FacebookException;", "isCanceled", "callback", "Lcom/facebook/FacebookCallback;", "Lcom/facebook/login/LoginResult;", "getFacebookActivityIntent", "Landroid/content/Intent;", "request", "logCompleteLogin", "context", "Landroid/content/Context;", "result", "Lcom/facebook/login/LoginClient$Result$Code;", "resultExtras", "", "Ljava/lang/Exception;", "wasLoginActivityTried", "logIn", "activity", "Landroid/app/Activity;", "fragment", "Landroid/app/Fragment;", "activityResultRegistryOwner", "Landroidx/activity/result/ActivityResultRegistryOwner;", "Landroidx/fragment/app/Fragment;", "Lcom/facebook/internal/FragmentWrapper;", "logInWithConfiguration", "logInWithPublishPermissions", "logInWithReadPermissions", "logOut", "logStartLogin", "loginRequest", "loginWithConfiguration", "onActivityResult", "resultCode", "", "data", "reauthorizeDataAccess", "registerCallback", "resolveError", "resolveIntent", "intent", "retrieveLoginStatus", "responseCallback", "Lcom/facebook/LoginStatusCallback;", "toastDurationMs", "", "retrieveLoginStatusImpl", "setAuthType", "setDefaultAudience", "setExpressLoginStatus", "setFamilyLogin", "setLoginBehavior", "setLoginTargetApp", "targetApp", "setMessengerPageId", "setResetMessengerState", "setShouldSkipAccountDeduplication", "startLogin", "startActivityDelegate", "Lcom/facebook/login/StartActivityDelegate;", "tryFacebookActivity", "unregisterCallback", "validatePublishPermissions", "validateReadPermissions", "ActivityStartActivityDelegate", "AndroidxActivityResultRegistryOwnerStartActivityDelegate", "Companion", "FacebookLoginActivityResultContract", "FragmentStartActivityDelegate", "LoginLoggerHolder", "facebook-common_release"})
public class LoginManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LoginBehavior loginBehavior = LoginBehavior.NATIVE_WITH_FALLBACK;
    @NotNull
    private DefaultAudience defaultAudience = DefaultAudience.FRIENDS;
    @NotNull
    private final SharedPreferences sharedPreferences;
    @NotNull
    private String authType = "rerequest";
    @Nullable
    private String messengerPageId;
    private boolean resetMessengerState;
    @NotNull
    private LoginTargetApp loginTargetApp = LoginTargetApp.FACEBOOK;
    private boolean isFamilyLogin;
    private boolean shouldSkipAccountDeduplication;
    @NotNull
    private static final String PUBLISH_PERMISSION_PREFIX = "publish";
    @NotNull
    private static final String MANAGE_PERMISSION_PREFIX = "manage";
    @NotNull
    private static final String EXPRESS_LOGIN_ALLOWED = "express_login_allowed";
    @NotNull
    private static final String PREFERENCE_LOGIN_MANAGER = "com.facebook.loginManager";
    @NotNull
    private static final Set<String> OTHER_PUBLISH_PERMISSIONS = com.facebook.login.LoginManager$Companion.access$getOtherPublishPermissions(Companion);
    @NotNull
    private static final String TAG;
    private static volatile LoginManager instance;

    public LoginManager() {
        Validate.sdkInitialized();
        SharedPreferences sharedPreferences = FacebookSdk.getApplicationContext().getSharedPreferences(PREFERENCE_LOGIN_MANAGER, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getApplicationContext().\u2026ER, Context.MODE_PRIVATE)");
        this.sharedPreferences = sharedPreferences;
        if (FacebookSdk.hasCustomTabsPrefetching && CustomTabUtils.getChromePackage() != null) {
            CustomTabPrefetchHelper prefetchHelper = new CustomTabPrefetchHelper();
            CustomTabsClient.bindCustomTabsService((Context)FacebookSdk.getApplicationContext(), (String)"com.android.chrome", (CustomTabsServiceConnection)prefetchHelper);
            CustomTabsClient.connectAndInitialize((Context)FacebookSdk.getApplicationContext(), (String)FacebookSdk.getApplicationContext().getPackageName());
        }
    }

    @NotNull
    public final LoginBehavior getLoginBehavior() {
        return this.loginBehavior;
    }

    @NotNull
    public final DefaultAudience getDefaultAudience() {
        return this.defaultAudience;
    }

    @NotNull
    public final String getAuthType() {
        return this.authType;
    }

    @NotNull
    public final LoginTargetApp getLoginTargetApp() {
        return this.loginTargetApp;
    }

    public final boolean isFamilyLogin() {
        return this.isFamilyLogin;
    }

    public final boolean getShouldSkipAccountDeduplication() {
        return this.shouldSkipAccountDeduplication;
    }

    public final void resolveError(@NotNull Activity activity, @NotNull GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.startLogin(new ActivityStartActivityDelegate(activity), this.createLoginRequestFromResponse(response));
    }

    @Deprecated(message="")
    public final void resolveError(@NotNull androidx.fragment.app.Fragment fragment, @NotNull GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.resolveError(new FragmentWrapper(fragment), response);
    }

    public final void resolveError(@NotNull androidx.fragment.app.Fragment fragment, @NotNull CallbackManager callbackManager, @NotNull GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ComponentActivity activity = (ComponentActivity)fragment.getActivity();
        if (activity == null) {
            throw new FacebookException("Cannot obtain activity context on the fragment " + fragment);
        }
        this.resolveError((ActivityResultRegistryOwner)activity, callbackManager, response);
    }

    public final void resolveError(@NotNull Fragment fragment, @NotNull GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.resolveError(new FragmentWrapper(fragment), response);
    }

    private final void resolveError(FragmentWrapper fragment, GraphResponse response) {
        this.startLogin(new FragmentStartActivityDelegate(fragment), this.createLoginRequestFromResponse(response));
    }

    public final void resolveError(@NotNull ActivityResultRegistryOwner activityResultRegistryOwner, @NotNull CallbackManager callbackManager, @NotNull GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)activityResultRegistryOwner, (String)"activityResultRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.startLogin(new AndroidxActivityResultRegistryOwnerStartActivityDelegate(activityResultRegistryOwner, callbackManager), this.createLoginRequestFromResponse(response));
    }

    private final LoginClient.Request createLoginRequestFromResponse(GraphResponse response) {
        AccessToken failedToken = response.getRequest().getAccessToken();
        Object object = failedToken;
        return this.createLoginRequest(object != null && (object = object.getPermissions()) != null ? CollectionsKt.filterNotNull((Iterable)((Iterable)object)) : null);
    }

    public final void registerCallback(@Nullable CallbackManager callbackManager, @Nullable FacebookCallback<LoginResult> callback) {
        if (!(callbackManager instanceof CallbackManagerImpl)) {
            throw new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
        }
        ((CallbackManagerImpl)callbackManager).registerCallback(CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode(), (arg_0, arg_1) -> LoginManager.registerCallback$lambda$0(this, callback, arg_0, arg_1));
    }

    public final void unregisterCallback(@Nullable CallbackManager callbackManager) {
        if (!(callbackManager instanceof CallbackManagerImpl)) {
            throw new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
        }
        ((CallbackManagerImpl)callbackManager).unregisterCallback(CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode());
    }

    @VisibleForTesting(otherwise=3)
    @JvmOverloads
    public boolean onActivityResult(int resultCode, @Nullable Intent data, @Nullable FacebookCallback<LoginResult> callback) {
        FacebookException exception = null;
        AccessToken accessToken = null;
        AuthenticationToken authenticationToken = null;
        LoginClient.Result.Code code = LoginClient.Result.Code.ERROR;
        Map<String, String> loggingExtras = null;
        LoginClient.Request originalRequest = null;
        boolean isCanceled = false;
        if (data != null) {
            data.setExtrasClassLoader(LoginClient.Result.class.getClassLoader());
            LoginClient.Result result = (LoginClient.Result)data.getParcelableExtra("com.facebook.LoginFragment:Result");
            if (result != null) {
                originalRequest = result.request;
                code = result.code;
                switch (resultCode) {
                    case -1: {
                        if (result.code == LoginClient.Result.Code.SUCCESS) {
                            accessToken = result.token;
                            authenticationToken = result.authenticationToken;
                            break;
                        }
                        exception = new FacebookAuthorizationException(result.errorMessage);
                        break;
                    }
                    case 0: {
                        isCanceled = true;
                    }
                }
                loggingExtras = result.loggingExtras;
            }
        } else if (resultCode == 0) {
            isCanceled = true;
            code = LoginClient.Result.Code.CANCEL;
        }
        if (exception == null && accessToken == null && !isCanceled) {
            exception = new FacebookException("Unexpected call to LoginManager.onActivityResult");
        }
        boolean wasLoginActivityTried = true;
        Context context = null;
        this.logCompleteLogin(context, code, loggingExtras, (Exception)((Object)exception), wasLoginActivityTried, originalRequest);
        this.finishLogin(accessToken, authenticationToken, originalRequest, exception, isCanceled, callback);
        return true;
    }

    public static /* synthetic */ boolean onActivityResult$default(LoginManager loginManager, int n, Intent intent, FacebookCallback facebookCallback, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onActivityResult");
        }
        if ((n2 & 4) != 0) {
            facebookCallback = null;
        }
        return loginManager.onActivityResult(n, intent, facebookCallback);
    }

    @NotNull
    public final LoginManager setLoginBehavior(@NotNull LoginBehavior loginBehavior) {
        Intrinsics.checkNotNullParameter((Object)((Object)loginBehavior), (String)"loginBehavior");
        this.loginBehavior = loginBehavior;
        return this;
    }

    @NotNull
    public final LoginManager setLoginTargetApp(@NotNull LoginTargetApp targetApp) {
        Intrinsics.checkNotNullParameter((Object)targetApp, (String)"targetApp");
        this.loginTargetApp = targetApp;
        return this;
    }

    @NotNull
    public final LoginManager setDefaultAudience(@NotNull DefaultAudience defaultAudience) {
        Intrinsics.checkNotNullParameter((Object)defaultAudience, (String)"defaultAudience");
        this.defaultAudience = defaultAudience;
        return this;
    }

    @NotNull
    public final LoginManager setAuthType(@NotNull String authType) {
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        this.authType = authType;
        return this;
    }

    @NotNull
    public final LoginManager setMessengerPageId(@Nullable String messengerPageId) {
        this.messengerPageId = messengerPageId;
        return this;
    }

    @NotNull
    public final LoginManager setResetMessengerState(boolean resetMessengerState) {
        this.resetMessengerState = resetMessengerState;
        return this;
    }

    @NotNull
    public final LoginManager setFamilyLogin(boolean isFamilyLogin) {
        this.isFamilyLogin = isFamilyLogin;
        return this;
    }

    @NotNull
    public final LoginManager setShouldSkipAccountDeduplication(boolean shouldSkipAccountDeduplication) {
        this.shouldSkipAccountDeduplication = shouldSkipAccountDeduplication;
        return this;
    }

    public void logOut() {
        AccessToken.Companion.setCurrentAccessToken(null);
        AuthenticationToken.Companion.setCurrentAuthenticationToken(null);
        Profile.Companion.setCurrentProfile(null);
        this.setExpressLoginStatus(false);
    }

    public final void retrieveLoginStatus(@NotNull Context context, @NotNull LoginStatusCallback responseCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)responseCallback, (String)"responseCallback");
        this.retrieveLoginStatus(context, 5000L, responseCallback);
    }

    public final void retrieveLoginStatus(@NotNull Context context, long toastDurationMs, @NotNull LoginStatusCallback responseCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)responseCallback, (String)"responseCallback");
        this.retrieveLoginStatusImpl(context, responseCallback, toastDurationMs);
    }

    @Deprecated(message="")
    public final void logInWithReadPermissions(@NotNull androidx.fragment.app.Fragment fragment, @NotNull Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.logInWithReadPermissions(new FragmentWrapper(fragment), permissions);
    }

    public final void logInWithReadPermissions(@NotNull androidx.fragment.app.Fragment fragment, @NotNull CallbackManager callbackManager, @NotNull Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        ComponentActivity activity = (ComponentActivity)fragment.getActivity();
        if (activity == null) {
            throw new FacebookException("Cannot obtain activity context on the fragment " + fragment);
        }
        this.logInWithReadPermissions((ActivityResultRegistryOwner)activity, callbackManager, permissions);
    }

    public final void logInWithReadPermissions(@NotNull Fragment fragment, @NotNull Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.logInWithReadPermissions(new FragmentWrapper(fragment), permissions);
    }

    private final void logInWithReadPermissions(FragmentWrapper fragment, Collection<String> permissions) {
        this.validateReadPermissions(permissions);
        LoginConfiguration loginConfig = new LoginConfiguration(permissions, null, 2, null);
        this.logIn(fragment, loginConfig);
    }

    public final void logInWithReadPermissions(@NotNull Activity activity, @Nullable Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.validateReadPermissions(permissions);
        LoginConfiguration loginConfig = new LoginConfiguration(permissions, null, 2, null);
        this.logIn(activity, loginConfig);
    }

    public final void logInWithReadPermissions(@NotNull ActivityResultRegistryOwner activityResultRegistryOwner, @NotNull CallbackManager callbackManager, @NotNull Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)activityResultRegistryOwner, (String)"activityResultRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.validateReadPermissions(permissions);
        LoginConfiguration loginConfig = new LoginConfiguration(permissions, null, 2, null);
        this.logIn(activityResultRegistryOwner, callbackManager, loginConfig);
    }

    public final void logInWithConfiguration(@NotNull androidx.fragment.app.Fragment fragment, @NotNull LoginConfiguration loginConfig) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)loginConfig, (String)"loginConfig");
        this.loginWithConfiguration(new FragmentWrapper(fragment), loginConfig);
    }

    private final void loginWithConfiguration(FragmentWrapper fragment, LoginConfiguration loginConfig) {
        this.logIn(fragment, loginConfig);
    }

    public final void loginWithConfiguration(@NotNull Activity activity, @NotNull LoginConfiguration loginConfig) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)loginConfig, (String)"loginConfig");
        this.logIn(activity, loginConfig);
    }

    public final void reauthorizeDataAccess(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        LoginClient.Request loginRequest = this.createReauthorizeRequest();
        this.startLogin(new ActivityStartActivityDelegate(activity), loginRequest);
    }

    public final void reauthorizeDataAccess(@NotNull androidx.fragment.app.Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.reauthorizeDataAccess(new FragmentWrapper(fragment));
    }

    private final void reauthorizeDataAccess(FragmentWrapper fragment) {
        LoginClient.Request loginRequest = this.createReauthorizeRequest();
        this.startLogin(new FragmentStartActivityDelegate(fragment), loginRequest);
    }

    @Deprecated(message="")
    public final void logInWithPublishPermissions(@NotNull androidx.fragment.app.Fragment fragment, @NotNull Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.logInWithPublishPermissions(new FragmentWrapper(fragment), permissions);
    }

    public final void logInWithPublishPermissions(@NotNull androidx.fragment.app.Fragment fragment, @NotNull CallbackManager callbackManager, @NotNull Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        ComponentActivity activity = (ComponentActivity)fragment.getActivity();
        if (activity == null) {
            throw new FacebookException("Cannot obtain activity context on the fragment " + fragment);
        }
        this.logInWithPublishPermissions((ActivityResultRegistryOwner)activity, callbackManager, permissions);
    }

    public final void logInWithPublishPermissions(@NotNull Fragment fragment, @NotNull Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.logInWithPublishPermissions(new FragmentWrapper(fragment), permissions);
    }

    private final void logInWithPublishPermissions(FragmentWrapper fragment, Collection<String> permissions) {
        this.validatePublishPermissions(permissions);
        LoginConfiguration loginConfig = new LoginConfiguration(permissions, null, 2, null);
        this.loginWithConfiguration(fragment, loginConfig);
    }

    public final void logInWithPublishPermissions(@NotNull Activity activity, @Nullable Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.validatePublishPermissions(permissions);
        LoginConfiguration loginConfig = new LoginConfiguration(permissions, null, 2, null);
        this.loginWithConfiguration(activity, loginConfig);
    }

    public final void logInWithPublishPermissions(@NotNull ActivityResultRegistryOwner activityResultRegistryOwner, @NotNull CallbackManager callbackManager, @NotNull Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)activityResultRegistryOwner, (String)"activityResultRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.validatePublishPermissions(permissions);
        LoginConfiguration loginConfig = new LoginConfiguration(permissions, null, 2, null);
        this.logIn(activityResultRegistryOwner, callbackManager, loginConfig);
    }

    public final void logIn(@NotNull androidx.fragment.app.Fragment fragment, @Nullable Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.logIn(new FragmentWrapper(fragment), permissions);
    }

    public final void logIn(@NotNull androidx.fragment.app.Fragment fragment, @Nullable Collection<String> permissions, @Nullable String loggerID) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.logIn(new FragmentWrapper(fragment), permissions, loggerID);
    }

    public final void logIn(@NotNull Fragment fragment, @Nullable Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.logIn(new FragmentWrapper(fragment), permissions);
    }

    public final void logIn(@NotNull Fragment fragment, @Nullable Collection<String> permissions, @Nullable String loggerID) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.logIn(new FragmentWrapper(fragment), permissions, loggerID);
    }

    public final void logIn(@NotNull FragmentWrapper fragment, @Nullable Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        LoginConfiguration loginConfig = new LoginConfiguration(permissions, null, 2, null);
        this.logIn(fragment, loginConfig);
    }

    public final void logIn(@NotNull FragmentWrapper fragment, @Nullable Collection<String> permissions, @Nullable String loggerID) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        LoginConfiguration loginConfig = new LoginConfiguration(permissions, null, 2, null);
        LoginClient.Request loginRequest = this.createLoginRequestWithConfig(loginConfig);
        if (loggerID != null) {
            loginRequest.setAuthId(loggerID);
        }
        this.startLogin(new FragmentStartActivityDelegate(fragment), loginRequest);
    }

    public final void logIn(@NotNull Activity activity, @Nullable Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        LoginConfiguration loginConfig = new LoginConfiguration(permissions, null, 2, null);
        this.logIn(activity, loginConfig);
    }

    public final void logIn(@NotNull FragmentWrapper fragment, @NotNull LoginConfiguration loginConfig) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)loginConfig, (String)"loginConfig");
        LoginClient.Request loginRequest = this.createLoginRequestWithConfig(loginConfig);
        this.startLogin(new FragmentStartActivityDelegate(fragment), loginRequest);
    }

    public final void logIn(@NotNull Activity activity, @NotNull LoginConfiguration loginConfig) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)loginConfig, (String)"loginConfig");
        if (activity instanceof ActivityResultRegistryOwner) {
            Log.w((String)TAG, (String)"You're calling logging in Facebook with an activity supports androidx activity result APIs. Please follow our document to upgrade to new APIs to avoid overriding onActivityResult().");
        }
        LoginClient.Request loginRequest = this.createLoginRequestWithConfig(loginConfig);
        this.startLogin(new ActivityStartActivityDelegate(activity), loginRequest);
    }

    public final void logIn(@NotNull Activity activity, @Nullable Collection<String> permissions, @Nullable String loggerID) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        LoginConfiguration loginConfig = new LoginConfiguration(permissions, null, 2, null);
        LoginClient.Request loginRequest = this.createLoginRequestWithConfig(loginConfig);
        if (loggerID != null) {
            loginRequest.setAuthId(loggerID);
        }
        this.startLogin(new ActivityStartActivityDelegate(activity), loginRequest);
    }

    private final void logIn(ActivityResultRegistryOwner activityResultRegistryOwner, CallbackManager callbackManager, LoginConfiguration loginConfig) {
        LoginClient.Request loginRequest = this.createLoginRequestWithConfig(loginConfig);
        this.startLogin(new AndroidxActivityResultRegistryOwnerStartActivityDelegate(activityResultRegistryOwner, callbackManager), loginRequest);
    }

    public final void logIn(@NotNull ActivityResultRegistryOwner activityResultRegistryOwner, @NotNull CallbackManager callbackManager, @NotNull Collection<String> permissions, @Nullable String loggerID) {
        Intrinsics.checkNotNullParameter((Object)activityResultRegistryOwner, (String)"activityResultRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        LoginConfiguration loginConfig = new LoginConfiguration(permissions, null, 2, null);
        LoginClient.Request loginRequest = this.createLoginRequestWithConfig(loginConfig);
        if (loggerID != null) {
            loginRequest.setAuthId(loggerID);
        }
        this.startLogin(new AndroidxActivityResultRegistryOwnerStartActivityDelegate(activityResultRegistryOwner, callbackManager), loginRequest);
    }

    public final void logIn(@NotNull ActivityResultRegistryOwner activityResultRegistryOwner, @NotNull CallbackManager callbackManager, @NotNull Collection<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)activityResultRegistryOwner, (String)"activityResultRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        LoginConfiguration loginConfig = new LoginConfiguration(permissions, null, 2, null);
        this.logIn(activityResultRegistryOwner, callbackManager, loginConfig);
    }

    @JvmOverloads
    @NotNull
    public final FacebookLoginActivityResultContract createLogInActivityResultContract(@Nullable CallbackManager callbackManager, @Nullable String loggerID) {
        return new FacebookLoginActivityResultContract(this, callbackManager, loggerID);
    }

    public static /* synthetic */ FacebookLoginActivityResultContract createLogInActivityResultContract$default(LoginManager loginManager, CallbackManager callbackManager, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createLogInActivityResultContract");
        }
        if ((n & 1) != 0) {
            callbackManager = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return loginManager.createLogInActivityResultContract(callbackManager, string2);
    }

    private final void validateReadPermissions(Collection<String> permissions) {
        if (permissions == null) {
            return;
        }
        for (String permission : permissions) {
            if (!Companion.isPublishPermission(permission)) continue;
            throw new FacebookException("Cannot pass a publish or manage permission (" + permission + ") to a request for read authorization");
        }
    }

    private final void validatePublishPermissions(Collection<String> permissions) {
        if (permissions == null) {
            return;
        }
        for (String permission : permissions) {
            if (Companion.isPublishPermission(permission)) continue;
            throw new FacebookException("Cannot pass a read permission (" + permission + ") to a request for publish authorization");
        }
    }

    @NotNull
    protected LoginClient.Request createLoginRequestWithConfig(@NotNull LoginConfiguration loginConfig) {
        Intrinsics.checkNotNullParameter((Object)loginConfig, (String)"loginConfig");
        String codeChallenge = null;
        CodeChallengeMethod codeChallengeMethod = CodeChallengeMethod.S256;
        try {
            codeChallenge = PKCEUtil.generateCodeChallenge(loginConfig.getCodeVerifier(), codeChallengeMethod);
        }
        catch (FacebookException _ex) {
            codeChallengeMethod = CodeChallengeMethod.PLAIN;
            codeChallenge = loginConfig.getCodeVerifier();
        }
        Set set = CollectionsKt.toSet((Iterable)loginConfig.getPermissions());
        String string2 = FacebookSdk.getApplicationId();
        String string3 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"randomUUID().toString()");
        LoginClient.Request request = new LoginClient.Request(this.loginBehavior, set, this.defaultAudience, this.authType, string2, string3, this.loginTargetApp, loginConfig.getNonce(), loginConfig.getCodeVerifier(), codeChallenge, codeChallengeMethod);
        request.setRerequest(AccessToken.Companion.isCurrentAccessTokenActive());
        request.setMessengerPageId(this.messengerPageId);
        request.setResetMessengerState(this.resetMessengerState);
        request.setFamilyLogin(this.isFamilyLogin);
        request.setShouldSkipAccountDeduplication(this.shouldSkipAccountDeduplication);
        return request;
    }

    @NotNull
    protected LoginClient.Request createLoginRequest(@Nullable Collection<String> permissions) {
        Collection<String> collection = permissions;
        Set set = collection != null ? CollectionsKt.toSet((Iterable)collection) : null;
        String string2 = FacebookSdk.getApplicationId();
        String string3 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"randomUUID().toString()");
        LoginClient.Request request = new LoginClient.Request(this.loginBehavior, set, this.defaultAudience, this.authType, string2, string3, this.loginTargetApp, null, null, null, null, 1920, null);
        request.setRerequest(AccessToken.Companion.isCurrentAccessTokenActive());
        request.setMessengerPageId(this.messengerPageId);
        request.setResetMessengerState(this.resetMessengerState);
        request.setFamilyLogin(this.isFamilyLogin);
        request.setShouldSkipAccountDeduplication(this.shouldSkipAccountDeduplication);
        return request;
    }

    @NotNull
    protected LoginClient.Request createReauthorizeRequest() {
        Set set = new HashSet();
        String string2 = FacebookSdk.getApplicationId();
        String string3 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"randomUUID().toString()");
        LoginClient.Request request = new LoginClient.Request(LoginBehavior.DIALOG_ONLY, set, this.defaultAudience, "reauthorize", string2, string3, this.loginTargetApp, null, null, null, null, 1920, null);
        request.setFamilyLogin(this.isFamilyLogin);
        request.setShouldSkipAccountDeduplication(this.shouldSkipAccountDeduplication);
        return request;
    }

    private final void startLogin(StartActivityDelegate startActivityDelegate, LoginClient.Request request) throws FacebookException {
        this.logStartLogin((Context)startActivityDelegate.getActivityContext(), request);
        CallbackManagerImpl.Companion.registerStaticCallback(CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode(), (arg_0, arg_1) -> LoginManager.startLogin$lambda$1(this, arg_0, arg_1));
        boolean started = this.tryFacebookActivity(startActivityDelegate, request);
        if (!started) {
            FacebookException exception = new FacebookException("Log in attempt failed: FacebookActivity could not be started. Please make sure you added FacebookActivity to the AndroidManifest.");
            boolean wasLoginActivityTried = false;
            this.logCompleteLogin((Context)startActivityDelegate.getActivityContext(), LoginClient.Result.Code.ERROR, null, (Exception)((Object)exception), wasLoginActivityTried, request);
            throw exception;
        }
    }

    private final void logStartLogin(Context context, LoginClient.Request loginRequest) {
        LoginLogger loginLogger = LoginLoggerHolder.INSTANCE.getLogger(context);
        if (loginLogger != null && loginRequest != null) {
            loginLogger.logStartLogin(loginRequest, loginRequest.isFamilyLogin() ? "foa_mobile_login_start" : "fb_mobile_login_start");
        }
    }

    private final void logCompleteLogin(Context context, LoginClient.Result.Code result, Map<String, String> resultExtras, Exception exception, boolean wasLoginActivityTried, LoginClient.Request request) {
        LoginLogger loginLogger = LoginLoggerHolder.INSTANCE.getLogger(context);
        if (loginLogger == null) {
            return;
        }
        LoginLogger loginLogger2 = loginLogger;
        if (request == null) {
            LoginLogger.logUnexpectedError$default(loginLogger2, "fb_mobile_login_complete", "Unexpected call to logCompleteLogin with null pendingAuthorizationRequest.", null, 4, null);
        } else {
            HashMap pendingLoggingExtras = new HashMap();
            ((Map)pendingLoggingExtras).put("try_login_activity", wasLoginActivityTried ? "1" : "0");
            loginLogger2.logCompleteLogin(request.getAuthId(), pendingLoggingExtras, result, resultExtras, exception, request.isFamilyLogin() ? "foa_mobile_login_complete" : "fb_mobile_login_complete");
        }
    }

    private final boolean tryFacebookActivity(StartActivityDelegate startActivityDelegate, LoginClient.Request request) {
        Intent intent = this.getFacebookActivityIntent(request);
        if (!this.resolveIntent(intent)) {
            return false;
        }
        try {
            startActivityDelegate.startActivityForResult(intent, LoginClient.Companion.getLoginRequestCode());
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    private final boolean resolveIntent(Intent intent) {
        ResolveInfo resolveInfo = FacebookSdk.getApplicationContext().getPackageManager().resolveActivity(intent, 0);
        return resolveInfo != null;
    }

    @NotNull
    protected Intent getFacebookActivityIntent(@NotNull LoginClient.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intent intent = new Intent();
        intent.setClass(FacebookSdk.getApplicationContext(), FacebookActivity.class);
        intent.setAction(request.getLoginBehavior().toString());
        Bundle extras = new Bundle();
        extras.putParcelable("request", (Parcelable)request);
        intent.putExtra("com.facebook.LoginFragment:Request", extras);
        return intent;
    }

    private final void finishLogin(AccessToken newToken, AuthenticationToken newIdToken, LoginClient.Request origRequest, FacebookException exception, boolean isCanceled, FacebookCallback<LoginResult> callback) {
        if (newToken != null) {
            AccessToken.Companion.setCurrentAccessToken(newToken);
            Profile.Companion.fetchProfileForCurrentAccessToken();
        }
        if (newIdToken != null) {
            AuthenticationToken.Companion.setCurrentAuthenticationToken(newIdToken);
        }
        if (callback != null) {
            LoginResult loginResult;
            LoginResult loginResult2 = loginResult = newToken != null && origRequest != null ? Companion.computeLoginResult(origRequest, newToken, newIdToken) : null;
            if (isCanceled || loginResult != null && loginResult.getRecentlyGrantedPermissions().isEmpty()) {
                callback.onCancel();
            } else if (exception != null) {
                callback.onError(exception);
            } else if (newToken != null && loginResult != null) {
                this.setExpressLoginStatus(true);
                callback.onSuccess(loginResult);
            }
        }
    }

    private final void retrieveLoginStatusImpl(Context context, LoginStatusCallback responseCallback, long toastDurationMs) {
        String applicationId = FacebookSdk.getApplicationId();
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
        String loggerRef = string2;
        Context context2 = context;
        if (context2 == null) {
            context2 = FacebookSdk.getApplicationContext();
        }
        LoginLogger logger = new LoginLogger(context2, applicationId);
        if (!this.isExpressLoginAllowed()) {
            logger.logLoginStatusFailure(loggerRef);
            responseCallback.onFailure();
            return;
        }
        LoginStatusClient client = LoginStatusClient.Companion.newInstance$facebook_common_release(context, applicationId, loggerRef, FacebookSdk.getGraphApiVersion(), toastDurationMs, null);
        PlatformServiceClient.CompletedListener callback = arg_0 -> LoginManager.retrieveLoginStatusImpl$lambda$2(loggerRef, logger, responseCallback, applicationId, arg_0);
        client.setCompletedListener(callback);
        logger.logLoginStatusStart(loggerRef);
        if (!client.start()) {
            logger.logLoginStatusFailure(loggerRef);
            responseCallback.onFailure();
        }
    }

    private final void setExpressLoginStatus(boolean isExpressLoginAllowed) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putBoolean(EXPRESS_LOGIN_ALLOWED, isExpressLoginAllowed);
        editor.apply();
    }

    private final boolean isExpressLoginAllowed() {
        return this.sharedPreferences.getBoolean(EXPRESS_LOGIN_ALLOWED, true);
    }

    @VisibleForTesting(otherwise=3)
    @JvmOverloads
    public final boolean onActivityResult(int resultCode, @Nullable Intent data) {
        return LoginManager.onActivityResult$default(this, resultCode, data, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final FacebookLoginActivityResultContract createLogInActivityResultContract(@Nullable CallbackManager callbackManager) {
        return LoginManager.createLogInActivityResultContract$default(this, callbackManager, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final FacebookLoginActivityResultContract createLogInActivityResultContract() {
        return LoginManager.createLogInActivityResultContract$default(this, null, null, 3, null);
    }

    private static final boolean registerCallback$lambda$0(LoginManager this$0, FacebookCallback $callback, int resultCode, Intent data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.onActivityResult(resultCode, data, $callback);
    }

    private static final boolean startLogin$lambda$1(LoginManager this$0, int resultCode, Intent data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return LoginManager.onActivityResult$default(this$0, resultCode, data, null, 4, null);
    }

    private static final void retrieveLoginStatusImpl$lambda$2(String $loggerRef, LoginLogger $logger, LoginStatusCallback $responseCallback, String $applicationId, Bundle result) {
        Intrinsics.checkNotNullParameter((Object)$loggerRef, (String)"$loggerRef");
        Intrinsics.checkNotNullParameter((Object)$logger, (String)"$logger");
        Intrinsics.checkNotNullParameter((Object)$responseCallback, (String)"$responseCallback");
        Intrinsics.checkNotNullParameter((Object)$applicationId, (String)"$applicationId");
        if (result != null) {
            String errorType = result.getString("com.facebook.platform.status.ERROR_TYPE");
            String errorDescription = result.getString("com.facebook.platform.status.ERROR_DESCRIPTION");
            if (errorType != null) {
                LoginManager.Companion.handleLoginStatusError(errorType, errorDescription, $loggerRef, $logger, $responseCallback);
            } else {
                String token = result.getString("com.facebook.platform.extra.ACCESS_TOKEN");
                Date expires = Utility.getBundleLongAsDate((Bundle)result, (String)"com.facebook.platform.extra.EXPIRES_SECONDS_SINCE_EPOCH", (Date)new Date(0L));
                ArrayList permissions = result.getStringArrayList("com.facebook.platform.extra.PERMISSIONS");
                String signedRequest = result.getString("signed request");
                String graphDomain = result.getString("graph_domain");
                Date dataAccessExpirationTime = Utility.getBundleLongAsDate((Bundle)result, (String)"com.facebook.platform.extra.EXTRA_DATA_ACCESS_EXPIRATION_TIME", (Date)new Date(0L));
                String userId = null;
                Object object = signedRequest;
                if (!(object == null || object.length() == 0)) {
                    userId = LoginMethodHandler.Companion.getUserIDFromSignedRequest(signedRequest);
                }
                if (!((object = (CharSequence)token) == null || object.length() == 0 || (object = (Collection)permissions) == null || object.isEmpty() || (object = (CharSequence)userId) == null || object.length() == 0)) {
                    AccessToken accessToken = new AccessToken(token, $applicationId, userId, (Collection)permissions, null, null, null, expires, null, dataAccessExpirationTime, graphDomain);
                    AccessToken.Companion.setCurrentAccessToken(accessToken);
                    Profile.Companion.fetchProfileForCurrentAccessToken();
                    $logger.logLoginStatusSuccess($loggerRef);
                    $responseCallback.onCompleted(accessToken);
                } else {
                    $logger.logLoginStatusFailure($loggerRef);
                    $responseCallback.onFailure();
                }
            }
        } else {
            $logger.logLoginStatusFailure($loggerRef);
            $responseCallback.onFailure();
        }
    }

    @JvmStatic
    @NotNull
    public static LoginManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static final Map<String, String> getExtraDataFromIntent(@Nullable Intent intent) {
        return Companion.getExtraDataFromIntent(intent);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final boolean isPublishPermission(@Nullable String permission) {
        return Companion.isPublishPermission(permission);
    }

    @JvmStatic
    @VisibleForTesting(otherwise=2)
    @NotNull
    public static final LoginResult computeLoginResult(@NotNull LoginClient.Request request, @NotNull AccessToken newToken, @Nullable AuthenticationToken newIdToken) {
        return Companion.computeLoginResult(request, newToken, newIdToken);
    }

    static {
        String string2 = LoginManager.class.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LoginManager::class.java.toString()");
        TAG = string2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/facebook/login/LoginManager$ActivityStartActivityDelegate;", "Lcom/facebook/login/StartActivityDelegate;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "activityContext", "getActivityContext", "()Landroid/app/Activity;", "startActivityForResult", "", "intent", "Landroid/content/Intent;", "requestCode", "", "facebook-common_release"})
    private static final class ActivityStartActivityDelegate
    implements StartActivityDelegate {
        @NotNull
        private final Activity activityContext;

        public ActivityStartActivityDelegate(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.activityContext = activity;
        }

        @Override
        @NotNull
        public Activity getActivityContext() {
            return this.activityContext;
        }

        @Override
        public void startActivityForResult(@NotNull Intent intent, int requestCode) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            this.getActivityContext().startActivityForResult(intent, requestCode);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/login/LoginManager$AndroidxActivityResultRegistryOwnerStartActivityDelegate;", "Lcom/facebook/login/StartActivityDelegate;", "activityResultRegistryOwner", "Landroidx/activity/result/ActivityResultRegistryOwner;", "callbackManager", "Lcom/facebook/CallbackManager;", "(Landroidx/activity/result/ActivityResultRegistryOwner;Lcom/facebook/CallbackManager;)V", "activityContext", "Landroid/app/Activity;", "getActivityContext", "()Landroid/app/Activity;", "startActivityForResult", "", "intent", "Landroid/content/Intent;", "requestCode", "", "facebook-common_release"})
    private static final class AndroidxActivityResultRegistryOwnerStartActivityDelegate
    implements StartActivityDelegate {
        @NotNull
        private final ActivityResultRegistryOwner activityResultRegistryOwner;
        @NotNull
        private final CallbackManager callbackManager;

        public AndroidxActivityResultRegistryOwnerStartActivityDelegate(@NotNull ActivityResultRegistryOwner activityResultRegistryOwner, @NotNull CallbackManager callbackManager) {
            Intrinsics.checkNotNullParameter((Object)activityResultRegistryOwner, (String)"activityResultRegistryOwner");
            Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
            this.activityResultRegistryOwner = activityResultRegistryOwner;
            this.callbackManager = callbackManager;
        }

        @Override
        public void startActivityForResult(@NotNull Intent intent, int requestCode) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"com/facebook/login/LoginManager$AndroidxActivityResultRegistryOwnerStartActivityDelegate$startActivityForResult$LauncherHolder", "", "()V", "launcher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "getLauncher", "()Landroidx/activity/result/ActivityResultLauncher;", "setLauncher", "(Landroidx/activity/result/ActivityResultLauncher;)V", "facebook-common_release"})
                public final class LauncherHolder {
                    @Nullable
                    private ActivityResultLauncher<Intent> launcher;

                    public LauncherHolder() {
                    }

                    @Nullable
                    public final ActivityResultLauncher<Intent> getLauncher() {
                        return this.launcher;
                    }

                    public final void setLauncher(@Nullable ActivityResultLauncher<Intent> activityResultLauncher) {
                        this.launcher = activityResultLauncher;
                    }
                }
                LauncherHolder launcherHolder = new LauncherHolder();
                launcherHolder.setLauncher((ActivityResultLauncher<Intent>)this.activityResultRegistryOwner.getActivityResultRegistry().register("facebook-login", (ActivityResultContract)new ActivityResultContract<Intent, Pair<Integer, Intent>>(){

                    @NotNull
                    public Intent createIntent(@NotNull Context context, @NotNull Intent input) {
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                        return input;
                    }

                    @NotNull
                    public Pair<Integer, Intent> parseResult(int resultCode, @Nullable Intent intent) {
                        Pair pair = Pair.create((Object)resultCode, (Object)intent);
                        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(resultCode, intent)");
                        return pair;
                    }
                }, arg_0 -> AndroidxActivityResultRegistryOwnerStartActivityDelegate.startActivityForResult$lambda$0(this, launcherHolder, arg_0)));
                ActivityResultLauncher<Intent> activityResultLauncher = launcherHolder.getLauncher();
                if (activityResultLauncher == null) break block0;
                activityResultLauncher.launch((Object)intent);
            }
        }

        @Override
        @Nullable
        public Activity getActivityContext() {
            return this.activityResultRegistryOwner instanceof Activity ? (Activity)this.activityResultRegistryOwner : null;
        }

        private static final void startActivityForResult$lambda$0(AndroidxActivityResultRegistryOwnerStartActivityDelegate this$0, startActivityForResult.LauncherHolder $launcherHolder, Pair result) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$launcherHolder, (String)"$launcherHolder");
            CallbackManager callbackManager = this$0.callbackManager;
            int n = CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode();
            Object object = result.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.first");
            callbackManager.onActivityResult(n, ((Number)object).intValue(), (Intent)result.second);
            ActivityResultLauncher<Intent> activityResultLauncher = $launcherHolder.getLauncher();
            if (activityResultLauncher != null) {
                activityResultLauncher.unregister();
            }
            $launcherHolder.setLauncher(null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J \u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007J\b\u0010\u001c\u001a\u00020\fH\u0017J2\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006)"}, d2={"Lcom/facebook/login/LoginManager$Companion;", "", "()V", "EXPRESS_LOGIN_ALLOWED", "", "MANAGE_PERMISSION_PREFIX", "OTHER_PUBLISH_PERMISSIONS", "", "PREFERENCE_LOGIN_MANAGER", "PUBLISH_PERMISSION_PREFIX", "TAG", "instance", "Lcom/facebook/login/LoginManager;", "otherPublishPermissions", "getOtherPublishPermissions", "()Ljava/util/Set;", "computeLoginResult", "Lcom/facebook/login/LoginResult;", "request", "Lcom/facebook/login/LoginClient$Request;", "newToken", "Lcom/facebook/AccessToken;", "newIdToken", "Lcom/facebook/AuthenticationToken;", "getExtraDataFromIntent", "", "intent", "Landroid/content/Intent;", "getInstance", "handleLoginStatusError", "", "errorType", "errorDescription", "loggerRef", "logger", "Lcom/facebook/login/LoginLogger;", "responseCallback", "Lcom/facebook/LoginStatusCallback;", "isPublishPermission", "", "permission", "facebook-common_release"})
    @SourceDebugExtension(value={"SMAP\nLoginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginManager.kt\ncom/facebook/login/LoginManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1400:1\n1#2:1401\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public LoginManager getInstance() {
            LoginManager loginManager;
            if (instance == null) {
                Companion companion = this;
                synchronized (companion) {
                    boolean bl = false;
                    instance = new LoginManager();
                    Unit unit = Unit.INSTANCE;
                }
            }
            if ((loginManager = instance) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
                loginManager = null;
            }
            return loginManager;
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @Nullable
        public final Map<String, String> getExtraDataFromIntent(@Nullable Intent intent) {
            if (intent == null) {
                return null;
            }
            intent.setExtrasClassLoader(LoginClient.Result.class.getClassLoader());
            LoginClient.Result result = (LoginClient.Result)intent.getParcelableExtra("com.facebook.LoginFragment:Result");
            if (result == null) {
                return null;
            }
            LoginClient.Result result2 = result;
            return result2.extraData;
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final boolean isPublishPermission(@Nullable String permission) {
            return permission != null && (StringsKt.startsWith$default((String)permission, (String)LoginManager.PUBLISH_PERMISSION_PREFIX, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)permission, (String)LoginManager.MANAGE_PERMISSION_PREFIX, (boolean)false, (int)2, null) || OTHER_PUBLISH_PERMISSIONS.contains(permission));
        }

        private final Set<String> getOtherPublishPermissions() {
            Object[] objectArray = new String[]{"ads_management", "create_event", "rsvp_event"};
            return SetsKt.setOf((Object[])objectArray);
        }

        @JvmStatic
        @VisibleForTesting(otherwise=2)
        @NotNull
        public final LoginResult computeLoginResult(@NotNull LoginClient.Request request, @NotNull AccessToken newToken, @Nullable AuthenticationToken newIdToken) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)newToken, (String)"newToken");
            Set<String> requestedPermissions = request.getPermissions();
            Set grantedPermissions = CollectionsKt.toMutableSet((Iterable)CollectionsKt.filterNotNull((Iterable)newToken.getPermissions()));
            if (request.isRerequest()) {
                grantedPermissions.retainAll((Collection)requestedPermissions);
            }
            Set deniedPermissions = CollectionsKt.toMutableSet((Iterable)CollectionsKt.filterNotNull((Iterable)requestedPermissions));
            deniedPermissions.removeAll(grantedPermissions);
            return new LoginResult(newToken, newIdToken, grantedPermissions, deniedPermissions);
        }

        private final void handleLoginStatusError(String errorType, String errorDescription, String loggerRef, LoginLogger logger, LoginStatusCallback responseCallback) {
            Exception exception = (Exception)((Object)new FacebookException(errorType + ": " + errorDescription));
            logger.logLoginStatusError(loggerRef, exception);
            responseCallback.onError(exception);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Set access$getOtherPublishPermissions(Companion $this) {
            return $this.getOtherPublishPermissions();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B\u001d\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001a\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/facebook/login/LoginManager$FacebookLoginActivityResultContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "", "", "Lcom/facebook/CallbackManager$ActivityResultParameters;", "callbackManager", "Lcom/facebook/CallbackManager;", "loggerID", "(Lcom/facebook/login/LoginManager;Lcom/facebook/CallbackManager;Ljava/lang/String;)V", "getCallbackManager", "()Lcom/facebook/CallbackManager;", "setCallbackManager", "(Lcom/facebook/CallbackManager;)V", "getLoggerID", "()Ljava/lang/String;", "setLoggerID", "(Ljava/lang/String;)V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "permissions", "parseResult", "resultCode", "", "intent", "facebook-common_release"})
    @SourceDebugExtension(value={"SMAP\nLoginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginManager.kt\ncom/facebook/login/LoginManager$FacebookLoginActivityResultContract\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1400:1\n1#2:1401\n*E\n"})
    public final class FacebookLoginActivityResultContract
    extends ActivityResultContract<Collection<? extends String>, CallbackManager.ActivityResultParameters> {
        @Nullable
        private CallbackManager callbackManager;
        @Nullable
        private String loggerID;
        final /* synthetic */ LoginManager this$0;

        public FacebookLoginActivityResultContract(@Nullable LoginManager this$0, @Nullable CallbackManager callbackManager, String loggerID) {
            this.this$0 = this$0;
            this.callbackManager = callbackManager;
            this.loggerID = loggerID;
        }

        public /* synthetic */ FacebookLoginActivityResultContract(LoginManager loginManager, CallbackManager callbackManager, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                callbackManager = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(loginManager, callbackManager, string2);
        }

        @Nullable
        public final CallbackManager getCallbackManager() {
            return this.callbackManager;
        }

        public final void setCallbackManager(@Nullable CallbackManager callbackManager) {
            this.callbackManager = callbackManager;
        }

        @Nullable
        public final String getLoggerID() {
            return this.loggerID;
        }

        public final void setLoggerID(@Nullable String string2) {
            this.loggerID = string2;
        }

        @NotNull
        public Intent createIntent(@NotNull Context context, @NotNull Collection<String> permissions) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
            LoginConfiguration loginConfig = new LoginConfiguration(permissions, null, 2, null);
            LoginClient.Request loginRequest = this.this$0.createLoginRequestWithConfig(loginConfig);
            String string2 = this.loggerID;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                loginRequest.setAuthId(it);
            }
            this.this$0.logStartLogin(context, loginRequest);
            Intent intent = this.this$0.getFacebookActivityIntent(loginRequest);
            if (!this.this$0.resolveIntent(intent)) {
                FacebookException exception = new FacebookException("Log in attempt failed: FacebookActivity could not be started. Please make sure you added FacebookActivity to the AndroidManifest.");
                this.this$0.logCompleteLogin(context, LoginClient.Result.Code.ERROR, null, (Exception)((Object)exception), false, loginRequest);
                throw exception;
            }
            return intent;
        }

        @NotNull
        public CallbackManager.ActivityResultParameters parseResult(int resultCode, @Nullable Intent intent) {
            int requestCode;
            block0: {
                LoginManager.onActivityResult$default(this.this$0, resultCode, intent, null, 4, null);
                requestCode = CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode();
                CallbackManager callbackManager = this.callbackManager;
                if (callbackManager == null) break block0;
                callbackManager.onActivityResult(requestCode, resultCode, intent);
            }
            return new CallbackManager.ActivityResultParameters(requestCode, resultCode, intent);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/login/LoginManager$FragmentStartActivityDelegate;", "Lcom/facebook/login/StartActivityDelegate;", "fragment", "Lcom/facebook/internal/FragmentWrapper;", "(Lcom/facebook/internal/FragmentWrapper;)V", "activityContext", "Landroid/app/Activity;", "getActivityContext", "()Landroid/app/Activity;", "startActivityForResult", "", "intent", "Landroid/content/Intent;", "requestCode", "", "facebook-common_release"})
    private static final class FragmentStartActivityDelegate
    implements StartActivityDelegate {
        @NotNull
        private final FragmentWrapper fragment;
        @Nullable
        private final Activity activityContext;

        public FragmentStartActivityDelegate(@NotNull FragmentWrapper fragment) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            this.fragment = fragment;
            this.activityContext = this.fragment.getActivity();
        }

        @Override
        public void startActivityForResult(@NotNull Intent intent, int requestCode) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            this.fragment.startActivityForResult(intent, requestCode);
        }

        @Override
        @Nullable
        public Activity getActivityContext() {
            return this.activityContext;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/login/LoginManager$LoginLoggerHolder;", "", "()V", "logger", "Lcom/facebook/login/LoginLogger;", "getLogger", "context", "Landroid/content/Context;", "facebook-common_release"})
    private static final class LoginLoggerHolder {
        @NotNull
        public static final LoginLoggerHolder INSTANCE = new LoginLoggerHolder();
        @Nullable
        private static LoginLogger logger;

        private LoginLoggerHolder() {
        }

        @Nullable
        public final synchronized LoginLogger getLogger(@Nullable Context context) {
            Context context2 = context;
            Context context3 = context2;
            if (context3 == null) {
                context3 = FacebookSdk.getApplicationContext();
            }
            if ((context2 = context3) == null) {
                return null;
            }
            if (logger == null) {
                logger = new LoginLogger(context2, FacebookSdk.getApplicationId());
            }
            return logger;
        }
    }
}

