/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.login.DeviceAuthDialog;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginMethodHandler;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;

class DeviceAuthMethodHandler
extends LoginMethodHandler {
    private static ScheduledThreadPoolExecutor backgroundExecutor;
    public static final Parcelable.Creator<DeviceAuthMethodHandler> CREATOR;

    DeviceAuthMethodHandler(LoginClient loginClient) {
        super(loginClient);
    }

    @Override
    boolean tryAuthorize(LoginClient.Request request) {
        this.showDialog(request);
        return true;
    }

    private void showDialog(LoginClient.Request request) {
        FragmentActivity activity = this.loginClient.getActivity();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        DeviceAuthDialog dialog = this.createDeviceAuthDialog();
        dialog.show(activity.getSupportFragmentManager(), "login_with_facebook");
        dialog.startLogin(request);
    }

    protected DeviceAuthDialog createDeviceAuthDialog() {
        return new DeviceAuthDialog();
    }

    public void onCancel() {
        LoginClient.Result outcome = LoginClient.Result.createCancelResult(this.loginClient.getPendingRequest(), "User canceled log in.");
        this.loginClient.completeAndValidate(outcome);
    }

    public void onError(Exception ex) {
        LoginClient.Result outcome = LoginClient.Result.createErrorResult(this.loginClient.getPendingRequest(), null, ex.getMessage());
        this.loginClient.completeAndValidate(outcome);
    }

    public void onSuccess(String accessToken, String applicationId, String userId, Collection<String> permissions, Collection<String> declinedPermissions, AccessTokenSource accessTokenSource, Date expirationTime, Date lastRefreshTime, Date dataAccessExpirationTime) {
        AccessToken token = new AccessToken(accessToken, applicationId, userId, permissions, declinedPermissions, accessTokenSource, expirationTime, lastRefreshTime, dataAccessExpirationTime);
        LoginClient.Result outcome = LoginClient.Result.createTokenResult(this.loginClient.getPendingRequest(), token);
        this.loginClient.completeAndValidate(outcome);
    }

    public static synchronized ScheduledThreadPoolExecutor getBackgroundExecutor() {
        if (backgroundExecutor == null) {
            backgroundExecutor = new ScheduledThreadPoolExecutor(1);
        }
        return backgroundExecutor;
    }

    protected DeviceAuthMethodHandler(Parcel parcel) {
        super(parcel);
    }

    @Override
    String getNameForLogging() {
        return "device_auth";
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
    }

    static {
        CREATOR = new Parcelable.Creator(){

            public DeviceAuthMethodHandler createFromParcel(Parcel source) {
                return new DeviceAuthMethodHandler(source);
            }

            public DeviceAuthMethodHandler[] newArray(int size) {
                return new DeviceAuthMethodHandler[size];
            }
        };
    }
}

