/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.net.Uri;
import android.os.Bundle;
import com.facebook.internal.Utility;
import com.facebook.share.model.ShareMessengerActionButton;
import com.facebook.share.model.ShareMessengerGenericTemplateContent;
import com.facebook.share.model.ShareMessengerGenericTemplateElement;
import com.facebook.share.model.ShareMessengerMediaTemplateContent;
import com.facebook.share.model.ShareMessengerOpenGraphMusicTemplateContent;
import com.facebook.share.model.ShareMessengerURLActionButton;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MessengerShareContentUtility {
    public static final Pattern FACEBOOK_DOMAIN = Pattern.compile("^(.+)\\.(facebook\\.com)$");
    public static final String TITLE = "title";
    public static final String SUBTITLE = "subtitle";
    public static final String URL = "url";
    public static final String IMAGE_URL = "image_url";
    public static final String BUTTONS = "buttons";
    public static final String FALLBACK_URL = "fallback_url";
    public static final String MESSENGER_EXTENSIONS = "messenger_extensions";
    public static final String WEBVIEW_SHARE_BUTTON = "webview_share_button";
    public static final String SHARABLE = "sharable";
    public static final String ATTACHMENT = "attachment";
    public static final String ATTACHMENT_ID = "attachment_id";
    public static final String ELEMENTS = "elements";
    public static final String DEFAULT_ACTION = "default_action";
    public static final String SHARE_BUTTON_HIDE = "hide";
    public static final String BUTTON_TYPE = "type";
    public static final String BUTTON_URL_TYPE = "web_url";
    public static final String PREVIEW_DEFAULT = "DEFAULT";
    public static final String PREVIEW_OPEN_GRAPH = "OPEN_GRAPH";
    public static final String TEMPLATE_TYPE = "template_type";
    public static final String TEMPLATE_GENERIC_TYPE = "generic";
    public static final String TEMPLATE_OPEN_GRAPH_TYPE = "open_graph";
    public static final String TEMPLATE_MEDIA_TYPE = "media";
    public static final String ATTACHMENT_TYPE = "type";
    public static final String ATTACHMENT_PAYLOAD = "payload";
    public static final String ATTACHMENT_TEMPLATE_TYPE = "template";
    public static final String WEBVIEW_RATIO = "webview_height_ratio";
    public static final String WEBVIEW_RATIO_FULL = "full";
    public static final String WEBVIEW_RATIO_TALL = "tall";
    public static final String WEBVIEW_RATIO_COMPACT = "compact";
    public static final String IMAGE_ASPECT_RATIO = "image_aspect_ratio";
    public static final String IMAGE_RATIO_SQUARE = "square";
    public static final String IMAGE_RATIO_HORIZONTAL = "horizontal";
    public static final String MEDIA_TYPE = "media_type";
    public static final String MEDIA_VIDEO = "video";
    public static final String MEDIA_IMAGE = "image";

    public static void addGenericTemplateContent(Bundle params, ShareMessengerGenericTemplateContent content) throws JSONException {
        MessengerShareContentUtility.addGenericTemplateElementForPreview(params, content.getGenericTemplateElement());
        Utility.putJSONValueInBundle((Bundle)params, (String)"MESSENGER_PLATFORM_CONTENT", (Object)MessengerShareContentUtility.serializeGenericTemplateContent(content));
    }

    public static void addOpenGraphMusicTemplateContent(Bundle params, ShareMessengerOpenGraphMusicTemplateContent content) throws JSONException {
        MessengerShareContentUtility.addOpenGraphMusicTemplateContentForPreview(params, content);
        Utility.putJSONValueInBundle((Bundle)params, (String)"MESSENGER_PLATFORM_CONTENT", (Object)MessengerShareContentUtility.serializeOpenGraphMusicTemplateContent(content));
    }

    public static void addMediaTemplateContent(Bundle params, ShareMessengerMediaTemplateContent content) throws JSONException {
        MessengerShareContentUtility.addMediaTemplateContentForPreview(params, content);
        Utility.putJSONValueInBundle((Bundle)params, (String)"MESSENGER_PLATFORM_CONTENT", (Object)MessengerShareContentUtility.serializeMediaTemplateContent(content));
    }

    private static void addGenericTemplateElementForPreview(Bundle params, ShareMessengerGenericTemplateElement element) throws JSONException {
        if (element.getButton() != null) {
            MessengerShareContentUtility.addActionButton(params, element.getButton(), false);
        } else if (element.getDefaultAction() != null) {
            MessengerShareContentUtility.addActionButton(params, element.getDefaultAction(), true);
        }
        Utility.putUri((Bundle)params, (String)"IMAGE", (Uri)element.getImageUrl());
        Utility.putNonEmptyString((Bundle)params, (String)"PREVIEW_TYPE", (String)PREVIEW_DEFAULT);
        Utility.putNonEmptyString((Bundle)params, (String)"TITLE", (String)element.getTitle());
        Utility.putNonEmptyString((Bundle)params, (String)"SUBTITLE", (String)element.getSubtitle());
    }

    private static void addOpenGraphMusicTemplateContentForPreview(Bundle params, ShareMessengerOpenGraphMusicTemplateContent content) throws JSONException {
        MessengerShareContentUtility.addActionButton(params, content.getButton(), false);
        Utility.putNonEmptyString((Bundle)params, (String)"PREVIEW_TYPE", (String)PREVIEW_OPEN_GRAPH);
        Utility.putUri((Bundle)params, (String)"OPEN_GRAPH_URL", (Uri)content.getUrl());
    }

    private static void addMediaTemplateContentForPreview(Bundle params, ShareMessengerMediaTemplateContent content) throws JSONException {
        MessengerShareContentUtility.addActionButton(params, content.getButton(), false);
        Utility.putNonEmptyString((Bundle)params, (String)"PREVIEW_TYPE", (String)PREVIEW_DEFAULT);
        Utility.putNonEmptyString((Bundle)params, (String)"ATTACHMENT_ID", (String)content.getAttachmentId());
        if (content.getMediaUrl() != null) {
            Utility.putUri((Bundle)params, (String)MessengerShareContentUtility.getMediaUrlKey(content.getMediaUrl()), (Uri)content.getMediaUrl());
        }
        Utility.putNonEmptyString((Bundle)params, (String)"type", (String)MessengerShareContentUtility.getMediaType(content.getMediaType()));
    }

    private static void addActionButton(Bundle params, ShareMessengerActionButton button, boolean isDefaultAction) throws JSONException {
        if (button == null) {
            return;
        }
        if (button instanceof ShareMessengerURLActionButton) {
            MessengerShareContentUtility.addURLActionButton(params, (ShareMessengerURLActionButton)button, isDefaultAction);
        }
    }

    private static void addURLActionButton(Bundle params, ShareMessengerURLActionButton button, boolean isDefaultAction) throws JSONException {
        String actionForDisplay = isDefaultAction ? Utility.getUriString((Uri)button.getUrl()) : button.getTitle() + " - " + Utility.getUriString((Uri)button.getUrl());
        Utility.putNonEmptyString((Bundle)params, (String)"TARGET_DISPLAY", (String)actionForDisplay);
        Utility.putUri((Bundle)params, (String)"ITEM_URL", (Uri)button.getUrl());
    }

    private static JSONObject serializeGenericTemplateContent(ShareMessengerGenericTemplateContent content) throws JSONException {
        JSONArray elements = new JSONArray().put((Object)MessengerShareContentUtility.serializeGenericTemplateElement(content.getGenericTemplateElement()));
        JSONObject payload = new JSONObject().put(TEMPLATE_TYPE, (Object)TEMPLATE_GENERIC_TYPE).put(SHARABLE, content.getIsSharable()).put(IMAGE_ASPECT_RATIO, (Object)MessengerShareContentUtility.getImageRatioString(content.getImageAspectRatio())).put(ELEMENTS, (Object)elements);
        JSONObject attachment = new JSONObject().put("type", (Object)ATTACHMENT_TEMPLATE_TYPE).put(ATTACHMENT_PAYLOAD, (Object)payload);
        return new JSONObject().put(ATTACHMENT, (Object)attachment);
    }

    private static JSONObject serializeOpenGraphMusicTemplateContent(ShareMessengerOpenGraphMusicTemplateContent content) throws JSONException {
        JSONArray elements = new JSONArray().put((Object)MessengerShareContentUtility.serializeOpenGraphMusicTemplateElement(content));
        JSONObject payload = new JSONObject().put(TEMPLATE_TYPE, (Object)TEMPLATE_OPEN_GRAPH_TYPE).put(ELEMENTS, (Object)elements);
        JSONObject attachment = new JSONObject().put("type", (Object)ATTACHMENT_TEMPLATE_TYPE).put(ATTACHMENT_PAYLOAD, (Object)payload);
        return new JSONObject().put(ATTACHMENT, (Object)attachment);
    }

    private static JSONObject serializeMediaTemplateContent(ShareMessengerMediaTemplateContent content) throws JSONException {
        JSONArray elements = new JSONArray().put((Object)MessengerShareContentUtility.serializeMediaTemplateElement(content));
        JSONObject payload = new JSONObject().put(TEMPLATE_TYPE, (Object)TEMPLATE_MEDIA_TYPE).put(ELEMENTS, (Object)elements);
        JSONObject attachment = new JSONObject().put("type", (Object)ATTACHMENT_TEMPLATE_TYPE).put(ATTACHMENT_PAYLOAD, (Object)payload);
        return new JSONObject().put(ATTACHMENT, (Object)attachment);
    }

    private static JSONObject serializeGenericTemplateElement(ShareMessengerGenericTemplateElement element) throws JSONException {
        JSONObject object = new JSONObject().put(TITLE, (Object)element.getTitle()).put(SUBTITLE, (Object)element.getSubtitle()).put(IMAGE_URL, (Object)Utility.getUriString((Uri)element.getImageUrl()));
        if (element.getButton() != null) {
            JSONArray jsonArray = new JSONArray();
            jsonArray.put((Object)MessengerShareContentUtility.serializeActionButton(element.getButton()));
            object.put(BUTTONS, (Object)jsonArray);
        }
        if (element.getDefaultAction() != null) {
            object.put(DEFAULT_ACTION, (Object)MessengerShareContentUtility.serializeActionButton(element.getDefaultAction(), true));
        }
        return object;
    }

    private static JSONObject serializeOpenGraphMusicTemplateElement(ShareMessengerOpenGraphMusicTemplateContent element) throws JSONException {
        JSONObject object = new JSONObject().put(URL, (Object)Utility.getUriString((Uri)element.getUrl()));
        if (element.getButton() != null) {
            JSONArray jsonArray = new JSONArray();
            jsonArray.put((Object)MessengerShareContentUtility.serializeActionButton(element.getButton()));
            object.put(BUTTONS, (Object)jsonArray);
        }
        return object;
    }

    private static JSONObject serializeMediaTemplateElement(ShareMessengerMediaTemplateContent element) throws JSONException {
        JSONObject object = new JSONObject().put(ATTACHMENT_ID, (Object)element.getAttachmentId()).put(URL, (Object)Utility.getUriString((Uri)element.getMediaUrl())).put(MEDIA_TYPE, (Object)MessengerShareContentUtility.getMediaType(element.getMediaType()));
        if (element.getButton() != null) {
            JSONArray jsonArray = new JSONArray();
            jsonArray.put((Object)MessengerShareContentUtility.serializeActionButton(element.getButton()));
            object.put(BUTTONS, (Object)jsonArray);
        }
        return object;
    }

    private static JSONObject serializeActionButton(ShareMessengerActionButton button) throws JSONException {
        return MessengerShareContentUtility.serializeActionButton(button, false);
    }

    private static JSONObject serializeActionButton(ShareMessengerActionButton button, boolean isDefault) throws JSONException {
        if (button instanceof ShareMessengerURLActionButton) {
            return MessengerShareContentUtility.serializeURLActionButton((ShareMessengerURLActionButton)button, isDefault);
        }
        return null;
    }

    private static JSONObject serializeURLActionButton(ShareMessengerURLActionButton button, boolean isDefault) throws JSONException {
        return new JSONObject().put("type", (Object)BUTTON_URL_TYPE).put(TITLE, (Object)(isDefault ? null : button.getTitle())).put(URL, (Object)Utility.getUriString((Uri)button.getUrl())).put(WEBVIEW_RATIO, (Object)MessengerShareContentUtility.getWebviewHeightRatioString(button.getWebviewHeightRatio())).put(MESSENGER_EXTENSIONS, button.getIsMessengerExtensionURL()).put(FALLBACK_URL, (Object)Utility.getUriString((Uri)button.getFallbackUrl())).put(WEBVIEW_SHARE_BUTTON, (Object)MessengerShareContentUtility.getShouldHideShareButton(button));
    }

    private static String getMediaUrlKey(Uri url) {
        String host = url.getHost();
        return !Utility.isNullOrEmpty((String)host) && FACEBOOK_DOMAIN.matcher(host).matches() ? "uri" : "IMAGE";
    }

    private static String getWebviewHeightRatioString(ShareMessengerURLActionButton.WebviewHeightRatio webviewHeightRatio) {
        if (webviewHeightRatio == null) {
            return WEBVIEW_RATIO_FULL;
        }
        switch (webviewHeightRatio) {
            case WebviewHeightRatioCompact: {
                return WEBVIEW_RATIO_COMPACT;
            }
            case WebviewHeightRatioTall: {
                return WEBVIEW_RATIO_TALL;
            }
        }
        return WEBVIEW_RATIO_FULL;
    }

    private static String getImageRatioString(ShareMessengerGenericTemplateContent.ImageAspectRatio imageAspectRatio) {
        if (imageAspectRatio == null) {
            return IMAGE_RATIO_HORIZONTAL;
        }
        switch (imageAspectRatio) {
            case SQUARE: {
                return IMAGE_RATIO_SQUARE;
            }
        }
        return IMAGE_RATIO_HORIZONTAL;
    }

    private static String getMediaType(ShareMessengerMediaTemplateContent.MediaType mediaType) {
        if (mediaType == null) {
            return MEDIA_IMAGE;
        }
        switch (mediaType) {
            case VIDEO: {
                return MEDIA_VIDEO;
            }
        }
        return MEDIA_IMAGE;
    }

    private static String getShouldHideShareButton(ShareMessengerURLActionButton button) {
        return button.getShouldHideWebviewShareButton() ? SHARE_BUTTON_HIDE : null;
    }
}

