/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.CustomTabActivity;
import com.facebook.internal.CustomTab;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;

public class CustomTabMainActivity
extends Activity {
    public static final String EXTRA_ACTION = CustomTabMainActivity.class.getSimpleName() + ".extra_action";
    public static final String EXTRA_PARAMS = CustomTabMainActivity.class.getSimpleName() + ".extra_params";
    public static final String EXTRA_CHROME_PACKAGE = CustomTabMainActivity.class.getSimpleName() + ".extra_chromePackage";
    public static final String EXTRA_URL = CustomTabMainActivity.class.getSimpleName() + ".extra_url";
    public static final String REFRESH_ACTION = CustomTabMainActivity.class.getSimpleName() + ".action_refresh";
    private boolean shouldCloseCustomTab = true;
    private BroadcastReceiver redirectReceiver;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (CustomTabActivity.CUSTOM_TAB_REDIRECT_ACTION.equals(this.getIntent().getAction())) {
            this.setResult(0);
            this.finish();
            return;
        }
        if (savedInstanceState == null) {
            String action = this.getIntent().getStringExtra(EXTRA_ACTION);
            Bundle parameters = this.getIntent().getBundleExtra(EXTRA_PARAMS);
            String chromePackage = this.getIntent().getStringExtra(EXTRA_CHROME_PACKAGE);
            CustomTab customTab = new CustomTab(action, parameters);
            customTab.openCustomTab(this, chromePackage);
            this.shouldCloseCustomTab = false;
            this.redirectReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    Intent newIntent = new Intent((Context)CustomTabMainActivity.this, CustomTabMainActivity.class);
                    newIntent.setAction(REFRESH_ACTION);
                    newIntent.putExtra(EXTRA_URL, intent.getStringExtra(EXTRA_URL));
                    newIntent.addFlags(0x24000000);
                    CustomTabMainActivity.this.startActivity(newIntent);
                }
            };
            LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.redirectReceiver, new IntentFilter(CustomTabActivity.CUSTOM_TAB_REDIRECT_ACTION));
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (REFRESH_ACTION.equals(intent.getAction())) {
            Intent broadcast = new Intent(CustomTabActivity.DESTROY_ACTION);
            LocalBroadcastManager.getInstance((Context)this).sendBroadcast(broadcast);
            this.sendResult(-1, intent);
        } else if (CustomTabActivity.CUSTOM_TAB_REDIRECT_ACTION.equals(intent.getAction())) {
            this.sendResult(-1, intent);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.shouldCloseCustomTab) {
            this.sendResult(0, null);
        }
        this.shouldCloseCustomTab = true;
    }

    private void sendResult(int resultCode, Intent resultIntent) {
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.redirectReceiver);
        if (resultIntent != null) {
            String responseURL = resultIntent.getStringExtra(EXTRA_URL);
            Bundle results = responseURL != null ? CustomTabMainActivity.parseResponseUri(responseURL) : new Bundle();
            Intent nativeProtocolResultIntent = NativeProtocol.createProtocolResultIntent((Intent)this.getIntent(), (Bundle)results, null);
            this.setResult(resultCode, nativeProtocolResultIntent != null ? nativeProtocolResultIntent : resultIntent);
        } else {
            this.setResult(resultCode, NativeProtocol.createProtocolResultIntent((Intent)this.getIntent(), null, null));
        }
        this.finish();
    }

    private static Bundle parseResponseUri(String urlString) {
        Uri u = Uri.parse((String)urlString);
        Bundle b = Utility.parseUrlQueryString((String)u.getQuery());
        b.putAll(Utility.parseUrlQueryString((String)u.getFragment()));
        return b;
    }
}

