/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.login.CustomTabLoginMethodHandler;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginMethodHandler;

abstract class NativeAppLoginMethodHandler
extends LoginMethodHandler {
    NativeAppLoginMethodHandler(LoginClient loginClient) {
        super(loginClient);
    }

    NativeAppLoginMethodHandler(Parcel source) {
        super(source);
    }

    @Override
    abstract boolean tryAuthorize(LoginClient.Request var1);

    @Override
    boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        LoginClient.Request request = this.loginClient.getPendingRequest();
        LoginClient.Result outcome = data == null ? LoginClient.Result.createCancelResult(request, "Operation canceled") : (resultCode == 0 ? this.handleResultCancel(request, data) : (resultCode != -1 ? LoginClient.Result.createErrorResult(request, "Unexpected resultCode from authorization.", null) : this.handleResultOk(request, data)));
        if (outcome != null) {
            this.loginClient.completeAndValidate(outcome);
        } else {
            this.loginClient.tryNextHandler();
        }
        return true;
    }

    private LoginClient.Result handleResultOk(LoginClient.Request request, Intent data) {
        Bundle extras = data.getExtras();
        String error = this.getError(extras);
        String errorCode = extras.get("error_code") != null ? extras.get("error_code").toString() : null;
        String errorMessage = this.getErrorMessage(extras);
        String e2e = extras.getString("e2e");
        if (!Utility.isNullOrEmpty((String)e2e)) {
            this.logWebLoginCompleted(e2e);
        }
        if (error == null && errorCode == null && errorMessage == null) {
            try {
                AccessToken token = NativeAppLoginMethodHandler.createAccessTokenFromWebBundle(request.getPermissions(), extras, AccessTokenSource.FACEBOOK_APPLICATION_WEB, request.getApplicationId());
                return LoginClient.Result.createTokenResult(request, token);
            }
            catch (FacebookException ex) {
                return LoginClient.Result.createErrorResult(request, null, ex.getMessage());
            }
        }
        if (error.equals("logged_out")) {
            CustomTabLoginMethodHandler.calledThroughLoggedOutAppSwitch = true;
            return null;
        }
        if (ServerProtocol.errorsProxyAuthDisabled.contains(error)) {
            return null;
        }
        if (ServerProtocol.errorsUserCanceled.contains(error)) {
            return LoginClient.Result.createCancelResult(request, null);
        }
        return LoginClient.Result.createErrorResult(request, error, errorMessage, errorCode);
    }

    private LoginClient.Result handleResultCancel(LoginClient.Request request, Intent data) {
        String errorCode;
        Bundle extras = data.getExtras();
        String error = this.getError(extras);
        String string2 = errorCode = extras.get("error_code") != null ? extras.get("error_code").toString() : null;
        if ("CONNECTION_FAILURE".equals(errorCode)) {
            String errorMessage = this.getErrorMessage(extras);
            return LoginClient.Result.createErrorResult(request, error, errorMessage, errorCode);
        }
        return LoginClient.Result.createCancelResult(request, error);
    }

    private String getError(Bundle extras) {
        String error = extras.getString("error");
        if (error == null) {
            error = extras.getString("error_type");
        }
        return error;
    }

    private String getErrorMessage(Bundle extras) {
        String errorMessage = extras.getString("error_message");
        if (errorMessage == null) {
            errorMessage = extras.getString("error_description");
        }
        return errorMessage;
    }

    protected boolean tryIntent(Intent intent, int requestCode) {
        if (intent == null) {
            return false;
        }
        try {
            this.loginClient.getFragment().startActivityForResult(intent, requestCode);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }
}

