/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.facebook.share.model.ShareMedia;
import java.util.ArrayList;
import java.util.List;

public final class SharePhoto
extends ShareMedia {
    private final Bitmap bitmap;
    private final Uri imageUrl;
    private final boolean userGenerated;
    private final String caption;
    public static final Parcelable.Creator<SharePhoto> CREATOR = new Parcelable.Creator<SharePhoto>(){

        public SharePhoto createFromParcel(Parcel source) {
            return new SharePhoto(source);
        }

        public SharePhoto[] newArray(int size) {
            return new SharePhoto[size];
        }
    };

    private SharePhoto(Builder builder) {
        super(builder);
        this.bitmap = builder.bitmap;
        this.imageUrl = builder.imageUrl;
        this.userGenerated = builder.userGenerated;
        this.caption = builder.caption;
    }

    SharePhoto(Parcel in) {
        super(in);
        this.bitmap = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
        this.imageUrl = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.userGenerated = in.readByte() != 0;
        this.caption = in.readString();
    }

    @Nullable
    public Bitmap getBitmap() {
        return this.bitmap;
    }

    @Nullable
    public Uri getImageUrl() {
        return this.imageUrl;
    }

    public boolean getUserGenerated() {
        return this.userGenerated;
    }

    public String getCaption() {
        return this.caption;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeParcelable((Parcelable)this.bitmap, 0);
        out.writeParcelable((Parcelable)this.imageUrl, 0);
        out.writeByte((byte)(this.userGenerated ? 1 : 0));
        out.writeString(this.caption);
    }

    @Override
    public ShareMedia.Type getMediaType() {
        return ShareMedia.Type.PHOTO;
    }

    public static final class Builder
    extends ShareMedia.Builder<SharePhoto, Builder> {
        private Bitmap bitmap;
        private Uri imageUrl;
        private boolean userGenerated;
        private String caption;

        public Builder setBitmap(@Nullable Bitmap bitmap) {
            this.bitmap = bitmap;
            return this;
        }

        public Builder setImageUrl(@Nullable Uri imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder setUserGenerated(boolean userGenerated) {
            this.userGenerated = userGenerated;
            return this;
        }

        public Builder setCaption(@Nullable String caption) {
            this.caption = caption;
            return this;
        }

        Uri getImageUrl() {
            return this.imageUrl;
        }

        Bitmap getBitmap() {
            return this.bitmap;
        }

        @Override
        public SharePhoto build() {
            return new SharePhoto(this);
        }

        @Override
        public Builder readFrom(SharePhoto model) {
            if (model == null) {
                return this;
            }
            return ((Builder)super.readFrom(model)).setBitmap(model.getBitmap()).setImageUrl(model.getImageUrl()).setUserGenerated(model.getUserGenerated()).setCaption(model.getCaption());
        }

        @Override
        Builder readFrom(Parcel parcel) {
            return this.readFrom((SharePhoto)parcel.readParcelable(SharePhoto.class.getClassLoader()));
        }

        static void writePhotoListTo(Parcel out, int parcelFlags, List<SharePhoto> photos) {
            Parcelable[] array = new ShareMedia[photos.size()];
            for (int i = 0; i < photos.size(); ++i) {
                array[i] = photos.get(i);
            }
            out.writeParcelableArray(array, parcelFlags);
        }

        static List<SharePhoto> readPhotoListFrom(Parcel in) {
            List<ShareMedia> media = Builder.readListFrom(in);
            ArrayList<SharePhoto> photos = new ArrayList<SharePhoto>();
            for (ShareMedia medium : media) {
                if (!(medium instanceof SharePhoto)) continue;
                photos.add((SharePhoto)medium);
            }
            return photos;
        }
    }
}

