/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.app.Activity;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookActivity;
import com.facebook.FacebookAuthorizationException;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.LoginStatusCallback;
import com.facebook.Profile;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.CustomTabUtils;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.PlatformServiceClient;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.login.CustomTabPrefetchHelper;
import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginLogger;
import com.facebook.login.LoginMethodHandler;
import com.facebook.login.LoginResult;
import com.facebook.login.LoginStatusClient;
import com.facebook.login.StartActivityDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class LoginManager {
    private static final String PUBLISH_PERMISSION_PREFIX = "publish";
    private static final String MANAGE_PERMISSION_PREFIX = "manage";
    private static final String EXPRESS_LOGIN_ALLOWED = "express_login_allowed";
    private static final String PREFERENCE_LOGIN_MANAGER = "com.facebook.loginManager";
    private static final Set<String> OTHER_PUBLISH_PERMISSIONS = LoginManager.getOtherPublishPermissions();
    private static volatile LoginManager instance;
    private LoginBehavior loginBehavior = LoginBehavior.NATIVE_WITH_FALLBACK;
    private DefaultAudience defaultAudience = DefaultAudience.FRIENDS;
    private final SharedPreferences sharedPreferences;
    private String authType = "rerequest";

    LoginManager() {
        Validate.sdkInitialized();
        this.sharedPreferences = FacebookSdk.getApplicationContext().getSharedPreferences(PREFERENCE_LOGIN_MANAGER, 0);
        if (FacebookSdk.hasCustomTabsPrefetching && CustomTabUtils.getChromePackage() != null) {
            CustomTabPrefetchHelper prefetchHelper = new CustomTabPrefetchHelper();
            CustomTabsClient.bindCustomTabsService((Context)FacebookSdk.getApplicationContext(), (String)"com.android.chrome", (CustomTabsServiceConnection)prefetchHelper);
            CustomTabsClient.connectAndInitialize((Context)FacebookSdk.getApplicationContext(), (String)FacebookSdk.getApplicationContext().getPackageName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoginManager getInstance() {
        if (instance != null) return instance;
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            if (instance != null) return instance;
            instance = new LoginManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void resolveError(Activity activity, GraphResponse response) {
        this.startLogin(new ActivityStartActivityDelegate(activity), this.createLoginRequestFromResponse(response));
    }

    public void resolveError(androidx.fragment.app.Fragment fragment, GraphResponse response) {
        this.resolveError(new FragmentWrapper(fragment), response);
    }

    public void resolveError(Fragment fragment, GraphResponse response) {
        this.resolveError(new FragmentWrapper(fragment), response);
    }

    private void resolveError(FragmentWrapper fragment, GraphResponse response) {
        this.startLogin(new FragmentStartActivityDelegate(fragment), this.createLoginRequestFromResponse(response));
    }

    private LoginClient.Request createLoginRequestFromResponse(GraphResponse response) {
        Validate.notNull((Object)response, (String)"response");
        AccessToken failedToken = response.getRequest().getAccessToken();
        return this.createLoginRequest(failedToken != null ? failedToken.getPermissions() : null);
    }

    public void registerCallback(CallbackManager callbackManager, final FacebookCallback<LoginResult> callback) {
        if (!(callbackManager instanceof CallbackManagerImpl)) {
            throw new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
        }
        ((CallbackManagerImpl)callbackManager).registerCallback(CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode(), new CallbackManagerImpl.Callback(){

            public boolean onActivityResult(int resultCode, Intent data) {
                return LoginManager.this.onActivityResult(resultCode, data, callback);
            }
        });
    }

    public void unregisterCallback(CallbackManager callbackManager) {
        if (!(callbackManager instanceof CallbackManagerImpl)) {
            throw new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
        }
        ((CallbackManagerImpl)callbackManager).unregisterCallback(CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode());
    }

    boolean onActivityResult(int resultCode, Intent data) {
        return this.onActivityResult(resultCode, data, null);
    }

    boolean onActivityResult(int resultCode, Intent data, FacebookCallback<LoginResult> callback) {
        FacebookException exception = null;
        AccessToken newToken = null;
        LoginClient.Result.Code code = LoginClient.Result.Code.ERROR;
        Map<String, String> loggingExtras = null;
        LoginClient.Request originalRequest = null;
        boolean isCanceled = false;
        if (data != null) {
            LoginClient.Result result = (LoginClient.Result)data.getParcelableExtra("com.facebook.LoginFragment:Result");
            if (result != null) {
                originalRequest = result.request;
                code = result.code;
                if (resultCode == -1) {
                    if (result.code == LoginClient.Result.Code.SUCCESS) {
                        newToken = result.token;
                    } else {
                        exception = new FacebookAuthorizationException(result.errorMessage);
                    }
                } else if (resultCode == 0) {
                    isCanceled = true;
                }
                loggingExtras = result.loggingExtras;
            }
        } else if (resultCode == 0) {
            isCanceled = true;
            code = LoginClient.Result.Code.CANCEL;
        }
        if (exception == null && newToken == null && !isCanceled) {
            exception = new FacebookException("Unexpected call to LoginManager.onActivityResult");
        }
        boolean wasLoginActivityTried = true;
        Context context = null;
        this.logCompleteLogin(context, code, loggingExtras, (Exception)((Object)exception), wasLoginActivityTried, originalRequest);
        this.finishLogin(newToken, originalRequest, exception, isCanceled, callback);
        return true;
    }

    @Nullable
    static Map<String, String> getExtraDataFromIntent(Intent intent) {
        if (intent == null) {
            return null;
        }
        LoginClient.Result result = (LoginClient.Result)intent.getParcelableExtra("com.facebook.LoginFragment:Result");
        if (result == null) {
            return null;
        }
        return result.extraData;
    }

    public LoginBehavior getLoginBehavior() {
        return this.loginBehavior;
    }

    public LoginManager setLoginBehavior(LoginBehavior loginBehavior) {
        this.loginBehavior = loginBehavior;
        return this;
    }

    public DefaultAudience getDefaultAudience() {
        return this.defaultAudience;
    }

    public LoginManager setDefaultAudience(DefaultAudience defaultAudience) {
        this.defaultAudience = defaultAudience;
        return this;
    }

    public String getAuthType() {
        return this.authType;
    }

    public LoginManager setAuthType(String authType) {
        this.authType = authType;
        return this;
    }

    public void logOut() {
        AccessToken.setCurrentAccessToken(null);
        Profile.setCurrentProfile(null);
        this.setExpressLoginStatus(false);
    }

    public void retrieveLoginStatus(Context context, LoginStatusCallback responseCallback) {
        this.retrieveLoginStatus(context, 5000L, responseCallback);
    }

    public void retrieveLoginStatus(Context context, long toastDurationMs, LoginStatusCallback responseCallback) {
        this.retrieveLoginStatusImpl(context, responseCallback, toastDurationMs);
    }

    public void logInWithReadPermissions(androidx.fragment.app.Fragment fragment, Collection<String> permissions) {
        this.logInWithReadPermissions(new FragmentWrapper(fragment), permissions);
    }

    public void logInWithReadPermissions(Fragment fragment, Collection<String> permissions) {
        this.logInWithReadPermissions(new FragmentWrapper(fragment), permissions);
    }

    private void logInWithReadPermissions(FragmentWrapper fragment, Collection<String> permissions) {
        this.validateReadPermissions(permissions);
        this.logIn(fragment, permissions);
    }

    public void logInWithReadPermissions(Activity activity, Collection<String> permissions) {
        this.validateReadPermissions(permissions);
        this.logIn(activity, permissions);
    }

    public void reauthorizeDataAccess(Activity activity) {
        LoginClient.Request loginRequest = this.createReauthorizeRequest();
        this.startLogin(new ActivityStartActivityDelegate(activity), loginRequest);
    }

    public void reauthorizeDataAccess(androidx.fragment.app.Fragment fragment) {
        this.reauthorizeDataAccess(new FragmentWrapper(fragment));
    }

    private void reauthorizeDataAccess(FragmentWrapper fragment) {
        LoginClient.Request loginRequest = this.createReauthorizeRequest();
        this.startLogin(new FragmentStartActivityDelegate(fragment), loginRequest);
    }

    public void logInWithPublishPermissions(androidx.fragment.app.Fragment fragment, Collection<String> permissions) {
        this.logInWithPublishPermissions(new FragmentWrapper(fragment), permissions);
    }

    public void logInWithPublishPermissions(Fragment fragment, Collection<String> permissions) {
        this.logInWithPublishPermissions(new FragmentWrapper(fragment), permissions);
    }

    private void logInWithPublishPermissions(FragmentWrapper fragment, Collection<String> permissions) {
        this.validatePublishPermissions(permissions);
        this.logIn(fragment, permissions);
    }

    public void logInWithPublishPermissions(Activity activity, Collection<String> permissions) {
        this.validatePublishPermissions(permissions);
        this.logIn(activity, permissions);
    }

    public void logIn(androidx.fragment.app.Fragment fragment, Collection<String> permissions) {
        this.logIn(new FragmentWrapper(fragment), permissions);
    }

    public void logIn(Fragment fragment, Collection<String> permissions) {
        this.logIn(new FragmentWrapper(fragment), permissions);
    }

    public void logIn(FragmentWrapper fragment, Collection<String> permissions) {
        LoginClient.Request loginRequest = this.createLoginRequest(permissions);
        this.startLogin(new FragmentStartActivityDelegate(fragment), loginRequest);
    }

    public void logIn(Activity activity, Collection<String> permissions) {
        LoginClient.Request loginRequest = this.createLoginRequest(permissions);
        this.startLogin(new ActivityStartActivityDelegate(activity), loginRequest);
    }

    private void validateReadPermissions(Collection<String> permissions) {
        if (permissions == null) {
            return;
        }
        for (String permission2 : permissions) {
            if (!LoginManager.isPublishPermission(permission2)) continue;
            throw new FacebookException(String.format("Cannot pass a publish or manage permission (%s) to a request for read authorization", permission2));
        }
    }

    private void validatePublishPermissions(Collection<String> permissions) {
        if (permissions == null) {
            return;
        }
        for (String permission2 : permissions) {
            if (LoginManager.isPublishPermission(permission2)) continue;
            throw new FacebookException(String.format("Cannot pass a read permission (%s) to a request for publish authorization", permission2));
        }
    }

    static boolean isPublishPermission(String permission2) {
        return permission2 != null && (permission2.startsWith(PUBLISH_PERMISSION_PREFIX) || permission2.startsWith(MANAGE_PERMISSION_PREFIX) || OTHER_PUBLISH_PERMISSIONS.contains(permission2));
    }

    private static Set<String> getOtherPublishPermissions() {
        HashSet<String> set = new HashSet<String>(){
            {
                this.add("ads_management");
                this.add("create_event");
                this.add("rsvp_event");
            }
        };
        return Collections.unmodifiableSet(set);
    }

    protected LoginClient.Request createLoginRequest(Collection<String> permissions) {
        LoginClient.Request request = new LoginClient.Request(this.loginBehavior, Collections.unmodifiableSet(permissions != null ? new HashSet<String>(permissions) : new HashSet()), this.defaultAudience, this.authType, FacebookSdk.getApplicationId(), UUID.randomUUID().toString());
        request.setRerequest(AccessToken.isCurrentAccessTokenActive());
        return request;
    }

    protected LoginClient.Request createReauthorizeRequest() {
        return new LoginClient.Request(LoginBehavior.DIALOG_ONLY, new HashSet<String>(), this.defaultAudience, "reauthorize", FacebookSdk.getApplicationId(), UUID.randomUUID().toString());
    }

    private void startLogin(StartActivityDelegate startActivityDelegate, LoginClient.Request request) throws FacebookException {
        this.logStartLogin((Context)startActivityDelegate.getActivityContext(), request);
        CallbackManagerImpl.registerStaticCallback((int)CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode(), (CallbackManagerImpl.Callback)new CallbackManagerImpl.Callback(){

            public boolean onActivityResult(int resultCode, Intent data) {
                return LoginManager.this.onActivityResult(resultCode, data);
            }
        });
        boolean started = this.tryFacebookActivity(startActivityDelegate, request);
        if (!started) {
            FacebookException exception = new FacebookException("Log in attempt failed: FacebookActivity could not be started. Please make sure you added FacebookActivity to the AndroidManifest.");
            boolean wasLoginActivityTried = false;
            this.logCompleteLogin((Context)startActivityDelegate.getActivityContext(), LoginClient.Result.Code.ERROR, null, (Exception)((Object)exception), wasLoginActivityTried, request);
            throw exception;
        }
    }

    private void logStartLogin(Context context, LoginClient.Request loginRequest) {
        LoginLogger loginLogger = LoginLoggerHolder.getLogger(context);
        if (loginLogger != null && loginRequest != null) {
            loginLogger.logStartLogin(loginRequest);
        }
    }

    private void logCompleteLogin(Context context, LoginClient.Result.Code result, Map<String, String> resultExtras, Exception exception, boolean wasLoginActivityTried, LoginClient.Request request) {
        LoginLogger loginLogger = LoginLoggerHolder.getLogger(context);
        if (loginLogger == null) {
            return;
        }
        if (request == null) {
            loginLogger.logUnexpectedError("fb_mobile_login_complete", "Unexpected call to logCompleteLogin with null pendingAuthorizationRequest.");
        } else {
            HashMap<String, String> pendingLoggingExtras = new HashMap<String, String>();
            pendingLoggingExtras.put("try_login_activity", wasLoginActivityTried ? "1" : "0");
            loginLogger.logCompleteLogin(request.getAuthId(), pendingLoggingExtras, result, resultExtras, exception);
        }
    }

    private boolean tryFacebookActivity(StartActivityDelegate startActivityDelegate, LoginClient.Request request) {
        Intent intent = this.getFacebookActivityIntent(request);
        if (!this.resolveIntent(intent)) {
            return false;
        }
        try {
            startActivityDelegate.startActivityForResult(intent, LoginClient.getLoginRequestCode());
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    private boolean resolveIntent(Intent intent) {
        ResolveInfo resolveInfo = FacebookSdk.getApplicationContext().getPackageManager().resolveActivity(intent, 0);
        return resolveInfo != null;
    }

    protected Intent getFacebookActivityIntent(LoginClient.Request request) {
        Intent intent = new Intent();
        intent.setClass(FacebookSdk.getApplicationContext(), FacebookActivity.class);
        intent.setAction(request.getLoginBehavior().toString());
        Bundle extras = new Bundle();
        extras.putParcelable("request", (Parcelable)request);
        intent.putExtra("com.facebook.LoginFragment:Request", extras);
        return intent;
    }

    static LoginResult computeLoginResult(LoginClient.Request request, AccessToken newToken) {
        Set<String> requestedPermissions = request.getPermissions();
        HashSet<String> grantedPermissions = new HashSet<String>(newToken.getPermissions());
        if (request.isRerequest()) {
            grantedPermissions.retainAll(requestedPermissions);
        }
        HashSet<String> deniedPermissions = new HashSet<String>(requestedPermissions);
        deniedPermissions.removeAll(grantedPermissions);
        return new LoginResult(newToken, grantedPermissions, deniedPermissions);
    }

    private void finishLogin(AccessToken newToken, LoginClient.Request origRequest, FacebookException exception, boolean isCanceled, FacebookCallback<LoginResult> callback) {
        if (newToken != null) {
            AccessToken.setCurrentAccessToken((AccessToken)newToken);
            Profile.fetchProfileForCurrentAccessToken();
        }
        if (callback != null) {
            LoginResult loginResult;
            LoginResult loginResult2 = loginResult = newToken != null ? LoginManager.computeLoginResult(origRequest, newToken) : null;
            if (isCanceled || loginResult != null && loginResult.getRecentlyGrantedPermissions().size() == 0) {
                callback.onCancel();
            } else if (exception != null) {
                callback.onError(exception);
            } else if (newToken != null) {
                this.setExpressLoginStatus(true);
                callback.onSuccess(loginResult);
            }
        }
    }

    private void retrieveLoginStatusImpl(Context context, final LoginStatusCallback responseCallback, long toastDurationMs) {
        final String applicationId = FacebookSdk.getApplicationId();
        final String loggerRef = UUID.randomUUID().toString();
        final LoginLogger logger = new LoginLogger(context, applicationId);
        if (!this.isExpressLoginAllowed()) {
            logger.logLoginStatusFailure(loggerRef);
            responseCallback.onFailure();
            return;
        }
        LoginStatusClient client = new LoginStatusClient(context, applicationId, loggerRef, FacebookSdk.getGraphApiVersion(), toastDurationMs);
        PlatformServiceClient.CompletedListener callback = new PlatformServiceClient.CompletedListener(){

            @Override
            public void completed(Bundle result) {
                if (result != null) {
                    String errorType = result.getString("com.facebook.platform.status.ERROR_TYPE");
                    String errorDescription = result.getString("com.facebook.platform.status.ERROR_DESCRIPTION");
                    if (errorType != null) {
                        LoginManager.handleLoginStatusError(errorType, errorDescription, loggerRef, logger, responseCallback);
                    } else {
                        String token = result.getString("com.facebook.platform.extra.ACCESS_TOKEN");
                        Date expires = Utility.getBundleLongAsDate((Bundle)result, (String)"com.facebook.platform.extra.EXPIRES_SECONDS_SINCE_EPOCH", (Date)new Date(0L));
                        ArrayList permissions = result.getStringArrayList("com.facebook.platform.extra.PERMISSIONS");
                        String signedRequest = result.getString("signed request");
                        String graphDomain = result.getString("graph_domain");
                        Date dataAccessExpirationTime = Utility.getBundleLongAsDate((Bundle)result, (String)"com.facebook.platform.extra.EXTRA_DATA_ACCESS_EXPIRATION_TIME", (Date)new Date(0L));
                        String userId = null;
                        if (!Utility.isNullOrEmpty((String)signedRequest)) {
                            userId = LoginMethodHandler.getUserIDFromSignedRequest(signedRequest);
                        }
                        if (!(Utility.isNullOrEmpty((String)token) || permissions == null || permissions.isEmpty() || Utility.isNullOrEmpty((String)userId))) {
                            AccessToken accessToken = new AccessToken(token, applicationId, userId, (Collection)permissions, null, null, null, expires, null, dataAccessExpirationTime, graphDomain);
                            AccessToken.setCurrentAccessToken((AccessToken)accessToken);
                            Profile.fetchProfileForCurrentAccessToken();
                            logger.logLoginStatusSuccess(loggerRef);
                            responseCallback.onCompleted(accessToken);
                        } else {
                            logger.logLoginStatusFailure(loggerRef);
                            responseCallback.onFailure();
                        }
                    }
                } else {
                    logger.logLoginStatusFailure(loggerRef);
                    responseCallback.onFailure();
                }
            }
        };
        client.setCompletedListener(callback);
        logger.logLoginStatusStart(loggerRef);
        if (!client.start()) {
            logger.logLoginStatusFailure(loggerRef);
            responseCallback.onFailure();
        }
    }

    private void setExpressLoginStatus(boolean isExpressLoginAllowed) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putBoolean(EXPRESS_LOGIN_ALLOWED, isExpressLoginAllowed);
        editor.apply();
    }

    private boolean isExpressLoginAllowed() {
        return this.sharedPreferences.getBoolean(EXPRESS_LOGIN_ALLOWED, true);
    }

    private static void handleLoginStatusError(String errorType, String errorDescription, String loggerRef, LoginLogger logger, LoginStatusCallback responseCallback) {
        FacebookException exception = new FacebookException(errorType + ": " + errorDescription);
        logger.logLoginStatusError(loggerRef, (Exception)((Object)exception));
        responseCallback.onError((Exception)((Object)exception));
    }

    private static class LoginLoggerHolder {
        private static LoginLogger logger;

        private LoginLoggerHolder() {
        }

        private static synchronized LoginLogger getLogger(Context context) {
            Context context2 = context = context != null ? context : FacebookSdk.getApplicationContext();
            if (context == null) {
                return null;
            }
            if (logger == null) {
                logger = new LoginLogger(context, FacebookSdk.getApplicationId());
            }
            return logger;
        }
    }

    private static class FragmentStartActivityDelegate
    implements StartActivityDelegate {
        private final FragmentWrapper fragment;

        FragmentStartActivityDelegate(FragmentWrapper fragment) {
            Validate.notNull((Object)fragment, (String)"fragment");
            this.fragment = fragment;
        }

        @Override
        public void startActivityForResult(Intent intent, int requestCode) {
            this.fragment.startActivityForResult(intent, requestCode);
        }

        @Override
        public Activity getActivityContext() {
            return this.fragment.getActivity();
        }
    }

    private static class ActivityStartActivityDelegate
    implements StartActivityDelegate {
        private final Activity activity;

        ActivityStartActivityDelegate(Activity activity) {
            Validate.notNull((Object)activity, (String)"activity");
            this.activity = activity;
        }

        @Override
        public void startActivityForResult(Intent intent, int requestCode) {
            this.activity.startActivityForResult(intent, requestCode);
        }

        @Override
        public Activity getActivityContext() {
            return this.activity;
        }
    }
}

