/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.referrals;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.facebook.CustomTabMainActivity;
import com.facebook.FacebookSdk;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.CustomTab;
import com.facebook.internal.CustomTabUtils;
import com.facebook.internal.Utility;
import com.facebook.login.CustomTabPrefetchHelper;

class ReferralClient {
    private Fragment fragment;
    private String currentPackage;
    protected String expectedChallenge;
    static final String REFERRAL_CODES_KEY = "fb_referral_codes";
    static final String ERROR_MESSAGE_KEY = "error_message";
    private static final String REFERRAL_DIALOG = "share_referral";
    private static final int CUSTOM_TAB_REQUEST_CODE = 1;
    private static final int CHALLENGE_LENGTH = 20;

    ReferralClient(Fragment fragment) {
        this.fragment = fragment;
    }

    void startReferral() {
        boolean started = this.tryStartReferral();
        if (!started) {
            Intent data = new Intent();
            data.putExtra(ERROR_MESSAGE_KEY, "Failed to open Referral dialog: Chrome custom tab could not be started. Please make sure internet permission is granted and Chrome is installed");
            this.finishReferral(0, data);
        }
    }

    void onActivityResult(int requestCode, int resultCode, Intent data) {
        String url;
        if (requestCode != 1) {
            return;
        }
        if (data != null && (url = data.getStringExtra(CustomTabMainActivity.EXTRA_URL)) != null && url.startsWith(CustomTabUtils.getValidRedirectURI(ReferralClient.getDeveloperDefinedRedirectUrl()))) {
            Uri uri = Uri.parse((String)url);
            Bundle values = Utility.parseUrlQueryString((String)uri.getQuery());
            if (this.validateChallenge(values)) {
                data.putExtras(values);
            } else {
                resultCode = 0;
                data.putExtra(ERROR_MESSAGE_KEY, "The referral response was missing a valid challenge string.");
            }
        }
        this.finishReferral(resultCode, data);
    }

    private boolean validateChallenge(Bundle values) {
        boolean valid = true;
        if (this.expectedChallenge != null) {
            String actualChallenge = values.getString("state");
            valid = this.expectedChallenge.equals(actualChallenge);
            this.expectedChallenge = null;
        }
        return valid;
    }

    static int getReferralRequestCode() {
        return CallbackManagerImpl.RequestCodeOffset.Referral.toRequestCode();
    }

    private void finishReferral(int resultCode, Intent data) {
        FragmentActivity activity;
        if (this.fragment.isAdded() && (activity = this.fragment.getActivity()) != null) {
            activity.setResult(resultCode, data);
            activity.finish();
        }
    }

    private boolean tryStartReferral() {
        if (this.fragment.getActivity() == null || this.fragment.getActivity().checkCallingOrSelfPermission("android.permission.INTERNET") != 0 || !this.isCustomTabsAllowed()) {
            return false;
        }
        Bundle parameters = this.getParameters();
        if (FacebookSdk.hasCustomTabsPrefetching) {
            CustomTabPrefetchHelper.mayLaunchUrl(CustomTab.getURIForAction(REFERRAL_DIALOG, parameters));
        }
        Intent intent = new Intent((Context)this.fragment.getActivity(), CustomTabMainActivity.class);
        intent.putExtra(CustomTabMainActivity.EXTRA_ACTION, REFERRAL_DIALOG);
        intent.putExtra(CustomTabMainActivity.EXTRA_PARAMS, parameters);
        intent.putExtra(CustomTabMainActivity.EXTRA_CHROME_PACKAGE, this.getChromePackage());
        this.fragment.startActivityForResult(intent, 1);
        return true;
    }

    private Bundle getParameters() {
        Bundle params = new Bundle();
        this.expectedChallenge = Utility.generateRandomString((int)20);
        params.putString("redirect_uri", CustomTabUtils.getValidRedirectURI(ReferralClient.getDeveloperDefinedRedirectUrl()));
        params.putString("app_id", FacebookSdk.getApplicationId());
        params.putString("state", this.expectedChallenge);
        return params;
    }

    private boolean isCustomTabsAllowed() {
        return this.getChromePackage() != null;
    }

    private String getChromePackage() {
        if (this.currentPackage == null) {
            this.currentPackage = CustomTabUtils.getChromePackage();
        }
        return this.currentPackage;
    }

    static String getDeveloperDefinedRedirectUrl() {
        return "fb" + FacebookSdk.getApplicationId() + "://authorize";
    }
}

