/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.facebook.AccessToken;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.GraphResponse;
import com.facebook.gamingservices.cloudgaming.CloudGameLoginHandler;
import com.facebook.gamingservices.cloudgaming.DaemonRequest;
import com.facebook.gamingservices.cloudgaming.internal.SDKMessageEnum;
import com.facebook.gamingservices.model.ContextCreateContent;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.FacebookDialogBase;
import com.facebook.internal.FragmentWrapper;
import com.facebook.share.internal.ResultProcessor;
import com.facebook.share.internal.ShareInternalUtility;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContextCreateDialog
extends FacebookDialogBase<ContextCreateContent, Result> {
    private static final int DEFAULT_REQUEST_CODE = CallbackManagerImpl.RequestCodeOffset.GameRequest.toRequestCode();
    @Nullable
    private FacebookCallback mCallback;

    public ContextCreateDialog(Activity activity) {
        super(activity, DEFAULT_REQUEST_CODE);
    }

    public ContextCreateDialog(androidx.fragment.app.Fragment fragment) {
        this(new FragmentWrapper(fragment));
    }

    public ContextCreateDialog(Fragment fragment) {
        this(new FragmentWrapper(fragment));
    }

    private ContextCreateDialog(FragmentWrapper fragmentWrapper) {
        super(fragmentWrapper, DEFAULT_REQUEST_CODE);
    }

    public boolean canShow(ContextCreateContent content) {
        return true;
    }

    protected void showImpl(ContextCreateContent content, Object mode) {
        if (CloudGameLoginHandler.isRunningInCloud()) {
            this.showForCloud(content, mode);
            return;
        }
    }

    private void showForCloud(ContextCreateContent content, Object mode) {
        block7: {
            Activity context = this.getActivityContext();
            AccessToken currentAccessToken = AccessToken.getCurrentAccessToken();
            if (currentAccessToken == null || currentAccessToken.isExpired()) {
                throw new FacebookException("Attempted to open ContextCreateContent with an invalid access token");
            }
            DaemonRequest.Callback requestCallback = new DaemonRequest.Callback(){

                @Override
                public void onCompleted(GraphResponse response) {
                    if (ContextCreateDialog.this.mCallback != null) {
                        if (response.getError() != null) {
                            ContextCreateDialog.this.mCallback.onError(new FacebookException(response.getError().getErrorMessage()));
                        } else {
                            ContextCreateDialog.this.mCallback.onSuccess((Object)new Result(response));
                        }
                    }
                }
            };
            JSONObject parameters = new JSONObject();
            try {
                String suggestedPlayersString;
                List<String> playerIDsList;
                if (content.getSuggestedPlayerIDs() != null && !(playerIDsList = Arrays.asList((suggestedPlayersString = content.getSuggestedPlayerIDs()).split("\\s*,\\s*"))).isEmpty()) {
                    if (playerIDsList.size() == 1) {
                        parameters.put("id", (Object)playerIDsList.get(0));
                    } else {
                        JSONArray playerIDs = new JSONArray();
                        for (int i = 0; i < playerIDsList.size(); ++i) {
                            playerIDs.put((Object)playerIDsList.get(i));
                        }
                        parameters.put("id", (Object)playerIDs);
                    }
                }
                DaemonRequest.executeAsync((Context)context, parameters, requestCallback, SDKMessageEnum.CONTEXT_CREATE);
            }
            catch (JSONException e) {
                if (this.mCallback == null) break block7;
                this.mCallback.onError(new FacebookException("Couldn't prepare Context Create Dialog"));
            }
        }
    }

    protected void registerCallbackImpl(CallbackManagerImpl callbackManager, final FacebookCallback callback) {
        this.mCallback = callback;
        final ResultProcessor resultProcessor = callback == null ? null : new ResultProcessor(callback){

            public void onSuccess(AppCall appCall, Bundle results) {
                if (results != null) {
                    callback.onSuccess((Object)new Result(results));
                } else {
                    this.onCancel(appCall);
                }
            }
        };
        callbackManager.registerCallback(this.getRequestCode(), new CallbackManagerImpl.Callback(){

            public boolean onActivityResult(int resultCode, Intent data) {
                return ShareInternalUtility.handleActivityResult((int)ContextCreateDialog.this.getRequestCode(), (int)resultCode, (Intent)data, (ResultProcessor)resultProcessor);
            }
        });
    }

    protected List<FacebookDialogBase.ModeHandler> getOrderedModeHandlers() {
        return null;
    }

    protected AppCall createBaseAppCall() {
        return null;
    }

    public static final class Result {
        @Nullable
        String contextID;

        private Result(Bundle results) {
            this.contextID = results.getString("id");
        }

        private Result(GraphResponse response) {
            try {
                JSONObject data = response.getJSONObject();
                if (data == null) {
                    this.contextID = null;
                    return;
                }
                JSONObject nestedData = data.optJSONObject("data");
                this.contextID = nestedData != null ? nestedData.getString("id") : null;
            }
            catch (JSONException e) {
                this.contextID = null;
            }
        }

        @Nullable
        public String getContextID() {
            return this.contextID;
        }
    }
}

