/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices.cloudgaming;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.GraphResponse;
import com.facebook.Profile;
import com.facebook.gamingservices.GamingPayload;
import com.facebook.gamingservices.cloudgaming.DaemonRequest;
import com.facebook.gamingservices.cloudgaming.internal.SDKLogger;
import com.facebook.gamingservices.cloudgaming.internal.SDKMessageEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CloudGameLoginHandler {
    private static final int DEFAULT_TIMEOUT_IN_SEC = 5;
    private static boolean IS_RUNNING_IN_CLOUD = false;
    private static SDKLogger mLogger = null;

    @Nullable
    public static synchronized AccessToken init(Context context) throws FacebookException {
        return CloudGameLoginHandler.init(context, 5);
    }

    @Nullable
    public static synchronized AccessToken init(Context context, int timeoutInSec) throws FacebookException {
        int timeout = timeoutInSec <= 0 ? 5 : timeoutInSec;
        boolean isCloudEnvReady = CloudGameLoginHandler.isCloudEnvReady(context, timeout);
        if (!isCloudEnvReady) {
            throw new FacebookException("Not running in Cloud environment.");
        }
        mLogger = SDKLogger.getInstance(context);
        GraphResponse response = DaemonRequest.executeAndWait(context, null, SDKMessageEnum.GET_ACCESS_TOKEN, timeout);
        if (response == null || response.getJSONObject() == null) {
            throw new FacebookException("Cannot receive response.");
        }
        if (response.getError() != null) {
            throw new FacebookException(response.getError().getErrorMessage());
        }
        CloudGameLoginHandler.setPackageName(response.getJSONObject(), context);
        try {
            AccessToken token = CloudGameLoginHandler.setCurrentAccessToken(response.getJSONObject());
            GamingPayload.loadPayloadFromCloudGame(response.getJSONObject().optString("payload"));
            Profile.fetchProfileForCurrentAccessToken();
            IS_RUNNING_IN_CLOUD = true;
            mLogger.logLoginSuccess();
            return token;
        }
        catch (JSONException ex) {
            throw new FacebookException("Cannot properly handle response.", (Throwable)ex);
        }
    }

    public static boolean isRunningInCloud() {
        return IS_RUNNING_IN_CLOUD;
    }

    private static boolean isCloudEnvReady(Context context, int timeoutInSec) {
        GraphResponse response = DaemonRequest.executeAndWait(context, null, SDKMessageEnum.IS_ENV_READY, timeoutInSec);
        if (response == null || response.getJSONObject() == null) {
            return false;
        }
        return response.getError() == null;
    }

    public static void gameLoadComplete(Context context) {
        mLogger = SDKLogger.getInstance(context);
        mLogger.logGameLoadComplete();
    }

    private static void setPackageName(JSONObject jsonObject, Context context) {
        String daemonPackageName = jsonObject.optString("daemonPackageName");
        if (daemonPackageName.isEmpty()) {
            throw new FacebookException("Could not establish a secure connection.");
        }
        SharedPreferences.Editor sharedPreferences = context.getSharedPreferences("com.facebook.gamingservices.cloudgaming:preferences", 0).edit();
        sharedPreferences.putString("daemonPackageName", daemonPackageName);
        sharedPreferences.commit();
    }

    @Nullable
    private static AccessToken setCurrentAccessToken(JSONObject jsonObject) throws JSONException {
        String token = jsonObject.optString("accessToken");
        String accessTokenSource = jsonObject.optString("accessTokenSource");
        String appID = jsonObject.optString("appID");
        String declinedPermissionsString = jsonObject.optString("declinedPermissions");
        String expiredPermissionsString = jsonObject.optString("expiredPermissions");
        String expirationTime = jsonObject.optString("expirationTime");
        String dataAccessExpirationTime = jsonObject.optString("dataAccessExpirationTime");
        String graphDomain = jsonObject.optString("graphDomain");
        String lastRefreshTime = jsonObject.optString("lastRefreshTime");
        String permissionsString = jsonObject.optString("permissions");
        String userID = jsonObject.optString("userID");
        String sessionID = jsonObject.optString("sessionID");
        if (token.isEmpty() || appID.isEmpty() || userID.isEmpty()) {
            return null;
        }
        if (mLogger != null) {
            mLogger.setAppID(appID);
            mLogger.setUserID(userID);
            mLogger.setSessionID(sessionID);
        }
        List<String> permissions = CloudGameLoginHandler.convertPermissionsStringIntoPermissionsList(permissionsString);
        List<String> declinedPermissions = CloudGameLoginHandler.convertPermissionsStringIntoPermissionsList(declinedPermissionsString);
        List<String> expiredPermissions = CloudGameLoginHandler.convertPermissionsStringIntoPermissionsList(expiredPermissionsString);
        AccessToken accessToken = new AccessToken(token, appID, userID, permissions, declinedPermissions, expiredPermissions, !accessTokenSource.isEmpty() ? AccessTokenSource.valueOf((String)accessTokenSource) : null, !expirationTime.isEmpty() ? new Date((long)Integer.parseInt(expirationTime) * 1000L) : null, !lastRefreshTime.isEmpty() ? new Date((long)Integer.parseInt(lastRefreshTime) * 1000L) : null, !dataAccessExpirationTime.isEmpty() ? new Date((long)Integer.parseInt(dataAccessExpirationTime) * 1000L) : null, !graphDomain.isEmpty() ? graphDomain : null);
        AccessToken.setCurrentAccessToken((AccessToken)accessToken);
        return accessToken;
    }

    private static List<String> convertPermissionsStringIntoPermissionsList(String permissionsString) throws JSONException {
        ArrayList<String> permissions = new ArrayList<String>();
        if (!permissionsString.isEmpty()) {
            JSONArray permissionsJSONArray = new JSONArray(permissionsString);
            for (int i = 0; i < permissionsJSONArray.length(); ++i) {
                permissions.add(permissionsJSONArray.get(i).toString());
            }
        }
        return permissions;
    }
}

