/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.bolts.TaskCompletionSource;
import com.facebook.gamingservices.GraphAPIException;
import com.facebook.gamingservices.Tournament;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a8\u0006\u0007"}, d2={"Lcom/facebook/gamingservices/TournamentFetcher;", "", "()V", "fetchTournaments", "Lcom/facebook/bolts/TaskCompletionSource;", "", "Lcom/facebook/gamingservices/Tournament;", "facebook-gamingservices_release"})
public final class TournamentFetcher {
    @NotNull
    public final TaskCompletionSource<List<Tournament>> fetchTournaments() {
        boolean isGamingLoggedIn;
        TaskCompletionSource task = new TaskCompletionSource();
        Bundle params = new Bundle();
        AccessToken currentAccessToken = AccessToken.Companion.getCurrentAccessToken();
        if (currentAccessToken == null || currentAccessToken.isExpired()) {
            throw (Throwable)new FacebookException("Attempted to fetch tournament with an invalid access token");
        }
        boolean bl = isGamingLoggedIn = currentAccessToken.getGraphDomain() != null && Intrinsics.areEqual((Object)"gaming", (Object)currentAccessToken.getGraphDomain());
        if (!isGamingLoggedIn) {
            throw (Throwable)new FacebookException("User is not using gaming login");
        }
        GraphRequest request2 = new GraphRequest(AccessToken.Companion.getCurrentAccessToken(), "me/tournaments", params, HttpMethod.GET, new GraphRequest.Callback(task){
            final /* synthetic */ TaskCompletionSource $task;

            public final void onCompleted(@NotNull GraphResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                GraphResponse graphResponse = response;
                boolean bl = false;
                boolean bl2 = false;
                GraphResponse graphResponse2 = graphResponse;
                boolean bl3 = false;
                if (graphResponse2.getError() != null) {
                    FacebookRequestError facebookRequestError = graphResponse2.getError();
                    if ((facebookRequestError != null ? facebookRequestError.getException() : null) != null) {
                        FacebookRequestError facebookRequestError2 = graphResponse2.getError();
                        this.$task.setError((Exception)(facebookRequestError2 != null ? facebookRequestError2.getException() : null));
                        return;
                    }
                    this.$task.setError((Exception)new GraphAPIException("Graph API Error"));
                    return;
                }
                try {
                    JSONObject jsonObject = graphResponse2.getJSONObject();
                    if (jsonObject == null) {
                        String errorMessage = "Failed to get response";
                        this.$task.setError((Exception)new GraphAPIException(errorMessage));
                        return;
                    }
                    JSONArray data = jsonObject.getJSONArray("data");
                    if (data == null || data.length() < 1) {
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        Locale locale = Locale.ROOT;
                        String string = "No tournament found";
                        Object[] objectArray = new Object[]{data.length(), 1};
                        boolean bl4 = false;
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
                        String errorMessage = string2;
                        this.$task.setError((Exception)new GraphAPIException(errorMessage));
                        return;
                    }
                    Gson gson = new GsonBuilder().create();
                    String string = data.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.toString()");
                    String dataString = string;
                    Object object = gson.fromJson(dataString, Tournament[].class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(dataString\u2026<Tournament>::class.java)");
                    List tournaments = ArraysKt.toList((Object[])((Object[])object));
                    this.$task.setResult((Object)tournaments);
                }
                catch (JSONException ex) {
                    this.$task.setError((Exception)((Object)ex));
                }
            }
            {
                this.$task = taskCompletionSource;
            }
        }, null, 32, null);
        request2.setParameters(params);
        request2.executeAsync();
        return task;
    }
}

