/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices.cloudgaming;

import android.content.Context;
import androidx.annotation.Nullable;
import com.facebook.gamingservices.cloudgaming.DaemonRequest;
import com.facebook.gamingservices.cloudgaming.internal.SDKLogger;
import com.facebook.gamingservices.cloudgaming.internal.SDKMessageEnum;
import org.json.JSONException;
import org.json.JSONObject;

public class InAppPurchaseLibrary {
    public static void onReady(Context context, DaemonRequest.Callback callback) {
        DaemonRequest.executeAsync(context, null, callback, SDKMessageEnum.ON_READY);
    }

    public static void getCatalog(Context context, DaemonRequest.Callback callback) {
        DaemonRequest.executeAsync(context, null, callback, SDKMessageEnum.GET_CATALOG);
    }

    public static void getPurchases(Context context, DaemonRequest.Callback callback) {
        DaemonRequest.executeAsync(context, null, callback, SDKMessageEnum.GET_PURCHASES);
    }

    public static void purchase(Context context, String productID, @Nullable String developerPayload, DaemonRequest.Callback callback) {
        try {
            JSONObject parameters = new JSONObject().put("productID", (Object)productID).put("developerPayload", (Object)developerPayload);
            DaemonRequest.executeAsync(context, parameters, callback, SDKMessageEnum.PURCHASE);
        }
        catch (JSONException e) {
            SDKLogger.logInternalError(context, SDKMessageEnum.PURCHASE, (Exception)((Object)e));
        }
    }

    public static void consumePurchase(Context context, String purchaseToken, DaemonRequest.Callback callback) {
        try {
            JSONObject parameters = new JSONObject().put("purchaseToken", (Object)purchaseToken);
            DaemonRequest.executeAsync(context, parameters, callback, SDKMessageEnum.CONSUME_PURCHASE);
        }
        catch (JSONException e) {
            SDKLogger.logInternalError(context, SDKMessageEnum.CONSUME_PURCHASE, (Exception)((Object)e));
        }
    }
}

