/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.app.Activity;
import android.app.Fragment;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.gamingservices.ContextChooseDialog;
import com.facebook.gamingservices.GamingContext;
import com.facebook.gamingservices.cloudgaming.CloudGameLoginHandler;
import com.facebook.gamingservices.cloudgaming.DaemonRequest;
import com.facebook.gamingservices.cloudgaming.internal.SDKMessageEnum;
import com.facebook.gamingservices.model.ContextChooseContent;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.CustomTabUtils;
import com.facebook.internal.DialogPresenter;
import com.facebook.internal.FacebookDialogBase;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.NativeProtocol;
import com.facebook.share.internal.ResultProcessor;
import com.facebook.share.internal.ShareInternalUtility;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 $2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0004#$%&B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0012\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0014J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0014R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u0018\u0012\u0014\u0012\u00120\u0013R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00010\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/facebook/gamingservices/ContextChooseDialog;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/gamingservices/model/ContextChooseContent;", "Lcom/facebook/gamingservices/ContextChooseDialog$Result;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;)V", "Landroid/app/Fragment;", "(Landroid/app/Fragment;)V", "fragmentWrapper", "Lcom/facebook/internal/FragmentWrapper;", "(Lcom/facebook/internal/FragmentWrapper;)V", "callback", "Lcom/facebook/FacebookCallback;", "orderedModeHandlers", "", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "getOrderedModeHandlers", "()Ljava/util/List;", "canShow", "", "content", "createBaseAppCall", "Lcom/facebook/internal/AppCall;", "registerCallbackImpl", "", "callbackManager", "Lcom/facebook/internal/CallbackManagerImpl;", "showForCloud", "showImpl", "mode", "", "ChromeCustomTabHandler", "Companion", "FacebookAppHandler", "Result", "facebook-gamingservices_release"})
public final class ContextChooseDialog
extends FacebookDialogBase<ContextChooseContent, Result> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FacebookCallback<Result> callback;
    private static final int DEFAULT_REQUEST_CODE = CallbackManagerImpl.RequestCodeOffset.GamingContextChoose.toRequestCode();
    @NotNull
    private static final String CONTEXT_CHOOSE_DIALOG = "context_choose";

    public ContextChooseDialog(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super(activity, DEFAULT_REQUEST_CODE);
    }

    public ContextChooseDialog(@NotNull androidx.fragment.app.Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(new FragmentWrapper(fragment));
    }

    public ContextChooseDialog(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(new FragmentWrapper(fragment));
    }

    private ContextChooseDialog(FragmentWrapper fragmentWrapper) {
        super(fragmentWrapper, DEFAULT_REQUEST_CODE);
    }

    public boolean canShow(@NotNull ContextChooseContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return CloudGameLoginHandler.isRunningInCloud() || new FacebookAppHandler().canShow(content, true) || new ChromeCustomTabHandler().canShow(content, true);
    }

    protected void showImpl(@NotNull ContextChooseContent content, @NotNull Object mode) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        if (CloudGameLoginHandler.isRunningInCloud()) {
            this.showForCloud(content);
        } else {
            super.showImpl((Object)content, mode);
        }
    }

    private final void showForCloud(ContextChooseContent content) {
        block5: {
            AccessToken currentAccessToken = AccessToken.Companion.getCurrentAccessToken();
            if (currentAccessToken == null || currentAccessToken.isExpired()) {
                throw new FacebookException("Attempted to open ContextChooseContent with an invalid access token");
            }
            DaemonRequest.Callback requestCallback = arg_0 -> ContextChooseDialog.showForCloud$lambda-2(this, arg_0);
            JSONObject parameters = new JSONObject();
            try {
                parameters.put("filters", content.getFilters());
                parameters.put("minSize", (Object)content.getMinSize());
                List<String> list = content.getFilters();
                if (list != null) {
                    List<String> list2 = list;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<String> it = list2;
                    boolean bl3 = false;
                    JSONArray filtersArray = new JSONArray();
                    for (String filter : it) {
                        filtersArray.put((Object)filter);
                    }
                    parameters.put("filters", (Object)filtersArray);
                }
                DaemonRequest.executeAsync((Context)this.getActivityContext(), parameters, requestCallback, SDKMessageEnum.CONTEXT_CHOOSE);
            }
            catch (JSONException e) {
                FacebookCallback<Result> facebookCallback = this.callback;
                if (facebookCallback == null) break block5;
                facebookCallback.onError(new FacebookException("Couldn't prepare Context Choose Dialog"));
            }
        }
    }

    protected void registerCallbackImpl(@NotNull CallbackManagerImpl callbackManager, @NotNull FacebookCallback<Result> callback) {
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callback = callback;
        ResultProcessor resultProcessor2 = new ResultProcessor(callback){
            final /* synthetic */ FacebookCallback<Result> $callback;
            {
                this.$callback = $callback;
                super($callback);
            }

            public void onSuccess(@NotNull AppCall appCall, @Nullable Bundle results) {
                Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
                if (results != null) {
                    if (results.getString("error_message") != null) {
                        this.$callback.onError(new FacebookException(results.getString("error_message")));
                        return;
                    }
                    String contextId = results.getString("id");
                    if (contextId != null) {
                        GamingContext.Companion.setCurrentGamingContext(new GamingContext(contextId));
                        this.$callback.onSuccess((Object)new Result(results));
                    }
                    this.$callback.onError(new FacebookException(results.getString("Invalid response received from server.")));
                } else {
                    this.onCancel(appCall);
                }
            }
        };
        callbackManager.registerCallback(this.getRequestCode(), (arg_0, arg_1) -> ContextChooseDialog.registerCallbackImpl$lambda-4(this, resultProcessor2, arg_0, arg_1));
    }

    @NotNull
    protected List<FacebookDialogBase.ModeHandler> getOrderedModeHandlers() {
        Object[] objectArray = new FacebookDialogBase.ModeHandler[]{new FacebookAppHandler(), new ChromeCustomTabHandler()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected AppCall createBaseAppCall() {
        return new AppCall(this.getRequestCode(), null, 2, null);
    }

    private static final void showForCloud$lambda-2(ContextChooseDialog this$0, GraphResponse response) {
        block3: {
            Unit unit;
            Unit unit2;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            FacebookCallback<Result> facebookCallback = this$0.callback;
            if (facebookCallback == null) break block3;
            FacebookCallback<Result> facebookCallback2 = facebookCallback;
            boolean bl = false;
            boolean bl2 = false;
            FacebookCallback<Result> callback = facebookCallback2;
            boolean bl3 = false;
            FacebookRequestError facebookRequestError = response.getError();
            if (facebookRequestError == null) {
                unit2 = null;
            } else {
                FacebookRequestError facebookRequestError2 = facebookRequestError;
                boolean bl4 = false;
                boolean bl5 = false;
                FacebookRequestError error = facebookRequestError2;
                boolean bl6 = false;
                callback.onError(new FacebookException(error.getErrorMessage()));
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit == null) {
                Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                callback.onSuccess((Object)new Result(response));
            }
        }
    }

    private static final boolean registerCallbackImpl$lambda-4(ContextChooseDialog this$0, registerCallbackImpl.resultProcessor.1 $resultProcessor, int resultCode, Intent data) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$resultProcessor), (String)"$resultProcessor");
        return ShareInternalUtility.handleActivityResult((int)this$0.getRequestCode(), (int)resultCode, (Intent)data, (ResultProcessor)$resultProcessor);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/facebook/gamingservices/ContextChooseDialog$Result;", "", "results", "Landroid/os/Bundle;", "(Landroid/os/Bundle;)V", "response", "Lcom/facebook/GraphResponse;", "(Lcom/facebook/GraphResponse;)V", "contextID", "", "getContextID", "()Ljava/lang/String;", "setContextID", "(Ljava/lang/String;)V", "facebook-gamingservices_release"})
    public static final class Result {
        @Nullable
        private String contextID;

        @Nullable
        public final String getContextID() {
            return this.contextID;
        }

        public final void setContextID(@Nullable String string) {
            this.contextID = string;
        }

        public Result(@NotNull Bundle results) {
            Intrinsics.checkNotNullParameter((Object)results, (String)"results");
            this.contextID = results.getString("id");
        }

        public Result(@NotNull GraphResponse response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            try {
                JSONObject jSONObject = response.getJSONObject();
                if (jSONObject != null) {
                    JSONObject jSONObject2 = jSONObject;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONObject data = jSONObject2;
                    boolean bl3 = false;
                    JSONObject jSONObject3 = data.optJSONObject("data");
                    if (jSONObject3 != null) {
                        JSONObject jSONObject4 = jSONObject3;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        JSONObject it = jSONObject4;
                        boolean bl6 = false;
                        this.setContextID(it.getString("id"));
                    }
                }
            }
            catch (JSONException e) {
                this.contextID = null;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00120\u0001R\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lcom/facebook/gamingservices/ContextChooseDialog$FacebookAppHandler;", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/gamingservices/model/ContextChooseContent;", "Lcom/facebook/gamingservices/ContextChooseDialog$Result;", "(Lcom/facebook/gamingservices/ContextChooseDialog;)V", "canShow", "", "content", "isBestEffort", "createAppCall", "Lcom/facebook/internal/AppCall;", "facebook-gamingservices_release"})
    private final class FacebookAppHandler
    extends FacebookDialogBase.ModeHandler {
        public FacebookAppHandler() {
            Intrinsics.checkNotNullParameter((Object)((Object)ContextChooseDialog.this), (String)"this$0");
            super((FacebookDialogBase)ContextChooseDialog.this);
        }

        public boolean canShow(@NotNull ContextChooseContent content, boolean isBestEffort) {
            AccessToken currentToken;
            ComponentName componentName;
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Activity activity = ContextChooseDialog.this.getActivityContext();
            PackageManager packageManager = activity == null ? null : activity.getPackageManager();
            Intent intent = new Intent("com.facebook.games.gaming_services.DEEPLINK");
            intent.setType("text/plain");
            PackageManager packageManager2 = packageManager;
            if (packageManager2 == null) {
                componentName = null;
            } else {
                PackageManager packageManager3 = packageManager2;
                boolean bl = false;
                boolean bl2 = false;
                PackageManager it = packageManager3;
                boolean bl3 = false;
                componentName = intent.resolveActivity(it);
            }
            boolean fbAppCanShow = componentName != null;
            AccessToken accessToken = currentToken = AccessToken.Companion.getCurrentAccessToken();
            boolean isGamingLoggedIn = (accessToken == null ? null : accessToken.getGraphDomain()) != null && Intrinsics.areEqual((Object)"gaming", (Object)currentToken.getGraphDomain());
            return fbAppCanShow && isGamingLoggedIn;
        }

        @NotNull
        public AppCall createAppCall(@NotNull ContextChooseContent content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            AppCall appCall = ContextChooseDialog.this.createBaseAppCall();
            Intent intent = new Intent("com.facebook.games.gaming_services.DEEPLINK");
            intent.setType("text/plain");
            AccessToken accessToken = AccessToken.Companion.getCurrentAccessToken();
            Bundle args = new Bundle();
            args.putString("deeplink", "CONTEXT_CHOOSE");
            if (accessToken != null) {
                args.putString("game_id", accessToken.getApplicationId());
            } else {
                args.putString("game_id", FacebookSdk.INSTANCE.getApplicationId());
            }
            if (content.getMinSize() != null) {
                args.putString("min_thread_size", content.getMinSize().toString());
            }
            if (content.getMaxSize() != null) {
                args.putString("max_thread_size", content.getMaxSize().toString());
            }
            if (content.getFilters() != null) {
                JSONArray jsonList = new JSONArray((Collection)content.getFilters());
                args.putString("filters", jsonList.toString());
            }
            NativeProtocol.setupProtocolRequestIntent((Intent)intent, (String)appCall.getCallId().toString(), (String)"", (int)NativeProtocol.INSTANCE.getLatestKnownVersion(), (Bundle)args);
            appCall.setRequestIntent(intent);
            return appCall;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00120\u0001R\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lcom/facebook/gamingservices/ContextChooseDialog$ChromeCustomTabHandler;", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/gamingservices/model/ContextChooseContent;", "Lcom/facebook/gamingservices/ContextChooseDialog$Result;", "(Lcom/facebook/gamingservices/ContextChooseDialog;)V", "canShow", "", "content", "isBestEffort", "createAppCall", "Lcom/facebook/internal/AppCall;", "facebook-gamingservices_release"})
    private final class ChromeCustomTabHandler
    extends FacebookDialogBase.ModeHandler {
        public ChromeCustomTabHandler() {
            Intrinsics.checkNotNullParameter((Object)((Object)ContextChooseDialog.this), (String)"this$0");
            super((FacebookDialogBase)ContextChooseDialog.this);
        }

        public boolean canShow(@NotNull ContextChooseContent content, boolean isBestEffort) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return CustomTabUtils.INSTANCE.getChromePackage() != null;
        }

        @NotNull
        public AppCall createAppCall(@NotNull ContextChooseContent content) {
            String string;
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            AppCall appCall = ContextChooseDialog.this.createBaseAppCall();
            AccessToken accessToken = AccessToken.Companion.getCurrentAccessToken();
            Bundle contextChooseParams = new Bundle();
            Bundle payload = new Bundle();
            Bundle filters = new Bundle();
            AccessToken accessToken2 = accessToken;
            String string2 = string = accessToken2 == null ? null : accessToken2.getApplicationId();
            contextChooseParams.putString("app_id", string == null ? FacebookSdk.INSTANCE.getApplicationId() : string);
            if (content.getMinSize() != null) {
                filters.putString("min_size", content.getMinSize().toString());
            }
            if (content.getMaxSize() != null) {
                filters.putString("max_size", content.getMaxSize().toString());
            }
            if (content.getFilters() != null) {
                JSONArray filterArray = new JSONArray((Collection)content.getFilters());
                filters.putString("filters", filterArray.toString());
            }
            payload.putString("filters", filters.toString());
            contextChooseParams.putString("payload", payload.toString());
            contextChooseParams.putString("redirect_uri", CustomTabUtils.INSTANCE.getDefaultRedirectURI());
            DialogPresenter.setupAppCallForCustomTabDialog((AppCall)appCall, (String)ContextChooseDialog.CONTEXT_CHOOSE_DIALOG, (Bundle)contextChooseParams);
            return appCall;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/gamingservices/ContextChooseDialog$Companion;", "", "()V", "CONTEXT_CHOOSE_DIALOG", "", "DEFAULT_REQUEST_CODE", "", "facebook-gamingservices_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

