/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.gamingservices.cloudgaming.CloudGameLoginHandler;
import com.facebook.gamingservices.cloudgaming.DaemonRequest;
import com.facebook.gamingservices.cloudgaming.internal.SDKMessageEnum;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenGamingMediaDialog
implements GraphRequest.OnProgressCallback {
    private Context context;
    private GraphRequest.Callback nestedCallback;

    public OpenGamingMediaDialog(Context context) {
        this(context, null);
    }

    public OpenGamingMediaDialog(Context context, GraphRequest.Callback callback) {
        this.context = context;
        this.nestedCallback = callback;
    }

    public void onCompleted(GraphResponse response) {
        if (this.nestedCallback != null) {
            this.nestedCallback.onCompleted(response);
        }
        if (response == null || response.getError() != null) {
            return;
        }
        String id = response.getJSONObject().optString("id", null);
        String video_id = response.getJSONObject().optString("video_id", null);
        if (id == null && video_id == null) {
            return;
        }
        id = id != null ? id : video_id;
        boolean isRunningInCloud = CloudGameLoginHandler.isRunningInCloud();
        if (isRunningInCloud) {
            JSONObject parameters = new JSONObject();
            try {
                parameters.put("id", (Object)id);
                parameters.put("deepLink", (Object)"MEDIA_ASSET");
                DaemonRequest.executeAsync(this.context, parameters, null, SDKMessageEnum.OPEN_GAMING_SERVICES_DEEP_LINK);
            }
            catch (JSONException jSONException) {}
        } else {
            String dialog_uri = "https://fb.gg/me/media_asset/" + id;
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)dialog_uri));
            this.context.startActivity(intent);
        }
    }

    public void onProgress(long current, long max) {
        if (this.nestedCallback != null && this.nestedCallback instanceof GraphRequest.OnProgressCallback) {
            ((GraphRequest.OnProgressCallback)this.nestedCallback).onProgress(current, max);
        }
    }
}

