/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.bolts.TaskCompletionSource;
import com.facebook.gamingservices.GraphAPIException;
import com.facebook.gamingservices.Tournament;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a8\u0006\u0007"}, d2={"Lcom/facebook/gamingservices/TournamentFetcher;", "", "()V", "fetchTournaments", "Lcom/facebook/bolts/TaskCompletionSource;", "", "Lcom/facebook/gamingservices/Tournament;", "facebook-gamingservices_release"})
public final class TournamentFetcher {
    @NotNull
    public final TaskCompletionSource<List<Tournament>> fetchTournaments() {
        boolean isGamingLoggedIn;
        TaskCompletionSource task = new TaskCompletionSource();
        Bundle params = new Bundle();
        AccessToken currentAccessToken = AccessToken.Companion.getCurrentAccessToken();
        if (currentAccessToken == null || currentAccessToken.isExpired()) {
            throw new FacebookException("Attempted to fetch tournament with an invalid access token");
        }
        boolean bl = isGamingLoggedIn = currentAccessToken.getGraphDomain() != null && Intrinsics.areEqual((Object)"gaming", (Object)currentAccessToken.getGraphDomain());
        if (!isGamingLoggedIn) {
            throw new FacebookException("User is not using gaming login");
        }
        GraphRequest request = new GraphRequest(AccessToken.Companion.getCurrentAccessToken(), "me/tournaments", params, HttpMethod.GET, arg_0 -> TournamentFetcher.fetchTournaments$lambda$1(task, arg_0), null, 32, null);
        request.setParameters(params);
        request.executeAsync();
        return task;
    }

    private static final void fetchTournaments$lambda$1(TaskCompletionSource $task, GraphResponse response) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        GraphResponse graphResponse = response;
        boolean bl = false;
        if (graphResponse.getError() != null) {
            FacebookRequestError facebookRequestError = graphResponse.getError();
            if ((facebookRequestError != null ? facebookRequestError.getException() : null) != null) {
                FacebookRequestError facebookRequestError2 = graphResponse.getError();
                $task.setError((Exception)(facebookRequestError2 != null ? facebookRequestError2.getException() : null));
                return;
            }
            $task.setError((Exception)new GraphAPIException("Graph API Error"));
            return;
        }
        try {
            JSONObject jsonObject = graphResponse.getJSONObject();
            if (jsonObject == null) {
                String errorMessage = "Failed to get response";
                $task.setError((Exception)new GraphAPIException(errorMessage));
                return;
            }
            JSONArray data = jsonObject.getJSONArray("data");
            if (data.length() < 1) {
                Locale locale = Locale.ROOT;
                String string = "No tournament found";
                Object[] objectArray = new Object[]{data.length(), 1};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
                String errorMessage = string2;
                $task.setError((Exception)new GraphAPIException(errorMessage));
                return;
            }
            Gson gson = new GsonBuilder().create();
            String string = data.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.toString()");
            String dataString = string;
            Object object = gson.fromJson(dataString, Tournament[].class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(dataString\u2026<Tournament>::class.java)");
            List tournaments = ArraysKt.toList((Object[])((Object[])object));
            $task.setResult((Object)tournaments);
        }
        catch (JSONException ex) {
            $task.setError((Exception)((Object)ex));
        }
    }
}

