/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.gamingservices.Tournament;
import com.facebook.gamingservices.TournamentConfig;
import com.facebook.gamingservices.cloudgaming.CloudGameLoginHandler;
import com.facebook.gamingservices.internal.TournamentShareDialogURIBuilder;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.FacebookDialogBase;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import com.facebook.share.internal.ResultProcessor;
import com.facebook.share.internal.ShareInternalUtility;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0007\u0018\u0000 /2\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001:\u0004./01B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0012\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010 \u001a\u00020!H\u0014J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030'H\u0014J\u0016\u0010(\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010(\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u0002J\u001a\u0010*\u001a\u00020#2\b\u0010+\u001a\u0004\u0018\u00010\u00022\u0006\u0010,\u001a\u00020-H\u0014R.\u0010\u000f\u001a\u001c\u0012\u0018\u0012\u00160\u0011R\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00010\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u00062"}, d2={"Lcom/facebook/gamingservices/TournamentShareDialog;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/gamingservices/TournamentConfig;", "Lcom/facebook/gamingservices/TournamentShareDialog$Result;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;)V", "Landroid/app/Fragment;", "(Landroid/app/Fragment;)V", "fragmentWrapper", "Lcom/facebook/internal/FragmentWrapper;", "(Lcom/facebook/internal/FragmentWrapper;)V", "orderedModeHandlers", "", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "getOrderedModeHandlers", "()Ljava/util/List;", "score", "", "getScore", "()Ljava/lang/Number;", "setScore", "(Ljava/lang/Number;)V", "tournament", "Lcom/facebook/gamingservices/Tournament;", "getTournament", "()Lcom/facebook/gamingservices/Tournament;", "setTournament", "(Lcom/facebook/gamingservices/Tournament;)V", "createBaseAppCall", "Lcom/facebook/internal/AppCall;", "registerCallbackImpl", "", "callbackManager", "Lcom/facebook/internal/CallbackManagerImpl;", "callback", "Lcom/facebook/FacebookCallback;", "show", "newTournamentConfig", "showImpl", "content", "mode", "", "AppSwitchHandler", "Companion", "FacebookAppHandler", "Result", "facebook-gamingservices_release"})
@AutoHandleExceptions
public final class TournamentShareDialog
extends FacebookDialogBase<TournamentConfig, Result> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Number score;
    @Nullable
    private Tournament tournament;
    private static final int defaultRequestCode = CallbackManagerImpl.RequestCodeOffset.TournamentShareDialog.toRequestCode();

    @Nullable
    public final Number getScore() {
        return this.score;
    }

    public final void setScore(@Nullable Number number) {
        this.score = number;
    }

    @Nullable
    public final Tournament getTournament() {
        return this.tournament;
    }

    public final void setTournament(@Nullable Tournament tournament) {
        this.tournament = tournament;
    }

    public TournamentShareDialog(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super(activity, defaultRequestCode);
    }

    public TournamentShareDialog(@NotNull androidx.fragment.app.Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(new FragmentWrapper(fragment));
    }

    public TournamentShareDialog(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(new FragmentWrapper(fragment));
    }

    private TournamentShareDialog(FragmentWrapper fragmentWrapper) {
        super(fragmentWrapper, defaultRequestCode);
    }

    public final void show(@NotNull Number score, @NotNull TournamentConfig newTournamentConfig) {
        Intrinsics.checkNotNullParameter((Object)score, (String)"score");
        Intrinsics.checkNotNullParameter((Object)newTournamentConfig, (String)"newTournamentConfig");
        this.score = score;
        this.showImpl(newTournamentConfig, FacebookDialogBase.BASE_AUTOMATIC_MODE);
    }

    public final void show(@NotNull Number score, @NotNull Tournament tournament) {
        Intrinsics.checkNotNullParameter((Object)score, (String)"score");
        Intrinsics.checkNotNullParameter((Object)tournament, (String)"tournament");
        this.score = score;
        this.tournament = tournament;
        this.showImpl(null, FacebookDialogBase.BASE_AUTOMATIC_MODE);
    }

    protected void showImpl(@Nullable TournamentConfig content, @NotNull Object mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        if (CloudGameLoginHandler.isRunningInCloud()) {
            return;
        }
        super.showImpl((Object)content, mode);
    }

    protected void registerCallbackImpl(@NotNull CallbackManagerImpl callbackManager, @NotNull FacebookCallback<Result> callback) {
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ResultProcessor resultProcessor2 = new ResultProcessor(callback){
            final /* synthetic */ FacebookCallback<Result> $callback;
            {
                this.$callback = $callback;
                super($callback);
            }

            public void onSuccess(@NotNull AppCall appCall, @Nullable Bundle results) {
                Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
                if (results != null) {
                    if (results.getString("error_message") != null) {
                        this.$callback.onError(new FacebookException(results.getString("error_message")));
                        return;
                    }
                    if (results.getString("tournament_id") != null) {
                        this.$callback.onSuccess((Object)new Result(results));
                        return;
                    }
                }
                this.onCancel(appCall);
            }
        };
        callbackManager.registerCallback(this.getRequestCode(), (arg_0, arg_1) -> TournamentShareDialog.registerCallbackImpl$lambda$0(this, resultProcessor2, arg_0, arg_1));
    }

    @NotNull
    protected List<FacebookDialogBase.ModeHandler> getOrderedModeHandlers() {
        ArrayList<FacebookDialogBase.ModeHandler> handlers = new ArrayList<FacebookDialogBase.ModeHandler>();
        handlers.add(new FacebookAppHandler());
        handlers.add(new AppSwitchHandler());
        return handlers;
    }

    @NotNull
    protected AppCall createBaseAppCall() {
        return new AppCall(this.getRequestCode(), null, 2, null);
    }

    private static final boolean registerCallbackImpl$lambda$0(TournamentShareDialog this$0, ResultProcessor $resultProcessor, int resultCode, Intent data) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return ShareInternalUtility.handleActivityResult((int)this$0.getRequestCode(), (int)resultCode, (Intent)data, (ResultProcessor)$resultProcessor);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00160\u0001R\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006\f"}, d2={"Lcom/facebook/gamingservices/TournamentShareDialog$AppSwitchHandler;", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/gamingservices/TournamentConfig;", "Lcom/facebook/gamingservices/TournamentShareDialog$Result;", "(Lcom/facebook/gamingservices/TournamentShareDialog;)V", "canShow", "", "content", "isBestEffort", "createAppCall", "Lcom/facebook/internal/AppCall;", "facebook-gamingservices_release"})
    private final class AppSwitchHandler
    extends FacebookDialogBase.ModeHandler {
        public AppSwitchHandler() {
            super((FacebookDialogBase)TournamentShareDialog.this);
        }

        public boolean canShow(@Nullable TournamentConfig content, boolean isBestEffort) {
            return true;
        }

        @NotNull
        public AppCall createAppCall(@Nullable TournamentConfig content) {
            Uri uri;
            AppCall appCall = TournamentShareDialog.this.createBaseAppCall();
            AccessToken currentAccessToken = AccessToken.Companion.getCurrentAccessToken();
            if (currentAccessToken == null || currentAccessToken.isExpired()) {
                throw new FacebookException("Attempted to share tournament with an invalid access token");
            }
            if (currentAccessToken.getGraphDomain() != null && !Intrinsics.areEqual((Object)"gaming", (Object)currentAccessToken.getGraphDomain())) {
                throw new FacebookException("Attempted to share tournament without without gaming login");
            }
            Number number = TournamentShareDialog.this.getScore();
            if (number == null) {
                throw new FacebookException("Attempted to share tournament without a score");
            }
            Number score = number;
            if (content != null) {
                uri = TournamentShareDialogURIBuilder.INSTANCE.uriForCreating$facebook_gamingservices_release(content, score, currentAccessToken.getApplicationId());
            } else {
                Tournament tournament = TournamentShareDialog.this.getTournament();
                if (tournament != null) {
                    Tournament it = tournament;
                    boolean bl = false;
                    uri = TournamentShareDialogURIBuilder.INSTANCE.uriForUpdating$facebook_gamingservices_release(it.identifier, score, currentAccessToken.getApplicationId());
                } else {
                    uri = null;
                }
            }
            Uri uri2 = uri;
            Intent intent = new Intent("android.intent.action.VIEW", uri2);
            TournamentShareDialog.this.startActivityForResult(intent, TournamentShareDialog.this.getRequestCode());
            return appCall;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/gamingservices/TournamentShareDialog$Companion;", "", "()V", "defaultRequestCode", "", "facebook-gamingservices_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00160\u0001R\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006\f"}, d2={"Lcom/facebook/gamingservices/TournamentShareDialog$FacebookAppHandler;", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/gamingservices/TournamentConfig;", "Lcom/facebook/gamingservices/TournamentShareDialog$Result;", "(Lcom/facebook/gamingservices/TournamentShareDialog;)V", "canShow", "", "content", "isBestEffort", "createAppCall", "Lcom/facebook/internal/AppCall;", "facebook-gamingservices_release"})
    private final class FacebookAppHandler
    extends FacebookDialogBase.ModeHandler {
        public FacebookAppHandler() {
            super((FacebookDialogBase)TournamentShareDialog.this);
        }

        public boolean canShow(@Nullable TournamentConfig content, boolean isBestEffort) {
            PackageManager packageManager = FacebookSdk.getApplicationContext().getPackageManager();
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"getApplicationContext().packageManager");
            PackageManager packageManager2 = packageManager;
            Intent intent = new Intent("com.facebook.games.gaming_services.DEEPLINK");
            intent.setType("text/plain");
            boolean fbAppCanShow = intent.resolveActivity(packageManager2) != null;
            return fbAppCanShow;
        }

        @NotNull
        public AppCall createAppCall(@Nullable TournamentConfig content) {
            Bundle bundle;
            AccessToken currentAccessToken = AccessToken.Companion.getCurrentAccessToken();
            AppCall appCall = TournamentShareDialog.this.createBaseAppCall();
            Intent intent = new Intent("com.facebook.games.gaming_services.DEEPLINK");
            intent.setType("text/plain");
            if (currentAccessToken == null || currentAccessToken.isExpired()) {
                throw new FacebookException("Attempted to share tournament with an invalid access token");
            }
            if (currentAccessToken.getGraphDomain() != null && !Intrinsics.areEqual((Object)"gaming", (Object)currentAccessToken.getGraphDomain())) {
                throw new FacebookException("Attempted to share tournament while user is not gaming logged in");
            }
            String appID = currentAccessToken.getApplicationId();
            Number number = TournamentShareDialog.this.getScore();
            if (number == null) {
                throw new FacebookException("Attempted to share tournament without a score");
            }
            Number score = number;
            if (content != null) {
                bundle = TournamentShareDialogURIBuilder.INSTANCE.bundleForCreating$facebook_gamingservices_release(content, score, appID);
            } else {
                Tournament tournament = TournamentShareDialog.this.getTournament();
                if (tournament != null) {
                    Tournament it = tournament;
                    boolean bl = false;
                    bundle = TournamentShareDialogURIBuilder.INSTANCE.bundleForUpdating$facebook_gamingservices_release(it.identifier, score, appID);
                } else {
                    bundle = null;
                }
            }
            Bundle args = bundle;
            NativeProtocol.setupProtocolRequestIntent((Intent)intent, (String)appCall.getCallId().toString(), (String)"", (int)20210906, (Bundle)args);
            appCall.setRequestIntent(intent);
            return appCall;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/facebook/gamingservices/TournamentShareDialog$Result;", "", "results", "Landroid/os/Bundle;", "(Landroid/os/Bundle;)V", "requestID", "", "getRequestID", "()Ljava/lang/String;", "setRequestID", "(Ljava/lang/String;)V", "tournamentID", "getTournamentID", "setTournamentID", "facebook-gamingservices_release"})
    public static final class Result {
        @Nullable
        private String requestID;
        @Nullable
        private String tournamentID;

        @Nullable
        public final String getRequestID() {
            return this.requestID;
        }

        public final void setRequestID(@Nullable String string) {
            this.requestID = string;
        }

        @Nullable
        public final String getTournamentID() {
            return this.tournamentID;
        }

        public final void setTournamentID(@Nullable String string) {
            this.tournamentID = string;
        }

        public Result(@NotNull Bundle results) {
            Intrinsics.checkNotNullParameter((Object)results, (String)"results");
            if (results.getString("request") != null) {
                this.requestID = results.getString("request");
            }
            this.tournamentID = results.getString("tournament_id");
        }
    }
}

