/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.bolts.TaskCompletionSource;
import com.facebook.gamingservices.GraphAPIException;
import com.facebook.gamingservices.Tournament;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lcom/facebook/gamingservices/TournamentUpdater;", "", "()V", "update", "Lcom/facebook/bolts/TaskCompletionSource;", "", "tournament", "Lcom/facebook/gamingservices/Tournament;", "score", "", "identifier", "", "facebook-gamingservices_release"})
public final class TournamentUpdater {
    @Nullable
    public final TaskCompletionSource<Boolean> update(@NotNull Tournament tournament, @NotNull Number score) {
        Intrinsics.checkNotNullParameter((Object)tournament, (String)"tournament");
        Intrinsics.checkNotNullParameter((Object)score, (String)"score");
        return this.update(tournament.identifier, score);
    }

    @Nullable
    public final TaskCompletionSource<Boolean> update(@NotNull String identifier, @NotNull Number score) {
        boolean isGamingLoggedIn;
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)score, (String)"score");
        AccessToken currentAccessToken = AccessToken.Companion.getCurrentAccessToken();
        if (currentAccessToken == null || currentAccessToken.isExpired()) {
            throw new FacebookException("Attempted to fetch tournament with an invalid access token");
        }
        boolean bl = isGamingLoggedIn = currentAccessToken.getGraphDomain() != null && Intrinsics.areEqual((Object)"gaming", (Object)currentAccessToken.getGraphDomain());
        if (!isGamingLoggedIn) {
            throw new FacebookException("User is not using gaming login");
        }
        TaskCompletionSource task = new TaskCompletionSource();
        String graphPath = identifier + "/update_score";
        Bundle params = new Bundle();
        params.putInt("score", score.intValue());
        GraphRequest request = new GraphRequest(currentAccessToken, graphPath, params, HttpMethod.POST, arg_0 -> TournamentUpdater.update$lambda$0(task, arg_0), null, 32, null);
        request.executeAsync();
        return task;
    }

    private static final void update$lambda$0(TaskCompletionSource $task, GraphResponse response) {
        String result;
        JSONObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.getError() != null) {
            FacebookRequestError facebookRequestError = response.getError();
            if ((facebookRequestError != null ? facebookRequestError.getException() : null) != null) {
                FacebookRequestError facebookRequestError2 = response.getError();
                $task.setError((Exception)(facebookRequestError2 != null ? facebookRequestError2.getException() : null));
                return;
            }
            $task.setError((Exception)new GraphAPIException("Graph API Error"));
            return;
        }
        JSONObject jSONObject = jsonObject = response.getJSONObject();
        String string = result = jSONObject != null ? jSONObject.optString("success") : null;
        if (result == null || ((CharSequence)result).length() == 0) {
            String errorMessage = "Graph API Error";
            $task.setError((Exception)new GraphAPIException(errorMessage));
            return;
        }
        boolean success = result.equals("true");
        $task.setResult((Object)success);
    }
}

