/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices.internal;

import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.facebook.gamingservices.TournamentConfig;
import com.facebook.gamingservices.internal.TournamentScoreType;
import com.facebook.gamingservices.internal.TournamentSortOrder;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000fJ%\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0012J%\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0015J%\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/gamingservices/internal/TournamentShareDialogURIBuilder;", "", "()V", "authority", "", "me", "scheme", "tournament", "bundleForCreating", "Landroid/os/Bundle;", "config", "Lcom/facebook/gamingservices/TournamentConfig;", "score", "", "appID", "bundleForCreating$facebook_gamingservices_release", "bundleForUpdating", "tournamentID", "bundleForUpdating$facebook_gamingservices_release", "uriForCreating", "Landroid/net/Uri;", "uriForCreating$facebook_gamingservices_release", "uriForUpdating", "uriForUpdating$facebook_gamingservices_release", "facebook-gamingservices_release"})
@SourceDebugExtension(value={"SMAP\nTournamentShareDialogURIBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TournamentShareDialogURIBuilder.kt\ncom/facebook/gamingservices/internal/TournamentShareDialogURIBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class TournamentShareDialogURIBuilder {
    @NotNull
    public static final TournamentShareDialogURIBuilder INSTANCE = new TournamentShareDialogURIBuilder();
    @NotNull
    public static final String scheme = "https";
    @NotNull
    public static final String authority = "fb.gg";
    @NotNull
    public static final String me = "me";
    @NotNull
    public static final String tournament = "instant_tournament";

    private TournamentShareDialogURIBuilder() {
    }

    @NotNull
    public final Uri uriForUpdating$facebook_gamingservices_release(@NotNull String tournamentID, @NotNull Number score, @NotNull String appID) {
        Intrinsics.checkNotNullParameter((Object)tournamentID, (String)"tournamentID");
        Intrinsics.checkNotNullParameter((Object)score, (String)"score");
        Intrinsics.checkNotNullParameter((Object)appID, (String)"appID");
        Uri uri = new Uri.Builder().scheme(scheme).authority(authority).appendPath(me).appendPath(tournament).appendPath(appID).appendQueryParameter("tournament_id", tournamentID).appendQueryParameter("score", score.toString()).build();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Builder()\n        .schem\u2026tring())\n        .build()");
        return uri;
    }

    @NotNull
    public final Uri uriForCreating$facebook_gamingservices_release(@NotNull TournamentConfig config, @NotNull Number score, @NotNull String appID) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)score, (String)"score");
        Intrinsics.checkNotNullParameter((Object)appID, (String)"appID");
        Uri.Builder builder = new Uri.Builder().scheme(scheme).authority(authority).appendPath(me).appendPath(tournament).appendPath(appID).appendQueryParameter("score", score.toString());
        Instant instant = config.getEndTime();
        if (instant != null) {
            it = instant;
            boolean bl = false;
            builder.appendQueryParameter("end_time", ((Instant)it).toString());
        }
        TournamentSortOrder tournamentSortOrder = config.getSortOrder();
        if (tournamentSortOrder != null) {
            it = tournamentSortOrder;
            boolean bl = false;
            builder.appendQueryParameter("sort_order", ((TournamentSortOrder)((Object)it)).toString());
        }
        TournamentScoreType tournamentScoreType = config.getScoreType();
        if (tournamentScoreType != null) {
            it = tournamentScoreType;
            boolean bl = false;
            builder.appendQueryParameter("score_format", ((Enum)it).toString());
        }
        String string = config.getTitle();
        if (string != null) {
            it = string;
            boolean bl = false;
            builder.appendQueryParameter("tournament_title", (String)it);
        }
        String string2 = config.getPayload();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            builder.appendQueryParameter("tournament_payload", (String)it);
        }
        Uri uri = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"builder.build()");
        return uri;
    }

    @NotNull
    public final Bundle bundleForUpdating$facebook_gamingservices_release(@NotNull String tournamentID, @NotNull Number score, @NotNull String appID) {
        Intrinsics.checkNotNullParameter((Object)tournamentID, (String)"tournamentID");
        Intrinsics.checkNotNullParameter((Object)score, (String)"score");
        Intrinsics.checkNotNullParameter((Object)appID, (String)"appID");
        Bundle args = new Bundle();
        args.putString("deeplink", "INSTANT_TOURNAMENT");
        args.putString("app_id", appID);
        args.putString("score", score.toString());
        args.putString("tournament_id", tournamentID);
        return args;
    }

    @NotNull
    public final Bundle bundleForCreating$facebook_gamingservices_release(@NotNull TournamentConfig config, @NotNull Number score, @NotNull String appID) {
        Bundle args;
        block5: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)score, (String)"score");
            Intrinsics.checkNotNullParameter((Object)appID, (String)"appID");
            args = new Bundle();
            args.putString("deeplink", "INSTANT_TOURNAMENT");
            args.putString("app_id", appID);
            args.putString("score", score.toString());
            TournamentSortOrder tournamentSortOrder = config.getSortOrder();
            if (tournamentSortOrder != null) {
                it = tournamentSortOrder;
                boolean bl = false;
                args.putString("sort_order", ((TournamentSortOrder)((Object)it)).toString());
            }
            TournamentScoreType tournamentScoreType = config.getScoreType();
            if (tournamentScoreType != null) {
                it = tournamentScoreType;
                boolean bl = false;
                args.putString("score_format", ((Enum)it).toString());
            }
            String string = config.getTitle();
            if (string != null) {
                it = string;
                boolean bl = false;
                args.putString("tournament_title", ((String)it).toString());
            }
            String string2 = config.getPayload();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                args.putString("tournament_payload", ((String)it).toString());
            }
            if (Build.VERSION.SDK_INT < 26) break block5;
            Instant instant = config.getEndTime();
            if (instant != null) {
                it = instant;
                boolean bl = false;
                int endTime = (int)((Instant)it).getEpochSecond();
                args.putString("end_time", String.valueOf(endTime));
            }
        }
        return args;
    }
}

