/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.app.Activity;
import android.app.Fragment;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.gamingservices.GamingContext;
import com.facebook.gamingservices.cloudgaming.CloudGameLoginHandler;
import com.facebook.gamingservices.cloudgaming.DaemonRequest;
import com.facebook.gamingservices.cloudgaming.internal.SDKMessageEnum;
import com.facebook.gamingservices.model.ContextCreateContent;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.DialogPresenter;
import com.facebook.internal.FacebookDialogBase;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.NativeProtocol;
import com.facebook.share.internal.ResultProcessor;
import com.facebook.share.internal.ShareInternalUtility;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 #2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0004#$%&B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0012\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0014J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0014R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u0018\u0012\u0014\u0012\u00120\u0013R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00010\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/facebook/gamingservices/ContextCreateDialog;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/gamingservices/model/ContextCreateContent;", "Lcom/facebook/gamingservices/ContextCreateDialog$Result;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;)V", "Landroid/app/Fragment;", "(Landroid/app/Fragment;)V", "fragmentWrapper", "Lcom/facebook/internal/FragmentWrapper;", "(Lcom/facebook/internal/FragmentWrapper;)V", "callback", "Lcom/facebook/FacebookCallback;", "orderedModeHandlers", "", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "getOrderedModeHandlers", "()Ljava/util/List;", "canShow", "", "content", "createBaseAppCall", "Lcom/facebook/internal/AppCall;", "registerCallbackImpl", "", "callbackManager", "Lcom/facebook/internal/CallbackManagerImpl;", "showForCloud", "showImpl", "mode", "", "Companion", "FacebookAppHandler", "Result", "WebHandler", "facebook-gamingservices_release"})
@SourceDebugExtension(value={"SMAP\nContextCreateDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextCreateDialog.kt\ncom/facebook/gamingservices/ContextCreateDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1#2:217\n*E\n"})
public final class ContextCreateDialog
extends FacebookDialogBase<ContextCreateContent, Result> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FacebookCallback<Result> callback;
    private static final int DEFAULT_REQUEST_CODE = CallbackManagerImpl.RequestCodeOffset.GamingContextCreate.toRequestCode();

    public ContextCreateDialog(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super(activity, DEFAULT_REQUEST_CODE);
    }

    public ContextCreateDialog(@NotNull androidx.fragment.app.Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(new FragmentWrapper(fragment));
    }

    public ContextCreateDialog(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this(new FragmentWrapper(fragment));
    }

    private ContextCreateDialog(FragmentWrapper fragmentWrapper) {
        super(fragmentWrapper, DEFAULT_REQUEST_CODE);
    }

    public boolean canShow(@NotNull ContextCreateContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return CloudGameLoginHandler.isRunningInCloud() || new FacebookAppHandler().canShow(content, true) || new WebHandler().canShow(content, true);
    }

    protected void showImpl(@NotNull ContextCreateContent content, @NotNull Object mode) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        if (CloudGameLoginHandler.isRunningInCloud()) {
            this.showForCloud(content);
        } else {
            super.showImpl((Object)content, mode);
        }
    }

    private final void showForCloud(ContextCreateContent content) {
        block4: {
            AccessToken currentAccessToken = AccessToken.Companion.getCurrentAccessToken();
            if (currentAccessToken == null || currentAccessToken.isExpired()) {
                throw new FacebookException("Attempted to open ContextCreateContent with an invalid access token");
            }
            DaemonRequest.Callback requestCallback = arg_0 -> ContextCreateDialog.showForCloud$lambda$2(this, arg_0);
            JSONObject parameters = new JSONObject();
            try {
                if (content.getSuggestedPlayerID() != null) {
                    parameters.put("id", (Object)content.getSuggestedPlayerID());
                }
                DaemonRequest.executeAsync((Context)this.getActivityContext(), parameters, requestCallback, SDKMessageEnum.CONTEXT_CREATE);
            }
            catch (JSONException e) {
                FacebookCallback<Result> facebookCallback = this.callback;
                if (facebookCallback == null) break block4;
                facebookCallback.onError(new FacebookException("Couldn't prepare Context Create Dialog"));
            }
        }
    }

    protected void registerCallbackImpl(@NotNull CallbackManagerImpl callbackManager, @NotNull FacebookCallback<Result> callback) {
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callback = callback;
        ResultProcessor resultProcessor2 = new ResultProcessor(callback){
            final /* synthetic */ FacebookCallback<Result> $callback;
            {
                this.$callback = $callback;
                super($callback);
            }

            public void onSuccess(@NotNull AppCall appCall, @Nullable Bundle results) {
                Intrinsics.checkNotNullParameter((Object)appCall, (String)"appCall");
                if (results != null) {
                    if (results.getString("error_message") != null) {
                        this.$callback.onError(new FacebookException(results.getString("error_message")));
                        return;
                    }
                    String contextId = results.getString("id");
                    String contextContextId = results.getString("context_id");
                    if (contextId != null) {
                        GamingContext.Companion.setCurrentGamingContext(new GamingContext(contextId));
                        this.$callback.onSuccess((Object)new Result(contextId));
                    } else if (contextContextId != null) {
                        GamingContext.Companion.setCurrentGamingContext(new GamingContext(contextContextId));
                        this.$callback.onSuccess((Object)new Result(contextContextId));
                    }
                    this.$callback.onError(new FacebookException(results.getString("Invalid response received from server.")));
                } else {
                    this.onCancel(appCall);
                }
            }
        };
        callbackManager.registerCallback(this.getRequestCode(), (arg_0, arg_1) -> ContextCreateDialog.registerCallbackImpl$lambda$3(this, resultProcessor2, arg_0, arg_1));
    }

    @NotNull
    protected List<FacebookDialogBase.ModeHandler> getOrderedModeHandlers() {
        Object[] objectArray = new FacebookDialogBase.ModeHandler[]{new FacebookAppHandler(), new WebHandler()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected AppCall createBaseAppCall() {
        return new AppCall(this.getRequestCode(), null, 2, null);
    }

    private static final void showForCloud$lambda$2(ContextCreateDialog this$0, GraphResponse response) {
        block3: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            FacebookCallback<Result> facebookCallback = this$0.callback;
            if (facebookCallback == null) break block3;
            FacebookCallback<Result> callback = facebookCallback;
            boolean bl = false;
            FacebookRequestError facebookRequestError = response.getError();
            if (facebookRequestError != null) {
                FacebookRequestError error = facebookRequestError;
                boolean bl2 = false;
                callback.onError(new FacebookException(error.getErrorMessage()));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                callback.onSuccess((Object)new Result(response));
            }
        }
    }

    private static final boolean registerCallbackImpl$lambda$3(ContextCreateDialog this$0, ResultProcessor $resultProcessor, int resultCode, Intent data) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$resultProcessor, (String)"$resultProcessor");
        return ShareInternalUtility.handleActivityResult((int)this$0.getRequestCode(), (int)resultCode, (Intent)data, (ResultProcessor)$resultProcessor);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/gamingservices/ContextCreateDialog$Companion;", "", "()V", "DEFAULT_REQUEST_CODE", "", "facebook-gamingservices_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00120\u0001R\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lcom/facebook/gamingservices/ContextCreateDialog$FacebookAppHandler;", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/gamingservices/model/ContextCreateContent;", "Lcom/facebook/gamingservices/ContextCreateDialog$Result;", "(Lcom/facebook/gamingservices/ContextCreateDialog;)V", "canShow", "", "content", "isBestEffort", "createAppCall", "Lcom/facebook/internal/AppCall;", "facebook-gamingservices_release"})
    @SourceDebugExtension(value={"SMAP\nContextCreateDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextCreateDialog.kt\ncom/facebook/gamingservices/ContextCreateDialog$FacebookAppHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1#2:217\n*E\n"})
    private final class FacebookAppHandler
    extends FacebookDialogBase.ModeHandler {
        public FacebookAppHandler() {
            super((FacebookDialogBase)ContextCreateDialog.this);
        }

        public boolean canShow(@NotNull ContextCreateContent content, boolean isBestEffort) {
            AccessToken currentToken;
            ComponentName componentName;
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Activity activity = ContextCreateDialog.this.getActivityContext();
            PackageManager packageManager = activity != null ? activity.getPackageManager() : null;
            Intent intent = new Intent("com.facebook.games.gaming_services.DEEPLINK");
            intent.setType("text/plain");
            PackageManager packageManager2 = packageManager;
            if (packageManager2 != null) {
                PackageManager it = packageManager2;
                boolean bl = false;
                componentName = intent.resolveActivity(it);
            } else {
                componentName = null;
            }
            boolean fbAppCanShow = componentName != null;
            AccessToken accessToken = currentToken = AccessToken.Companion.getCurrentAccessToken();
            boolean isGamingLoggedIn = (accessToken != null ? accessToken.getGraphDomain() : null) != null && Intrinsics.areEqual((Object)"gaming", (Object)currentToken.getGraphDomain());
            return fbAppCanShow && isGamingLoggedIn;
        }

        @NotNull
        public AppCall createAppCall(@NotNull ContextCreateContent content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            AppCall appCall = ContextCreateDialog.this.createBaseAppCall();
            Intent intent = new Intent("com.facebook.games.gaming_services.DEEPLINK");
            intent.setType("text/plain");
            AccessToken accessToken = AccessToken.Companion.getCurrentAccessToken();
            Bundle args = new Bundle();
            args.putString("deeplink", "CONTEXT_CREATE");
            if (accessToken != null) {
                args.putString("game_id", accessToken.getApplicationId());
            } else {
                args.putString("game_id", FacebookSdk.getApplicationId());
            }
            if (content.getSuggestedPlayerID() != null) {
                args.putString("player_id", content.getSuggestedPlayerID());
            }
            NativeProtocol.setupProtocolRequestIntent((Intent)intent, (String)appCall.getCallId().toString(), (String)"", (int)NativeProtocol.getLatestKnownVersion(), (Bundle)args);
            appCall.setRequestIntent(intent);
            return appCall;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0004\u00a8\u0006\u000b"}, d2={"Lcom/facebook/gamingservices/ContextCreateDialog$Result;", "", "contextID", "", "(Ljava/lang/String;)V", "response", "Lcom/facebook/GraphResponse;", "(Lcom/facebook/GraphResponse;)V", "getContextID", "()Ljava/lang/String;", "setContextID", "facebook-gamingservices_release"})
    @SourceDebugExtension(value={"SMAP\nContextCreateDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextCreateDialog.kt\ncom/facebook/gamingservices/ContextCreateDialog$Result\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1#2:217\n*E\n"})
    public static final class Result {
        @Nullable
        private String contextID;

        @Nullable
        public final String getContextID() {
            return this.contextID;
        }

        public final void setContextID(@Nullable String string) {
            this.contextID = string;
        }

        public Result(@NotNull String contextID) {
            Intrinsics.checkNotNullParameter((Object)contextID, (String)"contextID");
            this.contextID = contextID;
        }

        public Result(@NotNull GraphResponse response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            try {
                JSONObject jSONObject = response.getJSONObject();
                if (jSONObject != null) {
                    JSONObject jSONObject2;
                    JSONObject data = jSONObject;
                    boolean bl = false;
                    JSONObject jSONObject3 = jSONObject2 = data.optJSONObject("data");
                    if (jSONObject3 != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)jSONObject3, (String)"optJSONObject(\"data\")");
                        JSONObject it = jSONObject2;
                        boolean bl2 = false;
                        this.contextID = it.getString("id");
                    }
                }
            }
            catch (JSONException e) {
                this.contextID = null;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00120\u0001R\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lcom/facebook/gamingservices/ContextCreateDialog$WebHandler;", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "Lcom/facebook/internal/FacebookDialogBase;", "Lcom/facebook/gamingservices/model/ContextCreateContent;", "Lcom/facebook/gamingservices/ContextCreateDialog$Result;", "(Lcom/facebook/gamingservices/ContextCreateDialog;)V", "canShow", "", "content", "isBestEffort", "createAppCall", "Lcom/facebook/internal/AppCall;", "facebook-gamingservices_release"})
    private final class WebHandler
    extends FacebookDialogBase.ModeHandler {
        public WebHandler() {
            super((FacebookDialogBase)ContextCreateDialog.this);
        }

        public boolean canShow(@NotNull ContextCreateContent content, boolean isBestEffort) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return true;
        }

        @NotNull
        public AppCall createAppCall(@NotNull ContextCreateContent content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            AppCall appCall = ContextCreateDialog.this.createBaseAppCall();
            Bundle webParams = new Bundle();
            webParams.putString("player_id", content.getSuggestedPlayerID());
            AccessToken currentToken = AccessToken.Companion.getCurrentAccessToken();
            if (currentToken != null) {
                webParams.putString("dialog_access_token", currentToken.getToken());
            }
            DialogPresenter.setupAppCallForWebDialog((AppCall)appCall, (String)"context", (Bundle)webParams);
            return appCall;
        }
    }
}

