/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.gamingservices.cloudgaming.CloudGameLoginHandler;
import com.facebook.gamingservices.cloudgaming.DaemonRequest;
import com.facebook.gamingservices.cloudgaming.internal.SDKMessageEnum;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/facebook/gamingservices/GamingContext;", "", "contextID", "", "(Ljava/lang/String;)V", "getContextID", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "facebook-gamingservices_release"})
public final class GamingContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String contextID;
    private static final int DEFAULT_TIMEOUT = 5;
    @Nullable
    private static GamingContext currentContext;

    public GamingContext(@NotNull String contextID) {
        Intrinsics.checkNotNullParameter((Object)contextID, (String)"contextID");
        this.contextID = contextID;
    }

    @NotNull
    public final String getContextID() {
        return this.contextID;
    }

    @NotNull
    public final String component1() {
        return this.contextID;
    }

    @NotNull
    public final GamingContext copy(@NotNull String contextID) {
        Intrinsics.checkNotNullParameter((Object)contextID, (String)"contextID");
        return new GamingContext(contextID);
    }

    public static /* synthetic */ GamingContext copy$default(GamingContext gamingContext, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = gamingContext.contextID;
        }
        return gamingContext.copy(string);
    }

    @NotNull
    public String toString() {
        return "GamingContext(contextID=" + this.contextID + ')';
    }

    public int hashCode() {
        return this.contextID.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GamingContext)) {
            return false;
        }
        GamingContext gamingContext = (GamingContext)other;
        return Intrinsics.areEqual((Object)this.contextID, (Object)gamingContext.contextID);
    }

    @JvmStatic
    @Nullable
    public static final GamingContext getCurrentGamingContext() {
        return Companion.getCurrentGamingContext();
    }

    @JvmStatic
    public static final void setCurrentGamingContext(@NotNull GamingContext ctx) {
        Companion.setCurrentGamingContext(ctx);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/gamingservices/GamingContext$Companion;", "", "()V", "DEFAULT_TIMEOUT", "", "currentContext", "Lcom/facebook/gamingservices/GamingContext;", "getCurrentGamingContext", "setCurrentGamingContext", "", "ctx", "facebook-gamingservices_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final GamingContext getCurrentGamingContext() {
            if (CloudGameLoginHandler.isRunningInCloud()) {
                GraphResponse response = DaemonRequest.executeAndWait(FacebookSdk.getApplicationContext(), null, SDKMessageEnum.CONTEXT_GET_ID, 5);
                GraphResponse graphResponse = response;
                String string = graphResponse != null && (graphResponse = graphResponse.getJSONObject()) != null ? graphResponse.getString("id") : null;
                if (string == null) {
                    return null;
                }
                String contextId = string;
                return new GamingContext(contextId);
            }
            return currentContext;
        }

        @JvmStatic
        public final void setCurrentGamingContext(@NotNull GamingContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (CloudGameLoginHandler.isRunningInCloud()) {
                return;
            }
            currentContext = ctx;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

