/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices.cloudgaming;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;

class MediaUploadCallback
implements GraphRequest.Callback {
    private String title;
    private String body;
    private int timeInterval;
    @Nullable
    private String payload;
    GraphRequest.Callback callback;

    public MediaUploadCallback(String title, String body, int timeInterval, @Nullable String payload, GraphRequest.Callback callback) {
        this.title = title;
        this.body = body;
        this.timeInterval = timeInterval;
        this.payload = payload;
        this.callback = callback;
    }

    public void onCompleted(GraphResponse response) {
        if (response.getError() != null) {
            throw new FacebookException(response.getError().getErrorMessage());
        }
        String mediaID = response.getJSONObject().optString("id");
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        Bundle parameters = new Bundle();
        parameters.putString("title", this.title);
        parameters.putString("body", this.body);
        parameters.putInt("time_interval", this.timeInterval);
        if (this.payload != null) {
            parameters.putString("payload:", this.payload);
        }
        parameters.putString("media_id", mediaID);
        GraphRequest request = new GraphRequest(accessToken, "me/schedule_gaming_app_to_user_update", parameters, HttpMethod.POST, this.callback);
        request.executeAsync();
    }
}

