/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import com.facebook.AccessToken;
import com.facebook.AccessTokenTracker;
import com.facebook.CallbackManager;
import com.facebook.FacebookButtonBase;
import com.facebook.FacebookCallback;
import com.facebook.FacebookSdk;
import com.facebook.Profile;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.common.R;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.facebook.login.R;
import com.facebook.login.widget.ToolTipPopup;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LoginButton
extends FacebookButtonBase {
    private static final String TAG = LoginButton.class.getName();
    private boolean confirmLogout;
    private String loginText;
    private String logoutText;
    private LoginButtonProperties properties = new LoginButtonProperties();
    private String loginLogoutEventName = "fb_login_view_usage";
    private boolean toolTipChecked;
    private ToolTipPopup.Style toolTipStyle = ToolTipPopup.Style.BLUE;
    private ToolTipMode toolTipMode;
    private long toolTipDisplayTime = 6000L;
    private ToolTipPopup toolTipPopup;
    private AccessTokenTracker accessTokenTracker;
    private LoginManager loginManager;

    public LoginButton(Context context) {
        super(context, null, 0, 0, "fb_login_button_create", "fb_login_button_did_tap");
    }

    public LoginButton(Context context, AttributeSet attrs) {
        super(context, attrs, 0, 0, "fb_login_button_create", "fb_login_button_did_tap");
    }

    public LoginButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle, 0, "fb_login_button_create", "fb_login_button_did_tap");
    }

    public void setLoginText(String loginText) {
        this.loginText = loginText;
        this.setButtonText();
    }

    public void setLogoutText(String logoutText) {
        this.logoutText = logoutText;
        this.setButtonText();
    }

    public void setDefaultAudience(DefaultAudience defaultAudience) {
        this.properties.setDefaultAudience(defaultAudience);
    }

    public DefaultAudience getDefaultAudience() {
        return this.properties.getDefaultAudience();
    }

    public void setReadPermissions(List<String> permissions) {
        this.properties.setPermissions(permissions);
    }

    public void setReadPermissions(String ... permissions) {
        this.properties.setPermissions(Arrays.asList(permissions));
    }

    public void setPermissions(List<String> permissions) {
        this.properties.setPermissions(permissions);
    }

    public void setPermissions(String ... permissions) {
        this.properties.setPermissions(Arrays.asList(permissions));
    }

    public void setPublishPermissions(List<String> permissions) {
        this.properties.setPermissions(permissions);
    }

    public void setPublishPermissions(String ... permissions) {
        this.properties.setPermissions(Arrays.asList(permissions));
    }

    public void clearPermissions() {
        this.properties.clearPermissions();
    }

    public void setLoginBehavior(LoginBehavior loginBehavior) {
        this.properties.setLoginBehavior(loginBehavior);
    }

    public LoginBehavior getLoginBehavior() {
        return this.properties.getLoginBehavior();
    }

    public String getAuthType() {
        return this.properties.getAuthType();
    }

    @Nullable
    public String getMessengerPageId() {
        return this.properties.getMessengerPageId();
    }

    public boolean getResetMessengerState() {
        return this.properties.getResetMessengerState();
    }

    public void setAuthType(String authType) {
        this.properties.setAuthType(authType);
    }

    public void setMessengerPageId(String messengerPageId) {
        this.properties.setMessengerPageId(messengerPageId);
    }

    public void setResetMessengerState(boolean resetMessengerState) {
        this.properties.setResetMessengerState(resetMessengerState);
    }

    public void setToolTipStyle(ToolTipPopup.Style toolTipStyle) {
        this.toolTipStyle = toolTipStyle;
    }

    public void setToolTipMode(ToolTipMode toolTipMode) {
        this.toolTipMode = toolTipMode;
    }

    public ToolTipMode getToolTipMode() {
        return this.toolTipMode;
    }

    public void setToolTipDisplayTime(long displayTime) {
        this.toolTipDisplayTime = displayTime;
    }

    public long getToolTipDisplayTime() {
        return this.toolTipDisplayTime;
    }

    public void dismissToolTip() {
        if (this.toolTipPopup != null) {
            this.toolTipPopup.dismiss();
            this.toolTipPopup = null;
        }
    }

    public void registerCallback(CallbackManager callbackManager, FacebookCallback<LoginResult> callback) {
        this.getLoginManager().registerCallback(callbackManager, callback);
    }

    public void unregisterCallback(CallbackManager callbackManager) {
        this.getLoginManager().unregisterCallback(callbackManager);
    }

    protected void onAttachedToWindow() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            super.onAttachedToWindow();
            if (this.accessTokenTracker != null && !this.accessTokenTracker.isTracking()) {
                this.accessTokenTracker.startTracking();
                this.setButtonText();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(Canvas canvas) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void canvas2;
            super.onDraw((Canvas)canvas2);
            if (!this.toolTipChecked && !this.isInEditMode()) {
                this.toolTipChecked = true;
                this.checkToolTipSettings();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void showToolTipPerSettings(FetchedAppSettings fetchedAppSettings) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void settings;
            if (settings != null && settings.getNuxEnabled() && this.getVisibility() == 0) {
                String toolTipString = settings.getNuxContent();
                this.displayToolTip(toolTipString);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void displayToolTip(String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void toolTipString;
            this.toolTipPopup = new ToolTipPopup((String)toolTipString, (View)this);
            this.toolTipPopup.setStyle(this.toolTipStyle);
            this.toolTipPopup.setNuxDisplayTime(this.toolTipDisplayTime);
            this.toolTipPopup.show();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    private void checkToolTipSettings() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            switch (this.toolTipMode) {
                case AUTOMATIC: {
                    final String appId = Utility.getMetadataApplicationId((Context)this.getContext());
                    FacebookSdk.getExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                                return;
                            }
                            try {
                                final FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings((String)appId, (boolean)false);
                                LoginButton.this.getActivity().runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                                            return;
                                        }
                                        try {
                                            LoginButton.this.showToolTipPerSettings(settings);
                                            return;
                                        }
                                        catch (Throwable throwable) {
                                            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                                            return;
                                        }
                                    }
                                });
                                return;
                            }
                            catch (Throwable throwable) {
                                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                                return;
                            }
                        }
                    });
                    break;
                }
                case DISPLAY_ALWAYS: {
                    String toolTipString = this.getResources().getString(R.string.com_facebook_tooltip_default);
                    this.displayToolTip(toolTipString);
                    break;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void bottom;
            void right;
            void top;
            void left;
            void changed;
            super.onLayout((boolean)changed, (int)left, (int)top, (int)right, (int)bottom);
            this.setButtonText();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    protected void onDetachedFromWindow() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            super.onDetachedFromWindow();
            if (this.accessTokenTracker != null) {
                this.accessTokenTracker.stopTracking();
            }
            this.dismissToolTip();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onVisibilityChanged(View view, int n) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void visibility;
            void changedView;
            super.onVisibilityChanged((View)changedView, (int)visibility);
            if (visibility != false) {
                this.dismissToolTip();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    List<String> getPermissions() {
        return this.properties.getPermissions();
    }

    void setProperties(LoginButtonProperties properties) {
        this.properties = properties;
    }

    /*
     * WARNING - void declaration
     */
    protected void configureButton(Context context, AttributeSet attributeSet, int n, int n2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void defStyleRes;
            void defStyleAttr;
            void attrs;
            void context2;
            super.configureButton((Context)context2, (AttributeSet)attrs, (int)defStyleAttr, (int)defStyleRes);
            this.setInternalOnClickListener(this.getNewLoginClickListener());
            this.parseLoginButtonAttributes((Context)context2, (AttributeSet)attrs, (int)defStyleAttr, (int)defStyleRes);
            if (this.isInEditMode()) {
                this.setBackgroundColor(this.getResources().getColor(R.color.com_facebook_blue));
                this.loginText = "Continue with Facebook";
            } else {
                this.accessTokenTracker = new AccessTokenTracker(){

                    protected void onCurrentAccessTokenChanged(AccessToken oldAccessToken, AccessToken currentAccessToken) {
                        LoginButton.this.setButtonText();
                    }
                };
            }
            this.setButtonText();
            this.setCompoundDrawablesWithIntrinsicBounds(AppCompatResources.getDrawable((Context)this.getContext(), (int)R.drawable.com_facebook_button_icon), null, null, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    protected LoginClickListener getNewLoginClickListener() {
        return new LoginClickListener();
    }

    protected int getDefaultStyleResource() {
        return R.style.com_facebook_loginview_default_style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void parseLoginButtonAttributes(Context context, AttributeSet attributeSet, int n, int n2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void defStyleRes;
            void defStyleAttr;
            void attrs;
            void context2;
            this.toolTipMode = ToolTipMode.DEFAULT;
            TypedArray a = context2.getTheme().obtainStyledAttributes((AttributeSet)attrs, R.styleable.com_facebook_login_view, (int)defStyleAttr, (int)defStyleRes);
            try {
                this.confirmLogout = a.getBoolean(R.styleable.com_facebook_login_view_com_facebook_confirm_logout, true);
                this.loginText = a.getString(R.styleable.com_facebook_login_view_com_facebook_login_text);
                this.logoutText = a.getString(R.styleable.com_facebook_login_view_com_facebook_logout_text);
                this.toolTipMode = ToolTipMode.fromInt(a.getInt(R.styleable.com_facebook_login_view_com_facebook_tooltip_mode, ToolTipMode.DEFAULT.getValue()));
            }
            finally {
                a.recycle();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onMeasure(int n, int n2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void widthMeasureSpec;
            int logInWidth;
            int width;
            Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
            int height = this.getCompoundPaddingTop() + (int)Math.ceil(Math.abs(fontMetrics.top) + Math.abs(fontMetrics.bottom)) + this.getCompoundPaddingBottom();
            Resources resources = this.getResources();
            String text = this.loginText;
            if (text == null && (width = LoginButton.resolveSize((int)(logInWidth = this.measureButtonWidth(text = resources.getString(R.string.com_facebook_loginview_log_in_button_continue))), (int)widthMeasureSpec)) < logInWidth) {
                text = resources.getString(R.string.com_facebook_loginview_log_in_button);
            }
            logInWidth = this.measureButtonWidth(text);
            text = this.logoutText;
            if (text == null) {
                text = resources.getString(R.string.com_facebook_loginview_log_out_button);
            }
            int logOutWidth = this.measureButtonWidth(text);
            width = LoginButton.resolveSize((int)Math.max(logInWidth, logOutWidth), (int)widthMeasureSpec);
            this.setMeasuredDimension(width, height);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int measureButtonWidth(String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            void text;
            int textWidth = this.measureTextWidth((String)text);
            return this.getCompoundPaddingLeft() + this.getCompoundDrawablePadding() + textWidth + this.getCompoundPaddingRight();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    private void setButtonText() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            Resources resources = this.getResources();
            if (!this.isInEditMode() && AccessToken.isCurrentAccessTokenActive()) {
                this.setText(this.logoutText != null ? this.logoutText : resources.getString(R.string.com_facebook_loginview_log_out_button));
            } else if (this.loginText != null) {
                this.setText(this.loginText);
            } else {
                int measuredWidth;
                String text = resources.getString(R.string.com_facebook_loginview_log_in_button_continue);
                int width = this.getWidth();
                if (width != 0 && (measuredWidth = this.measureButtonWidth(text)) > width) {
                    text = resources.getString(R.string.com_facebook_loginview_log_in_button);
                }
                this.setText(text);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    protected int getDefaultRequestCode() {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return 0;
        }
        try {
            return CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return 0;
        }
    }

    LoginManager getLoginManager() {
        if (this.loginManager == null) {
            this.loginManager = LoginManager.getInstance();
        }
        return this.loginManager;
    }

    void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    protected class LoginClickListener
    implements View.OnClickListener {
        protected LoginClickListener() {
        }

        /*
         * WARNING - void declaration
         */
        public void onClick(View view) {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return;
            }
            try {
                void v;
                LoginButton.this.callExternalOnClickListener((View)v);
                AccessToken accessToken = AccessToken.getCurrentAccessToken();
                if (AccessToken.isCurrentAccessTokenActive()) {
                    this.performLogout(LoginButton.this.getContext());
                } else {
                    this.performLogin();
                }
                InternalAppEventsLogger logger = new InternalAppEventsLogger(LoginButton.this.getContext());
                Bundle parameters = new Bundle();
                parameters.putInt("logging_in", accessToken != null ? 0 : 1);
                parameters.putInt("access_token_expired", AccessToken.isCurrentAccessTokenActive() ? 1 : 0);
                logger.logEventImplicitly(LoginButton.this.loginLogoutEventName, parameters);
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return;
            }
        }

        protected void performLogin() {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return;
            }
            try {
                LoginManager loginManager = this.getLoginManager();
                if (LoginButton.this.getFragment() != null) {
                    loginManager.logIn(LoginButton.this.getFragment(), (Collection)LoginButton.this.properties.permissions);
                } else if (LoginButton.this.getNativeFragment() != null) {
                    loginManager.logIn(LoginButton.this.getNativeFragment(), (Collection)LoginButton.this.properties.permissions);
                } else {
                    loginManager.logIn(LoginButton.this.getActivity(), (Collection)LoginButton.this.properties.permissions);
                }
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void performLogout(Context context) {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return;
            }
            try {
                final LoginManager loginManager = this.getLoginManager();
                if (LoginButton.this.confirmLogout) {
                    void context2;
                    String logout = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_log_out_action);
                    String cancel = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_cancel_action);
                    Profile profile = Profile.getCurrentProfile();
                    String message = profile != null && profile.getName() != null ? String.format(LoginButton.this.getResources().getString(R.string.com_facebook_loginview_logged_in_as), profile.getName()) : LoginButton.this.getResources().getString(R.string.com_facebook_loginview_logged_in_using_facebook);
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)context2);
                    builder.setMessage((CharSequence)message).setCancelable(true).setPositiveButton((CharSequence)logout, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            loginManager.logOut();
                        }
                    }).setNegativeButton((CharSequence)cancel, null);
                    builder.create().show();
                } else {
                    loginManager.logOut();
                }
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return;
            }
        }

        protected LoginManager getLoginManager() {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return null;
            }
            try {
                LoginManager manager = LoginManager.getInstance();
                manager.setDefaultAudience(LoginButton.this.getDefaultAudience());
                manager.setLoginBehavior(LoginButton.this.getLoginBehavior());
                manager.setAuthType(LoginButton.this.getAuthType());
                manager.setMessengerPageId(LoginButton.this.getMessengerPageId());
                manager.setResetMessengerState(LoginButton.this.getResetMessengerState());
                return manager;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                return null;
            }
        }
    }

    static class LoginButtonProperties {
        private DefaultAudience defaultAudience = DefaultAudience.FRIENDS;
        private List<String> permissions = Collections.emptyList();
        private LoginBehavior loginBehavior = LoginBehavior.NATIVE_WITH_FALLBACK;
        private String authType = "rerequest";
        @Nullable
        private String messengerPageId;
        private boolean resetMessengerState;

        LoginButtonProperties() {
        }

        public void setDefaultAudience(DefaultAudience defaultAudience) {
            this.defaultAudience = defaultAudience;
        }

        public DefaultAudience getDefaultAudience() {
            return this.defaultAudience;
        }

        public void setPermissions(List<String> permissions) {
            this.permissions = permissions;
        }

        List<String> getPermissions() {
            return this.permissions;
        }

        public void clearPermissions() {
            this.permissions = null;
        }

        public void setLoginBehavior(LoginBehavior loginBehavior) {
            this.loginBehavior = loginBehavior;
        }

        public LoginBehavior getLoginBehavior() {
            return this.loginBehavior;
        }

        public String getAuthType() {
            return this.authType;
        }

        public void setAuthType(String authType) {
            this.authType = authType;
        }

        @Nullable
        public String getMessengerPageId() {
            return this.messengerPageId;
        }

        public void setMessengerPageId(@Nullable String pageId) {
            this.messengerPageId = pageId;
        }

        public boolean getResetMessengerState() {
            return this.resetMessengerState;
        }

        public void setResetMessengerState(boolean resetMessengerState) {
            this.resetMessengerState = resetMessengerState;
        }
    }

    public static enum ToolTipMode {
        AUTOMATIC("automatic", 0),
        DISPLAY_ALWAYS("display_always", 1),
        NEVER_DISPLAY("never_display", 2);

        public static ToolTipMode DEFAULT;
        private String stringValue;
        private int intValue;

        public static ToolTipMode fromInt(int enumValue) {
            for (ToolTipMode mode : ToolTipMode.values()) {
                if (mode.getValue() != enumValue) continue;
                return mode;
            }
            return null;
        }

        private ToolTipMode(String stringValue, int value) {
            this.stringValue = stringValue;
            this.intValue = value;
        }

        public String toString() {
            return this.stringValue;
        }

        public int getValue() {
            return this.intValue;
        }

        static {
            DEFAULT = AUTOMATIC;
        }
    }
}

