/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.marketing.internal;

import android.app.Application;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.marketing.CodelessActivityLifecycleTracker;
import com.facebook.marketing.internal.MarketingLogger;
import com.facebook.marketing.internal.RemoteConfigManager;

public final class MarketingInitProvider
extends ContentProvider {
    private static final String TAG = MarketingInitProvider.class.getSimpleName();

    public boolean onCreate() {
        try {
            if (!FacebookSdk.isInitialized()) {
                FacebookSdk.sdkInitialize((Context)this.getContext(), (FacebookSdk.InitializeCallback)new FacebookSdk.InitializeCallback(){

                    public void onInitialized() {
                        MarketingInitProvider.this.setupCodeless();
                    }
                });
            } else {
                this.setupCodeless();
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)"Failed to auto initialize the Marketing SDK", (Throwable)ex);
        }
        return false;
    }

    private void setupCodeless() {
        CodelessActivityLifecycleTracker.startTracking((Application)FacebookSdk.getApplicationContext());
        RemoteConfigManager.loadRemoteConfigAsync();
        MarketingLogger logger = new MarketingLogger((Context)((Application)FacebookSdk.getApplicationContext()), FacebookSdk.getApplicationId());
        logger.logCodelessInitialized();
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }
}

