/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.marketing.internal;

import android.os.Build;
import android.util.Log;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class MarketingUtils {
    private static final String TAG = MarketingUtils.class.getCanonicalName();

    public static boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    public static double normalizePrice(String value) {
        try {
            String cleanValue = value.replaceAll("[^\\d,.+-]", "");
            return NumberFormat.getNumberInstance(Locale.getDefault()).parse(cleanValue).doubleValue();
        }
        catch (ParseException e) {
            Log.e((String)TAG, (String)"Error parsing price: ", (Throwable)e);
            return 0.0;
        }
    }
}

