/*
 * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
 *
 * You are hereby granted a non-exclusive, worldwide, royalty-free license to use,
 * copy, modify, and distribute this software in source code or binary form for use
 * in connection with the web services and APIs provided by Facebook.
 *
 * As with any software that integrates with the Facebook platform, your use of
 * this software is subject to the Facebook Developer Principles and Policies
 * [http://developers.facebook.com/policy/]. This copyright notice shall be
 * included in all copies or substantial portions of the software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.facebook.marketing.internal;

import android.app.Application;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.marketing.CodelessActivityLifecycleTracker;

public final class MarketingInitProvider extends ContentProvider {
  private static final String TAG = MarketingInitProvider.class.getSimpleName();

  @Override
  @SuppressWarnings("deprecation")
  public boolean onCreate() {
    try {
      // Force SDK initialization first
      if (!FacebookSdk.isInitialized()) {
        FacebookSdk.sdkInitialize(
            getContext(),
            new FacebookSdk.InitializeCallback() {
              @Override
              public void onInitialized() {
                setupCodeless();
              }
            });
      } else {
        setupCodeless();
      }

    } catch (Exception ex) {
      Log.i(TAG, "Failed to auto initialize the Marketing SDK", ex);
    }
    return false;
  }

  private void setupCodeless() {
    CodelessActivityLifecycleTracker.startTracking(
        (Application) FacebookSdk.getApplicationContext());
    RemoteConfigManager.loadRemoteConfigAsync();

    MarketingLogger logger =
        new MarketingLogger(
            (Application) FacebookSdk.getApplicationContext(), FacebookSdk.getApplicationId());
    logger.logCodelessInitialized();
  }

  @Override
  public Cursor query(
      final Uri uri,
      final String[] projection,
      final String selection,
      final String[] selectionArgs,
      final String sortOrder) {
    return null;
  }

  @Override
  public String getType(final Uri uri) {
    return null;
  }

  @Override
  public Uri insert(final Uri uri, final ContentValues values) {
    return null;
  }

  @Override
  public int delete(final Uri uri, final String selection, final String[] selectionArgs) {
    return 0;
  }

  @Override
  public int update(
      final Uri uri,
      final ContentValues values,
      final String selection,
      final String[] selectionArgs) {
    return 0;
  }
}
