/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.marketing.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.Utility;
import com.facebook.marketing.internal.ButtonIndexingEventListener;
import com.facebook.marketing.internal.ButtonIndexingLogger;
import com.facebook.marketing.internal.RemoteConfig;
import com.facebook.marketing.internal.RemoteConfigManager;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ButtonIndexer {
    private static final String TAG = ButtonIndexer.class.getCanonicalName();
    private final Handler uiThreadHandler = new Handler(Looper.getMainLooper());
    private Set<Activity> activitiesSet = Collections.newSetFromMap(new WeakHashMap());
    private Set<ViewProcessor> viewProcessors = new HashSet<ViewProcessor>();
    private HashSet<String> listenerSet = new HashSet();
    private HashMap<Integer, HashSet<String>> activityToListenerMap = new HashMap();
    private static ButtonIndexer buttonIndexer = null;

    private ButtonIndexer() {
    }

    public static synchronized ButtonIndexer getInstance() {
        if (buttonIndexer == null) {
            buttonIndexer = new ButtonIndexer();
        }
        return buttonIndexer;
    }

    public void add(Activity activity) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new FacebookException("Can't add activity to ButtonIndexer on non-UI thread");
        }
        this.activitiesSet.add(activity);
        this.listenerSet.clear();
        if (this.activityToListenerMap.containsKey(activity.hashCode())) {
            this.listenerSet = this.activityToListenerMap.get(activity.hashCode());
        }
        this.startTracking();
    }

    public void remove(Activity activity) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new FacebookException("Can't remove activity from ButtonIndexer on non-UI thread");
        }
        this.activitiesSet.remove(activity);
        this.viewProcessors.clear();
        this.activityToListenerMap.put(activity.hashCode(), (HashSet)this.listenerSet.clone());
        this.listenerSet.clear();
    }

    public void destroy(Activity activity) {
        this.activityToListenerMap.remove(activity.hashCode());
    }

    private void startTracking() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            this.processViews();
        } else {
            this.uiThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    ButtonIndexer.this.processViews();
                }
            });
        }
    }

    private void processViews() {
        for (Activity activity : this.activitiesSet) {
            View rootView = AppEventUtility.getRootView((Activity)activity);
            if (activity == null || rootView == null) continue;
            String activityName = activity.getClass().getSimpleName();
            ViewProcessor processor = new ViewProcessor(rootView, activityName, this.listenerSet, this.uiThreadHandler);
            this.viewProcessors.add(processor);
        }
    }

    protected static class ViewProcessor
    implements ViewTreeObserver.OnGlobalLayoutListener,
    ViewTreeObserver.OnScrollChangedListener,
    Runnable {
        private WeakReference<View> rootView;
        private final Handler handler;
        private final String activityName;
        private HashSet<String> listenerSet;
        private HashMap<String, WeakReference<View>> viewMap;
        public static volatile Set<String> loadedKeySet = new HashSet<String>();
        private static volatile float displayDensity = -1.0f;
        private final String viewPlaceholder = "{\"classname\": \"placeholder\", \"id\": 1}";

        public ViewProcessor(View rootView, String activityName, HashSet<String> listenerSet, Handler handler) {
            this.rootView = new WeakReference<View>(rootView);
            this.handler = handler;
            this.activityName = activityName;
            this.listenerSet = listenerSet;
            this.viewMap = new HashMap();
            if (displayDensity < 0.0f) {
                Context context = rootView.getContext();
                DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
                displayDensity = displayMetrics.density;
            }
            this.handler.postDelayed((Runnable)this, 200L);
        }

        @Override
        public void run() {
            String appId = FacebookSdk.getApplicationId();
            RemoteConfig remoteConfig = RemoteConfigManager.getRemoteConfigWithoutQuery(appId);
            if (remoteConfig == null || !remoteConfig.getEnableButtonIndexing()) {
                return;
            }
            this.process();
        }

        public void onGlobalLayout() {
            this.process();
        }

        public void onScrollChanged() {
            this.process();
        }

        private void process() {
            View view = (View)this.rootView.get();
            if (view != null) {
                this.attachListeners(view);
            }
        }

        public void attachListeners(View rootView) {
            JSONObject tree = this.getClickableElementsOfView(rootView, -1, this.activityName, false);
            if (tree != null) {
                ButtonIndexingLogger.logAllIndexing(tree, this.activityName);
            }
            for (Map.Entry<String, WeakReference<View>> entry : this.viewMap.entrySet()) {
                String mapKey = entry.getKey();
                View view = (View)entry.getValue().get();
                if (view == null) continue;
                if (!(view instanceof AdapterView)) {
                    this.attachOnClickListener(view, mapKey);
                    continue;
                }
                if (!(view instanceof ListView)) continue;
                this.attachOnItemClickListener((AdapterView)((ListView)view), mapKey);
            }
        }

        @Nullable
        public JSONObject getClickableElementsOfView(View view, int index, String mapKey, boolean isAncestorClickable) {
            mapKey = mapKey + "." + String.valueOf(index);
            if (view == null) {
                return null;
            }
            JSONObject res = new JSONObject();
            try {
                boolean isClickable;
                boolean bl = isClickable = view.isClickable() || view instanceof Button;
                if (isClickable) {
                    this.viewMap.put(mapKey, new WeakReference<View>(view));
                }
                if ((view instanceof TextView || view instanceof ImageView) && (isAncestorClickable || isClickable)) {
                    if (loadedKeySet.contains(mapKey)) {
                        return null;
                    }
                    loadedKeySet.add(mapKey);
                    ViewHierarchy.updateBasicInfoOfView((View)view, (JSONObject)res);
                    ViewHierarchy.updateAppearanceOfView((View)view, (JSONObject)res, (float)displayDensity);
                    return res;
                }
                JSONArray childviews = new JSONArray();
                if (view instanceof ViewGroup) {
                    ViewGroup viewGroup = (ViewGroup)view;
                    int count = viewGroup.getChildCount();
                    int idx = 0;
                    for (int i = 0; i < count; ++i) {
                        JSONObject childview;
                        View child = viewGroup.getChildAt(i);
                        if (child.getVisibility() != 0) continue;
                        if ((childview = this.getClickableElementsOfView(child, idx++, mapKey, isAncestorClickable || isClickable)) != null) {
                            childviews.put((Object)childview);
                            continue;
                        }
                        childviews.put((Object)new JSONObject(this.viewPlaceholder));
                    }
                }
                if (childviews.length() > 0) {
                    ViewHierarchy.updateBasicInfoOfView((View)view, (JSONObject)res);
                    res.put("childviews", (Object)childviews);
                    return res;
                }
            }
            catch (JSONException e) {
                Utility.logd((String)TAG, (Exception)((Object)e));
            }
            return null;
        }

        private void attachOnClickListener(View view, String mapKey) {
            try {
                boolean listenerSupportButtonIndexing;
                if (view == null) {
                    return;
                }
                View.OnClickListener existingListener = ViewHierarchy.getExistingOnClickListener((View)view);
                boolean isButtonIndexingEventListener = existingListener instanceof ButtonIndexingEventListener.ButtonIndexingOnClickListener;
                boolean bl = listenerSupportButtonIndexing = isButtonIndexingEventListener && ((ButtonIndexingEventListener.ButtonIndexingOnClickListener)existingListener).getSupportButtonIndexing();
                if (!this.listenerSet.contains(mapKey) && !listenerSupportButtonIndexing) {
                    ButtonIndexingEventListener.ButtonIndexingOnClickListener listener = ButtonIndexingEventListener.getOnClickListener(view, mapKey);
                    view.setOnClickListener((View.OnClickListener)listener);
                    this.listenerSet.add(mapKey);
                }
            }
            catch (Exception e) {
                Utility.logd((String)TAG, (Exception)e);
            }
        }

        private void attachOnItemClickListener(AdapterView view, String mapKey) {
            try {
                boolean listenerSupportButtonIndexing;
                if (view == null) {
                    return;
                }
                AdapterView.OnItemClickListener existingListener = view.getOnItemClickListener();
                boolean isButtonIndexingEventListener = existingListener instanceof ButtonIndexingEventListener.ButtonIndexingOnItemClickListener;
                boolean bl = listenerSupportButtonIndexing = isButtonIndexingEventListener && ((ButtonIndexingEventListener.ButtonIndexingOnItemClickListener)existingListener).getSupportButtonIndexing();
                if (!this.listenerSet.contains(mapKey) && !listenerSupportButtonIndexing) {
                    ButtonIndexingEventListener.ButtonIndexingOnItemClickListener listener = ButtonIndexingEventListener.getOnItemClickListener(view, mapKey);
                    view.setOnItemClickListener((AdapterView.OnItemClickListener)listener);
                    this.listenerSet.add(mapKey);
                }
            }
            catch (Exception e) {
                Utility.logd((String)TAG, (Exception)e);
            }
        }
    }
}

