/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.marketing.internal;

import android.content.Context;
import android.view.View;
import android.widget.AdapterView;
import androidx.annotation.Nullable;
import com.facebook.FacebookSdk;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.marketing.internal.ButtonIndexingLogger;

public class ButtonIndexingEventListener {
    private static final String TAG = ButtonIndexingEventListener.class.getCanonicalName();

    public static ButtonIndexingOnClickListener getOnClickListener(View hostView, String mapKey) {
        return new ButtonIndexingOnClickListener(hostView, mapKey);
    }

    public static ButtonIndexingOnItemClickListener getOnItemClickListener(AdapterView hostView, String mapKey) {
        return new ButtonIndexingOnItemClickListener(hostView, mapKey);
    }

    private static void logIndexing(final View view, final String mapKey) {
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Context context = FacebookSdk.getApplicationContext();
                String applicationId = FacebookSdk.getApplicationId();
                ButtonIndexingLogger.logIndexing(applicationId, view, mapKey, context);
            }
        });
    }

    public static class ButtonIndexingOnItemClickListener
    implements AdapterView.OnItemClickListener {
        @Nullable
        private AdapterView.OnItemClickListener existingOnClickListener;
        private String mapKey;
        private boolean supportButtonIndexing = false;

        public ButtonIndexingOnItemClickListener(AdapterView hostView, String mapKey) {
            if (null == hostView) {
                return;
            }
            this.existingOnClickListener = hostView.getOnItemClickListener();
            this.mapKey = mapKey;
            this.supportButtonIndexing = true;
        }

        public void onItemClick(AdapterView<?> parent, View host, int position, long id) {
            if (null != this.existingOnClickListener) {
                this.existingOnClickListener.onItemClick(parent, host, position, id);
            }
            ButtonIndexingEventListener.logIndexing(host, this.mapKey);
        }

        public boolean getSupportButtonIndexing() {
            return this.supportButtonIndexing;
        }
    }

    public static class ButtonIndexingOnClickListener
    implements View.OnClickListener {
        @Nullable
        private View.OnClickListener existingOnClickListener;
        private String mapKey;
        private boolean supportButtonIndexing = false;

        public ButtonIndexingOnClickListener(View hostView, String mapKey) {
            if (null == hostView) {
                return;
            }
            this.existingOnClickListener = ViewHierarchy.getExistingOnClickListener((View)hostView);
            this.mapKey = mapKey;
            this.supportButtonIndexing = true;
        }

        public void onClick(View host) {
            if (null != this.existingOnClickListener) {
                this.existingOnClickListener.onClick(host);
            }
            ButtonIndexingEventListener.logIndexing(host, this.mapKey);
        }

        public boolean getSupportButtonIndexing() {
            return this.supportButtonIndexing;
        }
    }
}

