/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.marketing.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.facebook.AccessToken;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.appevents.codeless.ViewIndexer;
import com.facebook.appevents.codeless.internal.SensitiveUserDataUtils;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.Utility;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ButtonIndexingLogger {
    private static final String TAG = ButtonIndexingLogger.class.getCanonicalName();
    private static final String API_ENDPOINT = "%s/button_indexing";
    private static volatile Set<String> clickedKeySet = new HashSet<String>();
    private static volatile Set<String> loadedKeySet = new HashSet<String>();

    private static JSONObject generateButtonDetail(View view, String mapKey, boolean isFromClick) {
        try {
            JSONObject result = new JSONObject();
            JSONArray path = new JSONArray();
            String[] indexList = mapKey.split("\\.", -1);
            View currentView = view;
            int i = indexList.length - 1;
            while (currentView != null) {
                JSONObject currentPath = new JSONObject();
                currentPath.put("classname", (Object)currentView.getClass().getCanonicalName());
                currentPath.put("index", (Object)indexList[i]);
                currentPath.put("id", currentView.getId());
                String text = SensitiveUserDataUtils.isSensitiveUserData((View)currentView) ? "" : ViewHierarchy.getTextOfView((View)currentView);
                currentPath.put("text", (Object)text);
                currentPath.put("tag", (Object)(currentView.getTag() == null ? "" : String.valueOf(currentView.getTag())));
                currentPath.put("description", (Object)(currentView.getContentDescription() == null ? "" : String.valueOf(currentView.getContentDescription())));
                path.put((Object)currentPath);
                currentView = ViewHierarchy.getParentOfView((View)currentView);
                --i;
            }
            JSONArray revertedPath = new JSONArray();
            for (int j = path.length() - 1; j >= 0; --j) {
                revertedPath.put(path.get(j));
            }
            result.put("path", (Object)revertedPath);
            result.put("is_from_click", isFromClick);
            if (view instanceof ImageView) {
                Bitmap bitmap = ((BitmapDrawable)((ImageView)view).getDrawable()).getBitmap();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
                byte[] byteArray = byteArrayOutputStream.toByteArray();
                String encoded = Base64.encodeToString((byte[])byteArray, (int)0);
                result.put("image", (Object)encoded);
            }
            return result;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Log button indexing error", (Throwable)e);
            return new JSONObject();
        }
    }

    private static void sendGraphAPIRequest(Context context, String paths, String applicationId) {
        AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers((Context)context);
        if (identifiers != null && identifiers.getAndroidAdvertiserId() != null) {
            String version = AppEventUtility.getAppVersion();
            Bundle publishParams = new Bundle();
            try {
                publishParams.putString("app_version", version);
                publishParams.putString("indexed_button_list", paths);
                GraphRequest postRequest = GraphRequest.newPostRequest(null, (String)String.format(Locale.US, API_ENDPOINT, applicationId), null, null);
                postRequest.setParameters(publishParams);
                postRequest.executeAndWait();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"failed to send button indexing request", (Throwable)e);
            }
        }
    }

    public static void logIndexing(String applicationId, View view, String mapKey, Context context) {
        if (clickedKeySet.contains(mapKey)) {
            return;
        }
        clickedKeySet.add(mapKey);
        JSONObject detail = ButtonIndexingLogger.generateButtonDetail(view, mapKey, true);
        if (detail.length() > 0) {
            JSONArray paths = new JSONArray(Arrays.asList(detail.toString()));
            ButtonIndexingLogger.sendGraphAPIRequest(context, paths.toString(), applicationId);
        }
    }

    public static void logAllIndexing(final JSONObject tree, final String activityName) {
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JSONObject viewTree = new JSONObject();
                try {
                    String applicationId = FacebookSdk.getApplicationId();
                    AccessToken accessToken = AccessToken.getCurrentAccessToken();
                    viewTree.put("screenname", (Object)activityName);
                    JSONArray viewArray = new JSONArray();
                    viewArray.put((Object)tree);
                    viewTree.put("view", (Object)viewArray);
                    GraphRequest request = ViewIndexer.buildAppIndexingRequest((String)viewTree.toString(), (AccessToken)accessToken, (String)applicationId, (String)"button_sampling");
                    if (request != null) {
                        request.executeAndWait();
                    }
                }
                catch (JSONException e) {
                    Utility.logd((String)TAG, (Exception)((Object)e));
                }
            }
        });
    }
}

