/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.marketing.internal;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.HttpMethod;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.marketing.internal.RemoteConfig;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class RemoteConfigManager {
    private static final String TAG = RemoteConfigManager.class.getCanonicalName();
    private static final String SAMPLING_ENDPOINT_PATH = "%s/button_auto_detection_device_selection";
    private static final String SAMPLING_RESULT_FIELD = "is_selected";
    private static final Map<String, RemoteConfig> remoteConfigs = new ConcurrentHashMap<String, RemoteConfig>();

    public static void loadRemoteConfigAsync() {
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JSONObject resultJSON;
                String advertiserId;
                Context context = FacebookSdk.getApplicationContext();
                String applicationId = FacebookSdk.getApplicationId();
                AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers((Context)context);
                String string = advertiserId = identifiers != null ? identifiers.getAndroidAdvertiserId() : null;
                if (advertiserId != null && (resultJSON = RemoteConfigManager.getRemoteConfigQueryResponse(applicationId)) != null) {
                    RemoteConfigManager.parseRemoteConfigFromJSON(applicationId, resultJSON);
                }
            }
        });
    }

    @Nullable
    public static RemoteConfig getRemoteConfigWithoutQuery(String applicationId) {
        return applicationId != null ? remoteConfigs.get(applicationId) : null;
    }

    @Nullable
    private static JSONObject getRemoteConfigQueryResponse(String applicationId) {
        try {
            String publishUrl = String.format(Locale.US, SAMPLING_ENDPOINT_PATH, applicationId);
            Bundle publishParams = new Bundle();
            publishParams.putString("fields", SAMPLING_RESULT_FIELD);
            GraphRequest request = new GraphRequest(null, publishUrl, publishParams, HttpMethod.GET, null);
            request.setSkipClientToken(true);
            return request.executeAndWait().getJSONObject();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"fail to request button sampling api", (Throwable)e);
            return new JSONObject();
        }
    }

    private static void parseRemoteConfigFromJSON(String applicationId, JSONObject jsonObject) {
        JSONObject result;
        JSONArray data = jsonObject.optJSONArray("data");
        if (data != null && data.length() > 0 && (result = data.optJSONObject(0)) != null) {
            boolean enableButtonIndexing = result.optBoolean(SAMPLING_RESULT_FIELD, false);
            RemoteConfig remoteConfig = new RemoteConfig(enableButtonIndexing);
            remoteConfigs.put(applicationId, remoteConfig);
        }
    }
}

