/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookGraphResponseException;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.internal.CollectionMapper;
import com.facebook.internal.Mutable;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.share.Sharer;
import com.facebook.share.internal.ShareContentValidation;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.internal.VideoUploader;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareVideoContent;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ShareApi {
    private static final String TAG = "ShareApi";
    private static final String DEFAULT_GRAPH_NODE = "me";
    private static final String PHOTOS_EDGE = "photos";
    private static final String GRAPH_PATH_FORMAT = "%s/%s";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private String message;
    private String graphNode;
    private final ShareContent shareContent;

    /*
     * WARNING - void declaration
     */
    public static void share(ShareContent shareContent, FacebookCallback<Sharer.Result> facebookCallback) {
        if (CrashShieldHandler.isObjectCrashing(ShareApi.class)) {
            return;
        }
        try {
            void callback;
            ShareContent shareContent2;
            new ShareApi(shareContent2).share((FacebookCallback<Sharer.Result>)callback);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareApi.class);
            return;
        }
    }

    public ShareApi(ShareContent shareContent) {
        this.shareContent = shareContent;
        this.graphNode = DEFAULT_GRAPH_NODE;
    }

    public String getMessage() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            return this.message;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMessage(String string) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void message;
            this.message = message;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    public String getGraphNode() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            return this.graphNode;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setGraphNode(String string) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void graphNode;
            this.graphNode = graphNode;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    public ShareContent getShareContent() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            return this.shareContent;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    public boolean canShare() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return false;
        }
        try {
            if (this.getShareContent() == null) {
                return false;
            }
            AccessToken accessToken = AccessToken.getCurrentAccessToken();
            if (!AccessToken.isCurrentAccessTokenActive()) {
                return false;
            }
            Set permissions = accessToken.getPermissions();
            if (permissions == null || !permissions.contains("publish_actions")) {
                Log.w((String)TAG, (String)"The publish_actions permissions are missing, the share will fail unless this app was authorized to publish in another installation.");
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void share(FacebookCallback<Sharer.Result> facebookCallback) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void callback;
            if (!this.canShare()) {
                ShareInternalUtility.invokeCallbackWithError((FacebookCallback)callback, (String)"Insufficient permissions for sharing content via Api.");
                return;
            }
            ShareContent shareContent = this.getShareContent();
            try {
                ShareContentValidation.validateForApiShare((ShareContent)shareContent);
            }
            catch (FacebookException ex) {
                ShareInternalUtility.invokeCallbackWithException((FacebookCallback)callback, (Exception)((Object)ex));
                return;
            }
            if (shareContent instanceof ShareLinkContent) {
                this.shareLinkContent((ShareLinkContent)shareContent, (FacebookCallback<Sharer.Result>)callback);
            } else if (shareContent instanceof SharePhotoContent) {
                this.sharePhotoContent((SharePhotoContent)shareContent, (FacebookCallback<Sharer.Result>)callback);
            } else if (shareContent instanceof ShareVideoContent) {
                this.shareVideoContent((ShareVideoContent)shareContent, (FacebookCallback<Sharer.Result>)callback);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getGraphPath(String string) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            try {
                void pathAfterGraphNode;
                return String.format(Locale.ROOT, GRAPH_PATH_FORMAT, URLEncoder.encode(this.getGraphNode(), DEFAULT_CHARSET), pathAfterGraphNode);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addCommonParameters(Bundle bundle, ShareContent shareContent) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void bundle2;
            void shareContent2;
            List peopleIds = shareContent2.getPeopleIds();
            if (!Utility.isNullOrEmpty((Collection)peopleIds)) {
                bundle2.putString("tags", TextUtils.join((CharSequence)", ", (Iterable)peopleIds));
            }
            if (!Utility.isNullOrEmpty((String)shareContent2.getPlaceId())) {
                bundle2.putString("place", shareContent2.getPlaceId());
            }
            if (!Utility.isNullOrEmpty((String)shareContent2.getPageId())) {
                bundle2.putString("page", shareContent2.getPageId());
            }
            if (!Utility.isNullOrEmpty((String)shareContent2.getRef())) {
                bundle2.putString("ref", shareContent2.getRef());
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    private static void handleImagesOnAction(Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(ShareApi.class)) {
            return;
        }
        try {
            Bundle parameters;
            String imageStr = parameters.getString("image");
            if (imageStr != null) {
                try {
                    JSONArray images = new JSONArray(imageStr);
                    for (int i = 0; i < images.length(); ++i) {
                        JSONObject jsonImage = images.optJSONObject(i);
                        if (jsonImage != null) {
                            ShareApi.putImageInBundleWithArrayFormat(parameters, i, jsonImage);
                            continue;
                        }
                        String url = images.getString(i);
                        parameters.putString(String.format(Locale.ROOT, "image[%d][url]", i), url);
                    }
                    parameters.remove("image");
                    return;
                }
                catch (JSONException images) {
                    try {
                        JSONObject image = new JSONObject(imageStr);
                        ShareApi.putImageInBundleWithArrayFormat(parameters, 0, image);
                        parameters.remove("image");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareApi.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void putImageInBundleWithArrayFormat(Bundle bundle, int n, JSONObject jSONObject) throws JSONException {
        if (CrashShieldHandler.isObjectCrashing(ShareApi.class)) {
            return;
        }
        try {
            void image;
            Iterator keys = image.keys();
            while (keys.hasNext()) {
                Bundle parameters;
                void index;
                String property = (String)keys.next();
                String key = String.format(Locale.ROOT, "image[%d][%s]", (int)index, property);
                parameters.putString(key, image.get(property).toString());
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareApi.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sharePhotoContent(SharePhotoContent sharePhotoContent, FacebookCallback<Sharer.Result> facebookCallback) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void callback;
            final Mutable<Integer> requestCount = new Mutable<Integer>(0);
            AccessToken accessToken = AccessToken.getCurrentAccessToken();
            ArrayList<GraphRequest> requests = new ArrayList<GraphRequest>();
            final ArrayList results = new ArrayList();
            final ArrayList errorResponses = new ArrayList();
            GraphRequest.Callback requestCallback = new GraphRequest.Callback((FacebookCallback)callback){
                final /* synthetic */ FacebookCallback val$callback;
                {
                    this.val$callback = facebookCallback;
                }

                public void onCompleted(GraphResponse response) {
                    JSONObject result = response.getJSONObject();
                    if (result != null) {
                        results.add(result);
                    }
                    if (response.getError() != null) {
                        errorResponses.add(response);
                    }
                    requestCount.value = (Integer)requestCount.value - 1;
                    if ((Integer)requestCount.value == 0) {
                        if (!errorResponses.isEmpty()) {
                            ShareInternalUtility.invokeCallbackWithResults((FacebookCallback)this.val$callback, null, (GraphResponse)((GraphResponse)errorResponses.get(0)));
                        } else if (!results.isEmpty()) {
                            String postId = ((JSONObject)results.get(0)).optString("id");
                            ShareInternalUtility.invokeCallbackWithResults((FacebookCallback)this.val$callback, (String)postId, (GraphResponse)response);
                        }
                    }
                }
            };
            try {
                void photoContent;
                for (SharePhoto photo : photoContent.getPhotos()) {
                    Bundle params;
                    try {
                        params = this.getSharePhotoCommonParameters(photo, (SharePhotoContent)photoContent);
                    }
                    catch (JSONException e) {
                        ShareInternalUtility.invokeCallbackWithException((FacebookCallback)callback, (Exception)((Object)e));
                        return;
                    }
                    Bitmap bitmap = photo.getBitmap();
                    Uri photoUri = photo.getImageUrl();
                    String caption = photo.getCaption();
                    if (caption == null) {
                        caption = this.getMessage();
                    }
                    if (bitmap != null) {
                        requests.add(GraphRequest.newUploadPhotoRequest((AccessToken)accessToken, (String)this.getGraphPath(PHOTOS_EDGE), (Bitmap)bitmap, (String)caption, (Bundle)params, (GraphRequest.Callback)requestCallback));
                        continue;
                    }
                    if (photoUri == null) continue;
                    requests.add(GraphRequest.newUploadPhotoRequest((AccessToken)accessToken, (String)this.getGraphPath(PHOTOS_EDGE), (Uri)photoUri, (String)caption, (Bundle)params, (GraphRequest.Callback)requestCallback));
                }
                requestCount.value = (Integer)requestCount.value + requests.size();
                for (GraphRequest request : requests) {
                    request.executeAsync();
                }
            }
            catch (FileNotFoundException ex) {
                ShareInternalUtility.invokeCallbackWithException((FacebookCallback)callback, (Exception)ex);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void shareLinkContent(ShareLinkContent shareLinkContent, FacebookCallback<Sharer.Result> facebookCallback) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void linkContent;
            void callback;
            GraphRequest.Callback requestCallback = new GraphRequest.Callback((FacebookCallback)callback){
                final /* synthetic */ FacebookCallback val$callback;
                {
                    this.val$callback = facebookCallback;
                }

                public void onCompleted(GraphResponse response) {
                    JSONObject data = response.getJSONObject();
                    String postId = data == null ? null : data.optString("id");
                    ShareInternalUtility.invokeCallbackWithResults((FacebookCallback)this.val$callback, (String)postId, (GraphResponse)response);
                }
            };
            Bundle parameters = new Bundle();
            this.addCommonParameters(parameters, (ShareContent)linkContent);
            parameters.putString("message", this.getMessage());
            parameters.putString("link", Utility.getUriString((Uri)linkContent.getContentUrl()));
            parameters.putString("ref", linkContent.getRef());
            new GraphRequest(AccessToken.getCurrentAccessToken(), this.getGraphPath("feed"), parameters, HttpMethod.POST, requestCallback).executeAsync();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void shareVideoContent(ShareVideoContent shareVideoContent, FacebookCallback<Sharer.Result> facebookCallback) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void callback;
            try {
                void videoContent;
                VideoUploader.uploadAsync((ShareVideoContent)videoContent, this.getGraphNode(), (FacebookCallback<Sharer.Result>)callback);
            }
            catch (FileNotFoundException ex) {
                ShareInternalUtility.invokeCallbackWithException((FacebookCallback)callback, (Exception)ex);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Bundle getSharePhotoCommonParameters(SharePhoto sharePhoto, SharePhotoContent sharePhotoContent) throws JSONException {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            List peopleIds;
            void photoContent;
            void photo;
            Bundle params = photo.getParameters();
            if (!params.containsKey("place") && !Utility.isNullOrEmpty((String)photoContent.getPlaceId())) {
                params.putString("place", photoContent.getPlaceId());
            }
            if (!(params.containsKey("tags") || Utility.isNullOrEmpty((Collection)photoContent.getPeopleIds()) || Utility.isNullOrEmpty((Collection)(peopleIds = photoContent.getPeopleIds())))) {
                JSONArray tags = new JSONArray();
                for (String id : peopleIds) {
                    JSONObject tag = new JSONObject();
                    tag.put("tag_uid", (Object)id);
                    tags.put((Object)tag);
                }
                params.putString("tags", tags.toString());
            }
            if (!params.containsKey("ref") && !Utility.isNullOrEmpty((String)photoContent.getRef())) {
                params.putString("ref", photoContent.getRef());
            }
            return params;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void stageArrayList(ArrayList arrayList, CollectionMapper.OnMapValueCompleteListener onMapValueCompleteListener) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void onArrayListStagedListener;
            void arrayList2;
            JSONArray stagedObject = new JSONArray();
            CollectionMapper.Collection<Integer> collection = new CollectionMapper.Collection<Integer>((ArrayList)arrayList2, stagedObject){
                final /* synthetic */ ArrayList val$arrayList;
                final /* synthetic */ JSONArray val$stagedObject;
                {
                    this.val$arrayList = arrayList;
                    this.val$stagedObject = jSONArray;
                }

                @Override
                public Iterator<Integer> keyIterator() {
                    final int size = this.val$arrayList.size();
                    final Mutable<Integer> current = new Mutable<Integer>(0);
                    return new Iterator<Integer>(){

                        @Override
                        public boolean hasNext() {
                            return (Integer)current.value < size;
                        }

                        @Override
                        public Integer next() {
                            Integer n = (Integer)current.value;
                            Mutable mutable = current;
                            mutable.value = (Integer)mutable.value + 1;
                            Integer n2 = mutable.value;
                            return n;
                        }

                        @Override
                        public void remove() {
                        }
                    };
                }

                @Override
                public Object get(Integer key) {
                    return this.val$arrayList.get(key);
                }

                @Override
                public void set(Integer key, Object value, CollectionMapper.OnErrorListener onErrorListener) {
                    try {
                        this.val$stagedObject.put(key.intValue(), value);
                    }
                    catch (JSONException ex) {
                        String message = ex.getLocalizedMessage();
                        if (message == null) {
                            message = "Error staging object.";
                        }
                        onErrorListener.onError(new FacebookException(message));
                    }
                }
            };
            CollectionMapper.OnMapperCompleteListener onStagedArrayMapperCompleteListener = new CollectionMapper.OnMapperCompleteListener((CollectionMapper.OnMapValueCompleteListener)onArrayListStagedListener, stagedObject){
                final /* synthetic */ CollectionMapper.OnMapValueCompleteListener val$onArrayListStagedListener;
                final /* synthetic */ JSONArray val$stagedObject;
                {
                    this.val$onArrayListStagedListener = onMapValueCompleteListener;
                    this.val$stagedObject = jSONArray;
                }

                @Override
                public void onComplete() {
                    this.val$onArrayListStagedListener.onComplete(this.val$stagedObject);
                }

                @Override
                public void onError(FacebookException exception) {
                    this.val$onArrayListStagedListener.onError(exception);
                }
            };
            this.stageCollectionValues(collection, onStagedArrayMapperCompleteListener);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> void stageCollectionValues(CollectionMapper.Collection<T> collection, CollectionMapper.OnMapperCompleteListener onMapperCompleteListener) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void onCollectionValuesStagedListener;
            void collection2;
            CollectionMapper.ValueMapper valueMapper = new CollectionMapper.ValueMapper(){

                @Override
                public void mapValue(Object value, CollectionMapper.OnMapValueCompleteListener onMapValueCompleteListener) {
                    if (value instanceof ArrayList) {
                        ShareApi.access$000(ShareApi.this, (ArrayList)value, onMapValueCompleteListener);
                    } else if (value instanceof SharePhoto) {
                        ShareApi.access$100(ShareApi.this, (SharePhoto)value, onMapValueCompleteListener);
                    } else {
                        onMapValueCompleteListener.onComplete(value);
                    }
                }
            };
            CollectionMapper.iterate(collection2, valueMapper, (CollectionMapper.OnMapperCompleteListener)onCollectionValuesStagedListener);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void stagePhoto(SharePhoto sharePhoto, CollectionMapper.OnMapValueCompleteListener onMapValueCompleteListener) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void onPhotoStagedListener;
            void photo;
            Bitmap bitmap = photo.getBitmap();
            Uri imageUrl = photo.getImageUrl();
            if (bitmap != null || imageUrl != null) {
                GraphRequest.Callback requestCallback = new GraphRequest.Callback((CollectionMapper.OnMapValueCompleteListener)onPhotoStagedListener, (SharePhoto)photo){
                    final /* synthetic */ CollectionMapper.OnMapValueCompleteListener val$onPhotoStagedListener;
                    final /* synthetic */ SharePhoto val$photo;
                    {
                        this.val$onPhotoStagedListener = onMapValueCompleteListener;
                        this.val$photo = sharePhoto;
                    }

                    public void onCompleted(GraphResponse response) {
                        FacebookRequestError error = response.getError();
                        if (error != null) {
                            String message = error.getErrorMessage();
                            if (message == null) {
                                message = "Error staging photo.";
                            }
                            this.val$onPhotoStagedListener.onError((FacebookException)new FacebookGraphResponseException(response, message));
                            return;
                        }
                        JSONObject data = response.getJSONObject();
                        if (data == null) {
                            this.val$onPhotoStagedListener.onError(new FacebookException("Error staging photo."));
                            return;
                        }
                        String stagedImageUri = data.optString("uri");
                        if (stagedImageUri == null) {
                            this.val$onPhotoStagedListener.onError(new FacebookException("Error staging photo."));
                            return;
                        }
                        JSONObject stagedObject = new JSONObject();
                        try {
                            stagedObject.put("url", (Object)stagedImageUri);
                            stagedObject.put("user_generated", this.val$photo.getUserGenerated());
                        }
                        catch (JSONException ex) {
                            String message = ex.getLocalizedMessage();
                            if (message == null) {
                                message = "Error staging photo.";
                            }
                            this.val$onPhotoStagedListener.onError(new FacebookException(message));
                            return;
                        }
                        this.val$onPhotoStagedListener.onComplete(stagedObject);
                    }
                };
                if (bitmap != null) {
                    ShareInternalUtility.newUploadStagingResourceWithImageRequest((AccessToken)AccessToken.getCurrentAccessToken(), (Bitmap)bitmap, (GraphRequest.Callback)requestCallback).executeAsync();
                } else {
                    try {
                        ShareInternalUtility.newUploadStagingResourceWithImageRequest((AccessToken)AccessToken.getCurrentAccessToken(), (Uri)imageUrl, (GraphRequest.Callback)requestCallback).executeAsync();
                    }
                    catch (FileNotFoundException ex) {
                        String message = ex.getLocalizedMessage();
                        if (message == null) {
                            message = "Error staging photo.";
                        }
                        onPhotoStagedListener.onError(new FacebookException(message));
                    }
                }
            } else {
                onPhotoStagedListener.onError(new FacebookException("Photos must have an imageURL or bitmap."));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(ShareApi shareApi, ArrayList arrayList, CollectionMapper.OnMapValueCompleteListener onMapValueCompleteListener) {
        if (CrashShieldHandler.isObjectCrashing(ShareApi.class)) {
            return;
        }
        try {
            void x2;
            void x1;
            ShareApi x0;
            x0.stageArrayList((ArrayList)x1, (CollectionMapper.OnMapValueCompleteListener)x2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareApi.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(ShareApi shareApi, SharePhoto sharePhoto, CollectionMapper.OnMapValueCompleteListener onMapValueCompleteListener) {
        if (CrashShieldHandler.isObjectCrashing(ShareApi.class)) {
            return;
        }
        try {
            void x2;
            void x1;
            ShareApi x0;
            x0.stagePhoto((SharePhoto)x1, (CollectionMapper.OnMapValueCompleteListener)x2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, ShareApi.class);
            return;
        }
    }
}

