/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import com.facebook.CallbackManager;
import com.facebook.FacebookButtonBase;
import com.facebook.FacebookCallback;
import com.facebook.FacebookSdk;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.share.DeviceShareDialog;
import com.facebook.share.R;
import com.facebook.share.model.ShareContent;

public final class DeviceShareButton
extends FacebookButtonBase {
    private ShareContent shareContent;
    private int requestCode = this.isInEditMode() ? 0 : this.getDefaultRequestCode();
    private boolean enabledExplicitlySet = false;
    private DeviceShareDialog dialog = null;

    public DeviceShareButton(Context context) {
        this(context, null, 0);
    }

    public DeviceShareButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private DeviceShareButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr, 0, "fb_device_share_button_create", "fb_device_share_button_did_tap");
        this.internalSetEnabled(false);
    }

    public ShareContent getShareContent() {
        return this.shareContent;
    }

    public void setShareContent(ShareContent shareContent) {
        this.shareContent = shareContent;
        if (!this.enabledExplicitlySet) {
            this.internalSetEnabled(this.canShare());
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enabledExplicitlySet = true;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public void registerCallback(CallbackManager callbackManager, FacebookCallback<DeviceShareDialog.Result> callback) {
        this.getDialog().registerCallback(callbackManager, callback);
    }

    public void registerCallback(CallbackManager callbackManager, FacebookCallback<DeviceShareDialog.Result> callback, int requestCode) {
        this.setRequestCode(requestCode);
        this.getDialog().registerCallback(callbackManager, callback, requestCode);
    }

    protected void configureButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super.configureButton(context, attrs, defStyleAttr, defStyleRes);
        this.setInternalOnClickListener(this.getShareOnClickListener());
    }

    protected int getDefaultStyleResource() {
        return R.style.com_facebook_button_share;
    }

    protected int getDefaultRequestCode() {
        return CallbackManagerImpl.RequestCodeOffset.Share.toRequestCode();
    }

    protected View.OnClickListener getShareOnClickListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                DeviceShareButton.this.callExternalOnClickListener(v);
                DeviceShareButton.this.getDialog().show(DeviceShareButton.this.getShareContent());
            }
        };
    }

    private void internalSetEnabled(boolean enabled) {
        this.setEnabled(enabled);
        this.enabledExplicitlySet = false;
    }

    private void setRequestCode(int requestCode) {
        if (FacebookSdk.isFacebookRequestCode((int)requestCode)) {
            throw new IllegalArgumentException("Request code " + requestCode + " cannot be within the range reserved by the Facebook SDK.");
        }
        this.requestCode = requestCode;
    }

    private boolean canShare() {
        return new DeviceShareDialog(this.getActivity()).canShow(this.getShareContent());
    }

    private DeviceShareDialog getDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = this.getFragment() != null ? new DeviceShareDialog(this.getFragment()) : (this.getNativeFragment() != null ? new DeviceShareDialog(this.getNativeFragment()) : new DeviceShareDialog(this.getActivity()));
        return this.dialog;
    }
}

