/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookGraphResponseException;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.internal.CollectionMapper;
import com.facebook.internal.Mutable;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import com.facebook.share.Sharer;
import com.facebook.share.internal.ShareContentValidation;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.internal.VideoUploader;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareOpenGraphAction;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.ShareOpenGraphObject;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareVideoContent;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@AutoHandleExceptions
public final class ShareApi {
    private static final String TAG = "ShareApi";
    private static final String DEFAULT_GRAPH_NODE = "me";
    private static final String PHOTOS_EDGE = "photos";
    private static final String GRAPH_PATH_FORMAT = "%s/%s";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private String message;
    private String graphNode;
    private final ShareContent shareContent;

    public static void share(ShareContent shareContent, FacebookCallback<Sharer.Result> callback) {
        new ShareApi(shareContent).share(callback);
    }

    public ShareApi(ShareContent shareContent) {
        this.shareContent = shareContent;
        this.graphNode = DEFAULT_GRAPH_NODE;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getGraphNode() {
        return this.graphNode;
    }

    public void setGraphNode(String graphNode) {
        this.graphNode = graphNode;
    }

    public ShareContent getShareContent() {
        return this.shareContent;
    }

    public boolean canShare() {
        if (this.getShareContent() == null) {
            return false;
        }
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        if (!AccessToken.isCurrentAccessTokenActive()) {
            return false;
        }
        Set permissions = accessToken.getPermissions();
        if (permissions == null || !permissions.contains("publish_actions")) {
            Log.w((String)TAG, (String)"The publish_actions permissions are missing, the share will fail unless this app was authorized to publish in another installation.");
        }
        return true;
    }

    public void share(FacebookCallback<Sharer.Result> callback) {
        if (!this.canShare()) {
            ShareInternalUtility.invokeCallbackWithError(callback, (String)"Insufficient permissions for sharing content via Api.");
            return;
        }
        ShareContent shareContent = this.getShareContent();
        try {
            ShareContentValidation.validateForApiShare((ShareContent)shareContent);
        }
        catch (FacebookException ex) {
            ShareInternalUtility.invokeCallbackWithException(callback, (Exception)((Object)ex));
            return;
        }
        if (shareContent instanceof ShareLinkContent) {
            this.shareLinkContent((ShareLinkContent)shareContent, callback);
        } else if (shareContent instanceof SharePhotoContent) {
            this.sharePhotoContent((SharePhotoContent)shareContent, callback);
        } else if (shareContent instanceof ShareVideoContent) {
            this.shareVideoContent((ShareVideoContent)shareContent, callback);
        } else if (shareContent instanceof ShareOpenGraphContent) {
            this.shareOpenGraphContent((ShareOpenGraphContent)shareContent, callback);
        }
    }

    private String getGraphPath(String pathAfterGraphNode) {
        try {
            return String.format(Locale.ROOT, GRAPH_PATH_FORMAT, URLEncoder.encode(this.getGraphNode(), DEFAULT_CHARSET), pathAfterGraphNode);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private void addCommonParameters(Bundle bundle, ShareContent shareContent) {
        List peopleIds = shareContent.getPeopleIds();
        if (!Utility.isNullOrEmpty((Collection)peopleIds)) {
            bundle.putString("tags", TextUtils.join((CharSequence)", ", (Iterable)peopleIds));
        }
        if (!Utility.isNullOrEmpty((String)shareContent.getPlaceId())) {
            bundle.putString("place", shareContent.getPlaceId());
        }
        if (!Utility.isNullOrEmpty((String)shareContent.getPageId())) {
            bundle.putString("page", shareContent.getPageId());
        }
        if (!Utility.isNullOrEmpty((String)shareContent.getRef())) {
            bundle.putString("ref", shareContent.getRef());
        }
    }

    private void shareOpenGraphContent(ShareOpenGraphContent openGraphContent, final FacebookCallback<Sharer.Result> callback) {
        final GraphRequest.Callback requestCallback = new GraphRequest.Callback(){

            public void onCompleted(GraphResponse response) {
                JSONObject data = response.getJSONObject();
                String postId = data == null ? null : data.optString("id");
                ShareInternalUtility.invokeCallbackWithResults((FacebookCallback)callback, (String)postId, (GraphResponse)response);
            }
        };
        final ShareOpenGraphAction action = openGraphContent.getAction();
        final Bundle parameters = action.getBundle();
        this.addCommonParameters(parameters, (ShareContent)openGraphContent);
        if (!Utility.isNullOrEmpty((String)this.getMessage())) {
            parameters.putString("message", this.getMessage());
        }
        CollectionMapper.OnMapperCompleteListener stageCallback = new CollectionMapper.OnMapperCompleteListener(){

            @Override
            public void onComplete() {
                try {
                    ShareApi.handleImagesOnAction(parameters);
                    new GraphRequest(AccessToken.getCurrentAccessToken(), ShareApi.this.getGraphPath(URLEncoder.encode(action.getActionType(), ShareApi.DEFAULT_CHARSET)), parameters, HttpMethod.POST, requestCallback).executeAsync();
                }
                catch (UnsupportedEncodingException ex) {
                    ShareInternalUtility.invokeCallbackWithException((FacebookCallback)callback, (Exception)ex);
                }
            }

            @Override
            public void onError(FacebookException exception) {
                ShareInternalUtility.invokeCallbackWithException((FacebookCallback)callback, (Exception)exception);
            }
        };
        this.stageOpenGraphAction(parameters, stageCallback);
    }

    private static void handleImagesOnAction(Bundle parameters) {
        String imageStr = parameters.getString("image");
        if (imageStr != null) {
            try {
                JSONArray images = new JSONArray(imageStr);
                for (int i = 0; i < images.length(); ++i) {
                    JSONObject jsonImage = images.optJSONObject(i);
                    if (jsonImage != null) {
                        ShareApi.putImageInBundleWithArrayFormat(parameters, i, jsonImage);
                        continue;
                    }
                    String url = images.getString(i);
                    parameters.putString(String.format(Locale.ROOT, "image[%d][url]", i), url);
                }
                parameters.remove("image");
                return;
            }
            catch (JSONException images) {
                try {
                    JSONObject image = new JSONObject(imageStr);
                    ShareApi.putImageInBundleWithArrayFormat(parameters, 0, image);
                    parameters.remove("image");
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
    }

    private static void putImageInBundleWithArrayFormat(Bundle parameters, int index, JSONObject image) throws JSONException {
        Iterator keys = image.keys();
        while (keys.hasNext()) {
            String property = (String)keys.next();
            String key = String.format(Locale.ROOT, "image[%d][%s]", index, property);
            parameters.putString(key, image.get(property).toString());
        }
    }

    private void sharePhotoContent(SharePhotoContent photoContent, final FacebookCallback<Sharer.Result> callback) {
        final Mutable<Integer> requestCount = new Mutable<Integer>(0);
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        ArrayList<GraphRequest> requests = new ArrayList<GraphRequest>();
        final ArrayList results = new ArrayList();
        final ArrayList errorResponses = new ArrayList();
        GraphRequest.Callback requestCallback = new GraphRequest.Callback(){

            public void onCompleted(GraphResponse response) {
                JSONObject result = response.getJSONObject();
                if (result != null) {
                    results.add(result);
                }
                if (response.getError() != null) {
                    errorResponses.add(response);
                }
                requestCount.value = (Integer)requestCount.value - 1;
                if ((Integer)requestCount.value == 0) {
                    if (!errorResponses.isEmpty()) {
                        ShareInternalUtility.invokeCallbackWithResults((FacebookCallback)callback, null, (GraphResponse)((GraphResponse)errorResponses.get(0)));
                    } else if (!results.isEmpty()) {
                        String postId = ((JSONObject)results.get(0)).optString("id");
                        ShareInternalUtility.invokeCallbackWithResults((FacebookCallback)callback, (String)postId, (GraphResponse)response);
                    }
                }
            }
        };
        try {
            for (SharePhoto photo : photoContent.getPhotos()) {
                Bundle params;
                try {
                    params = this.getSharePhotoCommonParameters(photo, photoContent);
                }
                catch (JSONException e) {
                    ShareInternalUtility.invokeCallbackWithException(callback, (Exception)((Object)e));
                    return;
                }
                Bitmap bitmap = photo.getBitmap();
                Uri photoUri = photo.getImageUrl();
                String caption = photo.getCaption();
                if (caption == null) {
                    caption = this.getMessage();
                }
                if (bitmap != null) {
                    requests.add(GraphRequest.newUploadPhotoRequest((AccessToken)accessToken, (String)this.getGraphPath(PHOTOS_EDGE), (Bitmap)bitmap, (String)caption, (Bundle)params, (GraphRequest.Callback)requestCallback));
                    continue;
                }
                if (photoUri == null) continue;
                requests.add(GraphRequest.newUploadPhotoRequest((AccessToken)accessToken, (String)this.getGraphPath(PHOTOS_EDGE), (Uri)photoUri, (String)caption, (Bundle)params, (GraphRequest.Callback)requestCallback));
            }
            requestCount.value = (Integer)requestCount.value + requests.size();
            for (GraphRequest request : requests) {
                request.executeAsync();
            }
        }
        catch (FileNotFoundException ex) {
            ShareInternalUtility.invokeCallbackWithException(callback, (Exception)ex);
        }
    }

    private void shareLinkContent(ShareLinkContent linkContent, final FacebookCallback<Sharer.Result> callback) {
        GraphRequest.Callback requestCallback = new GraphRequest.Callback(){

            public void onCompleted(GraphResponse response) {
                JSONObject data = response.getJSONObject();
                String postId = data == null ? null : data.optString("id");
                ShareInternalUtility.invokeCallbackWithResults((FacebookCallback)callback, (String)postId, (GraphResponse)response);
            }
        };
        Bundle parameters = new Bundle();
        this.addCommonParameters(parameters, (ShareContent)linkContent);
        parameters.putString("message", this.getMessage());
        parameters.putString("link", Utility.getUriString((Uri)linkContent.getContentUrl()));
        parameters.putString("picture", Utility.getUriString((Uri)linkContent.getImageUrl()));
        parameters.putString("name", linkContent.getContentTitle());
        parameters.putString("description", linkContent.getContentDescription());
        parameters.putString("ref", linkContent.getRef());
        new GraphRequest(AccessToken.getCurrentAccessToken(), this.getGraphPath("feed"), parameters, HttpMethod.POST, requestCallback).executeAsync();
    }

    private void shareVideoContent(ShareVideoContent videoContent, FacebookCallback<Sharer.Result> callback) {
        try {
            VideoUploader.uploadAsync(videoContent, this.getGraphNode(), callback);
        }
        catch (FileNotFoundException ex) {
            ShareInternalUtility.invokeCallbackWithException(callback, (Exception)ex);
        }
    }

    private Bundle getSharePhotoCommonParameters(SharePhoto photo, SharePhotoContent photoContent) throws JSONException {
        List peopleIds;
        Bundle params = photo.getParameters();
        if (!params.containsKey("place") && !Utility.isNullOrEmpty((String)photoContent.getPlaceId())) {
            params.putString("place", photoContent.getPlaceId());
        }
        if (!(params.containsKey("tags") || Utility.isNullOrEmpty((Collection)photoContent.getPeopleIds()) || Utility.isNullOrEmpty((Collection)(peopleIds = photoContent.getPeopleIds())))) {
            JSONArray tags = new JSONArray();
            for (String id : peopleIds) {
                JSONObject tag = new JSONObject();
                tag.put("tag_uid", (Object)id);
                tags.put((Object)tag);
            }
            params.putString("tags", tags.toString());
        }
        if (!params.containsKey("ref") && !Utility.isNullOrEmpty((String)photoContent.getRef())) {
            params.putString("ref", photoContent.getRef());
        }
        return params;
    }

    private void stageArrayList(final ArrayList arrayList, final CollectionMapper.OnMapValueCompleteListener onArrayListStagedListener) {
        final JSONArray stagedObject = new JSONArray();
        CollectionMapper.Collection<Integer> collection = new CollectionMapper.Collection<Integer>(){

            @Override
            public Iterator<Integer> keyIterator() {
                final int size = arrayList.size();
                final Mutable<Integer> current = new Mutable<Integer>(0);
                return new Iterator<Integer>(){

                    @Override
                    public boolean hasNext() {
                        return (Integer)current.value < size;
                    }

                    @Override
                    public Integer next() {
                        Integer n = (Integer)current.value;
                        Mutable mutable = current;
                        mutable.value = (Integer)mutable.value + 1;
                        Integer n2 = mutable.value;
                        return n;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }

            @Override
            public Object get(Integer key) {
                return arrayList.get(key);
            }

            @Override
            public void set(Integer key, Object value, CollectionMapper.OnErrorListener onErrorListener) {
                try {
                    stagedObject.put(key.intValue(), value);
                }
                catch (JSONException ex) {
                    String message = ex.getLocalizedMessage();
                    if (message == null) {
                        message = "Error staging object.";
                    }
                    onErrorListener.onError(new FacebookException(message));
                }
            }
        };
        CollectionMapper.OnMapperCompleteListener onStagedArrayMapperCompleteListener = new CollectionMapper.OnMapperCompleteListener(){

            @Override
            public void onComplete() {
                onArrayListStagedListener.onComplete(stagedObject);
            }

            @Override
            public void onError(FacebookException exception) {
                onArrayListStagedListener.onError(exception);
            }
        };
        this.stageCollectionValues(collection, onStagedArrayMapperCompleteListener);
    }

    private <T> void stageCollectionValues(CollectionMapper.Collection<T> collection, CollectionMapper.OnMapperCompleteListener onCollectionValuesStagedListener) {
        CollectionMapper.ValueMapper valueMapper = new CollectionMapper.ValueMapper(){

            @Override
            public void mapValue(Object value, CollectionMapper.OnMapValueCompleteListener onMapValueCompleteListener) {
                if (value instanceof ArrayList) {
                    ShareApi.this.stageArrayList((ArrayList)value, onMapValueCompleteListener);
                } else if (value instanceof ShareOpenGraphObject) {
                    ShareApi.this.stageOpenGraphObject((ShareOpenGraphObject)value, onMapValueCompleteListener);
                } else if (value instanceof SharePhoto) {
                    ShareApi.this.stagePhoto((SharePhoto)value, onMapValueCompleteListener);
                } else {
                    onMapValueCompleteListener.onComplete(value);
                }
            }
        };
        CollectionMapper.iterate(collection, valueMapper, onCollectionValuesStagedListener);
    }

    private void stageOpenGraphAction(final Bundle parameters, CollectionMapper.OnMapperCompleteListener onOpenGraphActionStagedListener) {
        CollectionMapper.Collection<String> collection = new CollectionMapper.Collection<String>(){

            @Override
            public Iterator<String> keyIterator() {
                return parameters.keySet().iterator();
            }

            @Override
            public Object get(String key) {
                return parameters.get(key);
            }

            @Override
            public void set(String key, Object value, CollectionMapper.OnErrorListener onErrorListener) {
                if (!Utility.putJSONValueInBundle((Bundle)parameters, (String)key, (Object)value)) {
                    onErrorListener.onError(new FacebookException("Unexpected value: " + value.toString()));
                }
            }
        };
        this.stageCollectionValues(collection, onOpenGraphActionStagedListener);
    }

    private void stageOpenGraphObject(final ShareOpenGraphObject object, final CollectionMapper.OnMapValueCompleteListener onOpenGraphObjectStagedListener) {
        String type = object.getString("type");
        if (type == null) {
            type = object.getString("og:type");
        }
        if (type == null) {
            onOpenGraphObjectStagedListener.onError(new FacebookException("Open Graph objects must contain a type value."));
            return;
        }
        final JSONObject stagedObject = new JSONObject();
        CollectionMapper.Collection<String> collection = new CollectionMapper.Collection<String>(){

            @Override
            public Iterator<String> keyIterator() {
                return object.keySet().iterator();
            }

            @Override
            public Object get(String key) {
                return object.get(key);
            }

            @Override
            public void set(String key, Object value, CollectionMapper.OnErrorListener onErrorListener) {
                try {
                    stagedObject.put(key, value);
                }
                catch (JSONException ex) {
                    String message = ex.getLocalizedMessage();
                    if (message == null) {
                        message = "Error staging object.";
                    }
                    onErrorListener.onError(new FacebookException(message));
                }
            }
        };
        final GraphRequest.Callback requestCallback = new GraphRequest.Callback(){

            public void onCompleted(GraphResponse response) {
                FacebookRequestError error = response.getError();
                if (error != null) {
                    String message = error.getErrorMessage();
                    if (message == null) {
                        message = "Error staging Open Graph object.";
                    }
                    onOpenGraphObjectStagedListener.onError((FacebookException)new FacebookGraphResponseException(response, message));
                    return;
                }
                JSONObject data = response.getJSONObject();
                if (data == null) {
                    onOpenGraphObjectStagedListener.onError((FacebookException)new FacebookGraphResponseException(response, "Error staging Open Graph object."));
                    return;
                }
                String stagedObjectId = data.optString("id");
                if (stagedObjectId == null) {
                    onOpenGraphObjectStagedListener.onError((FacebookException)new FacebookGraphResponseException(response, "Error staging Open Graph object."));
                    return;
                }
                onOpenGraphObjectStagedListener.onComplete(stagedObjectId);
            }
        };
        final String ogType = type;
        CollectionMapper.OnMapperCompleteListener onMapperCompleteListener = new CollectionMapper.OnMapperCompleteListener(){

            @Override
            public void onComplete() {
                String objectString = stagedObject.toString();
                Bundle parameters = new Bundle();
                parameters.putString("object", objectString);
                try {
                    new GraphRequest(AccessToken.getCurrentAccessToken(), ShareApi.this.getGraphPath("objects/" + URLEncoder.encode(ogType, ShareApi.DEFAULT_CHARSET)), parameters, HttpMethod.POST, requestCallback).executeAsync();
                }
                catch (UnsupportedEncodingException ex) {
                    String message = ex.getLocalizedMessage();
                    if (message == null) {
                        message = "Error staging Open Graph object.";
                    }
                    onOpenGraphObjectStagedListener.onError(new FacebookException(message));
                }
            }

            @Override
            public void onError(FacebookException exception) {
                onOpenGraphObjectStagedListener.onError(exception);
            }
        };
        this.stageCollectionValues(collection, onMapperCompleteListener);
    }

    private void stagePhoto(final SharePhoto photo, final CollectionMapper.OnMapValueCompleteListener onPhotoStagedListener) {
        Bitmap bitmap = photo.getBitmap();
        Uri imageUrl = photo.getImageUrl();
        if (bitmap != null || imageUrl != null) {
            GraphRequest.Callback requestCallback = new GraphRequest.Callback(){

                public void onCompleted(GraphResponse response) {
                    FacebookRequestError error = response.getError();
                    if (error != null) {
                        String message = error.getErrorMessage();
                        if (message == null) {
                            message = "Error staging photo.";
                        }
                        onPhotoStagedListener.onError((FacebookException)new FacebookGraphResponseException(response, message));
                        return;
                    }
                    JSONObject data = response.getJSONObject();
                    if (data == null) {
                        onPhotoStagedListener.onError(new FacebookException("Error staging photo."));
                        return;
                    }
                    String stagedImageUri = data.optString("uri");
                    if (stagedImageUri == null) {
                        onPhotoStagedListener.onError(new FacebookException("Error staging photo."));
                        return;
                    }
                    JSONObject stagedObject = new JSONObject();
                    try {
                        stagedObject.put("url", (Object)stagedImageUri);
                        stagedObject.put("user_generated", photo.getUserGenerated());
                    }
                    catch (JSONException ex) {
                        String message = ex.getLocalizedMessage();
                        if (message == null) {
                            message = "Error staging photo.";
                        }
                        onPhotoStagedListener.onError(new FacebookException(message));
                        return;
                    }
                    onPhotoStagedListener.onComplete(stagedObject);
                }
            };
            if (bitmap != null) {
                ShareInternalUtility.newUploadStagingResourceWithImageRequest((AccessToken)AccessToken.getCurrentAccessToken(), (Bitmap)bitmap, (GraphRequest.Callback)requestCallback).executeAsync();
            } else {
                try {
                    ShareInternalUtility.newUploadStagingResourceWithImageRequest((AccessToken)AccessToken.getCurrentAccessToken(), (Uri)imageUrl, (GraphRequest.Callback)requestCallback).executeAsync();
                }
                catch (FileNotFoundException ex) {
                    String message = ex.getLocalizedMessage();
                    if (message == null) {
                        message = "Error staging photo.";
                    }
                    onPhotoStagedListener.onError(new FacebookException(message));
                }
            }
        } else {
            onPhotoStagedListener.onError(new FacebookException("Photos must have an imageURL or bitmap."));
        }
    }
}

