/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.bluetooth;

import com.facebook.battery.metrics.bluetooth.BluetoothMetrics;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.infer.annotation.ThreadSafe;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@ThreadSafe
public class BluetoothMetricsCollector
extends SystemMetricsCollector<BluetoothMetrics> {
    private int bleScanCount;
    private long bleScanDurationMs;
    private final ReentrantReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();

    @Override
    @ThreadSafe(enableChecks=false)
    public boolean getSnapshot(BluetoothMetrics snapshot) {
        if (snapshot == null) {
            throw new IllegalArgumentException("Null value passed to getSnapshot!");
        }
        this.mReadWriteLock.readLock().lock();
        try {
            snapshot.bleScanCount = this.bleScanCount;
            snapshot.bleScanDurationMs = this.bleScanDurationMs;
            boolean bl = true;
            return bl;
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
    }

    @Override
    public BluetoothMetrics createMetrics() {
        return new BluetoothMetrics();
    }

    public void addScan(long durationMs) {
        if (durationMs > 0L) {
            this.mReadWriteLock.writeLock().lock();
            try {
                ++this.bleScanCount;
                this.bleScanDurationMs += durationMs;
            }
            finally {
                this.mReadWriteLock.writeLock().unlock();
            }
        }
    }
}

