/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.camera;

import android.support.annotation.Nullable;
import com.facebook.battery.metrics.core.SystemMetrics;

public class CameraMetrics
extends SystemMetrics<CameraMetrics> {
    private static final long serialVersionUID = 0L;
    public long cameraPreviewTimeMs;
    public long cameraOpenTimeMs;

    @Override
    public CameraMetrics sum(@Nullable CameraMetrics b, @Nullable CameraMetrics output) {
        if (output == null) {
            output = new CameraMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            output.cameraPreviewTimeMs = this.cameraPreviewTimeMs + b.cameraPreviewTimeMs;
            output.cameraOpenTimeMs = this.cameraOpenTimeMs + b.cameraOpenTimeMs;
        }
        return output;
    }

    @Override
    public CameraMetrics diff(@Nullable CameraMetrics b, @Nullable CameraMetrics output) {
        if (output == null) {
            output = new CameraMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            output.cameraPreviewTimeMs = this.cameraPreviewTimeMs - b.cameraPreviewTimeMs;
            output.cameraOpenTimeMs = this.cameraOpenTimeMs - b.cameraOpenTimeMs;
        }
        return output;
    }

    @Override
    public CameraMetrics set(CameraMetrics b) {
        this.cameraPreviewTimeMs = b.cameraPreviewTimeMs;
        this.cameraOpenTimeMs = b.cameraOpenTimeMs;
        return this;
    }

    public String toString() {
        return "CameraMetrics{cameraPreviewTimeMs=" + this.cameraPreviewTimeMs + ", cameraOpenTimeMs=" + this.cameraOpenTimeMs + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CameraMetrics that = (CameraMetrics)o;
        return this.cameraPreviewTimeMs == that.cameraPreviewTimeMs && this.cameraOpenTimeMs == that.cameraOpenTimeMs;
    }

    public int hashCode() {
        int result = (int)(this.cameraPreviewTimeMs ^ this.cameraPreviewTimeMs >>> 32);
        result = 31 * result + (int)(this.cameraOpenTimeMs ^ this.cameraOpenTimeMs >>> 32);
        return result;
    }
}

